/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.SourceDefinitionParticipantAdaptor;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionalObjectInvalidException;

public abstract class ImmutableDefinition
extends SourceDefinition {
    private boolean m_RolledBack = false;
    private Transaction m_ActiveTransaction = null;

    ImmutableDefinition(String string, DataProvider dataProvider, Transaction transaction) {
        super(string, dataProvider);
        this.setActiveTransaction(transaction);
        transaction.registerParticipant(new SourceDefinitionParticipantAdaptor(this));
    }

    final void checkValidity(Transaction transaction) throws TransactionalObjectInvalidException {
        if (this.isRolledBack()) {
            throw new TransactionalObjectInvalidException();
        }
        if (null != this.getActiveTransaction() && !this.getActiveTransaction().isAncestorOf(transaction)) {
            throw new TransactionalObjectInvalidException();
        }
    }

    final void commit(Transaction transaction) {
        this.setActiveTransaction(transaction);
    }

    public final Transaction getActiveTransaction() {
        return this.m_ActiveTransaction;
    }

    protected abstract SourceDefinition getType();

    protected SourceDefinition getElementType() {
        return this.getType();
    }

    SourceDefinition getType(Transaction transaction) {
        return this.getType();
    }

    SourceDefinition getElementType(Transaction transaction) {
        return this.getElementType();
    }

    private final boolean isRolledBack() {
        return this.m_RolledBack;
    }

    final void rollback() {
        this.setRolledBack(true);
    }

    private final void setActiveTransaction(Transaction transaction) {
        this.m_ActiveTransaction = transaction;
    }

    private final void setRolledBack(boolean bl) {
        this.m_RolledBack = bl;
    }

    public Object getTransactionalState(Transaction transaction) {
        return this;
    }
}

