/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.olapi.data.source.CompoundCursorSpecification;
import oracle.olapi.data.source.CursorSpecification;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.ValueCursorSpecification;
import oracle.olapi.transaction.Transaction;

public final class CursorManagerSpecification {
    private CursorSpecification m_RootCursorSpecification;
    private Transaction m_Transaction;

    CursorManagerSpecification(SourceDefinition sourceDefinition, Transaction transaction) {
        this.setTransaction(transaction);
        this.setRootCursorSpecification(this.createCursorSpecification(sourceDefinition, transaction));
        this.getRootCursorSpecification()._setDefaultFetchSize(100);
    }

    private final CursorSpecification createCursorSpecification(SourceDefinition sourceDefinition, Transaction transaction) {
        ArrayList arrayList = new ArrayList();
        sourceDefinition.accumulateOutputs(arrayList, transaction);
        if (arrayList.isEmpty()) {
            return new ValueCursorSpecification(sourceDefinition);
        }
        ArrayList<CursorSpecification> arrayList2 = new ArrayList<CursorSpecification>(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Source source = (Source)iterator.next();
            arrayList2.add(this.createCursorSpecification(source.getDefinition(), transaction));
        }
        return new CompoundCursorSpecification(sourceDefinition, arrayList2);
    }

    public final CursorSpecification getRootCursorSpecification() {
        return this.m_RootCursorSpecification;
    }

    public final Transaction getTransaction() {
        return this.m_Transaction;
    }

    public final boolean isExpired() {
        return this.getRootCursorSpecification().isExpired(this.getRootCursorSpecification()._getSourceDefinition(), this.getTransaction());
    }

    private void setRootCursorSpecification(CursorSpecification cursorSpecification) {
        this.m_RootCursorSpecification = cursorSpecification;
    }

    private void setTransaction(Transaction transaction) {
        this.m_Transaction = transaction;
    }
}

