/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.spl;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.express.ExpressServerException;
import oracle.express.ObjectClosedException;
import oracle.express.TaskInterruptedException;
import oracle.express.idl.ExpressConnectionModule.ConnectionInterfaceStub;
import oracle.express.idl.ExpressModule.ExpressException;
import oracle.express.idl.ExpressModule.InterruptableInterface;
import oracle.express.idl.ExpressModule.RemoteObjectClosedException;
import oracle.express.idl.ExpressModule.RemoteTaskInterruptedException;
import oracle.express.idl.util.BooleanHolder;
import oracle.express.idl.util.RpcProperties;
import oracle.express.idl.util.SPLTypeMapHelper;
import oracle.express.spl.NAValueException;
import oracle.jdbc.OracleConnection;
import oracle.sql.NUMBER;

public class SPLExecutor {
    private static Map stmtListMap = new HashMap();
    private static int _sIdCount = 0;
    private Properties _props;
    private OracleConnection _jdbc_connection;
    private ConnectionInterfaceStub _ifaceStub;

    public SPLExecutor(OracleConnection oracleConnection) {
        this(oracleConnection, null);
    }

    public SPLExecutor(OracleConnection oracleConnection, Properties properties) {
        this._jdbc_connection = oracleConnection;
        this._props = properties != null ? properties : new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SQLException {
        String string = "ORAOLAP9.2.0.1.0";
        Statement statement = null;
        try {
            SPLTypeMapHelper.setTypeMap(this._jdbc_connection);
            statement = this._jdbc_connection.prepareCall("{ call OlapiHandshake2(?, ?) }");
            statement.setString(1, "10.2.0.3.0");
            statement.registerOutParameter(2, 1);
            statement.execute();
            string = "ORAOLAP" + statement.getString(2);
        }
        catch (Exception exception) {
        }
        finally {
            if (null != statement) {
                statement.close();
            }
        }
        this._ifaceStub = new ConnectionInterfaceStub(this._jdbc_connection, string, new NUMBER(0), "ExpressConnectionModule::ConnectionInterface", new RpcProperties(this._props));
    }

    public InterruptableInterface getInterruptableInterface() {
        return this._ifaceStub;
    }

    public String getProperty(String string) {
        return this._props.getProperty(string);
    }

    public String executeCommand(String string) throws ObjectClosedException, ExpressServerException {
        this.throwExceptionIfConnectionClosed();
        string = this.appendNewLineTerminatorIfMissing(string);
        try {
            int n = _sIdCount++;
            return this._ifaceStub.executeCommand(string, n);
        }
        catch (SQLException sQLException) {
            throw new ExpressServerException(sQLException);
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
    }

    public int evaluateIntegerExpression(String string) throws NAValueException, ObjectClosedException, ExpressServerException {
        this.throwExceptionIfConnectionClosed();
        try {
            int n = _sIdCount++;
            BooleanHolder booleanHolder = new BooleanHolder();
            int n2 = this._ifaceStub.evaluateIntegerExpression(string, booleanHolder, n);
            if (booleanHolder.value) {
                throw new NAValueException();
            }
            return n2;
        }
        catch (SQLException sQLException) {
            throw new ExpressServerException(sQLException);
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
    }

    public short evaluateShortIntegerExpression(String string) throws NAValueException, ObjectClosedException, ExpressServerException {
        this.throwExceptionIfConnectionClosed();
        try {
            int n = _sIdCount++;
            BooleanHolder booleanHolder = new BooleanHolder();
            short s = this._ifaceStub.evaluateShortIntegerExpression(string, booleanHolder, n);
            if (booleanHolder.value) {
                throw new NAValueException();
            }
            return s;
        }
        catch (SQLException sQLException) {
            throw new ExpressServerException(sQLException);
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
    }

    public double evaluateDecimalExpression(String string) throws NAValueException, ObjectClosedException, ExpressServerException {
        this.throwExceptionIfConnectionClosed();
        try {
            int n = _sIdCount++;
            BooleanHolder booleanHolder = new BooleanHolder();
            double d = this._ifaceStub.evaluateDecimalExpression(string, booleanHolder, n);
            if (booleanHolder.value) {
                throw new NAValueException();
            }
            return d;
        }
        catch (SQLException sQLException) {
            throw new ExpressServerException(sQLException);
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
    }

    public float evaluateShortDecimalExpression(String string) throws NAValueException, ObjectClosedException, ExpressServerException {
        this.throwExceptionIfConnectionClosed();
        try {
            int n = _sIdCount++;
            BooleanHolder booleanHolder = new BooleanHolder();
            float f = this._ifaceStub.evaluateShortDecimalExpression(string, booleanHolder, n);
            if (booleanHolder.value) {
                throw new NAValueException();
            }
            return f;
        }
        catch (SQLException sQLException) {
            throw new ExpressServerException(sQLException);
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
    }

    public String evaluateStringExpression(String string) throws NAValueException, ObjectClosedException, ExpressServerException {
        this.throwExceptionIfConnectionClosed();
        try {
            int n = _sIdCount++;
            BooleanHolder booleanHolder = new BooleanHolder();
            String string2 = this._ifaceStub.evaluateStringExpression(string, booleanHolder, n);
            if (booleanHolder.value) {
                throw new NAValueException();
            }
            return string2;
        }
        catch (SQLException sQLException) {
            throw new ExpressServerException(sQLException);
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
    }

    public String[] evaluateStringListExpression(String string) throws NAValueException, ObjectClosedException, ExpressServerException {
        this.throwExceptionIfConnectionClosed();
        try {
            int n = _sIdCount++;
            BooleanHolder booleanHolder = new BooleanHolder();
            String[] stringArray = this._ifaceStub.evaluateStringListExpression(string, booleanHolder, n);
            if (booleanHolder.value) {
                throw new NAValueException();
            }
            return stringArray;
        }
        catch (SQLException sQLException) {
            throw new ExpressServerException(sQLException);
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
    }

    public boolean evaluateBooleanExpression(String string) throws NAValueException, ObjectClosedException, ExpressServerException {
        this.throwExceptionIfConnectionClosed();
        try {
            int n = _sIdCount++;
            BooleanHolder booleanHolder = new BooleanHolder();
            boolean bl = this._ifaceStub.evaluateBooleanExpression(string, booleanHolder, n);
            if (booleanHolder.value) {
                throw new NAValueException();
            }
            return bl;
        }
        catch (SQLException sQLException) {
            throw new ExpressServerException(sQLException);
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
    }

    public Date evaluateDateExpression(String string) throws NAValueException, ObjectClosedException, ExpressServerException {
        this.throwExceptionIfConnectionClosed();
        try {
            int n = _sIdCount++;
            BooleanHolder booleanHolder = new BooleanHolder();
            if (this._ifaceStub.isPostServerVsnnum("10.2.0.0.0")) {
                Date date = this._ifaceStub.evaluateDate2Expression(string, booleanHolder, n);
                if (booleanHolder.value) {
                    throw new NAValueException();
                }
                return date;
            }
            long l = this._ifaceStub.evaluateDateExpression(string, booleanHolder, n);
            if (booleanHolder.value) {
                throw new NAValueException();
            }
            return new Date(l * 1000L);
        }
        catch (SQLException sQLException) {
            throw new ExpressServerException(sQLException);
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
    }

    private void throwExceptionIfConnectionClosed() throws ObjectClosedException {
        try {
            if (this._jdbc_connection.isClosed()) {
                throw new ObjectClosedException();
            }
        }
        catch (SQLException sQLException) {
            throw new ObjectClosedException();
        }
    }

    private String appendNewLineTerminatorIfMissing(String string) {
        if (!string.endsWith("\n")) {
            return string + "\n";
        }
        return string;
    }
}

