/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.express.olapi.transaction.ExpressDataReadTransaction;
import oracle.express.olapi.transaction.ExpressTransaction;
import oracle.express.olapi.transaction.TransactionEventAdapter;
import oracle.olapi.transaction.NotCommittableException;
import oracle.olapi.transaction.NotPreparedException;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionEvent;
import oracle.olapi.transaction.TransactionInactiveException;
import oracle.olapi.transaction.TransactionListener;
import oracle.olapi.transaction.TransactionProvider;
import oracle.olapi.transaction.TransactionTypeUnavailableException;

public final class ExpressTransactionProvider
implements TransactionProvider {
    private Map _transactionMap = new HashMap();
    private List _transactionListeners = new ArrayList();

    public final Transaction getCurrentTransaction() {
        Transaction transaction = (Transaction)this._transactionMap.get(Thread.currentThread());
        if (transaction == null) {
            transaction = new ExpressDataReadTransaction(null, this);
            this._setCurrentTransaction(transaction);
        }
        return transaction;
    }

    public final void setCurrentTransaction(Transaction transaction) {
        Transaction transaction2 = this.getCurrentTransaction();
        if (transaction2 != transaction) {
            this._setCurrentTransaction(transaction);
            this._fireSetCurrentEvent(transaction2, transaction);
        }
    }

    public final void _beginSubtransaction(Transaction transaction) {
        Transaction transaction2 = this.getCurrentTransaction();
        this._setCurrentTransaction(transaction);
        this._fireAfterCreateEvent(transaction2, transaction);
    }

    private void _setCurrentTransaction(Transaction transaction) {
        this._transactionMap.put(Thread.currentThread(), transaction);
    }

    public final void prepareCurrentTransaction() throws NotCommittableException, TransactionInactiveException {
        this.getCurrentTransaction().prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitCurrentTransaction() throws NotPreparedException, TransactionInactiveException {
        Transaction transaction = this.getCurrentTransaction();
        ExpressTransaction expressTransaction = ((ExpressTransaction)transaction)._getParent();
        try {
            this._fireBeforeCommitEvent(transaction, expressTransaction);
        }
        finally {
            transaction.commit();
            this._updateTransactionMap(transaction, expressTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollbackCurrentTransaction() throws NotPreparedException, TransactionInactiveException {
        Transaction transaction = this.getCurrentTransaction();
        ExpressTransaction expressTransaction = ((ExpressTransaction)transaction)._getParent();
        try {
            this._fireBeforeRollbackEvent(transaction, expressTransaction);
        }
        finally {
            transaction.rollback();
            this._updateTransactionMap(transaction, expressTransaction);
        }
    }

    public final Transaction beginSubtransaction() throws TransactionInactiveException {
        Transaction transaction = this.getCurrentTransaction();
        Transaction transaction2 = transaction.createSubtransaction();
        this._fireAfterCreateEvent(transaction, transaction2);
        return transaction2;
    }

    public final Transaction getCurrentTransactionForMetadataRead() throws TransactionTypeUnavailableException, TransactionInactiveException {
        Transaction transaction;
        Transaction transaction2 = this.getCurrentTransaction();
        if (transaction2 != (transaction = transaction2.getTransactionForMetadataRead())) {
            this._fireAfterCreateEvent(transaction2, transaction);
        }
        return transaction;
    }

    public final Transaction getCurrentTransactionForMetadataWrite() throws TransactionTypeUnavailableException, TransactionInactiveException {
        Transaction transaction;
        Transaction transaction2 = this.getCurrentTransaction();
        if (transaction2 != (transaction = transaction2.getTransactionForMetadataWrite())) {
            this._fireAfterCreateEvent(transaction2, transaction);
        }
        return transaction;
    }

    public final Transaction getCurrentTransactionForDataRead() throws TransactionTypeUnavailableException, TransactionInactiveException {
        Transaction transaction;
        Transaction transaction2 = this.getCurrentTransaction();
        if (transaction2 != (transaction = transaction2.getTransactionForDataRead())) {
            this._fireAfterCreateEvent(transaction2, transaction);
        }
        return transaction;
    }

    public final Transaction getCurrentTransactionForDataWrite() throws TransactionTypeUnavailableException, TransactionInactiveException {
        Transaction transaction;
        Transaction transaction2 = this.getCurrentTransaction();
        if (transaction2 != (transaction = transaction2.getTransactionForDataWrite())) {
            this._fireAfterCreateEvent(transaction2, transaction);
        }
        return transaction;
    }

    private void _updateTransactionMap(Transaction transaction, Transaction transaction2) {
        if (transaction == null || transaction == transaction2) {
            return;
        }
        ArrayList<Thread> arrayList = new ArrayList<Thread>(5);
        Iterator iterator = this._transactionMap.keySet().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            if (!thread.isAlive()) {
                iterator.remove();
                continue;
            }
            if (!transaction.equals(this._transactionMap.get(thread))) continue;
            arrayList.add(thread);
        }
        int n = arrayList.size();
        while (n > 0) {
            this._transactionMap.put(arrayList.get(--n), transaction2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTransactionListener(TransactionListener transactionListener) {
        List list = this._transactionListeners;
        synchronized (list) {
            this._transactionListeners.add(transactionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTransactionListener(TransactionListener transactionListener) {
        List list = this._transactionListeners;
        synchronized (list) {
            this._transactionListeners.remove(transactionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _fireEvent(Transaction transaction, Transaction transaction2, TransactionEventAdapter transactionEventAdapter) {
        List list = this._transactionListeners;
        synchronized (list) {
            TransactionEventImpl transactionEventImpl;
            Iterator iterator = this._transactionListeners.iterator();
            TransactionEventImpl transactionEventImpl2 = transactionEventImpl = iterator.hasNext() ? new TransactionEventImpl(transaction, transaction2) : null;
            while (iterator.hasNext()) {
                TransactionListener transactionListener = (TransactionListener)iterator.next();
                transactionEventAdapter.execute(transactionListener, transactionEventImpl);
            }
        }
    }

    protected void _fireAfterCreateEvent(Transaction transaction, Transaction transaction2) {
        this._setCurrentTransaction(transaction2);
        this._fireEvent(transaction, transaction2, new TransactionEventAdapter(){

            public void execute(TransactionListener transactionListener, TransactionEvent transactionEvent) {
                transactionListener.performAfterCreate(transactionEvent);
            }
        });
    }

    protected void _fireBeforeCommitEvent(Transaction transaction, Transaction transaction2) {
        this._fireEvent(transaction, transaction2, new TransactionEventAdapter(){

            public void execute(TransactionListener transactionListener, TransactionEvent transactionEvent) {
                transactionListener.performBeforeCommit(transactionEvent);
            }
        });
    }

    protected void _fireBeforeRollbackEvent(Transaction transaction, Transaction transaction2) {
        this._fireEvent(transaction, transaction2, new TransactionEventAdapter(){

            public void execute(TransactionListener transactionListener, TransactionEvent transactionEvent) {
                transactionListener.performBeforeRollback(transactionEvent);
            }
        });
    }

    protected void _fireSetCurrentEvent(Transaction transaction, Transaction transaction2) {
        this._fireEvent(transaction, transaction2, new TransactionEventAdapter(){

            public void execute(TransactionListener transactionListener, TransactionEvent transactionEvent) {
                transactionListener.performAfterSetCurrent(transactionEvent);
            }
        });
    }

    private static class TransactionEventImpl
    implements TransactionEvent {
        private Transaction _fromT;
        private Transaction _toT;

        public TransactionEventImpl(Transaction transaction, Transaction transaction2) {
            this._fromT = transaction;
            this._toT = transaction2;
        }

        public Transaction getFromTransaction() {
            return this._fromT;
        }

        public Transaction getToTransaction() {
            return this._toT;
        }
    }
}

