/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.express.olapi.transaction.ExpressTransactionProvider;
import oracle.express.olapi.transaction.PrepareLockException;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.transaction.ActiveSubtransactionsException;
import oracle.olapi.transaction.NotCommittableException;
import oracle.olapi.transaction.NotPreparedException;
import oracle.olapi.transaction.Participant;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionInactiveException;
import oracle.olapi.transaction.TransactionProvider;
import oracle.olapi.transaction.TransactionTypeUnavailableException;
import oracle.olapi.transaction.UpdateAwareParticipant;

abstract class ExpressTransaction
implements Transaction {
    private ExpressTransaction _parent;
    private Set _activeSubtransactions;
    private ExpressTransactionProvider _transactionProvider;
    private int _status;
    private Object _statusLock;
    private Set _participants;
    private Set _updateAwareParticipants;
    private ExpressTransaction _prepareLock;

    ExpressTransaction(ExpressTransaction expressTransaction, ExpressTransactionProvider expressTransactionProvider) {
        this._parent = expressTransaction;
        this._activeSubtransactions = new HashSet();
        this._transactionProvider = expressTransactionProvider;
        this._status = 0;
        this._statusLock = new Object();
        this._participants = new HashSet();
        this._updateAwareParticipants = new HashSet();
        if (this._parent != null) {
            this._parent._subtransactionCreated(this);
        }
    }

    public final int getStatus() {
        return this._status;
    }

    public final TransactionProvider getTransactionProvider() {
        return this._transactionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerParticipant(Participant participant) throws TransactionInactiveException {
        Object object = this._statusLock;
        synchronized (object) {
            Set set = this._participants;
            synchronized (set) {
                if (this._status != 0 && this._status != 1) {
                    throw new TransactionInactiveException(this);
                }
                this._participants.add(participant);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterParticipant(Participant participant) {
        Set set = this._participants;
        synchronized (set) {
            this._participants.remove(participant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerUpdateAwareParticipant(UpdateAwareParticipant updateAwareParticipant) throws TransactionInactiveException {
        Object object = this._statusLock;
        synchronized (object) {
            if (this._status != 0 && this._status != 1) {
                throw new TransactionInactiveException(this);
            }
            Set set = this._participants;
            synchronized (set) {
                this._updateAwareParticipants.add(updateAwareParticipant);
                this._participants.add(updateAwareParticipant);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterUpdateAwareParticipant(UpdateAwareParticipant updateAwareParticipant) {
        Set set = this._participants;
        synchronized (set) {
            this._updateAwareParticipants.remove(updateAwareParticipant);
            this._participants.remove(updateAwareParticipant);
        }
    }

    public final boolean isAncestorOf(Transaction transaction) {
        if (this.equals(transaction)) {
            return true;
        }
        if (!(transaction instanceof ExpressTransaction)) {
            return false;
        }
        return this.isAncestorOf(((ExpressTransaction)transaction)._getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void prepare() throws NotCommittableException, TransactionInactiveException {
        HashSet hashSet = this._statusLock;
        synchronized (hashSet) {
            if (this._status != 0) {
                throw new TransactionInactiveException(this);
            }
            if (this._activeSubtransactions.size() > 0) {
                throw new ActiveSubtransactionsException(this.makeList(this._activeSubtransactions));
            }
            this._status = 1;
        }
        Object object = this._participants;
        synchronized (object) {
            hashSet = new HashSet(this._participants);
        }
        try {
            while (!this._participants.isEmpty()) {
                object = new ArrayList(this._participants);
                this._participants.clear();
                Object object2 = object.iterator();
                while (object2.hasNext()) {
                    ((Participant)object2.next()).prepare(this._getParent());
                }
                object2 = this._participants;
                synchronized (object2) {
                    hashSet.addAll(this._participants);
                }
            }
            this._participants = hashSet;
        }
        catch (NotCommittableException notCommittableException) {
            hashSet.addAll(this._participants);
            this._participants = hashSet;
            this._status = 0;
            throw notCommittableException;
        }
        catch (RuntimeException runtimeException) {
            hashSet.addAll(this._participants);
            this._participants = hashSet;
            this._status = 0;
            throw runtimeException;
        }
        try {
            object = this._getParent();
            if (object != null) {
                ((ExpressTransaction)object)._prepareSubtransaction(this);
            }
        }
        catch (NotCommittableException notCommittableException) {
            this._status = 0;
            throw notCommittableException;
        }
        catch (RuntimeException runtimeException) {
            this._status = 0;
            throw runtimeException;
        }
        this._status = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit() throws NotPreparedException, TransactionInactiveException {
        Object object = this._statusLock;
        synchronized (object) {
            if (this._status != 2) {
                if (this._status == 0 || this._status == 1) {
                    throw new NotPreparedException(this);
                }
                throw new TransactionInactiveException(this);
            }
            this._status = 3;
        }
        object = this._participants;
        synchronized (object) {
            HashSet hashSet = new HashSet(this._participants);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((Participant)iterator.next()).commit(this._getParent());
            }
        }
        object = this._getParent();
        if (object != null) {
            ((ExpressTransaction)object)._commitSubtransaction(this);
        }
        this._status = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollback() throws TransactionInactiveException {
        Object object = this._statusLock;
        synchronized (object) {
            if (this._status != 0 && this._status != 2) {
                throw new TransactionInactiveException(this);
            }
            if (this._activeSubtransactions.size() > 0) {
                throw new ActiveSubtransactionsException(this.makeList(this._activeSubtransactions));
            }
            this._status = 5;
        }
        try {
            object = this._participants;
            synchronized (object) {
                HashSet hashSet = new HashSet(this._participants);
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    try {
                        ((Participant)iterator.next()).rollback();
                    }
                    catch (Exception exception) {}
                }
            }
            object = this._getParent();
            if (object != null) {
                ((ExpressTransaction)object)._rollbackSubtransaction(this);
            }
        }
        finally {
            this._status = 6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Transaction createSubtransaction() throws TransactionInactiveException {
        Object object = this._statusLock;
        synchronized (object) {
            if (this._status != 0) {
                throw new TransactionInactiveException(this);
            }
            ExpressTransaction expressTransaction = this._createSubtransaction();
            return expressTransaction;
        }
    }

    public final Transaction getTransactionForMetadataRead() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Transaction getTransactionForMetadataWrite() throws TransactionTypeUnavailableException, TransactionInactiveException {
        Object object = this._statusLock;
        synchronized (object) {
            if (this._status != 0 && this._status != 1) {
                throw new TransactionInactiveException(this);
            }
            return this._getTransactionForMetadataWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Transaction getTransactionForDataRead() throws TransactionTypeUnavailableException, TransactionInactiveException {
        Object object = this._statusLock;
        synchronized (object) {
            if (this._status != 0) {
                throw new TransactionInactiveException(this);
            }
            return this._getTransactionForDataRead();
        }
    }

    public final Transaction getTransactionForDataWrite() throws TransactionTypeUnavailableException, TransactionInactiveException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void _prepareSubtransaction(ExpressTransaction expressTransaction) throws NotCommittableException {
        HashSet hashSet;
        if (this._prepareLock != null) {
            throw new PrepareLockException(this._prepareLock, expressTransaction);
        }
        this._prepareLock = expressTransaction;
        Collection collection = this._participants;
        synchronized (collection) {
            hashSet = new HashSet(this._updateAwareParticipants);
        }
        try {
            while (!this._updateAwareParticipants.isEmpty()) {
                collection = new ArrayList(this._updateAwareParticipants);
                this._updateAwareParticipants.clear();
                Object object = collection.iterator();
                while (object.hasNext()) {
                    ((UpdateAwareParticipant)object.next()).prepareSubtransaction(expressTransaction);
                }
                object = this._participants;
                synchronized (object) {
                    hashSet.addAll(this._updateAwareParticipants);
                }
            }
            this._updateAwareParticipants = hashSet;
        }
        catch (NotCommittableException notCommittableException) {
            hashSet.addAll(this._updateAwareParticipants);
            this._updateAwareParticipants = hashSet;
            this._prepareLock = null;
            throw notCommittableException;
        }
        catch (RuntimeException runtimeException) {
            hashSet.addAll(this._updateAwareParticipants);
            this._updateAwareParticipants = hashSet;
            this._prepareLock = null;
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void _commitSubtransaction(ExpressTransaction expressTransaction) {
        Set set = this._participants;
        synchronized (set) {
            Iterator iterator = this._updateAwareParticipants.iterator();
            while (iterator.hasNext()) {
                ((UpdateAwareParticipant)iterator.next()).commitSubtransaction();
            }
        }
        this._participants.addAll(expressTransaction._participants);
        this._updateAwareParticipants.addAll(expressTransaction._updateAwareParticipants);
        this._prepareLock = null;
        this._activeSubtransactions.remove(expressTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void _rollbackSubtransaction(ExpressTransaction expressTransaction) {
        Set set = this._participants;
        synchronized (set) {
            HashSet hashSet = new HashSet(this._updateAwareParticipants);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                try {
                    ((UpdateAwareParticipant)iterator.next()).rollbackSubtransaction(expressTransaction);
                }
                catch (Exception exception) {}
            }
        }
        if (this._prepareLock == expressTransaction) {
            this._prepareLock = null;
        }
        this._activeSubtransactions.remove(expressTransaction);
    }

    final ExpressTransaction _getParent() {
        return this._parent;
    }

    public final Transaction getParent() {
        return this._getParent();
    }

    final ExpressTransactionProvider _getExpressTransactionProvider() {
        return this._transactionProvider;
    }

    final void _subtransactionCreated(ExpressTransaction expressTransaction) {
        this._activeSubtransactions.add(expressTransaction);
    }

    private List makeList(Set set) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(set);
        return arrayList;
    }

    abstract ExpressTransaction _createSubtransaction();

    abstract ExpressTransaction _getTransactionForMetadataWrite();

    abstract ExpressTransaction _getTransactionForDataRead();

    public abstract boolean isTransactionForDataWrite();
}

