/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.express.idl.ExpressOlapiDataSourceModule.BaseOnlyDefinitionStruct;
import oracle.express.idl.ExpressOlapiDataSourceModule.ComparisonRuleEnum;
import oracle.express.idl.ExpressOlapiDataSourceModule.ConstantListDefinitionStruct;
import oracle.express.idl.ExpressOlapiDataSourceModule.ConstantListValuesUnion;
import oracle.express.idl.ExpressOlapiDataSourceModule.DefinitionPost92Union;
import oracle.express.idl.ExpressOlapiDataSourceModule.DefinitionUnion;
import oracle.express.idl.ExpressOlapiDataSourceModule.DynamicDefinitionStruct;
import oracle.express.idl.ExpressOlapiDataSourceModule.JoinDefinitionStruct;
import oracle.express.idl.ExpressOlapiDataSourceModule.MetadataDefinitionStruct;
import oracle.express.idl.ExpressOlapiDataSourceModule.RangeDefinitionStruct;
import oracle.express.idl.ExpressOlapiDataSourceModule.RecursiveJoinDefinitionStruct;
import oracle.express.idl.ExpressOlapiDataSourceModule.ValueDefinitionStruct;
import oracle.express.idl.ExpressOlapiModule.DataSequenceUnion;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.XMLWriter;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.express.olapi.data.full.DefinitionUnionAdapter;
import oracle.express.olapi.data.full.ExpressDataProvider;
import oracle.express.olapi.data.full.SourceConverter;
import oracle.olapi.Debug;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.source.AliasDefinition;
import oracle.olapi.data.source.ConstantListDefinition;
import oracle.olapi.data.source.DistinctDefinition;
import oracle.olapi.data.source.DynamicDefinition;
import oracle.olapi.data.source.ExtractDefinition;
import oracle.olapi.data.source.HiddenDefinition;
import oracle.olapi.data.source.JoinDefinition;
import oracle.olapi.data.source.PositionDefinition;
import oracle.olapi.data.source.RangeDefinition;
import oracle.olapi.data.source.RecursiveJoinDefinition;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.ValueDefinition;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.MetadataToXMLConverterPrior10105;
import oracle.olapi.metadata.mdm.MdmSourceDefinition;

public final class SourceToStructureConverter
extends SourceConverter {
    private List m_DefinitionUnionList = new ArrayList();
    private List m_InputSourceIndexList = new ArrayList();
    private Map m_SourceToIndexMap = new HashMap();
    private short m_Count;
    private DefinitionUnionAdapter m_CurrentDefinitionUnion = null;
    private boolean m_CurrentDefinitionModified = false;
    private boolean m_CurrentDefinitionAdded = false;
    private MetadataToXMLConverter m_MetadataToXMLConverter = new MetadataToXMLConverterPrior10105();
    private static final short VISITED_THIS_ROUND = -1;
    private static final short VISITED_PREVIOUS_ROUND = -2;
    private static final short STALE_DEFINITION = -3;

    protected SourceToStructureConverter(DefinitionManager definitionManager) {
        super(definitionManager);
    }

    protected final MetadataToXMLConverter getMetadataToXMLConverter() {
        return this.m_MetadataToXMLConverter;
    }

    private Short addDefinition(DefinitionUnionAdapter definitionUnionAdapter, SourceDefinition sourceDefinition) {
        this.getDefinitionUnionList().add(definitionUnionAdapter);
        Short s = this.newIndex();
        this.getSourceToIndexMap().put(sourceDefinition, s);
        this.setCurrentDefinitionAdded(true);
        return s;
    }

    private static ComparisonRuleEnum convertComparisonRuleEnum(int n) {
        switch (n) {
            case 0: {
                return ComparisonRuleEnum.SELECT;
            }
            case 1: {
                return ComparisonRuleEnum.ASC;
            }
            case 2: {
                return ComparisonRuleEnum.DESC;
            }
            case 4: {
                return ComparisonRuleEnum.ASCNULLSFIRST;
            }
            case 5: {
                return ComparisonRuleEnum.DESCNULLSLAST;
            }
            case 3: {
                return ComparisonRuleEnum.XSREMOVE;
            }
        }
        return null;
    }

    private Short convertDefinition(SourceDefinition sourceDefinition, boolean bl) {
        boolean bl2;
        short s;
        Short s2 = this.getIndex(sourceDefinition);
        if (null != s2 && ((s = s2.shortValue()) >= 0 || -1 == s && !bl)) {
            if (this.isModifiedThisRound(sourceDefinition)) {
                this.setCurrentDefinitionModified(true);
            }
            return s2;
        }
        DefinitionUnionAdapter definitionUnionAdapter = this.getCurrentDefinitionUnion();
        boolean bl3 = this.isCurrentDefinitionAdded();
        boolean bl4 = this.isCurrentDefinitionModified();
        this.resetCurrentDefinitionState();
        boolean bl5 = bl2 = null != s2;
        if (!bl2 || bl) {
            ExpressDataProvider expressDataProvider = (ExpressDataProvider)sourceDefinition.getDataProvider();
            DefinitionUnionAdapter definitionUnionAdapter2 = this.createDefinitionUnion(expressDataProvider);
            s2 = this.addDefinition(definitionUnionAdapter2, sourceDefinition);
            if (bl2) {
                definitionUnionAdapter2.idOnly(sourceDefinition.getSource().getID());
            } else {
                this.setCurrentDefinitionUnion(definitionUnionAdapter2);
                this.setCurrentDefinitionModified(true);
            }
        }
        sourceDefinition.acceptVisitor(this, null);
        if (this.isCurrentDefinitionModified()) {
            this.markAsModified(sourceDefinition);
        }
        if (!this.isCurrentDefinitionAdded()) {
            this.getSourceToIndexMap().put(sourceDefinition, new Short(-1));
        }
        this.setCurrentDefinitionUnion(definitionUnionAdapter);
        this.setCurrentDefinitionAdded(bl3);
        if (!this.isCurrentDefinitionModified()) {
            this.setCurrentDefinitionModified(bl4);
        }
        return s2;
    }

    private final void resetCurrentDefinitionState() {
        this.setCurrentDefinitionModified(false);
        this.setCurrentDefinitionUnion(null);
        this.setCurrentDefinitionAdded(false);
    }

    protected final boolean localConvertDefinitionTree(SourceDefinition sourceDefinition, Source[] sourceArray, boolean bl, boolean bl2, List list) {
        int n;
        this.resetCurrentDefinitionState();
        this.convertDefinition(sourceDefinition, bl);
        ArrayList<Short> arrayList = new ArrayList<Short>();
        for (n = 0; n < sourceArray.length; ++n) {
            SourceDefinition sourceDefinition2 = sourceArray[n].getDefinition();
            Short s = this.convertDefinition(sourceDefinition2, true);
            arrayList.add(s);
        }
        int n2 = n = bl2 || this.isCurrentDefinitionModified() ? 1 : 0;
        if (n != 0) {
            this.getInputSourceIndexList().addAll(arrayList);
        }
        list.clear();
        return n != 0;
    }

    private ConstantListValuesUnion createConstantListValuesUnion(List list, boolean bl) {
        ConstantListValuesUnion constantListValuesUnion = null;
        if (bl) {
            constantListValuesUnion = new ConstantListValuesUnion();
        }
        Object var4_4 = null;
        if (!list.isEmpty()) {
            var4_4 = list.get(0);
        }
        if (var4_4 instanceof SourceDefinition) {
            this.populateConstantListValuesUnionWithSources(list, constantListValuesUnion);
            return constantListValuesUnion;
        }
        if (!bl) {
            return null;
        }
        DataSequenceUnion dataSequenceUnion = new DataSequenceUnion();
        constantListValuesUnion.literals(dataSequenceUnion);
        if (var4_4 instanceof String) {
            this.populateConstantListValuesUnionWithStrings(list, dataSequenceUnion);
            return constantListValuesUnion;
        }
        if (var4_4 instanceof Date) {
            this.populateConstantListValuesUnionWithDates(list, dataSequenceUnion);
            return constantListValuesUnion;
        }
        if (var4_4 instanceof Boolean) {
            this.populateConstantListValuesUnionWithBooleans(list, dataSequenceUnion);
            return constantListValuesUnion;
        }
        if (var4_4 instanceof Integer) {
            this.populateConstantListValuesUnionWithIntegers(list, dataSequenceUnion);
            return constantListValuesUnion;
        }
        if (var4_4 instanceof Double) {
            this.populateConstantListValuesUnionWithDoubles(list, dataSequenceUnion);
            return constantListValuesUnion;
        }
        if (var4_4 instanceof Float) {
            this.populateConstantListValuesUnionWithFloats(list, dataSequenceUnion);
            return constantListValuesUnion;
        }
        Debug._assert(list.isEmpty() || var4_4 instanceof Short);
        this.populateConstantListValuesUnionWithShorts(list, dataSequenceUnion);
        return constantListValuesUnion;
    }

    private DefinitionUnionAdapter createDefinitionUnion(ExpressDataProvider expressDataProvider) {
        if (!expressDataProvider.isServerVersionLaterThan(new int[]{9, 2, 0, 3, 0})) {
            return new DefinitionUnionAdapter(new DefinitionUnion());
        }
        return new DefinitionUnionAdapter(new DefinitionPost92Union());
    }

    private void flushIndices() {
        Short s = new Short(-2);
        Short s2 = new Short(-3);
        Iterator iterator = this.getSourceToIndexMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            short s3 = (Short)entry.getValue();
            if (s3 == -2 || s3 == -3) {
                entry.setValue(s2);
                continue;
            }
            entry.setValue(s);
        }
    }

    private short getCount() {
        return this.m_Count;
    }

    private final DefinitionUnionAdapter getCurrentDefinitionUnion() {
        return this.m_CurrentDefinitionUnion;
    }

    public List getDefinitionUnionList() {
        return this.m_DefinitionUnionList;
    }

    private Short getIndex(SourceDefinition sourceDefinition) {
        return (Short)this.getSourceToIndexMap().get(sourceDefinition);
    }

    private boolean isCurrentDefinitionAdded() {
        return this.m_CurrentDefinitionAdded;
    }

    private void setCurrentDefinitionAdded(boolean bl) {
        this.m_CurrentDefinitionAdded = bl;
    }

    private boolean isCurrentDefinitionModified() {
        return this.m_CurrentDefinitionModified;
    }

    private void setCurrentDefinitionModified(boolean bl) {
        this.m_CurrentDefinitionModified = bl;
    }

    short[] getInputSourceIndexArray() {
        List list = this.getInputSourceIndexList();
        short[] sArray = new short[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Short s = (Short)iterator.next();
            sArray[n] = s;
            ++n;
        }
        return sArray;
    }

    private List getInputSourceIndexList() {
        return this.m_InputSourceIndexList;
    }

    private Map getSourceToIndexMap() {
        return this.m_SourceToIndexMap;
    }

    private Short newIndex() {
        Short s = new Short(this.m_Count);
        this.m_Count = (short)(this.m_Count + 1);
        return s;
    }

    private void populateConstantListValuesUnionWithBooleans(List list, DataSequenceUnion dataSequenceUnion) {
        boolean[] blArray = new boolean[list.size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = (Boolean)list.get(i);
        }
        dataSequenceUnion.booleanValues(blArray);
    }

    private void populateConstantListValuesUnionWithDates(List list, DataSequenceUnion dataSequenceUnion) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            Date date = (Date)list.get(i);
            nArray[i] = n = (int)(date.getTime() / 1000L);
        }
        dataSequenceUnion.dateValues(nArray);
    }

    private void populateConstantListValuesUnionWithDoubles(List list, DataSequenceUnion dataSequenceUnion) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (Double)list.get(i);
        }
        dataSequenceUnion.doubleValues(dArray);
    }

    private void populateConstantListValuesUnionWithFloats(List list, DataSequenceUnion dataSequenceUnion) {
        float[] fArray = new float[list.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = ((Float)list.get(i)).floatValue();
        }
        dataSequenceUnion.floatValues(fArray);
    }

    private void populateConstantListValuesUnionWithIntegers(List list, DataSequenceUnion dataSequenceUnion) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)list.get(i);
        }
        dataSequenceUnion.longValues(nArray);
    }

    private void populateConstantListValuesUnionWithShorts(List list, DataSequenceUnion dataSequenceUnion) {
        short[] sArray = new short[list.size()];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (Short)list.get(i);
        }
        dataSequenceUnion.shortValues(sArray);
    }

    private void populateConstantListValuesUnionWithSources(List list, ConstantListValuesUnion constantListValuesUnion) {
        int n = list.size();
        if (null == constantListValuesUnion) {
            for (int i = 0; i < n; ++i) {
                SourceDefinition sourceDefinition = (SourceDefinition)list.get(i);
                this.visitDefinition(sourceDefinition, false);
            }
        } else {
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                SourceDefinition sourceDefinition = (SourceDefinition)list.get(i);
                sArray[i] = this.visitDefinition(sourceDefinition, true);
            }
            constantListValuesUnion.sequenceIndices(sArray);
        }
    }

    private void populateConstantListValuesUnionWithStrings(List list, DataSequenceUnion dataSequenceUnion) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)list.get(i);
        }
        dataSequenceUnion.wstringValues(stringArray);
    }

    final void recover() {
        Map.Entry entry;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getSourceToIndexMap().entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if ((Short)entry.getValue() < 0) continue;
            arrayList.add(entry.getKey());
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            this.getSourceToIndexMap().remove(entry);
        }
    }

    protected final void localReset() {
        this.getDefinitionUnionList().clear();
        this.getInputSourceIndexList().clear();
        this.flushIndices();
        this.resetCount();
    }

    private void resetCount() {
        this.m_Count = 0;
    }

    private void setCount(short s) {
        this.m_Count = s;
    }

    private void setCurrentDefinitionUnion(DefinitionUnionAdapter definitionUnionAdapter) {
        this.m_CurrentDefinitionUnion = definitionUnionAdapter;
    }

    private void setIndex(SourceDefinition sourceDefinition, Short s) {
        this.getSourceToIndexMap().put(sourceDefinition, s);
    }

    public Object visitAliasDefinition(AliasDefinition aliasDefinition, Object object) {
        boolean bl = null != this.getCurrentDefinitionUnion();
        short s = this.visitDefinition(aliasDefinition.getBase(), bl);
        if (bl) {
            this.getCurrentDefinitionUnion().aliasDefinition(new BaseOnlyDefinitionStruct(aliasDefinition.getSource().getID(), s));
        }
        return null;
    }

    public Object visitConstantListDefinition(ConstantListDefinition constantListDefinition, Object object) {
        boolean bl = null != this.getCurrentDefinitionUnion();
        ConstantListValuesUnion constantListValuesUnion = this.createConstantListValuesUnion(constantListDefinition.getElements(), bl);
        if (bl) {
            this.getCurrentDefinitionUnion().constantListDefinition(new ConstantListDefinitionStruct(constantListDefinition.getSource().getID(), constantListValuesUnion));
        }
        return null;
    }

    private short visitDefinition(SourceDefinition sourceDefinition, boolean bl) {
        Short s = this.convertDefinition(sourceDefinition, bl);
        return s;
    }

    public Object visitDistinctDefinition(DistinctDefinition distinctDefinition, Object object) {
        boolean bl = null != this.getCurrentDefinitionUnion();
        short s = this.visitDefinition(distinctDefinition.getBase(), bl);
        if (bl) {
            this.getCurrentDefinitionUnion().distinctDefinition(new BaseOnlyDefinitionStruct(distinctDefinition.getSource().getID(), s));
        }
        return null;
    }

    public Object visitDynamicDefinition(DynamicDefinition dynamicDefinition, Object object) {
        short s;
        boolean bl;
        boolean bl2 = bl = null != this.getCurrentDefinitionUnion();
        if (!bl && (s = dynamicDefinition.isModified(this.getTransaction())) != 0) {
            bl = true;
            ExpressDataProvider expressDataProvider = (ExpressDataProvider)dynamicDefinition.getDataProvider();
            DefinitionUnionAdapter definitionUnionAdapter = this.createDefinitionUnion(expressDataProvider);
            this.setCurrentDefinitionUnion(definitionUnionAdapter);
            this.addDefinition(definitionUnionAdapter, dynamicDefinition);
            this.setCurrentDefinitionModified(true);
        }
        s = this.visitDefinition(dynamicDefinition.getCurrent(), bl);
        if (bl) {
            dynamicDefinition.getTemplate().addCursorLock(this.getCursorLock());
            this.getCurrentDefinitionUnion().dynamicDefinition(new DynamicDefinitionStruct(dynamicDefinition.getSource().getID(), s));
        }
        return null;
    }

    public Object visitExtractDefinition(ExtractDefinition extractDefinition, Object object) {
        boolean bl = null != this.getCurrentDefinitionUnion();
        short s = this.visitDefinition(extractDefinition.getBase(), bl);
        if (bl) {
            this.getCurrentDefinitionUnion().extractDefinition(new BaseOnlyDefinitionStruct(extractDefinition.getSource().getID(), s));
        }
        return null;
    }

    public Object visitHiddenDefinition(HiddenDefinition hiddenDefinition, Object object) {
        boolean bl;
        Object object2;
        Object object3;
        if (hiddenDefinition instanceof MdmSourceDefinition) {
            MdmSourceDefinition mdmSourceDefinition = (MdmSourceDefinition)hiddenDefinition;
            object3 = mdmSourceDefinition.getMdmSource();
            object2 = new ArrayList();
            boolean bl2 = this.getMetadataToXMLConverter().addMetadataObject((BaseMetadataObject)object3, (List)object2);
            if (bl2) {
                this.setCurrentDefinitionModified(true);
            }
        }
        boolean bl3 = bl = null != this.getCurrentDefinitionUnion();
        if (bl) {
            object3 = hiddenDefinition.getSource().getMetadataProvider().getID();
            object2 = hiddenDefinition.getSource().getPersistentID();
            this.getCurrentDefinitionUnion().hiddenDefinition(new MetadataDefinitionStruct(hiddenDefinition.getSource().getID(), (String)object3, (String)object2));
        }
        return null;
    }

    public Object visitJoinDefinition(JoinDefinition joinDefinition, Object object) {
        boolean bl = null != this.getCurrentDefinitionUnion();
        short s = this.visitDefinition(joinDefinition.getBase(), bl);
        short s2 = this.visitDefinition(joinDefinition.getJoined(), bl);
        short s3 = this.visitDefinition(joinDefinition.getComparison(), bl);
        if (bl) {
            ComparisonRuleEnum comparisonRuleEnum = SourceToStructureConverter.convertComparisonRuleEnum(joinDefinition.getComparisonRule());
            this.getCurrentDefinitionUnion().joinDefinition(new JoinDefinitionStruct(joinDefinition.getSource().getID(), s, s2, s3, comparisonRuleEnum, joinDefinition.isVisible()));
        }
        return null;
    }

    public Object visitRecursiveJoinDefinition(RecursiveJoinDefinition recursiveJoinDefinition, Object object) {
        boolean bl = null != this.getCurrentDefinitionUnion();
        short s = this.visitDefinition(recursiveJoinDefinition.getBase(), bl);
        short s2 = this.visitDefinition(recursiveJoinDefinition.getJoined(), bl);
        short s3 = this.visitDefinition(recursiveJoinDefinition.getComparison(), bl);
        short s4 = this.visitDefinition(recursiveJoinDefinition.getParent(), bl);
        if (bl) {
            ComparisonRuleEnum comparisonRuleEnum = SourceToStructureConverter.convertComparisonRuleEnum(recursiveJoinDefinition.getComparisonRule());
            this.getCurrentDefinitionUnion().recursiveJoinDefinition(new RecursiveJoinDefinitionStruct(recursiveJoinDefinition.getSource().getID(), s, s2, s3, s4, comparisonRuleEnum, recursiveJoinDefinition.isParentsFirst(), recursiveJoinDefinition.isParentsRestrictedToBase(), recursiveJoinDefinition.isVisible(), recursiveJoinDefinition.getMaxRecursions()));
        }
        return null;
    }

    public Object visitPositionDefinition(PositionDefinition positionDefinition, Object object) {
        if (positionDefinition.isZeroBased()) {
            throw new UnsupportedOperationException();
        }
        boolean bl = null != this.getCurrentDefinitionUnion();
        short s = this.visitDefinition(positionDefinition.getBase(), bl);
        if (bl) {
            this.getCurrentDefinitionUnion().positionDefinition(new BaseOnlyDefinitionStruct(positionDefinition.getSource().getID(), s));
        }
        return null;
    }

    public Object visitRangeDefinition(RangeDefinition rangeDefinition, Object object) {
        boolean bl = null != this.getCurrentDefinitionUnion();
        short s = this.visitDefinition(rangeDefinition.getBottom(), bl);
        short s2 = this.visitDefinition(rangeDefinition.getTop(), bl);
        if (bl) {
            this.getCurrentDefinitionUnion().rangeDefinition(new RangeDefinitionStruct(rangeDefinition.getSource().getID(), s, s2));
        }
        return null;
    }

    public Object visitValueDefinition(ValueDefinition valueDefinition, Object object) {
        boolean bl = null != this.getCurrentDefinitionUnion();
        short s = this.visitDefinition(valueDefinition.getBase(), bl);
        short s2 = this.visitDefinition(valueDefinition.getInput(), bl);
        if (bl) {
            this.getCurrentDefinitionUnion().valueDefinition(new ValueDefinitionStruct(valueDefinition.getSource().getID(), s, s2));
        }
        return null;
    }

    final void mergeChildTransactionOnCommit(SourceConverter sourceConverter) {
        SourceToStructureConverter sourceToStructureConverter = (SourceToStructureConverter)sourceConverter;
        Map map = sourceToStructureConverter.getSourceToIndexMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.getSourceToIndexMap().put(entry.getKey(), entry.getValue());
        }
        map.clear();
    }

    final XMLWriter finishup(InterfaceStub interfaceStub, Properties properties) {
        XMLWriter xMLWriter = new XMLWriter(interfaceStub);
        this.getMetadataToXMLConverter().generateXML(xMLWriter);
        return xMLWriter;
    }
}

