/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.XMLWriter;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.express.olapi.data.full.ExpressSpecifiedCursorManager;
import oracle.olapi.data.cursor.SourceType;
import oracle.olapi.data.source.CursorLock;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.transaction.Transaction;

public abstract class SourceConverter
extends DataDescriptorDefinitionVisitor {
    private DefinitionManager m_DefinitionManager = null;
    private XMLWriter m_Writer = null;
    private Set m_ModifiedDefinitions = new HashSet();
    private List m_InputSourceTypeList = new ArrayList();
    private List m_InputSourceCountList = new ArrayList();
    private List m_CursorManagerIDList = new ArrayList();
    private Transaction m_Transaction = null;

    protected XMLWriter getWriter() {
        return this.m_Writer;
    }

    protected void setWriter(XMLWriter xMLWriter) {
        this.m_Writer = xMLWriter;
    }

    protected Set getModifiedDefinitions() {
        return this.m_ModifiedDefinitions;
    }

    protected void markAsModified(SourceDefinition sourceDefinition) {
        this.getModifiedDefinitions().add(sourceDefinition);
    }

    protected boolean isModifiedThisRound(SourceDefinition sourceDefinition) {
        return this.getModifiedDefinitions().contains(sourceDefinition);
    }

    protected SourceConverter(DefinitionManager definitionManager) {
        this.m_DefinitionManager = definitionManager;
        this.m_Transaction = definitionManager.getTransaction();
    }

    protected CursorLock getCursorLock() {
        return this.getDefinitionManager();
    }

    protected DefinitionManager getDefinitionManager() {
        return this.m_DefinitionManager;
    }

    protected Transaction getTransaction() {
        return this.m_Transaction;
    }

    protected void setTransaction(Transaction transaction) {
        this.m_Transaction = transaction;
    }

    protected long[] getCursorManagerIDArray() {
        List list = this.getCursorManagerIDList();
        long[] lArray = new long[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            lArray[n] = l;
            ++n;
        }
        return lArray;
    }

    protected List getCursorManagerIDList() {
        return this.m_CursorManagerIDList;
    }

    boolean cursorManagerWasSent(long l) {
        return this.getCursorManagerIDList().contains(new Long(l));
    }

    protected boolean needToRespecifyCursorManagers(boolean bl) {
        return bl;
    }

    short[] getInputSourceCountArray() {
        List list = this.getInputSourceCountList();
        short[] sArray = new short[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Short s = (Short)iterator.next();
            sArray[n] = s;
            ++n;
        }
        return sArray;
    }

    protected List getInputSourceCountList() {
        return this.m_InputSourceCountList;
    }

    SourceType[] getInputSourceTypeArray() {
        List list = this.getInputSourceTypeList();
        SourceType[] sourceTypeArray = new SourceType[list.size()];
        list.toArray(sourceTypeArray);
        return sourceTypeArray;
    }

    protected List getInputSourceTypeList() {
        return this.m_InputSourceTypeList;
    }

    protected abstract MetadataToXMLConverter getMetadataToXMLConverter();

    void convertDefinitionTree(SourceDefinition sourceDefinition, Source[] sourceArray, boolean bl, long l, boolean bl2, List list) {
        boolean bl3 = bl || bl2;
        boolean bl4 = this.localConvertDefinitionTree(sourceDefinition, sourceArray, bl2, bl3, list);
        if (!this.needToRespecifyCursorManagers(bl4)) {
            return;
        }
        ArrayList<SourceType> arrayList = new ArrayList<SourceType>();
        SourceType[] sourceTypeArray = ExpressSpecifiedCursorManager.calculateInputSourceTypes(sourceArray);
        for (int i = 0; i < sourceArray.length; ++i) {
            arrayList.add(sourceTypeArray[i]);
        }
        this.getCursorManagerIDList().add(new Long(l));
        this.getInputSourceTypeList().addAll(arrayList);
        this.getInputSourceCountList().add(new Short((short)sourceArray.length));
    }

    protected abstract boolean localConvertDefinitionTree(SourceDefinition var1, Source[] var2, boolean var3, boolean var4, List var5);

    abstract void recover();

    void success() {
    }

    void reset(InterfaceStub interfaceStub, Transaction transaction) {
        XMLWriter xMLWriter = new XMLWriter(interfaceStub);
        this.setWriter(xMLWriter);
        this.localReset();
        this.getInputSourceCountList().clear();
        this.getInputSourceTypeList().clear();
        this.getCursorManagerIDList().clear();
        this.getModifiedDefinitions().clear();
        this.setTransaction(transaction);
        this.getMetadataToXMLConverter().setTransaction(transaction);
    }

    protected abstract void localReset();

    abstract void mergeChildTransactionOnCommit(SourceConverter var1);

    abstract XMLWriter finishup(InterfaceStub var1, Properties var2);
}

