/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.ArrayList;
import java.util.List;
import oracle.express.olapi.data.CountHolder;
import oracle.express.olapi.data.CursorStructure;
import oracle.express.olapi.data.RandomAccessCompoundCursorStructure;
import oracle.express.olapi.data.SequentialAccessCompoundCursorStructure;
import oracle.express.olapi.data.ValueCursorStructure;
import oracle.olapi.data.source.CompoundCursorSpecification;
import oracle.olapi.data.source.CursorManagerSpecification;
import oracle.olapi.data.source.CursorManagerSpecificationExpiredException;
import oracle.olapi.data.source.CursorSpecification;
import oracle.olapi.data.source.CursorSpecificationVisitor;
import oracle.olapi.data.source.ValueCursorSpecification;

final class FullCursorStructureFactory
extends CursorSpecificationVisitor {
    private static FullCursorStructureFactory _sInstance;

    private static FullCursorStructureFactory _getInstance() {
        if (_sInstance == null) {
            _sInstance = new FullCursorStructureFactory();
        }
        return _sInstance;
    }

    private FullCursorStructureFactory() {
    }

    public static final CursorStructure createCursorStructure(CursorManagerSpecification cursorManagerSpecification, CountHolder countHolder) throws CursorManagerSpecificationExpiredException {
        if (cursorManagerSpecification.isExpired()) {
            throw new CursorManagerSpecificationExpiredException();
        }
        return FullCursorStructureFactory.createCursorStructure(cursorManagerSpecification.getRootCursorSpecification(), countHolder);
    }

    public static final CursorStructure createCursorStructure(CursorSpecification cursorSpecification, CountHolder countHolder) throws CursorManagerSpecificationExpiredException {
        return (CursorStructure)cursorSpecification.acceptVisitor(FullCursorStructureFactory._getInstance(), new Context(countHolder, false));
    }

    public final Object visitCompoundCursorSpecification(CompoundCursorSpecification compoundCursorSpecification, Object object) {
        Context context = (Context)object;
        int n = context.getCountHolder().incrementCount();
        if (compoundCursorSpecification.getDefaultFetchSize() != -1) {
            context.setRandomAccess();
        }
        boolean bl = context.isRandomAccess();
        List list = compoundCursorSpecification.getOutputs();
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            arrayList.add(((CursorSpecification)object2.next()).acceptVisitor(this, object));
        }
        object2 = (ValueCursorStructure)compoundCursorSpecification.getValueCursorSpecification().acceptVisitor(this, object);
        if (bl) {
            return new RandomAccessCompoundCursorStructure(n, compoundCursorSpecification.getSource(), compoundCursorSpecification.isExtentCalculationSpecified(), compoundCursorSpecification.isParentStartCalculationSpecified(), compoundCursorSpecification.isParentEndCalculationSpecified(), compoundCursorSpecification.getDefaultFetchSize(), (ValueCursorStructure)object2, arrayList);
        }
        return new SequentialAccessCompoundCursorStructure(n, compoundCursorSpecification.getSource(), compoundCursorSpecification.isExtentCalculationSpecified(), compoundCursorSpecification.isParentStartCalculationSpecified(), compoundCursorSpecification.isParentEndCalculationSpecified(), compoundCursorSpecification.getDefaultFetchSize(), (ValueCursorStructure)object2, arrayList);
    }

    public final Object visitValueCursorSpecification(ValueCursorSpecification valueCursorSpecification, Object object) {
        Context context = (Context)object;
        int n = context.getCountHolder().incrementCount();
        return new ValueCursorStructure(n, valueCursorSpecification.getSource(), valueCursorSpecification.isExtentCalculationSpecified(), valueCursorSpecification.isParentStartCalculationSpecified(), valueCursorSpecification.isParentEndCalculationSpecified(), valueCursorSpecification.getDefaultFetchSize());
    }

    private static final class Context {
        private CountHolder _countHolder;
        private boolean _randomAccess;

        public Context(CountHolder countHolder, boolean bl) {
            this._countHolder = countHolder;
            this._randomAccess = bl;
        }

        public final CountHolder getCountHolder() {
            return this._countHolder;
        }

        public final boolean isRandomAccess() {
            return this._randomAccess;
        }

        public final void setRandomAccess() {
            this._randomAccess = true;
        }
    }
}

