/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.ArrayList;
import java.util.List;
import oracle.express.ExpressServerException;
import oracle.express.ObjectClosedException;
import oracle.express.TaskInterruptedException;
import oracle.express.idl.ExpressModule.ExpressException;
import oracle.express.idl.ExpressModule.InvalidMetadataException;
import oracle.express.idl.ExpressModule.RemoteObjectClosedException;
import oracle.express.idl.ExpressModule.RemoteTaskInterruptedException;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorManagerInterface;
import oracle.express.idl.ExpressOlapiDataSourceModule.UnmatchedInputsException;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.WstringHolder;
import oracle.express.idl.util.XMLWriter;
import oracle.express.olapi.data.full.BaseCursorManager;
import oracle.express.olapi.data.full.CursorLockReleaser;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.express.olapi.data.full.ParameterToXMLConverter;
import oracle.express.olapi.data.full.SourceConverter;
import oracle.olapi.data.source.CursorLockException;
import oracle.olapi.data.source.Parameter;
import oracle.olapi.data.source.SQLCursorManager;
import oracle.olapi.data.source.Source;
import oracle.olapi.transaction.Transaction;
import org.omg.CORBA.NO_IMPLEMENT;

public class ExpressSQLCursorManager
extends BaseCursorManager
implements SQLCursorManager {
    ExpressSQLCursorManager(Source source, CursorManagerInterface cursorManagerInterface, long l, DefinitionManager definitionManager, List list) {
        super(source, cursorManagerInterface, l, definitionManager, list);
    }

    public final String generateSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        this.generateSQL(stringBuffer);
        return stringBuffer.toString();
    }

    public final void generateSQL(StringBuffer stringBuffer) {
        Object object;
        Object object2;
        String string;
        if (this.getParameters().size() == 0) {
            string = " ";
        } else {
            Object object3;
            object2 = new ParameterToXMLConverter();
            XMLWriter xMLWriter = new XMLWriter((InterfaceStub)((Object)this.getCursorManagerInterface()));
            ((ParameterToXMLConverter)object2).setWriter(xMLWriter);
            xMLWriter.beginElement("ClientData");
            xMLWriter.closeTag();
            xMLWriter.beginElement("SourceDefinitions");
            xMLWriter.closeTag();
            object = this.getParameters().iterator();
            while (object.hasNext()) {
                object3 = (Parameter)object.next();
                ((ParameterToXMLConverter)object2).visitParameter((Parameter)object3);
            }
            xMLWriter.endElement("SourceDefinitions");
            xMLWriter.newLine();
            xMLWriter.endElement("ClientData");
            object3 = new StringBuffer(xMLWriter.getStringLength());
            StringBuffer[] stringBufferArray = xMLWriter.getSegmentedStrings();
            for (int i = 0; i < stringBufferArray.length; ++i) {
                ((StringBuffer)object3).append(stringBufferArray[i]);
            }
            string = ((StringBuffer)object3).toString();
        }
        object2 = new WstringHolder();
        try {
            this.getCursorManagerInterface().generateSQL(string, (WstringHolder)object2);
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteObjectClosedException remoteObjectClosedException) {
            this._closed();
            throw new ObjectClosedException(remoteObjectClosedException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            this._closed();
            throw new ObjectClosedException(nO_IMPLEMENT.toString());
        }
        catch (UnmatchedInputsException unmatchedInputsException) {
            object = new ArrayList<String>();
            for (int i = 0; i < unmatchedInputsException.ids.length; ++i) {
                object.add(unmatchedInputsException.ids[i]);
            }
            throw new oracle.olapi.data.source.UnmatchedInputsException((List)object);
        }
        catch (InvalidMetadataException invalidMetadataException) {
            throw new oracle.olapi.metadata.InvalidMetadataException(invalidMetadataException);
        }
        stringBuffer.append(((WstringHolder)object2).value);
    }

    protected final void localCreateDefinitionSequence(Transaction transaction, SourceConverter sourceConverter) {
        boolean bl = false;
        Source[] sourceArray = new Source[]{};
        try {
            sourceConverter.convertDefinitionTree(this.getSource().getDefinition(), sourceArray, bl, this.getCursorManagerID(), false, this.getParameters());
        }
        catch (CursorLockException cursorLockException) {
            CursorLockReleaser.releaseCursorLock(this.getSource().getDefinition(), this.getDefinitionManager());
            throw cursorLockException;
        }
    }
}

