/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.List;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorManagerInterface;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorSpecifierStruct;
import oracle.express.olapi.data.CursorFactory;
import oracle.express.olapi.data.full.DataCursorManager;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.express.olapi.replay.ExceptionDefinitionWriter;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.cursor.Cursor;
import oracle.olapi.data.cursor.CursorInput;
import oracle.olapi.data.cursor.SpecificationUpdateNeededException;
import oracle.olapi.data.source.CursorInfoSpecification;
import oracle.olapi.data.source.CursorSpecification;
import oracle.olapi.data.source.Parameter;
import oracle.olapi.data.source.Source;

public class ExpressDataCursorManager
extends DataCursorManager {
    private int m_FetchSize = -1;
    private CursorInfoSpecification m_CursorInfoSpec = null;

    ExpressDataCursorManager(Source source, int n, CursorInfoSpecification cursorInfoSpecification, CursorManagerInterface cursorManagerInterface, long l, DefinitionManager definitionManager, List list) {
        super(source, cursorManagerInterface, l, definitionManager, list);
        this.setNeedsSpecificationUpdate(false);
        this.setCursorInfoSpecification(cursorInfoSpecification);
        this.setFetchSize(n);
    }

    private void setCursorInfoSpecification(CursorInfoSpecification cursorInfoSpecification) {
        this.m_CursorInfoSpec = cursorInfoSpecification;
    }

    CursorInfoSpecification getCursorInfoSpecification() {
        return this.m_CursorInfoSpec;
    }

    public final synchronized Cursor createCursor() throws SpecificationUpdateNeededException {
        try {
            Parameter[] parameterArray;
            if (this.isSpecificationUpdateNeeded()) {
                throw new SpecificationUpdateNeededException();
            }
            if (!this.isPreparedForOpenCursor()) {
                parameterArray = null;
                try {
                    parameterArray = (CursorSpecification)this.getCursorInfoSpecification();
                }
                catch (ClassCastException classCastException) {
                    throw new UnsupportedOperationException();
                }
                this.prepareForOpenCursor((CursorSpecification)parameterArray, null);
            }
            parameterArray = new Parameter[this.getParameters().size()];
            this.getParameters().toArray(parameterArray);
            return CursorFactory.createCursor(this.getRootCursorStructure(), this.getNumCursorStructures(), this.getCursorBlockManager(), parameterArray);
        }
        catch (RuntimeException runtimeException) {
            ExceptionDefinitionWriter.dispatch(this.getSource(), runtimeException);
            throw runtimeException;
        }
    }

    public final void updateSpecification(CursorInfoSpecification cursorInfoSpecification) throws IllegalArgumentException {
        if (!this.getTransaction().equals(cursorInfoSpecification.getTransaction())) {
            throw new IllegalArgumentException();
        }
        this.setCursorInfoSpecification(cursorInfoSpecification);
        CursorSpecification cursorSpecification = null;
        try {
            cursorSpecification = (CursorSpecification)cursorInfoSpecification;
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException();
        }
        CursorSpecifierStruct[] cursorSpecifierStructArray = DefinitionManager._cursorSpecificationToCursorSpecifierSequence(cursorSpecification);
        this.updateSpecification(cursorSpecifierStructArray);
    }

    public final int getFetchSize() {
        return this.m_FetchSize;
    }

    public final void setFetchSize(int n) {
        this.m_FetchSize = n;
    }

    public final Cursor createCursor(CursorInput[] cursorInputArray) {
        throw new UnsupportedOperationException();
    }
}

