/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.aw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.express.aw.AWMetadataLookup;
import oracle.express.spl.NAValueException;
import oracle.express.spl.SPLExecutor;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mtm.MtmAWColumnExpression;
import oracle.olapi.metadata.mtm.MtmAWView;
import oracle.olapi.metadata.mtm.MtmInvalidMetadataException;
import oracle.olapi.metadata.mtm.MtmSolvedLevelHierarchyMap;

public abstract class AWHelper {
    protected SPLExecutor spl = null;
    protected AWMetadataLookup m_AWLookup;
    private Collection attachedAW = new ArrayList();
    public static final String ATTACHAW_PROGNAME = "__AWG.ATTACH";
    public static final String LEVELDIM_PROGNAME = "__AWG.GETLEVELDIM";
    public static final String LEVELREL_PROGNAME = "__AWG.GETLEVELREL";
    public static final String HIERDIM_PROGNAME = "__AWG.GETHIERDIM";
    public static final String FAMILYREL_PROGNAME = "__AWG.GETFAMILYREL";
    public static final String TIMESPAN_PROGNAME = "__AWG.GETTIMESPAN";
    public static final String ENDDATE_PROGNAME = "__AWG.GETENDDATE";
    public static final String PARENTREL_PROGNAME = "__AWG.GETPARENTREL";
    public static final String LEVELBYPOS_PROGNAME = "__AWG.GETLEVELPOS";
    public static final String STOREVAL_VARNAME = "__AWG.SAVED.DIMVAL";
    public static final String STOREVAL_PROGNAME = "__AWG.STOREVAL";

    public AWHelper(AWMetadataLookup aWMetadataLookup) {
        this.m_AWLookup = aWMetadataLookup;
        this.spl = new SPLExecutor(this.m_AWLookup.getDataProvider().getConnection());
        try {
            this.spl.initialize();
        }
        catch (Exception exception) {
            this.spl = null;
        }
    }

    protected abstract boolean initialize();

    public String getAWName(MdmLevelHierarchy mdmLevelHierarchy) throws MtmInvalidMetadataException {
        try {
            MtmSolvedLevelHierarchyMap mtmSolvedLevelHierarchyMap = (MtmSolvedLevelHierarchyMap)mdmLevelHierarchy.getLevelHierarchyMap();
            MtmAWColumnExpression mtmAWColumnExpression = (MtmAWColumnExpression)mtmSolvedLevelHierarchyMap.getETExpression();
            MtmAWView mtmAWView = (MtmAWView)mtmSolvedLevelHierarchyMap.getTable();
            String string = mtmAWView.getAWName();
            String string2 = mtmAWColumnExpression.getAWObjectName();
            if (string == null || string2 == null) {
                throw new MtmInvalidMetadataException();
            }
            this.openAW(string);
            return string2;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    protected int findLevelPosition(MdmLevel mdmLevel) throws MtmInvalidMetadataException {
        MdmLevelHierarchy mdmLevelHierarchy = mdmLevel.getLevelHierarchy();
        String string = this.getAWName(mdmLevelHierarchy);
        int n = 0;
        List list = mdmLevelHierarchy.getLevels();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MdmLevel mdmLevel2 = (MdmLevel)iterator.next();
            if (mdmLevel.equals(mdmLevel2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void openAW(String string) {
        if (!this.attachedAW.contains(string = AWMetadataLookup.removePrefix(string, '.'))) {
            this.executeCommand(ATTACHAW_PROGNAME, new String[]{string});
            this.attachedAW.add(string);
        }
    }

    public abstract String getHierarchyName(MdmLevelHierarchy var1) throws MtmInvalidMetadataException;

    public abstract String getLevelName(MdmLevel var1) throws MtmInvalidMetadataException;

    public abstract String getFamilyRelation(MdmLevelHierarchy var1) throws MtmInvalidMetadataException;

    public abstract String getHierarchyDimension(MdmLevelHierarchy var1) throws MtmInvalidMetadataException;

    public abstract String getLevelDimension(MdmLevelHierarchy var1) throws MtmInvalidMetadataException;

    public abstract String getLevelRelation(MdmLevelHierarchy var1) throws MtmInvalidMetadataException;

    public abstract String getParentRelation(MdmLevelHierarchy var1) throws MtmInvalidMetadataException;

    public abstract String getTimeSpan(MdmLevelHierarchy var1) throws MtmInvalidMetadataException;

    public abstract String getEnddate(MdmLevelHierarchy var1) throws MtmInvalidMetadataException;

    protected String evaluateDMLFunction(String string, String string2) {
        return this.evaluateDMLFunction(string, new String[]{string2});
    }

    protected String quote(String string) {
        StringBuffer stringBuffer = new StringBuffer(40);
        this.appendQuotedLine(stringBuffer, string);
        return stringBuffer.toString();
    }

    protected String evaluateDMLFunctionWithQuotedArgument(String string, String string2) {
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer(80);
        try {
            stringBuffer.append(string);
            stringBuffer.append('(');
            this.appendQuotedLine(stringBuffer, string2);
            stringBuffer.append(')');
            string3 = this.spl.evaluateStringExpression(stringBuffer.toString());
            return string3;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String evaluateDMLFunction(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(string);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(i == 0 ? "(" : ",");
                stringBuffer.append(stringArray[i]);
            }
            stringBuffer.append(")");
        }
        try {
            return this.spl.evaluateStringExpression(stringBuffer.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void defineProgram(String string, String string2, String[] stringArray) {
        this.defineObject(string, (string2 != null ? string2 : "") + " PROGRAM");
        this.defineBlock("PROGRAM", stringArray);
    }

    protected void defineObject(String string, String string2) {
        try {
            if (this.spl.evaluateBooleanExpression("exists('" + string + "') eq FALSE")) {
                this.spl.executeCommand("DEFINE " + string + " " + string2 + " AW EXPRESS");
            }
        }
        catch (NAValueException nAValueException) {
            // empty catch block
        }
    }

    protected void executeCommand(String string, String[] stringArray) {
        try {
            StringBuffer stringBuffer = new StringBuffer(80);
            stringBuffer.append("CALL ");
            stringBuffer.append(string);
            if (stringArray.length > 0) {
                stringBuffer.append("(");
                this.appendQuotedLine(stringBuffer, stringArray[0]);
                for (int i = 1; i < stringArray.length; ++i) {
                    stringBuffer.append(",");
                    this.appendQuotedLine(stringBuffer, stringArray[i]);
                }
                stringBuffer.append(")");
            }
            this.spl.executeCommand(stringBuffer.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void defineBlock(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append(string);
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append(" JOINLINES(-\n");
            for (int i = 0; i < stringArray.length; ++i) {
                this.appendQuotedLine(stringBuffer, stringArray[i]);
            }
            stringBuffer.append(")");
        }
        this.spl.executeCommand(stringBuffer.toString());
    }

    protected void appendQuotedLine(StringBuffer stringBuffer, String string) {
        stringBuffer.append("'");
        int n = -1;
        int n2 = 0;
        while ((n2 = string.indexOf(39, ++n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append("\\'");
            n = n2;
        }
        stringBuffer.append(string.substring(n));
        stringBuffer.append("'");
    }
}

