/*
 * Decompiled with CFR 0.152.
 */
package oracle.express;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.express.ErrorDescription;
import oracle.express.ResourceBundleHelper;
import oracle.express.idl.ExpressModule.ErrorClassEnum;
import oracle.express.idl.ExpressModule.ExpressException;
import oracle.olapi.HasLocalizedMessage;

public final class ErrorStack
implements HasLocalizedMessage,
Serializable {
    private static final int _ERROR_CLASS_FIRST = 0;
    public static final int ERROR_CLASS_OLAPI = 0;
    public static final int ERROR_CLASS_CORBA_SYSTEM = 1;
    public static final int ERROR_CLASS_UNKNOWN_ERROR = 2;
    public static final int ERROR_CLASS_EXPRESS_FAILURE = 3;
    public static final int ERROR_CLASS_EXPRESS_FATAL = 4;
    public static final int ERROR_CLASS_EXPRESS_TERMINATE = 5;
    private static final int _ERROR_CLASS_LAST = 5;
    private ExpressException _e;
    private List _errorDescriptions;

    public ErrorStack(ExpressException expressException) {
        this._e = expressException;
    }

    public final List getErrorDescriptions() {
        if (this._errorDescriptions == null) {
            ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>(this._e.errorDescriptions.length);
            for (int i = 0; i < this._e.errorDescriptions.length; ++i) {
                arrayList.add(new ErrorDescription(this._e.errorDescriptions[i]));
            }
            this._errorDescriptions = Collections.unmodifiableList(arrayList);
        }
        return this._errorDescriptions;
    }

    public final int getErrorClass() {
        if (this._e.errorClass.equals(ErrorClassEnum.OLAPI)) {
            return 0;
        }
        if (this._e.errorClass.equals(ErrorClassEnum.CORBA_SYSTEM)) {
            return 1;
        }
        if (this._e.errorClass.equals(ErrorClassEnum.UNKNOWN_ERROR)) {
            return 2;
        }
        if (this._e.errorClass.equals(ErrorClassEnum.EXPRESS_FAILURE)) {
            return 3;
        }
        if (this._e.errorClass.equals(ErrorClassEnum.EXPRESS_FATAL)) {
            return 4;
        }
        if (this._e.errorClass.equals(ErrorClassEnum.EXPRESS_TERMINATE)) {
            return 5;
        }
        return -1;
    }

    public String getLocalizedMessage(Locale locale) {
        Object[] objectArray;
        String string = ResourceBundleHelper._getResourceBundle(locale).getString("ErrorStack");
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getErrorDescriptions().iterator();
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            stringBuffer.append(objectArray.getLocalizedMessage(locale));
            stringBuffer.append("\n");
        }
        objectArray = new Object[]{ErrorStack._errorClassToString(this.getErrorClass(), locale), stringBuffer.toString()};
        String string2 = MessageFormat.format(string, objectArray);
        return string2;
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public final String toString() {
        return this.getLocalizedMessage();
    }

    private static final String _errorClassToString(int n, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleHelper._getResourceBundle(locale);
        switch (n) {
            case 0: {
                return resourceBundle.getString("Olapi");
            }
            case 1: {
                return resourceBundle.getString("CorbaSystem");
            }
            case 2: {
                return resourceBundle.getString("UnknownError");
            }
            case 3: {
                return resourceBundle.getString("ExpressFailure");
            }
            case 4: {
                return resourceBundle.getString("ExpressFatal");
            }
            case 5: {
                return resourceBundle.getString("ExpressTerminate");
            }
        }
        return null;
    }
}

