/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.dependency.index;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.dependency.DependencyManager;
import oracle.ide.dependency.IdDeclaration;
import oracle.ide.dependency.IdDeclarationProvider;
import oracle.ide.dependency.IdReference;
import oracle.ide.dependency.Reference;
import oracle.ide.dependency.index.DependencyCriteria;
import oracle.ide.dependency.index.IndexDeclaration;
import oracle.ide.dependency.index.IndexDeclarationProvider;
import oracle.ide.index.DataCollector;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.Project;
import oracle.ideimpl.dependency.index.DependencyCollector;
import oracle.ideimpl.index.IndexingContextImpl;

public class IndexIdDeclarationProvider
extends IndexDeclarationProvider
implements IdDeclarationProvider {
    @Override
    public Collection<QueryCriteria> getDeclarationCriteria(Context context, Reference reference) {
        if (reference instanceof IdReference) {
            String id = ((IdReference)reference).getDeclarationId();
            return Collections.singleton(DependencyCriteria.getDeclarationCriteria(id));
        }
        return Collections.emptySet();
    }

    @Override
    public boolean canGetDeclaration(Context context, String id) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdDeclaration getDeclaration(Context context, String id) throws InterruptedException {
        Project project = context.getProject();
        if (project != null) {
            Index index = IndexManager.getIndexManager().getIndex(project);
            try {
                URL[] urls;
                QueryCriteria criteria = new QueryCriteria();
                criteria.put((Object)"dependency.declaration", (Object)id);
                for (URL url : urls = (URL[])index.query(criteria).get()) {
                    DependencyCollector dc = new DependencyCollector();
                    IndexingContextImpl ic = new IndexingContextImpl(project);
                    ic.setFilterKey((Object)"dependency.declaration");
                    ic.startIndexing();
                    try {
                        ic.index(url, -1L, (DataCollector)dc);
                    }
                    finally {
                        ic.endIndexing();
                    }
                    for (IndexDeclaration declaration : dc.getDeclarations()) {
                        IndexDeclaration idDeclaration;
                        if (!(declaration instanceof IdDeclaration) || !id.equals((idDeclaration = declaration).getDeclarationId())) continue;
                        IndexDeclaration indexDeclaration = idDeclaration;
                        return indexDeclaration;
                    }
                }
            }
            catch (ExecutionException e) {
                DependencyManager.getDependencyManager().getLogger().log(Level.SEVERE, "Unable to get declaration for " + id, e);
            }
            finally {
                index.release();
            }
        }
        return null;
    }
}

