/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.dependency;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.dependency.Declaration;
import oracle.ide.dependency.DeclarationProvider;
import oracle.ide.dependency.DependencyManager;
import oracle.ide.dependency.ProgressIndicator;
import oracle.ide.dependency.Reference;
import oracle.ide.dependency.ReferenceProvider;
import oracle.ide.dependency.Scope;
import oracle.ide.model.Node;
import oracle.ide.performance.PerformanceLogger;

public class DependencyManagerImpl
extends DependencyManager {
    private static final ProgressIndicator NULL_PROGRESS_INDICATOR = new ProgressIndicator(){

        @Override
        public void setProgress(int progress) {
        }

        @Override
        public void setProgressText(String text) {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }
    };
    final CopyOnWriteArrayList<DeclarationProvider> declarationProviders = new CopyOnWriteArrayList();
    final CopyOnWriteArrayList<ReferenceProvider> referenceProviders = new CopyOnWriteArrayList();

    static void checkEventThread() {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalArgumentException("Cannot be called on event thread");
        }
    }

    @Override
    public Logger getLogger() {
        return Logger.getLogger(DependencyManager.class.getName());
    }

    @Override
    public Declaration getDeclaration(final Context context) {
        final Result result = DependencyManagerImpl.createResult();
        this.callProviders(this.declarationProviders, NULL_PROGRESS_INDICATOR, "oracle.ideimpl.dependency.DependencyManagerImpl.getDeclaration", new ProviderTask<DeclarationProvider>(){

            @Override
            public boolean run(DeclarationProvider provider, ProgressIndicator progress) {
                if (provider.canGetDeclaration(context)) {
                    result.setResult(provider.getDeclaration(context));
                    return !result.isSet();
                }
                return true;
            }
        });
        return (Declaration)result.getResult();
    }

    @Override
    public Reference getReference(final Context context) {
        final Result result = DependencyManagerImpl.createResult();
        this.callProviders(this.referenceProviders, NULL_PROGRESS_INDICATOR, "oracle.ideimpl.dependency.DependencyManagerImpl.getReference", new ProviderTask<ReferenceProvider>(){

            @Override
            public boolean run(ReferenceProvider provider, ProgressIndicator progress) {
                if (provider.canGetReference(context)) {
                    result.setResult(provider.getReference(context));
                }
                return !result.isSet();
            }
        });
        return (Reference)result.getResult();
    }

    @Override
    public Collection<Reference> getReferences(final Context context, final Node node) throws InterruptedException {
        DependencyManagerImpl.checkEventThread();
        final HashSet references = new HashSet();
        this.callProviders(this.referenceProviders, NULL_PROGRESS_INDICATOR, "oracle.ideimpl.dependency.DependencyManagerImpl.getReferences", new InterruptibleProviderTask<ReferenceProvider>(){

            @Override
            public boolean run(ReferenceProvider provider, ProgressIndicator progress) throws InterruptedException {
                Collection<? extends Reference> results;
                if (provider.canGetReferences(context, node) && (results = provider.getReferences(context, node)) != null) {
                    references.addAll(results);
                }
                return true;
            }
        });
        return Collections.unmodifiableCollection(references);
    }

    @Override
    public Collection<Declaration> getDeclarations(final Context context, final Node node) throws InterruptedException {
        DependencyManagerImpl.checkEventThread();
        final HashSet declarations = new HashSet();
        this.callProviders(this.declarationProviders, NULL_PROGRESS_INDICATOR, "oracle.ideimpl.dependency.DependencyManagerImpl.getReferences", new InterruptibleProviderTask<DeclarationProvider>(){

            @Override
            public boolean run(DeclarationProvider provider, ProgressIndicator progress) throws InterruptedException {
                Collection<? extends Declaration> results;
                if (provider.canGetDeclarations(context, node) && (results = provider.getDeclarations(context, node)) != null) {
                    declarations.addAll(results);
                }
                return true;
            }
        });
        return Collections.unmodifiableCollection(declarations);
    }

    @Override
    public Collection<Declaration> getTopLevelDeclarations(final Context context, final Node node) throws InterruptedException {
        DependencyManagerImpl.checkEventThread();
        final HashSet declarations = new HashSet();
        this.callProviders(this.declarationProviders, NULL_PROGRESS_INDICATOR, "oracle.ideimpl.dependency.DependencyManagerImpl.getReferences", new InterruptibleProviderTask<DeclarationProvider>(){

            @Override
            public boolean run(DeclarationProvider provider, ProgressIndicator progress) throws InterruptedException {
                Collection<? extends Declaration> results;
                if (provider.canGetDeclarations(context, node) && (results = provider.getTopLevelDeclarations(context, node)) != null) {
                    declarations.addAll(results);
                }
                return true;
            }
        });
        return Collections.unmodifiableCollection(declarations);
    }

    @Override
    public Collection<Reference> findReferences(Context context, Scope scope, Declaration declaration) throws InterruptedException {
        return this.findReferences(context, scope, declaration, NULL_PROGRESS_INDICATOR);
    }

    @Override
    public Collection<Reference> findReferences(final Context context, final Scope scope, final Declaration declaration, ProgressIndicator progress) throws InterruptedException {
        DependencyManagerImpl.checkEventThread();
        final HashSet references = new HashSet();
        this.callProviders(this.referenceProviders, progress, "oracle.ideimpl.dependency.DependencyManagerImpl.findUrlsReferencing", new InterruptibleProviderTask<ReferenceProvider>(){

            @Override
            public boolean run(ReferenceProvider provider, ProgressIndicator progress) throws InterruptedException {
                Collection<? extends Reference> results;
                if (provider.canFindReferences(context, scope, declaration) && (results = provider.findReferences(context, scope, declaration, progress)) != null) {
                    references.addAll(results);
                }
                return true;
            }
        });
        return Collections.unmodifiableCollection(references);
    }

    @Override
    public void addDeclarationProvider(DeclarationProvider provider) {
        this.declarationProviders.add(provider);
    }

    @Override
    public void addReferenceProvider(ReferenceProvider provider) {
        this.referenceProviders.add(provider);
    }

    @Override
    public Collection<DeclarationProvider> getDeclarationProviders() {
        return Collections.unmodifiableCollection(this.declarationProviders);
    }

    @Override
    public Collection<ReferenceProvider> getReferenceProviders() {
        return Collections.unmodifiableCollection(this.referenceProviders);
    }

    private <T> void callProviders(Collection<T> providers, ProgressIndicator progress, String name, final ProviderTask<T> task) {
        try {
            this.callProviders(providers, progress, name, new InterruptibleProviderTask<T>(){

                @Override
                public boolean run(T provider, ProgressIndicator progress) {
                    return task.run(provider, progress);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Non-interruptible task threw InterruptedException", e);
        }
    }

    private <T> void callProviders(Collection<T> providers, ProgressIndicator progress, String name, InterruptibleProviderTask<T> task) throws InterruptedException {
        for (T provider : providers) {
            try {
                long start = System.nanoTime();
                boolean result = task.run(provider, progress);
                PerformanceLogger.get().log(name, provider.getClass().getName(), System.nanoTime() - start);
                if (result) continue;
                break;
            }
            catch (RuntimeException e) {
                this.getLogger().log(Level.SEVERE, "Exception in " + provider.getClass().getName(), e);
            }
        }
    }

    private static <T> Result<T> createResult() {
        return new Result();
    }

    private static final class Result<T> {
        private T result;

        private Result() {
        }

        T getResult() {
            return this.result;
        }

        void setResult(T result) {
            this.result = result;
        }

        boolean isSet() {
            return this.result != null;
        }
    }

    private static interface InterruptibleProviderTask<T> {
        public boolean run(T var1, ProgressIndicator var2) throws InterruptedException;
    }

    private static interface ProviderTask<T> {
        public boolean run(T var1, ProgressIndicator var2);
    }
}

