/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dependency.index;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.dependency.Declaration;
import oracle.ide.dependency.DependencyManager;
import oracle.ide.dependency.ProgressIndicator;
import oracle.ide.dependency.Reference;
import oracle.ide.dependency.ReferenceProvider;
import oracle.ide.dependency.Scope;
import oracle.ide.dependency.index.IndexReference;
import oracle.ide.index.DataCollector;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.dependency.index.DependencyCollector;
import oracle.ideimpl.index.IndexingContextImpl;
import oracle.javatools.data.PropertyStorage;

public abstract class IndexReferenceProvider
implements ReferenceProvider {
    protected abstract Collection<QueryCriteria> getReferenceCriteria(Context var1, Declaration var2);

    protected ContentSet getContentSet(Context context, Project project, Declaration declaration) {
        return ProjectContent.getInstance((PropertyStorage)project).getAllContents();
    }

    @Override
    public boolean canGetReference(Context context) {
        return false;
    }

    @Override
    public Reference getReference(Context context) {
        return null;
    }

    @Override
    public boolean canGetReferences(Context context, Node node) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Collection<? extends Reference> getReferences(Context context, Node node) throws InterruptedException {
        Project project = context.getProject();
        Index index = IndexManager.getIndexManager().getIndex(project);
        index.lock();
        DependencyCollector dc = new DependencyCollector();
        IndexingContextImpl ic = new IndexingContextImpl(project);
        ic.setFilterKey((Object)"dependency.reference");
        ic.startIndexing();
        try {
            ic.index(node.getURL(), -1L, (DataCollector)dc);
        }
        finally {
            ic.endIndexing();
        }
        Collection<IndexReference> collection = Collections.unmodifiableCollection(dc.getReferences());
        index.unlock();
        index.release();
        return collection;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        index.unlock();
                        throw throwable;
                    }
                    catch (LockFailedException e) {
                        DependencyManager.getDependencyManager().getLogger().log(Level.SEVERE, "Unable to get references for " + URLFileSystem.getPlatformPathName((URL)node.getURL()), e);
                        index.release();
                    }
                }
                catch (Throwable throwable2) {
                    index.release();
                    throw throwable2;
                }
            }
        }
        return Collections.emptySet();
    }

    @Override
    public boolean canFindReferences(Context context, Scope scope, Declaration declaration) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends Reference> findReferences(Context context, Scope scope, Declaration declaration, ProgressIndicator progress) throws InterruptedException {
        ArrayList<IndexReference> references = new ArrayList<IndexReference>();
        for (Project project : scope.getProjects()) {
            ContentSet content = this.getContentSet(context, project, declaration);
            Index index = IndexManager.getIndexManager().getIndex(project, content);
            try {
                index.lock();
                try {
                    for (QueryCriteria criteria : this.getReferenceCriteria(context, declaration)) {
                        URL[] urls;
                        for (URL url : urls = (URL[])index.query(criteria).get()) {
                            if (!scope.isIncluded(project, content, url)) continue;
                            DependencyCollector dc = new DependencyCollector();
                            IndexingContextImpl ic = new IndexingContextImpl(project);
                            ic.setFilterKey((Object)"dependency.reference");
                            ic.startIndexing();
                            try {
                                ic.index(url, -1L, (DataCollector)dc);
                            }
                            finally {
                                ic.endIndexing();
                            }
                            Collection<IndexReference> urlReferences = dc.getReferences();
                            Iterator<IndexReference> iterator = urlReferences.iterator();
                            while (iterator.hasNext()) {
                                IndexReference reference = iterator.next();
                                if (this.verify(context, reference, declaration)) continue;
                                iterator.remove();
                            }
                            references.addAll(urlReferences);
                        }
                    }
                }
                finally {
                    index.unlock();
                }
            }
            catch (LockFailedException e) {
                DependencyManager.getDependencyManager().getLogger().log(Level.SEVERE, "Unable to find references", e);
            }
            catch (ExecutionException e) {
                DependencyManager.getDependencyManager().getLogger().log(Level.SEVERE, "Unable to find references", e);
            }
            finally {
                index.release();
            }
        }
        return Collections.unmodifiableCollection(references);
    }

    protected boolean verify(Context context, IndexReference reference, Declaration declaration) throws InterruptedException {
        return reference.isReferenceTo(context, declaration);
    }
}

