/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.DBObjectSearch;
import oracle.dbtools.raptor.controls.celleditor.PairElement;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.xml.XMLUtil;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.UtDataTypeConnectionProvider;
import oracle.dbtools.unit_test.UtDataTypeFactory;
import oracle.dbtools.unit_test.codehook.ICodeHook;
import oracle.dbtools.unit_test.config.UtConfig;
import oracle.dbtools.unit_test.create_wizard.CreateWizArb;
import oracle.dbtools.unit_test.editor.DynamicValueQuery;
import oracle.dbtools.unit_test.manage_user.UserUtils;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.testObjects.UtArguments;
import oracle.dbtools.unit_test.testObjects.UtLookupItem;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.utils.UiUtils;
import oracle.dbtools.unit_test.utils.UtWhoObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OracleConnection;
import oracle.jdeveloper.db.ConnectionException;
import oracle.sql.CLOB;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class UtUtils {
    private static Map<Integer, String> _connectionNameMap = new HashMap<Integer, String>();

    private UtUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UtWhoObject getWho(String string, String string2, String string3) {
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        UtWhoObject utWhoObject = null;
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string4 = "select created_on,created_by,updated_on,updated_by from " + string + " where " + string2 + " = :ID";
                hashMap.put("ID", string3);
                resultSetWrapper = dBUtil.executeOracleQuery(string4, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        utWhoObject = new UtWhoObject(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return utWhoObject;
    }

    public static String removeTrailingSemiColons(String string) {
        if ((string = string.trim()).endsWith(";")) {
            string = string.substring(0, string.length() - 1);
            string = UtUtils.removeTrailingSemiColons(string);
        }
        return string;
    }

    public static Connection getDataConnection(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = UtUtils.uiPickDataConnection(string2);
        }
        return UtUtils.getUniqueConnection(string2);
    }

    public static Connection getRunnerConnection(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = UtUtils.uiPickConnection(true, UtAddinArb.get("UT_RUNNER_CONNECTION_CHOICE_TITLE"), UtAddinArb.get("UT_RUNNER_CONNECTION_CHOICE_LABEL"));
        }
        Connection connection = UtUtils.getUniqueConnection(string2);
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return connection;
    }

    public static Connection checkRunnerConnection(Connection connection) {
        String string = null;
        if (connection != null) {
            string = UtUtils.getDbQualName(connection);
        }
        return UtUtils.getRunnerConnection(string);
    }

    public static String uiPickDataConnection(String string) {
        String string2 = UtAddinArb.get("UT_DATATYPE_CONNECTION_CHOICE_TITLE");
        String string3 = UtAddinArb.get("UT_DATATYPE_CONNECTION_CHOICE_LABEL");
        boolean bl = true;
        return ConnectionSelectorUI.getConnection((String)string2, (String)string3, (String)string, (boolean)bl, (boolean)true);
    }

    public static String uiPickConnection(boolean bl, String string, String string2) {
        return ConnectionSelectorUI.getConnection((String)string, (String)string2, null, (boolean)bl, (boolean)true);
    }

    private static Connection getUniqueConnection(String string) {
        Connection connection = null;
        if (null != string) {
            try {
                connection = Connections.getInstance().getUniqueConnection(string);
                if (null != connection) {
                    _connectionNameMap.put(connection.hashCode(), string);
                }
            }
            catch (ConnectionException connectionException) {
                Logger.getLogger(UtUtils.class.getName()).log(Level.SEVERE, UtUtils.logString((Exception)((Object)connectionException)), connectionException);
                String string2 = connectionException.getLocalizedMessage();
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)UtAddinArb.get("ERROR"), null);
            }
        }
        return connection;
    }

    public static String getDbQualName(Connection connection) {
        String string = null;
        string = Connections.getInstance().getConnectionName(connection);
        if (null == string) {
            string = _connectionNameMap.get(connection.hashCode());
        }
        return string;
    }

    public static String getQuery(String string) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)"/oracle/dbtools/unit_test/testObjects/ObjectSql.xml");
        if (queryXMLSupport == null) {
            queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)"/oracle/dbtools/unit_test/testObjects/ObjectSql.xml");
        }
        Query query = queryXMLSupport.getQuery(string, UtAddin.getRepositoryManager().getConnection());
        return query.getSql();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTestImplConnectionName(String string) {
        String string2 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string3 = UtUtils.getQuery("getTestImplConnectionName");
                hashMap.put("ID", string);
                string2 = dBUtil.executeReturnOneCol(string3, hashMap);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTestConnectionName(String string) {
        String string2 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string3 = UtUtils.getQuery("getTestConnectionName");
                hashMap.put("ID", string);
                string2 = dBUtil.executeReturnOneCol(string3, hashMap);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSuiteConnectionName(String string) {
        String string2 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string3 = UtUtils.getQuery("getSuiteConnectionName");
                hashMap.put("ID", string);
                string2 = dBUtil.executeReturnOneCol(string3, hashMap);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTestNameUsed(String string) {
        boolean bl = true;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = UtUtils.getQuery("testExistCheck");
                hashMap.put("NAME", string);
                String string3 = dBUtil.executeReturnOneCol(string2, hashMap);
                bl = string3 == null || !string3.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTestNameUsed(String string, String string2) {
        boolean bl = true;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string3 = UtUtils.getQuery("testExistIdCheck");
                hashMap.put("ID", string);
                hashMap.put("NAME", string2);
                String string4 = dBUtil.executeReturnOneCol(string3, hashMap);
                bl = string4 == null || !string4.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLibCount(ICodeHook iCodeHook) {
        int n = 0;
        String string = null;
        string = iCodeHook instanceof IStartup ? "libStartupCount" : (iCodeHook instanceof ITeardown ? "libTeardownCount" : (iCodeHook instanceof DynamicValueQuery ? "libDynQueryCount" : "libValidationCount"));
        HashMap hashMap = new HashMap();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = UtUtils.getQuery(string);
                String string3 = dBUtil.executeReturnOneCol(string2, hashMap);
                if (string3 != null) {
                    n = Integer.valueOf(string3);
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLibNameUsed(ICodeHook iCodeHook, String string) {
        boolean bl = true;
        String string2 = null;
        string2 = iCodeHook instanceof IStartup ? "libStartupExistCheck" : (iCodeHook instanceof ITeardown ? "libTeardownExistCheck" : (iCodeHook instanceof DynamicValueQuery ? "libDynQueryExistCheck" : "libValidationExistCheck"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string3 = UtUtils.getQuery(string2);
                hashMap.put("NAME", string);
                String string4 = dBUtil.executeReturnOneCol(string3, hashMap);
                bl = string4 != null && !string4.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLibNameUsed(String string, ICodeHook iCodeHook, String string2) {
        boolean bl = true;
        String string3 = null;
        string3 = iCodeHook instanceof IStartup ? "libStartupExistIdCheck" : (iCodeHook instanceof ITeardown ? "libTeardownExistIdCheck" : (iCodeHook instanceof DynamicValueQuery ? "libDynQueryExistIdCheck" : "libValidationExistIdCheck"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string4 = UtUtils.getQuery(string3);
                hashMap.put("ID", string);
                hashMap.put("NAME", string2);
                String string5 = dBUtil.executeReturnOneCol(string4, hashMap);
                bl = string5 != null && !string5.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    public static int getSuiteCount() {
        return UtUtils.runReposQueryReturningInt("suiteCount");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSuiteNameUsed(String string) {
        boolean bl = true;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = UtUtils.getQuery("suiteExistCheck");
                hashMap.put("NAME", string);
                String string3 = dBUtil.executeReturnOneCol(string2, hashMap);
                bl = string3 == null || !string3.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSuiteNameUsed(String string, String string2) {
        boolean bl = true;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string3 = UtUtils.getQuery("suiteExistIdCheck");
                hashMap.put("ID", string);
                hashMap.put("NAME", string2);
                String string4 = dBUtil.executeReturnOneCol(string3, hashMap);
                bl = string4 == null || !string4.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runReposQueryReturningString(String string, HashMap<String, String> hashMap) {
        String string2 = null;
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string3 = UtUtils.getQuery(string);
                string2 = dBUtil.executeReturnOneCol(string3, hashMap);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return string2;
    }

    public static String getSuiteId(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NAME", string);
        return UtUtils.runReposQueryReturningString("getSuiteId", hashMap);
    }

    public static String getTestId(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NAME", string);
        return UtUtils.runReposQueryReturningString("getTestId", hashMap);
    }

    public static String getLibStartupId(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NAME", string);
        return UtUtils.runReposQueryReturningString("getLibStartupId", hashMap);
    }

    public static String getLibTeardownId(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NAME", string);
        return UtUtils.runReposQueryReturningString("getLibTeardownId", hashMap);
    }

    public static String getLibValidationId(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NAME", string);
        return UtUtils.runReposQueryReturningString("getLibValidationId", hashMap);
    }

    public static String getLibDynamicValueQueryId(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NAME", string);
        return UtUtils.runReposQueryReturningString("getLibDynQueryId", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runReposQueryReturningInt(String string) {
        int n = 0;
        HashMap hashMap = new HashMap();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = UtUtils.getQuery(string);
                String string3 = dBUtil.executeReturnOneCol(string2, hashMap);
                if (string3 != null) {
                    n = Integer.valueOf(string3);
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCanonicalizedName(String string) {
        String string2 = null;
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                String string3 = "DECLARE canon_name VARCHAR2(128); BEGIN DBMS_UTILITY.CANONICALIZE(?, canon_name, 128); ? := canon_name; END;";
                try {
                    CallableStatement callableStatement = connection.prepareCall(string3);
                    try {
                        callableStatement.setString(1, string);
                        callableStatement.registerOutParameter(2, 12);
                        callableStatement.execute();
                        string2 = callableStatement.getString(2);
                    }
                    finally {
                        callableStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    string2 = string;
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserName(Connection connection) {
        String string = null;
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = UtUtils.getQuery("getUser");
                string = dBUtil.executeReturnOneCol(string2, (List)null);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return string;
    }

    public static int getLookupCategoryCount() {
        return UtUtils.runReposQueryReturningInt("lookupCategoryCount");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCategoryNameUsed(String string) {
        boolean bl = true;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = UtUtils.getQuery("checkLookupCategoryExists");
                hashMap.put("NAME", string);
                String string3 = dBUtil.executeReturnOneCol(string2, hashMap);
                bl = string3 == null || !string3.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDatatypeNameUsed(String string, String string2) {
        boolean bl = true;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string3 = UtUtils.getQuery("checkLookupDatatypeExists");
                hashMap.put("TYPE_STRING", string);
                hashMap.put("CAT_ID", string2);
                String string4 = dBUtil.executeReturnOneCol(string3, hashMap);
                bl = string4 == null || !string4.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    public static boolean isAdmin() {
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (connection == null) {
            return false;
        }
        return UserUtils.sessionHasAdminRole(connection);
    }

    public static boolean isUser() {
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (connection == null) {
            return false;
        }
        return UserUtils.sessionHasUserRole(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAdminRoleEnabled() {
        boolean bl = true;
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (connection == null) {
            return false;
        }
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                String string = UtUtils.getQuery("isAdmin");
                String string2 = dBUtil.executeReturnOneCol(string, (List)null);
                bl = string2 != null && !string2.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUserRoleEnabled() {
        boolean bl = true;
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (connection == null) {
            return false;
        }
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string = UtUtils.getQuery("isUser");
                String string2 = dBUtil.executeReturnOneCol(string, (List)null);
                bl = string2 != null && !string2.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGrantsValid() {
        boolean bl = false;
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (connection == null) {
            return false;
        }
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                String string = UtUtils.getQuery("checkGrants");
                String string2 = dBUtil.executeReturnOneCol(string, (List)null);
                bl = string2 != null && Integer.valueOf(string2) > 69;
            }
            catch (Exception exception) {
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSynonymsValid() {
        boolean bl = false;
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (connection == null) {
            return false;
        }
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                String string = UtUtils.getQuery("checkSynonyms");
                String string2 = dBUtil.executeReturnOneCol(string, (List)null);
                bl = string2 != null && !string2.equals("0");
            }
            catch (Exception exception) {
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocalRepos() {
        boolean bl = false;
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (connection == null) {
            return false;
        }
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                String string = UtUtils.getQuery("isLocalRepos");
                String string2 = dBUtil.executeReturnOneCol(string, (List)null);
                bl = string2 != null && !string2.equals("0");
            }
            catch (Exception exception) {
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidationUsed(String string) {
        boolean bl = true;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = UtUtils.getQuery("isValidationUsed");
                hashMap.put("VAL_ID", string);
                String string3 = dBUtil.executeReturnOneCol(string2, hashMap);
                bl = string3 != null && !string3.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isImplNameUsed(String string, String string2) {
        boolean bl = true;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string3 = UtUtils.getQuery("testImplExistCheck");
                hashMap.put("NAME", string);
                hashMap.put("ID", string2);
                String string4 = dBUtil.executeReturnOneCol(string3, hashMap);
                bl = string4 != null && !string4.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReturnUsed(String string, String string2) {
        boolean bl = true;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string3 = null;
                if (string2.equals("test")) {
                    string3 = UtUtils.getQuery("testReturnCheck");
                } else if (string2.equals("suite")) {
                    string3 = UtUtils.getQuery("suiteReturnCheck");
                } else {
                    boolean bl2 = false;
                    return bl2;
                }
                hashMap.put("ID", string);
                String string4 = dBUtil.executeReturnOneCol(string3, hashMap);
                bl = string4 != null && !string4.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTestImplCount(String string) {
        int n = 0;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = UtUtils.getQuery("testImplCount");
                hashMap.put("ID", string);
                String string3 = dBUtil.executeReturnOneCol(string2, hashMap);
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getInputList(String string, String string2, String string3) {
        ResultSetWrapper resultSetWrapper = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string4 = UtUtils.getQuery("getInputs");
                hashMap.put("ID", string2);
                hashMap.put("TYPE", string);
                hashMap.put("ARG", string3);
                resultSetWrapper = dBUtil.executeOracleQuery(string4, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString(1));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getOutputList(String string, String string2, String string3) {
        ResultSetWrapper resultSetWrapper = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string4 = UtUtils.getQuery("getOutputs");
                hashMap.put("ID", string2);
                hashMap.put("TYPE", string);
                hashMap.put("ARG", string3);
                resultSetWrapper = dBUtil.executeOracleQuery(string4, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString(1));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PairElement> getLookupCategories(PairElement pairElement) {
        ResultSetWrapper resultSetWrapper = null;
        ArrayList<PairElement> arrayList = new ArrayList<PairElement>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (connection != null && Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string = UtUtils.getQuery("getLookupCategories");
                if (pairElement == null) {
                    hashMap.put("NAME", null);
                } else {
                    hashMap.put("NAME", pairElement.getName());
                }
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        arrayList.add(new PairElement(resultSet.getString(1), resultSet.getString(2)));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        if (pairElement != null) {
            arrayList.add(pairElement);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PairElement getLookupCategoryPair(String string) {
        ResultSetWrapper resultSetWrapper = null;
        PairElement pairElement = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = UtUtils.getQuery("getLookupCategoryPair");
                hashMap.put("CAT_ID", string);
                resultSetWrapper = dBUtil.executeOracleQuery(string2, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        pairElement = new PairElement(resultSet.getString(1), resultSet.getString(2));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return pairElement;
    }

    public static ExportFileInfo getExportFileWriter(String string) {
        ExportFileInfo exportFileInfo = null;
        ImpexpFile impexpFile = UtUtils.getImpexpFile(true, UtAddinArb.getString("SELECT_EXPORT_FILE"), string);
        if (impexpFile != null) {
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(impexpFile.fileName), impexpFile.encoding);
                exportFileInfo = new ExportFileInfo();
                exportFileInfo.writer = outputStreamWriter;
                exportFileInfo.fileName = impexpFile.fileName;
                exportFileInfo.encoding = impexpFile.encoding;
            }
            catch (Exception exception) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(exception), exception);
            }
        }
        return exportFileInfo;
    }

    public static Reader getImportFileReader(String string) {
        InputStreamReader inputStreamReader = null;
        ImpexpFile impexpFile = UtUtils.getImpexpFile(false, UtAddinArb.getString("SELECT_IMPORT_FILE"), string);
        if (impexpFile != null) {
            try {
                inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(impexpFile.fileName), impexpFile.encoding);
            }
            catch (Exception exception) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(exception), exception);
            }
        }
        return inputStreamReader;
    }

    private static ImpexpFile getImpexpFile(boolean bl, String string, String string2) {
        Object object;
        if (string2 != null) {
            string2 = string2.replace("\\", "").replace("/", "").replace(":", "").replace("*", "").replace("?", "").replace("\"", "").replace("<", "").replace(">", "").replace("|", "");
        }
        ImpexpFile impexpFile = null;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("XML Files", "xml");
        uRLFileChooser.setFileFilter((FileFilter)fileNameExtensionFilter);
        UtConfig utConfig = UtAddin.getConfig();
        String string3 = utConfig.getString("EXPORTDIR");
        if (string3 == null || string3.equals("")) {
            string3 = System.getProperty("user.home");
        }
        String string4 = string3 = string3 + File.separator;
        string4 = string2 != null ? string4 + string2 + ".xml" : string4 + "*.xml";
        try {
            File file = new File(string4);
            uRLFileChooser.setSelectedFile(file);
        }
        catch (Exception exception) {
            object = new File(string4);
            uRLFileChooser.setSelectedFile((File)object);
        }
        uRLFileChooser.showEncodings(true);
        int n = 0;
        n = bl ? uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow(), string) : uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), string);
        if (n == 0) {
            impexpFile = new ImpexpFile();
            object = uRLFileChooser.getSelectedFile().toString();
            int n2 = ((String)object).lastIndexOf(File.separator);
            String string5 = ((String)object).substring(n2);
            String string6 = ((String)object).substring(0, n2);
            utConfig.setString("EXPORTDIR", string6);
            if (string5.lastIndexOf(".") > -1) {
                impexpFile.fileName = uRLFileChooser.getSelectedFile().toString();
            } else {
                impexpFile.fileName = uRLFileChooser.getSelectedFile().toString() + ".xml";
            }
            impexpFile.encoding = uRLFileChooser.getEncoding();
        }
        return impexpFile;
    }

    public static ArrayList<PairElement> getDataTypePairs() {
        ArrayList<PairElement> arrayList = new ArrayList<PairElement>();
        UtDataTypeFactory utDataTypeFactory = UtDataTypeFactory.getInstance();
        TreeMap treeMap = new TreeMap(utDataTypeFactory.getSupportedTypeMetadata(OracleConnection.class));
        for (TypeMetadata typeMetadata : treeMap.values()) {
            String string = typeMetadata.get_data_type();
            Integer n = typeMetadata.get_type_code();
            if (string == null) continue;
            if (string.equals("REF CURSOR")) {
                HashMap<TypeMetadata.Attribute, String> hashMap = new HashMap<TypeMetadata.Attribute, String>();
                hashMap.put(TypeMetadata.Attribute.IMPL_DATA_TYPE, "PL/SQL CURSOR_FOR");
                typeMetadata = UtDataTypeFactory.getTypeMetadata((TypeMetadata)typeMetadata, hashMap);
            }
            if (string.equals("PL/SQL CURSOR_FOR") || typeMetadata.isSyntaxSynonym() || typeMetadata.isIncomplete()) continue;
            arrayList.add(new PairElement(String.valueOf(n), string));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PairElement> getLookupDataTypePairs(PairElement pairElement, PairElement pairElement2) {
        ResultSetWrapper resultSetWrapper = null;
        ArrayList<PairElement> arrayList = new ArrayList<PairElement>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string = UtUtils.getQuery("getLookupDatatypes");
                hashMap.put("CAT_NAME", pairElement.getName());
                if (pairElement2 != null) {
                    hashMap.put("DATA_NAME", pairElement2.getName());
                } else {
                    hashMap.put("DATA_NAME", null);
                }
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        arrayList.add(new PairElement(resultSet.getString(1), resultSet.getString(2)));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        if (pairElement2 != null) {
            arrayList.add(pairElement2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLookupCatogory(String string) {
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = " begin  DELETE FROM UT_LOOKUP_CATEGORIES WHERE ID = '" + string + "';" + " end;";
                dBUtil.executeUpdate(string2, (List)null);
                connection.commit();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLookupDatatype(String string) {
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = " begin  DELETE FROM UT_LOOKUP_DATATYPES WHERE ID = '" + string + "';" + " end;";
                dBUtil.executeUpdate(string2, (List)null);
                connection.commit();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTestImpl(String string) {
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = " begin  delete from ut_test_impl where uti_id = '" + string + "';" + " end;";
                dBUtil.executeUpdate(string2, (List)null);
                connection.commit();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTest(String string) {
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = "begin  delete from ut_test where ut_id = '" + string + "'; " + " end; ";
                dBUtil.executeUpdate(string2, (List)null);
                connection.commit();
            }
            catch (Exception exception) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(exception), exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSuite(String string) {
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = "begin  delete from UT_SUITE where UT_SID  = '" + string + "'; " + " end; ";
                dBUtil.executeUpdate(string2, (List)null);
                connection.commit();
            }
            catch (Exception exception) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(exception), exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeTestResult(String string) {
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = "begin  delete from UT_TEST_RESULTS where UTR_ID = '" + string + "'; " + " end; ";
                dBUtil.executeUpdate(string2, (List)null);
                connection.commit();
            }
            catch (Exception exception) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(exception), exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeSuiteResult(String string) {
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = "begin  delete from UT_SUITE_RESULTS where UTSR_ID = '" + string + "'; " + " end; ";
                dBUtil.executeUpdate(string2, (List)null);
                connection.commit();
            }
            catch (Exception exception) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(exception), exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public static String getXmlValue(String string, String string2, String string3) {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            if (string == null) {
                return "";
            }
            InputSource inputSource = new InputSource(new StringReader(string));
            dOMParser.parse(inputSource);
        }
        catch (Exception exception) {
            Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(exception), exception);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        if (xMLDocument != null) {
            Node node = XMLHelper.getChildNode((Node)xMLDocument, (String)string2);
            if (node != null) {
                return XMLHelper.getNodeValue((Node)node, (String)string3);
            }
            return "";
        }
        return "";
    }

    public static String selectTableName() {
        String string = null;
        try {
            URL uRL;
            Serializable serializable;
            Object object;
            UtDataTypeConnectionProvider utDataTypeConnectionProvider = UtAddin.getDataTypeConnectionProvider();
            String string2 = utDataTypeConnectionProvider.peekDataTypeConnectionQualName();
            if (null == string2) {
                if (null == (string2 = UtUtils.uiPickDataConnection(string2))) {
                    return null;
                }
                utDataTypeConnectionProvider.setDataTypeConnectionQualName(string2);
            }
            Connection connection = null;
            try {
                connection = Connections.getInstance().getConnection(string2);
            }
            catch (DBException dBException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString((Exception)((Object)dBException)), dBException);
                object = null;
                serializable = dBException.getCause();
                object = serializable != null ? serializable.getLocalizedMessage() : dBException.getLocalizedMessage();
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)object, (String)UtAddinArb.get("ERROR"), null);
            }
            if (connection == null) {
                return null;
            }
            DBObjectSearch dBObjectSearch = new DBObjectSearch();
            dBObjectSearch.setConn(string2);
            dBObjectSearch.setType("TABLE");
            object = dBObjectSearch.getList();
            ((JList)object).setSelectionMode(0);
            dBObjectSearch.init();
            serializable = dBObjectSearch.getJComboBox();
            UiUtils.nameForQA((JComboBox)serializable, "Schema", new String[0]);
            JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)dBObjectSearch, null, (String)UtAddinArb.getString("SELECT_TABLE_TITLE"), (int)3);
            jEWTDialog.setOKButtonEnabled(true);
            boolean bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            if (bl && (uRL = (URL)((JList)object).getSelectedValue()) != null) {
                String string3 = UtUtils.getUserName(Connections.getInstance().getConnection(string2));
                String string4 = DBURLFormatHelper.getSchema((URL)uRL);
                string = string3 == null || string4 == null || !string3.equals(string4) ? "\"" + string4 + "\".\"" + DBURLFormatHelper.getName((URL)uRL) + "\"" : "\"" + DBURLFormatHelper.getName((URL)uRL) + "\"";
            }
        }
        catch (Exception exception) {
            Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(exception), exception);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtUtils.logString(exception), (String)UtAddinArb.get("ERROR"), null);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<UtLookupItem> getLookupValues(String string, String string2) {
        if (string == null || string.equals("")) {
            string = UtConfig.getInstance().getPairElement("LOOKUP_CATEGORY").getName();
        }
        ResultSetWrapper resultSetWrapper = null;
        Vector<UtLookupItem> vector = new Vector<UtLookupItem>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string3 = UtUtils.getQuery("getLookupValues");
                hashMap.put("CATEGORY", string);
                hashMap.put("DATATYPE", string2);
                resultSetWrapper = dBUtil.executeOracleQuery(string3, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string4 = resultSet.getString(1);
                        String string5 = resultSet.getString(2);
                        Clob clob = resultSet.getClob(3);
                        String string6 = resultSet.getString(4);
                        try {
                            UtDataTypeConnectionProvider utDataTypeConnectionProvider = UtAddin.getDataTypeConnectionProvider();
                            TypeMetadata typeMetadata = UtDataTypeFactory.getInstance().getTypeMetadata((DataTypeConnectionProvider)utDataTypeConnectionProvider, string2);
                            DataType dataType = UtDataTypeFactory.getInstance().getDataType((DataTypeConnectionProvider)utDataTypeConnectionProvider, typeMetadata);
                            DataValue dataValue = XMLUtil.unmarshallDataValue((Clob)clob, (DataType)dataType);
                            UtLookupItem utLookupItem = new UtLookupItem(string, string2, string6, string4, string5, dataValue);
                            vector.add(utLookupItem);
                        }
                        catch (Exception exception) {
                            Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.SEVERE, UtUtils.logString(exception), exception);
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> getLookupCounts(String string) {
        if (string == null || string.equals("")) {
            string = UtConfig.getInstance().getPairElement("LOOKUP_CATEGORY").getName();
        }
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = UtUtils.getQuery("getLookupCounts");
                hashMap2.put("CATEGORY", string);
                resultSetWrapper = dBUtil.executeOracleQuery(string2, hashMap2);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        hashMap.put(resultSet.getString(1), resultSet.getString(2));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return hashMap;
    }

    public static void popupMessage(Component component, String string, String string2) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(string2 == null ? "" : string2);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)component, (Component)jPanel, null, (String)string, (int)16);
        jEWTDialog.setDefaultButton(16);
        jEWTDialog.setMinimumSize(new Dimension(300, 120));
        WizardLauncher.runDialog((JDialog)jEWTDialog);
    }

    public static String asString(Exception exception) {
        return UtUtils.asString(exception, true);
    }

    public static String logString(Exception exception) {
        return UtUtils.asString(exception, false);
    }

    private static String asString(Exception exception, boolean bl) {
        String string = null;
        if (null != exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(exception.getClass().getName()).append(": ").append(exception.getLocalizedMessage());
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                stringBuilder.append('\n').append('\t').append(stackTraceElement.toString());
                if (!bl) break;
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public static Clob asClob(Connection connection, String string) throws SQLException {
        CLOB cLOB = null;
        if (string != null) {
            cLOB = CLOB.createTemporary((Connection)connection, (boolean)false, (int)10);
            cLOB.setString(1L, string);
        }
        return cLOB;
    }

    public static boolean checkForUnsupportedParamTypes(Component component, String string, UtTest utTest) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string);
        }
        catch (Exception exception) {
            Logger.getLogger(UtUtils.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        ArrayList<UtArguments> arrayList = utTest.getCallableArgumentsSorted();
        for (UtArguments utArguments : arrayList) {
            boolean bl = false;
            if (connection != null) {
                bl = UtDataTypeFactory.getInstance().isSupportedType(connection, utArguments.get_type_metadata());
            }
            if (bl) continue;
            String string2 = utArguments.get_argument_name();
            String string3 = utArguments.get_data_type();
            ++n;
            if (string2 != null) {
                stringBuffer.append(CreateWizArb.format("ARG_TYPE_NOT_SUPPORTED", string3, string2));
            } else {
                stringBuffer.append(CreateWizArb.format("RET_TYPE_NOT_SUPPORTED", string3));
            }
            stringBuffer.append("\n");
        }
        if (n > 0) {
            Object object = utTest.getObjectCall();
            if (object == null) {
                object = utTest.getObjectName();
            }
            stringBuffer.append(CreateWizArb.format("CANNOT_TEST_OPERATION", object, n));
            MessageDialog.error((Component)component, (Object)stringBuffer.toString(), (String)UtAddinArb.getString("ERROR"), null);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSharedRepositoryOwner() {
        String string = null;
        HashMap hashMap = new HashMap();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = UtUtils.getQuery("GetSharedRepoOwner");
                string = dBUtil.executeReturnOneCol(string2, hashMap);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTestableOperation(Connection connection, String string, String string2, String string3) {
        boolean bl = false;
        String string4 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SCHEMA", string);
        hashMap.put("OP", string2);
        if (string3 == null || string3.equals("")) {
            string4 = "IsValidStandaloneOp";
        } else {
            string4 = "IsValidPackagedOp";
            hashMap.put("PACKAGE", string3);
        }
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string5 = UtUtils.getQuery(string4);
                String string6 = dBUtil.executeReturnOneCol(string5, hashMap);
                bl = string6 != null && string6.equals("1");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    private static class ImpexpFile {
        private String fileName;
        private String encoding;

        private ImpexpFile() {
        }
    }

    public static class ExportFileInfo {
        public Writer writer;
        public String fileName;
        public String encoding;
    }
}

