/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.testObjects;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.codehook.ICodeHook;
import oracle.dbtools.unit_test.editor.DynamicValueQuery;
import oracle.dbtools.unit_test.editor.UiArb;
import oracle.dbtools.unit_test.impexp.ExportContext;
import oracle.dbtools.unit_test.impexp.ImportContext;
import oracle.dbtools.unit_test.impexp.LoggerLevel;
import oracle.dbtools.unit_test.process_validation.IValidation;
import oracle.dbtools.unit_test.process_validation.ValidationRegistry;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.startup.StartupRegistry;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.teardown.TearDownRegistry;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtLibraryRef;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UtLibraryItem {
    private UtLibraryRef _ref;
    private String _implClass;
    private String _xml;

    public UtLibraryItem(UtLibraryRef utLibraryRef, String string, String string2) {
        this._ref = utLibraryRef;
        this._implClass = string;
        this._xml = string2;
    }

    public UtLibraryItem(String string, String string2) {
        this(UtLibraryItem.getKind(string), string2);
    }

    public UtLibraryItem(Kind kind, String string) {
        String string2 = null;
        if (kind != null) {
            switch (kind) {
                case STARTUP: {
                    string2 = "libStartup";
                    break;
                }
                case TEARDOWN: {
                    string2 = "libTeardown";
                    break;
                }
                case VALIDATION: {
                    string2 = "libValidation";
                    break;
                }
                case DYNAMIC_VALUE_QUERY: {
                    string2 = "libDynQuery";
                }
            }
        } else {
            string2 = "libValidation";
        }
        this.load(string2, string);
    }

    public UtLibraryItem(ImportContext importContext) {
        ICodeHook iCodeHook;
        String string;
        XMLElement xMLElement = importContext.getImportedElement();
        String string2 = xMLElement.getAttribute("id");
        if (string2 == null || string2.equals("")) {
            importContext.log(LoggerLevel.SEVERE, "unexpected null value");
        }
        if ((string = xMLElement.getAttribute("name")) == null || string.equals("")) {
            importContext.log(LoggerLevel.SEVERE, "unexpected null value");
        }
        this._ref = new UtLibraryRef(string2, string);
        this._implClass = xMLElement.getAttribute("class");
        if (this._implClass == null || this._implClass.equals("")) {
            importContext.log(LoggerLevel.SEVERE, "unexpected null value");
        }
        XMLElement xMLElement2 = null;
        NodeList nodeList = xMLElement.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof XMLElement)) continue;
            xMLElement2 = (XMLElement)node;
            break;
        }
        if ((iCodeHook = this.createCodeHook()) != null) {
            iCodeHook.loadFromXmlElement(xMLElement2);
            this._xml = iCodeHook.getXml();
            if (UtUtils.isLibNameUsed(string2, iCodeHook, string)) {
                importContext.log(LoggerLevel.SEVERE, "duplicate library item name or ID");
            }
        } else {
            importContext.log(LoggerLevel.SEVERE, "Invalid codehook type name");
        }
    }

    public void export(ExportContext exportContext) {
        XMLElement xMLElement = exportContext.createExportedElement("libitem");
        xMLElement.setAttribute("id", this._ref.getLibId());
        xMLElement.setAttribute("name", this._ref.getName());
        xMLElement.setAttribute("class", this._implClass);
        ICodeHook iCodeHook = this.createCodeHook();
        XMLElement xMLElement2 = iCodeHook.getXmlElement();
        if (xMLElement2 != null) {
            exportContext.reparentExportedElement(xMLElement, xMLElement2);
        }
    }

    public void setLibRef(UtLibraryRef utLibraryRef) {
        this._ref = utLibraryRef;
    }

    public UtLibraryRef getRef() {
        return this._ref;
    }

    public void setImplClass(String string) {
        this._implClass = string;
    }

    public String getImplClass() {
        return this._implClass;
    }

    public void setXml(String string) {
        this._xml = string;
    }

    public String getXml() {
        return this._xml;
    }

    public Kind getKind() {
        return UtLibraryItem.getKind(this._implClass);
    }

    public String getImplKey() {
        String string = null;
        Kind kind = this.getKind();
        if (kind != null) {
            switch (kind) {
                case STARTUP: {
                    string = StartupRegistry.getKeyFor(this._implClass);
                    break;
                }
                case TEARDOWN: {
                    string = TearDownRegistry.getKeyFor(this._implClass);
                    break;
                }
                case VALIDATION: {
                    string = ValidationRegistry.getKeyFor(this._implClass);
                    break;
                }
                case DYNAMIC_VALUE_QUERY: {
                    string = UiArb.getString("DVQ_NAME");
                }
            }
        }
        return string;
    }

    public ICodeHook createCodeHook() {
        ICodeHook iCodeHook = null;
        Kind kind = this.getKind();
        if (kind != null) {
            switch (kind) {
                case STARTUP: {
                    iCodeHook = StartupRegistry.getInstanceFor(this.getImplKey());
                    break;
                }
                case TEARDOWN: {
                    iCodeHook = TearDownRegistry.getInstanceFor(this.getImplKey());
                    break;
                }
                case VALIDATION: {
                    iCodeHook = ValidationRegistry.getInstanceFor(this.getImplKey());
                    break;
                }
                case DYNAMIC_VALUE_QUERY: {
                    iCodeHook = new DynamicValueQuery();
                }
            }
            iCodeHook.setLibraryRef(null);
            iCodeHook.setOwnerId(null);
            iCodeHook.loadFromXml(this._xml);
        }
        return iCodeHook;
    }

    public boolean save() throws ObjectUpdateException {
        boolean bl = false;
        String string = null;
        Kind kind = this.getKind();
        if (kind != null) {
            switch (kind) {
                case STARTUP: {
                    string = "mergeLibStartup";
                    break;
                }
                case TEARDOWN: {
                    string = "mergeLibTeardown";
                    break;
                }
                case VALIDATION: {
                    string = "mergeLibValidation";
                    break;
                }
                case DYNAMIC_VALUE_QUERY: {
                    string = "mergeLibDynQuery";
                }
            }
        }
        if (string != null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Connection connection = UtAddin.getRepositoryManager().getConnection();
            if (Connections.getInstance().lock(connection)) {
                Savepoint savepoint = null;
                try {
                    savepoint = connection.setSavepoint();
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    String string2 = UtUtils.getQuery(string);
                    hashMap.put("LIB_ID", this._ref.getLibId());
                    hashMap.put("NAME", this._ref.getName());
                    hashMap.put("CLASS", this._implClass);
                    hashMap.put("XML", UtUtils.asClob(connection, this._xml));
                    dBUtil.setRaiseError(true);
                    int n = dBUtil.executeUpdate(string2, hashMap);
                    if (0 == n) {
                        connection.rollback(savepoint);
                        throw new ObjectUpdateException();
                    }
                    connection.commit();
                    bl = n > 0;
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    if (savepoint != null) {
                        try {
                            connection.rollback(savepoint);
                        }
                        catch (SQLException sQLException2) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException2.getStackTrace()[0].toString(), sQLException2);
                        }
                    }
                    throw new ObjectUpdateException(sQLException);
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
        return bl;
    }

    private static Kind getKind(String string) {
        Kind kind = null;
        try {
            Class<?> clazz = Class.forName(string);
            kind = IStartup.class.isAssignableFrom(clazz) ? Kind.STARTUP : (ITeardown.class.isAssignableFrom(clazz) ? Kind.TEARDOWN : (IValidation.class.isAssignableFrom(clazz) ? Kind.VALIDATION : Kind.DYNAMIC_VALUE_QUERY));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(UtLibraryItem.class.getName()).log(Level.WARNING, classNotFoundException.getStackTrace()[0].toString(), classNotFoundException);
        }
        return kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String string, String string2) {
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                String string3 = UtUtils.getQuery(string);
                hashMap.put("ID", string2);
                resultSetWrapper = dBUtil.executeOracleQuery(string3, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        this._ref = new UtLibraryRef(string2, resultSet.getString("NAME"));
                        this._implClass = resultSet.getString("CLASS");
                        this._xml = resultSet.getString("XML");
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public static enum Kind {
        STARTUP,
        TEARDOWN,
        VALIDATION,
        DYNAMIC_VALUE_QUERY;

    }
}

