/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.runner;

import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.datatypes.CallableBinding;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.LockableDataTypeConnectionProvider;
import oracle.dbtools.unit_test.runner.Runner;
import oracle.dbtools.unit_test.runner.StatusObject;
import oracle.dbtools.unit_test.runner.UtRunnerArb;
import oracle.dbtools.unit_test.runner.UtRunnerImplArgs;
import oracle.dbtools.unit_test.runner.UtRunnerImplIterator;
import oracle.dbtools.unit_test.runner.UtRunnerObject;
import oracle.dbtools.unit_test.testObjects.UtTestImpl;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.Ide;

public class Debugger {
    private Connection _conn;
    private String message;

    public Debugger(Connection connection) {
        this._conn = connection;
    }

    public Connection getConn() {
        return this._conn;
    }

    public void setConn(Connection connection) {
        this._conn = connection;
    }

    public void debugImpl(final UtTestImpl utTestImpl) {
        Connection connection = this._conn;
        this._conn = UtUtils.checkRunnerConnection(connection);
        if (null == this._conn) {
            return;
        }
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtRunnerArb.format("UT_TASK_NAME", utTestImpl.getName()), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            protected Void doWork() throws TaskException {
                Debugger.this.message = Debugger.this.debugRunImpl(utTestImpl);
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                String string = UtRunnerArb.format("UT_TASK_FAIL", raptorTaskEvent.getTaskDescriptor().getName(), raptorTaskEvent.getTaskDescriptor().getMessage());
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, string);
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                try {
                    if (!Debugger.this._conn.isClosed()) {
                        Debugger.this._conn.close();
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    if (!Debugger.this._conn.isClosed()) {
                        Debugger.this._conn.close();
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UtUtils.popupMessage((Component)Ide.getMainWindow(), utTestImpl.getName(), Debugger.this.message);
                    }
                });
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String debugRunImpl(UtTestImpl utTestImpl) {
        DBConfig dBConfig = DBConfig.getInstance();
        String string = dBConfig.getString("NULLDISPLAY");
        if (utTestImpl == null) {
            return UtRunnerArb.getString("DEBUG_NO_IMPL");
        }
        StringBuilder stringBuilder = new StringBuilder();
        LockableDataTypeConnectionProvider lockableDataTypeConnectionProvider = new LockableDataTypeConnectionProvider(this._conn);
        UtRunnerImplIterator utRunnerImplIterator = utTestImpl.getRunnerIterator((DataTypeConnectionProvider)lockableDataTypeConnectionProvider);
        try {
            utRunnerImplIterator.open();
            UtRunnerObject utRunnerObject = utRunnerImplIterator.next();
            if (utRunnerObject != null) {
                stringBuilder.append(UtRunnerArb.getString("DEBUG_HEADER") + "\n\n");
                stringBuilder.append(UtRunnerArb.getString("DEBUG_CODE") + "\n");
                stringBuilder.append(utRunnerObject.getSql());
                stringBuilder.append("\n" + UtRunnerArb.getString("DEBUG_BINDS") + "\n");
                for (CallableBinding callableBinding : utRunnerObject.getBinds()) {
                    UtRunnerImplArgs utRunnerImplArgs = (UtRunnerImplArgs)callableBinding.getParameter();
                    callableBinding.reportBinding(stringBuilder, string, utRunnerImplArgs.getInputDataValue());
                }
                stringBuilder.append("\n" + UtRunnerArb.getString("DEBUG_RESULTS") + "\n");
                Runner runner = new Runner(this._conn);
                StatusObject statusObject = runner.executeImpl(utTestImpl, null, true, false, true, true);
                stringBuilder.append(UtRunnerArb.getString(statusObject.getStatus()) + "\n");
                if (statusObject.getDebug() != null) {
                    stringBuilder.append(statusObject.getDebug() + "\n");
                } else if (statusObject.getMessage() != null) {
                    stringBuilder.append(statusObject.getMessage() + "\n");
                }
            } else {
                stringBuilder.append(UtRunnerArb.getString("DQV_NO_VALUES"));
            }
        }
        catch (SQLException sQLException) {
            stringBuilder.append(UtRunnerArb.format("DQV_ERROR", sQLException.getLocalizedMessage()));
        }
        catch (Exception exception) {
            stringBuilder.append(UtUtils.asString(exception));
        }
        finally {
            utRunnerImplIterator.close();
        }
        return stringBuilder.toString();
    }
}

