/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.process_validation;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.codehook.PLSQLCodeEditor;
import oracle.dbtools.unit_test.process_validation.IValidation;
import oracle.dbtools.unit_test.process_validation.Validation;
import oracle.dbtools.unit_test.process_validation.ValidationArb;
import oracle.dbtools.unit_test.utils.UtUtils;

public class QueryReturningRows
extends Validation
implements IValidation {
    private String _name = ValidationArb.getString("QUERY_ROWS_NAME");
    private PLSQLCodeEditor _codeEditor = new PLSQLCodeEditor();

    public QueryReturningRows() {
        this.onChangeEditability();
        this.setDefaultCode();
    }

    private void setDefaultCode() {
        String string = ValidationArb.getString("QUERY_RET_ROWS_TEMPLATE");
        this._codeEditor.setCode(string);
    }

    @Override
    public String getHookName() {
        return this._name;
    }

    @Override
    public String getDescription() {
        return this._codeEditor.getCode();
    }

    @Override
    protected Component createComponent() {
        return this._codeEditor.createEditorPanel(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                QueryReturningRows.this.fireChangeListeners();
            }
        });
    }

    @Override
    public String getXml() {
        String string = this._codeEditor.getCode();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        stringBuilder.append("<validation>");
        stringBuilder.append("<class><![CDATA[" + this.getClass().getCanonicalName() + "]]></class>");
        stringBuilder.append("<name><![CDATA[" + this._name + "]]></name>");
        stringBuilder.append("<description><![CDATA[" + string + "]]></description>");
        stringBuilder.append("<code><![CDATA[" + string + "]]></code>");
        stringBuilder.append("</validation>");
        return stringBuilder.toString();
    }

    @Override
    public void loadFromXml(String string) {
        String string2 = string != null ? UtUtils.getXmlValue(string, "validation", "code") : "";
        this._codeEditor.setCode(string2);
        this._codeEditor.setReadOnly(!this.isEditable());
    }

    @Override
    protected void onChangeEditability() {
        this._codeEditor.setReadOnly(!this.isEditable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runValidation(DataTypeConnectionProvider dataTypeConnectionProvider, Map<String, Object> map) throws Exception {
        Connection connection = dataTypeConnectionProvider.getValidDataTypeConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                PreparedStatement preparedStatement = connection.prepareStatement(UtUtils.removeTrailingSemiColons(this.substituteValues(this._codeEditor.getCode(), map)));
                try {
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new Exception(ValidationArb.getString("QUERY_ROWS_CHECK_FAILED"));
                    }
                }
                finally {
                    preparedStatement.close();
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }
}

