/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.navigator.nodes;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.dbtools.raptor.report.navigatorV2.Folder;
import oracle.dbtools.raptor.report.navigatorV2.FolderNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportXMLUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.navigator.nodes.AbstractLoadChildrenTask;
import oracle.dbtools.unit_test.navigator.nodes.UtLibraryFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtLookupRootFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtTestFolder;
import oracle.dbtools.unit_test.repository.RepositoryManager;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.dbtools.util.Resource;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilenameFilter;
import oracle.jdevimpl.java.explorer.LeafElement;

public class RootFolder
extends DefaultContainer {
    protected static final Logger LOGGER = Logger.getLogger(RootFolder.class.getName());
    private static RootFolder INSTANCE;
    ReportXMLUtil xmlUtil = new ReportXMLUtil();
    XLIFFHelper xliff = new XLIFFHelper();
    private boolean _admin;
    private int _adminGood = 0;
    private boolean _user;
    private int _userGood = 0;
    private String _qualName;
    private String _shortLabel = UtAddinArb.getString("ROOT_NODE");
    private boolean _initialized;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public static synchronized RootFolder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RootFolder();
        }
        return INSTANCE;
    }

    private RootFolder() {
        this.getAttributes().set(ElementAttributes.SELECTION_CONTAINER);
    }

    public synchronized void reset() {
        this._adminGood = 0;
        this._userGood = 0;
        this._qualName = null;
        UpdateMessage.fireAttributeChanged((Subject)RootFolder.getInstance(), null);
    }

    private boolean getAdmin() {
        if (this._adminGood == 0) {
            this._admin = UtUtils.isAdmin();
            this._adminGood = 1;
        }
        return this._admin;
    }

    private boolean getUser() {
        if (this._userGood == 0) {
            this._user = UtUtils.isUser();
            this._userGood = 1;
        }
        return this._user;
    }

    public String getShortLabel() {
        final String string = UtAddin.getRepositoryConnectionName();
        if (null == string) {
            this._qualName = null;
            this._shortLabel = UtAddinArb.getString("ROOT_NODE");
        } else if (!string.equals(this._qualName)) {
            this._qualName = string;
            RaptorTask<Void> raptorTask = new RaptorTask<Void>(UtAddinArb.getString("DECORATE_ROOT_LABEL_TASK"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

                protected Void doWork() throws TaskException {
                    try {
                        String string2 = Connections.getDisplayName((String)string);
                        if (RootFolder.this.getAdmin()) {
                            string2 = string2 + " " + UtAddinArb.getString("ADMIN_ROOT");
                        }
                        if (RootFolder.this.getUser()) {
                            string2 = string2 + " " + UtAddinArb.getString("USER_ROOT");
                        }
                        RootFolder.this._shortLabel = UtAddinArb.getString("ROOT_NODE") + " - " + string2;
                        UpdateMessage.fireAttributeChanged((Subject)RootFolder.this, null);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        this.setMessage(UtAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                        throw new TaskException((Throwable)exception);
                    }
                    return null;
                }
            };
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
        return this._shortLabel;
    }

    public Icon getIcon() {
        return UtAddin.rootIcon;
    }

    public void clearTree() {
        this.removeAll();
        this.add((Element)new LeafElement(UtAddinArb.getString("CONNECT_REPO"), UtAddinArb.getString("CONNECT_REPO"), null));
        UpdateMessage.fireStructureChanged((Subject)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPackage(String string, DefaultContainer defaultContainer) throws Exception {
        URL[] uRLArray = Resource.getPath((String)(string = string.replaceAll("\\.", "\\/")));
        if (uRLArray != null) {
            for (URL uRL : uRLArray) {
                URL[] uRLArray2;
                for (URL uRL2 : uRLArray2 = URLFileSystem.list((URL)uRL, (URLFilenameFilter)new URLFilenameFilter(){

                    public boolean accept(URL uRL, String string) {
                        return string.endsWith(".xml");
                    }
                })) {
                    InputStreamReader inputStreamReader = null;
                    try {
                        InputStream inputStream = URLFileSystem.openInputStream((URL)uRL2);
                        String string2 = "UTF-8";
                        inputStreamReader = new InputStreamReader(inputStream, string2);
                        String string3 = null;
                        if (uRL2.toString().contains(".jar!")) {
                            string3 = uRL2.toString().substring(uRL2.toString().lastIndexOf(".jar!") + 5);
                            this.xliff.setBaseDocName(string3);
                        } else {
                            string3 = uRL2.toString().substring(uRL2.toString().lastIndexOf("classes") + 7);
                            this.xliff.setBaseDocName(string3);
                        }
                        this.xmlUtil.parseXML(defaultContainer, inputStreamReader, false, string, this.xliff);
                    }
                    finally {
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (Exception exception) {
                                RootFolder.log(exception);
                            }
                        }
                    }
                }
            }
        }
    }

    public void loadTree() {
        if (this.isOpen()) {
            this.removeAll(true);
            this.openImpl();
        }
    }

    public void closeImpl() {
        this.removeAll();
    }

    public void externalInit() {
        this._initialized = true;
        this.openImpl();
    }

    protected void openImpl() {
        if (!this._initialized) {
            return;
        }
        this.add(DummyElement.INSTANCE);
        UpdateMessage.fireChildAdded((Subject)this, (Element)DummyElement.INSTANCE);
        AbstractLoadChildrenTask abstractLoadChildrenTask = new AbstractLoadChildrenTask((Element)this){

            protected List<Element> doWork() {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                try {
                    RootFolder.this.removeAll(true);
                    Connection connection = UtAddin.getRepositoryManager().getConnection();
                    if (UtAddin.isRepositoryOpen() && RepositoryManager.isCurrentVersion(connection)) {
                        Element element = new Folder(UtAddinArb.getString("MAIN_REPORT"), UtAddinArb.getString("MAIN_REPORT"));
                        URL uRL = new URL("sqldev.reports:/" + UtAddinArb.getString("MAIN_REPORT"));
                        FolderNode folderNode = new FolderNode(uRL, (Folder)element){

                            public Icon getIcon() {
                                return UtAddin.reportFolderIcon;
                            }
                        };
                        folderNode.setEditable(false);
                        RootFolder.this.addPackage("oracle.dbtools.unit_test.reports", (DefaultContainer)folderNode);
                        arrayList.add((Element)folderNode);
                        arrayList.add((Element)new UtTestFolder(UtAddinArb.getString("MAIN_TEST"), UtAddinArb.getString("MAIN_TEST"), UtAddin.testFolderIcon));
                        arrayList.add((Element)new UtSuiteFolder(UtAddinArb.getString("MAIN_SUITE"), UtAddinArb.getString("MAIN_SUITE"), UtAddin.suiteFolderIcon));
                        arrayList.add((Element)new UtLibraryFolder(UtAddinArb.getString("MAIN_LIBRARY"), UtAddinArb.getString("MAIN_LIBRARY"), UtAddin.libraryFolderIcon));
                        arrayList.add((Element)new UtLookupRootFolder(UtAddinArb.getString("LOOKUPS"), UtAddinArb.getString("LOOKUPS"), UtAddin.lookupFolderIcon));
                    } else if (UtAddin.isRepositoryOpen() && !RepositoryManager.isCurrentVersion(connection)) {
                        arrayList.add((Element)new LeafElement(UtAddinArb.getString("BAD_VERSION"), UtAddinArb.getString("BAD_VERSION"), null));
                    } else if (!UtAddin.isRepositoryOpen() && UtAddin.defaultDefined()) {
                        UtAddin.openRepository(UtAddin.getConfig().getRepository());
                        if (!UtAddin.isRepositoryOpen()) {
                            arrayList.add((Element)new LeafElement(UtAddinArb.getString("CONNECT_REPO"), UtAddinArb.getString("CONNECT_REPO"), null));
                        }
                    } else {
                        arrayList.add((Element)new LeafElement(UtAddinArb.getString("CONNECT_REPO"), UtAddinArb.getString("CONNECT_REPO"), null));
                    }
                }
                catch (Exception exception) {
                    this.log(exception);
                }
                for (Element element : arrayList) {
                    RootFolder.this.add(element);
                }
                return arrayList;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)abstractLoadChildrenTask);
    }
}

