/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.navigator;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.navigator.UtNavFilter;
import oracle.dbtools.unit_test.navigator.UtNavigatorWindow;
import oracle.dbtools.unit_test.navigator.nodes.RootFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtDynamicValueQueriesFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtLibraryFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtLookupCategoryFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtLookupRootFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtNestedSuitesFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtStartupTypesFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtStartupsFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteNode;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteTestsFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtTeardownTypesFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtTeardownsFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtTestFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtTestImplNode;
import oracle.dbtools.unit_test.navigator.nodes.UtTestNode;
import oracle.dbtools.unit_test.navigator.nodes.UtValidationTypesFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtValidationsFolder;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Folder;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public class UtNavigatorManager
extends DefaultNavigatorManager {
    private static final String UT_NAVIGATOR_WINDOW_ID = "UtNavigatorWindow";
    private static final String UT_NAV_CMD = "UtNavigator.SHOW_NAVIGATOR";
    private static final int UT_NAV_CMD_ID = Ide.findOrCreateCmdID((String)"UtNavigator.SHOW_NAVIGATOR");
    private static final String TITLE_NAME = "Unit Test";
    private static final String PACKAGED_TITLE_NAME = "PL/SQL Unit Test";

    public UtNavigatorManager() {
        this.registerFilter(UtSuiteFolder.class, UtNavFilter.class, null);
        this.registerFilter(UtSuiteNode.class, UtNavFilter.class, null);
        this.registerFilter(UtTestFolder.class, UtNavFilter.class, null);
        this.registerFilter(UtTestNode.class, UtNavFilter.class, null);
        this.registerFilter(UtTestImplNode.class, UtNavFilter.class, null);
        this.registerFilter(UtLibraryFolder.class, UtNavFilter.class, null);
        this.registerFilter(UtStartupTypesFolder.class, UtNavFilter.class, null);
        this.registerFilter(UtNestedSuitesFolder.class, UtNavFilter.class, null);
        this.registerFilter(UtSuiteTestsFolder.class, UtNavFilter.class, null);
        this.registerFilter(UtTeardownTypesFolder.class, UtNavFilter.class, null);
        this.registerFilter(UtValidationTypesFolder.class, UtNavFilter.class, null);
        this.registerFilter(UtStartupsFolder.class, UtNavFilter.class, null);
        this.registerFilter(UtTeardownsFolder.class, UtNavFilter.class, null);
        this.registerFilter(UtValidationsFolder.class, UtNavFilter.class, null);
        this.registerFilter(UtDynamicValueQueriesFolder.class, UtNavFilter.class, null);
        this.registerFilter(UtLookupRootFolder.class, UtNavFilter.class, null);
        this.registerFilter(UtLookupCategoryFolder.class, UtNavFilter.class, null);
    }

    private static String getNavigatorLabel() {
        return RaptorExtensionConstants.isStandAlone() ? TITLE_NAME : PACKAGED_TITLE_NAME;
    }

    protected IdeAction createShowNavigatorAction() {
        String string = UtAddinArb.getString("NAV_NAME");
        IdeAction ideAction = IdeAction.get((int)UT_NAV_CMD_ID, null, (String)StringUtils.stripMnemonic((String)string), null, (Integer)StringUtils.getMnemonicKeyCode((String)string), (Icon)RaptorImage.getIcon((String)"unittestroot.png"), null, (boolean)true);
        return ideAction;
    }

    protected NavigatorWindow createNavigatorWindow() {
        return this.createNavigatorWindow((Folder)RootFolder.getInstance(), true, 0);
    }

    protected DefaultNavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return new UtNavigatorWindow(context, viewId.getId());
    }

    protected String getDefaultName() {
        return UtNavigatorManager.getNavigatorLabel();
    }

    protected String getViewCategory() {
        return UT_NAVIGATOR_WINDOW_ID;
    }

    public void initialize() {
        super.initialize();
        IdeAction ideAction = this.getShowAction();
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_VIEW_CONNECTION_NAVIGATOR);
        JMenu jMenu = MenuManager.getJMenu((String)"View");
        menubar.add((Component)jMenuItem, jMenu, MenuConstants.SECTION_VIEW_NAVIGATOR);
    }

    protected DockingParam createNavigatorDockingParam() {
        DockingParam dockingParam = new DockingParam();
        NavigatorManager navigatorManager = DatabaseNavigatorManager.getInstance();
        if (navigatorManager.getNavigatorWindow() != null) {
            dockingParam.setTabbedWith((Dockable)navigatorManager.getNavigatorWindow());
        } else {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            Dockable dockable = null;
            if (explorerManager != null) {
                ViewId viewId = explorerManager.getDefaultViewId();
                dockable = DockStation.getDockStation().findDockable(viewId);
            }
            dockingParam.setPosition(dockable, 2, 0);
            NavigatorManager.setWorkspaceNavigatorManager((NavigatorManager)this);
        }
        return dockingParam;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_unittesting_html");
    }
}

