/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.navigator;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.dbtools.raptor.navigator.WrappedException;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.codehook.CodeHookDefaults;
import oracle.dbtools.unit_test.editor.DynamicValueQuery;
import oracle.dbtools.unit_test.navigator.nodes.AbstractLoadChildrenTask;
import oracle.dbtools.unit_test.navigator.nodes.UtDynamicValueQueriesFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtDynamicValueQueryElement;
import oracle.dbtools.unit_test.navigator.nodes.UtLibraryFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtLookupCategoryFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtLookupNode;
import oracle.dbtools.unit_test.navigator.nodes.UtLookupRootFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtNestedSuiteNode;
import oracle.dbtools.unit_test.navigator.nodes.UtNestedSuitesFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtParamElement;
import oracle.dbtools.unit_test.navigator.nodes.UtStartupElement;
import oracle.dbtools.unit_test.navigator.nodes.UtStartupTypesFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtStartupsFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteNode;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteTestNode;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteTestsFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtTeardownElement;
import oracle.dbtools.unit_test.navigator.nodes.UtTeardownTypesFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtTeardownsFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtTestFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtTestImplNode;
import oracle.dbtools.unit_test.navigator.nodes.UtTestNode;
import oracle.dbtools.unit_test.navigator.nodes.UtValidationElement;
import oracle.dbtools.unit_test.navigator.nodes.UtValidationTypesFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtValidationsFolder;
import oracle.dbtools.unit_test.process_validation.IValidation;
import oracle.dbtools.unit_test.process_validation.ValidationRegistry;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.startup.StartupRegistry;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.teardown.TearDownRegistry;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;

public class UtNavFilter
extends BaseRaptorFilter {
    private List<Element> m_children;

    private String getQuery(String string) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)"/oracle/dbtools/unit_test/navigator/NavSql.xml");
        Query query = queryXMLSupport.getQuery(string, UtAddin.getRepositoryManager().getConnection());
        return query.getSql();
    }

    public TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getAddObjects()) {
            Element element = (Element)e;
            this.add(element);
            TNode tNode2 = treeExplorer.addChild(element, tNode, treeExplorer.getTreeModel());
            this.cache(tNode2);
            tNode2.getChildFilter();
        }
        return tNode;
    }

    private void add(Element element) {
        if (this.m_children != null && !this.m_children.contains(element)) {
            this.m_children.add(element);
        }
    }

    public TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (Object e : updateMessage.getRemoveObjects()) {
            Element element = (Element)e;
            this.remove(element);
            TNode tNode2 = this.lookup(element);
            if (tNode2 == null) {
                tNode2 = treeExplorer.searchTNodeBreadthFirst((Element)e, tNode);
            }
            if (tNode2 == null) continue;
            treeExplorer.removeChild(tNode2, treeExplorer.getTreeModel());
            this.uncache(tNode2);
        }
        return tNode;
    }

    private void remove(Element element) {
        if (this.m_children != null && this.m_children.contains(element)) {
            this.m_children.remove(element);
        }
    }

    public void closeChildren() {
        if (this.m_children != null) {
            this.m_children.clear();
            this.m_children = null;
        }
        this.clearCache();
    }

    public Iterator<Element> getChildren() {
        if (this.m_children == null) {
            this.m_children = this.doLoadChildrenTask();
        }
        return this.m_children.iterator();
    }

    protected Object getKey(Object object) {
        if (object instanceof Locatable) {
            return ((Locatable)object).getURL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String> loadTree(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string3 = this.getQuery(string);
                if (string2 != null) {
                    hashMap2.put("ID", string2);
                }
                if ((resultSetWrapper = dBUtil.executeOracleQuery(string3, hashMap2)) != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        hashMap.put(resultSet.getString(2), resultSet.getString(1));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return hashMap;
    }

    private List<Element> doLoadChildrenTask() {
        Node node = (Node)this.getOwner().getData();
        final AbstractLoadChildrenTask abstractLoadChildrenTask = new AbstractLoadChildrenTask((Element)node){

            protected List<Element> doWork() throws TaskException {
                ArrayList<Element> arrayList = new ArrayList();
                try {
                    arrayList = UtNavFilter.this.loadChildren();
                }
                catch (Exception exception) {
                    Throwable throwable = exception;
                    if (exception instanceof WrappedException) {
                        throwable = exception.getCause();
                    }
                    throw new TaskException(throwable);
                }
                return arrayList;
            }

            @Override
            public String getConnectionName() {
                return UtAddin.getRepositoryConnectionName();
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RaptorTaskManager.getInstance().addTask((RaptorTask)abstractLoadChildrenTask);
            }
        });
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(DummyElement.INSTANCE);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Element> loadChildren() {
        ArrayList<Element> arrayList;
        block39: {
            TNode tNode;
            HashMap<Object, Object> hashMap;
            block48: {
                Connection connection;
                block38: {
                    ResultSetWrapper resultSetWrapper;
                    block47: {
                        block46: {
                            block45: {
                                block44: {
                                    block43: {
                                        block42: {
                                            block41: {
                                                block40: {
                                                    hashMap = new HashMap();
                                                    arrayList = new ArrayList<Element>();
                                                    tNode = this.getOwner();
                                                    if (tNode == null) {
                                                        return arrayList;
                                                    }
                                                    if (!(tNode.getData() instanceof UtSuiteFolder)) break block40;
                                                    hashMap = this.loadTree("suite", null);
                                                    for (String string : hashMap.keySet()) {
                                                        UtSuiteNode utSuiteNode = new UtSuiteNode((String)hashMap.get(string), (String)hashMap.get(string), UtAddin.suiteNodeIcon);
                                                        utSuiteNode.setId(string);
                                                        arrayList.add((Element)utSuiteNode);
                                                    }
                                                    break block39;
                                                }
                                                if (!(tNode.getData() instanceof UtSuiteNode)) break block41;
                                                String string = ((UtSuiteNode)tNode.getData()).getId();
                                                arrayList.add((Element)new UtNestedSuitesFolder(UtAddinArb.getString("MAIN_SUITE"), UtAddinArb.getString("MAIN_SUITE"), UtAddin.suiteFolderIcon, string));
                                                arrayList.add((Element)new UtSuiteTestsFolder(UtAddinArb.getString("MAIN_TEST"), UtAddinArb.getString("MAIN_TEST"), UtAddin.testFolderIcon, string));
                                                break block39;
                                            }
                                            if (!(tNode.getData() instanceof UtNestedSuitesFolder)) break block42;
                                            String string = ((UtNestedSuitesFolder)tNode.getData()).getSuiteId();
                                            hashMap = this.loadTree("nested_suite", string);
                                            for (String string2 : hashMap.keySet()) {
                                                UtNestedSuiteNode utNestedSuiteNode = new UtNestedSuiteNode((String)hashMap.get(string2), (String)hashMap.get(string2), UtAddin.suiteNodeIcon);
                                                utNestedSuiteNode.setId(string2);
                                                utNestedSuiteNode.setSuiteId(string);
                                                arrayList.add((Element)utNestedSuiteNode);
                                            }
                                            break block39;
                                        }
                                        if (!(tNode.getData() instanceof UtSuiteTestsFolder)) break block43;
                                        String string = ((UtSuiteTestsFolder)tNode.getData()).getSuiteId();
                                        hashMap = this.loadTree("suite_test", string);
                                        for (String string3 : hashMap.keySet()) {
                                            UtSuiteTestNode utSuiteTestNode = new UtSuiteTestNode((String)hashMap.get(string3), (String)hashMap.get(string3), UtAddin.testNodeIcon);
                                            utSuiteTestNode.setId(string3);
                                            utSuiteTestNode.setSuiteId(string);
                                            arrayList.add((Element)utSuiteTestNode);
                                        }
                                        break block39;
                                    }
                                    if (!(tNode.getData() instanceof UtTestFolder)) break block44;
                                    hashMap = this.loadTree("test", null);
                                    for (String string : hashMap.keySet()) {
                                        UtTestNode utTestNode = new UtTestNode((String)hashMap.get(string), (String)hashMap.get(string), UtAddin.testNodeIcon);
                                        utTestNode.setId(string);
                                        arrayList.add((Element)utTestNode);
                                    }
                                    break block39;
                                }
                                if (!(tNode.getData() instanceof UtTestNode)) break block45;
                                String string = ((UtTestNode)tNode.getData()).getId();
                                hashMap = this.loadTree("test_impl", string);
                                for (String string4 : hashMap.keySet()) {
                                    UtTestImplNode utTestImplNode = new UtTestImplNode((String)hashMap.get(string4), (String)hashMap.get(string4), UtAddin.testImplIcon);
                                    utTestImplNode.setId(string4);
                                    arrayList.add((Element)utTestImplNode);
                                }
                                break block39;
                            }
                            if (!(tNode.getData() instanceof UtTestImplNode)) break block46;
                            String string = ((UtTestImplNode)tNode.getData()).getId();
                            hashMap = this.loadTree("test_param", string);
                            for (String string5 : hashMap.keySet()) {
                                UtParamElement utParamElement = new UtParamElement((String)hashMap.get(string5), (String)hashMap.get(string5), UtAddin.testParamIcon);
                                utParamElement.setId(string5);
                                arrayList.add((Element)utParamElement);
                            }
                            break block39;
                        }
                        if (!(tNode.getData() instanceof UtLookupRootFolder)) break block47;
                        hashMap = this.loadTree("lookup_categories", null);
                        for (String string : hashMap.keySet()) {
                            UtLookupCategoryFolder utLookupCategoryFolder = new UtLookupCategoryFolder((String)hashMap.get(string), (String)hashMap.get(string), UtAddin.lookupFolderIcon);
                            utLookupCategoryFolder.setId(string);
                            utLookupCategoryFolder.setCategory((String)hashMap.get(string));
                            arrayList.add((Element)utLookupCategoryFolder);
                        }
                        break block39;
                    }
                    if (!(tNode.getData() instanceof UtLookupCategoryFolder)) break block48;
                    String string = ((UtLookupCategoryFolder)tNode.getData()).getId();
                    Object var5_27 = null;
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    connection = UtAddin.getRepositoryManager().getConnection();
                    if (!Connections.getInstance().lock(connection)) break block39;
                    try {
                        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                        dBUtil.setRaiseError(true);
                        String string6 = this.getQuery("lookup_cat_datatypes");
                        hashMap2.put("ID", string);
                        resultSetWrapper = dBUtil.executeOracleQuery(string6, hashMap2);
                        if (resultSetWrapper != null) {
                            ResultSet resultSet = resultSetWrapper.getResultSet();
                            while (resultSet.next()) {
                                UtLookupNode utLookupNode = new UtLookupNode(resultSet.getString(5), resultSet.getString(5), UtAddin.lookupNodeIcon);
                                utLookupNode.setId(resultSet.getString(1));
                                utLookupNode.setCatId(resultSet.getString(2));
                                utLookupNode.setCategory(resultSet.getString(3));
                                utLookupNode.setDataTypeId(resultSet.getString(4));
                                utLookupNode.setDatatype(resultSet.getString(5));
                                arrayList.add((Element)utLookupNode);
                            }
                        }
                        if (resultSetWrapper == null) break block38;
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                        break block39;
                    }
                    finally {
                        if (var5_27 != null) {
                            var5_27.close();
                        }
                        Connections.getInstance().unlock(connection);
                    }
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
                break block39;
            }
            if (tNode.getData() instanceof UtLibraryFolder) {
                arrayList.add((Element)new UtStartupTypesFolder(UtAddinArb.getString("LIB_STARTUP_TYPES"), UtAddinArb.getString("LIB_STARTUP_TYPES"), UtAddin.libStartupTypesFolderIcon));
                arrayList.add((Element)new UtTeardownTypesFolder(UtAddinArb.getString("LIB_TEARDOWN_TYPES"), UtAddinArb.getString("LIB_TEARDOWN_TYPES"), UtAddin.libTeardownTypesFolderIcon));
                arrayList.add((Element)new UtValidationTypesFolder(UtAddinArb.getString("LIB_VALIDATION_TYPES"), UtAddinArb.getString("LIB_VALIDATION_TYPES"), UtAddin.libValidationTypesFolderIcon));
                arrayList.add((Element)new UtDynamicValueQueriesFolder(UtAddinArb.getString("LIB_DVQS"), UtAddinArb.getString("LIB_DVQS"), UtAddin.libStartupTypesFolderIcon));
            } else if (tNode.getData() instanceof UtStartupTypesFolder) {
                for (String string : StartupRegistry.getLovValues()) {
                    IStartup iStartup = StartupRegistry.getInstanceFor(string);
                    if (iStartup == null || iStartup.getComponent(new CodeHookDefaults()) == null) continue;
                    arrayList.add((Element)new UtStartupsFolder(string, string, UtAddin.libStartupsFolderIcon));
                }
            } else if (tNode.getData() instanceof UtTeardownTypesFolder) {
                for (String string : TearDownRegistry.getLovValues()) {
                    ITeardown iTeardown = TearDownRegistry.getInstanceFor(string);
                    if (iTeardown == null || iTeardown.getComponent(new CodeHookDefaults()) == null) continue;
                    arrayList.add((Element)new UtTeardownsFolder(string, string, UtAddin.libTeardownsFolderIcon));
                }
            } else if (tNode.getData() instanceof UtValidationTypesFolder) {
                for (String string : ValidationRegistry.getLovValues()) {
                    IValidation iValidation = ValidationRegistry.getInstanceFor(string);
                    if (iValidation == null || iValidation.getComponent(new CodeHookDefaults()) == null) continue;
                    arrayList.add((Element)new UtValidationsFolder(string, string, UtAddin.libValidationsFolderIcon));
                }
            } else if (tNode.getData() instanceof UtStartupsFolder) {
                String string = ((UtStartupsFolder)tNode.getData()).getShortLabel();
                String string7 = StartupRegistry.getClassFor(string).getName();
                hashMap = this.loadTree("lib_startups", string7);
                for (String string8 : hashMap.keySet()) {
                    UtStartupElement utStartupElement = new UtStartupElement((String)hashMap.get(string8), (String)hashMap.get(string8), UtAddin.libStartupIcon);
                    utStartupElement.setId(string8);
                    arrayList.add((Element)utStartupElement);
                }
            } else if (tNode.getData() instanceof UtTeardownsFolder) {
                String string = ((UtTeardownsFolder)tNode.getData()).getShortLabel();
                String string9 = TearDownRegistry.getClassFor(string).getName();
                hashMap = this.loadTree("lib_teardowns", string9);
                for (String string10 : hashMap.keySet()) {
                    UtTeardownElement utTeardownElement = new UtTeardownElement((String)hashMap.get(string10), (String)hashMap.get(string10), UtAddin.libTeardownIcon);
                    utTeardownElement.setId(string10);
                    arrayList.add((Element)utTeardownElement);
                }
            } else if (tNode.getData() instanceof UtValidationsFolder) {
                String string = ((UtValidationsFolder)tNode.getData()).getShortLabel();
                String string11 = ValidationRegistry.getClassFor(string).getName();
                hashMap = this.loadTree("lib_validations", string11);
                for (String string12 : hashMap.keySet()) {
                    UtValidationElement utValidationElement = new UtValidationElement((String)hashMap.get(string12), (String)hashMap.get(string12), UtAddin.libValidationIcon);
                    utValidationElement.setId(string12);
                    arrayList.add((Element)utValidationElement);
                }
            } else if (tNode.getData() instanceof UtDynamicValueQueriesFolder) {
                String string = DynamicValueQuery.class.getName();
                hashMap = this.loadTree("lib_dyn_queries", string);
                for (String string13 : hashMap.keySet()) {
                    UtDynamicValueQueryElement utDynamicValueQueryElement = new UtDynamicValueQueryElement((String)hashMap.get(string13), (String)hashMap.get(string13), UtAddin.libStartupIcon);
                    utDynamicValueQueryElement.setId(string13);
                    arrayList.add((Element)utDynamicValueQueryElement);
                }
            }
        }
        return arrayList;
    }
}

