/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.impexp;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.unit_test.impexp.ImportContext;
import oracle.dbtools.unit_test.impexp.ImportListener;
import oracle.dbtools.unit_test.impexp.LoggerLevel;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtLibraryItem;
import oracle.dbtools.unit_test.testObjects.UtSuite;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportManager {
    private Reader _reader;
    private HashMap<String, ImportAction> _actionMap = new HashMap();
    private String _errorMessage = null;

    public ImportManager(Reader reader) {
        this._reader = reader;
        this._actionMap.put(UtTest.class.getName(), new ImportAction(){

            @Override
            void importObject(XMLElement xMLElement, ImportListener importListener) {
                UtTest utTest = new UtTest(new ImportContextImpl(xMLElement));
                if (ImportManager.this._errorMessage == null) {
                    try {
                        utTest.save(true);
                        if (importListener != null) {
                            importListener.onImportTest(utTest);
                        }
                    }
                    catch (ObjectUpdateException objectUpdateException) {
                        ImportManager.this.logMessage(LoggerLevel.SEVERE, "Error saving " + utTest.getTestName());
                    }
                }
            }
        });
        this._actionMap.put(UtSuite.class.getName(), new ImportAction(){

            @Override
            void importObject(XMLElement xMLElement, ImportListener importListener) {
                UtSuite utSuite = new UtSuite(new ImportContextImpl(xMLElement));
                if (ImportManager.this._errorMessage == null) {
                    try {
                        utSuite.save(true);
                        if (importListener != null) {
                            importListener.onImportSuite(utSuite);
                        }
                    }
                    catch (ObjectUpdateException objectUpdateException) {
                        ImportManager.this.logMessage(LoggerLevel.SEVERE, "Error saving " + utSuite.getSuiteName());
                    }
                }
            }
        });
        this._actionMap.put(UtLibraryItem.class.getName(), new ImportAction(){

            @Override
            void importObject(XMLElement xMLElement, ImportListener importListener) {
                UtLibraryItem utLibraryItem = new UtLibraryItem(new ImportContextImpl(xMLElement));
                if (ImportManager.this._errorMessage == null) {
                    try {
                        utLibraryItem.save();
                        if (importListener != null) {
                            importListener.onImportLibraryItem(utLibraryItem);
                        }
                    }
                    catch (ObjectUpdateException objectUpdateException) {
                        ImportManager.this.logMessage(LoggerLevel.SEVERE, "Error saving " + utLibraryItem.getRef().getName());
                    }
                }
            }
        });
    }

    public boolean importObjects() {
        return this.importObjects(null);
    }

    public boolean importObjects(ImportListener importListener) {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse(this._reader);
        }
        catch (Exception exception) {
            this.logMessage(LoggerLevel.SEVERE, exception.getLocalizedMessage());
            return false;
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
        if (!xMLElement.getTagName().equals("UT")) {
            this.logMessage(LoggerLevel.SEVERE, "Invalid root element for UT import file: " + xMLElement.getTagName());
            return false;
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        block2: for (int i = 0; this._errorMessage == null && i < n; ++i) {
            XMLElement xMLElement2;
            Node node = nodeList.item(i);
            if (!(node instanceof XMLElement) || !(xMLElement2 = (XMLElement)node).getTagName().equals("object")) continue;
            String string = xMLElement2.getAttribute("class");
            ImportAction importAction = this._actionMap.get(string);
            if (importAction == null) {
                this.logMessage(LoggerLevel.SEVERE, "Invalid object element: " + string);
                continue;
            }
            NodeList nodeList2 = xMLElement2.getChildNodes();
            int n3 = nodeList2.getLength();
            for (int j = 0; j < n3; ++j) {
                Node node2 = nodeList2.item(j);
                if (!(node2 instanceof XMLElement)) continue;
                importAction.importObject((XMLElement)node2, importListener);
                ++n2;
                continue block2;
            }
        }
        if (this._errorMessage == null && n2 == 0) {
            this._errorMessage = "No valid objects found in import file";
        }
        return this._errorMessage == null;
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public void close() {
        try {
            this._reader.close();
        }
        catch (IOException iOException) {
            this.logMessage(LoggerLevel.SEVERE, iOException.getMessage());
        }
    }

    private void logMessage(LoggerLevel loggerLevel, String string) {
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, string);
        if (this._errorMessage == null) {
            switch (loggerLevel) {
                case ERROR: 
                case SEVERE: {
                    this._errorMessage = string;
                }
            }
        }
    }

    class ImportContextImpl
    implements ImportContext {
        private XMLElement _elem;

        public ImportContextImpl(XMLElement xMLElement) {
            this._elem = xMLElement;
        }

        @Override
        public XMLElement getImportedElement() {
            return this._elem;
        }

        @Override
        public List<XMLElement> getNestedElements(XMLElement xMLElement, String string) {
            NodeList nodeList = xMLElement.getChildrenByTagName(string);
            int n = nodeList.getLength();
            ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>(n);
            for (int i = 0; i < n; ++i) {
                XMLElement xMLElement2 = (XMLElement)nodeList.item(i);
                arrayList.add(xMLElement2);
            }
            return arrayList;
        }

        @Override
        public void log(LoggerLevel loggerLevel, String string) {
            ImportManager.this.logMessage(loggerLevel, string);
        }
    }

    abstract class ImportAction {
        ImportAction() {
        }

        abstract void importObject(XMLElement var1, ImportListener var2);
    }
}

