/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.unit_test.codehook.CodeHook;
import oracle.dbtools.unit_test.codehook.CodeHookLookup;
import oracle.dbtools.unit_test.codehook.ICodeHook;
import oracle.dbtools.unit_test.editor.CodeHookPanel;
import oracle.dbtools.unit_test.editor.ListTableModel;
import oracle.dbtools.unit_test.editor.UiArb;
import oracle.dbtools.unit_test.process_validation.IValidation;
import oracle.dbtools.unit_test.process_validation.ValidationArb;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class ValidationListTableModel
extends ListTableModel<IValidation> {
    private static final int SELECTOR = 0;
    private static final int VALIDATION = 1;
    private static final String[] COL_NAMES = new String[]{"", ValidationArb.getString("VALIDATION_LABEL")};
    private CodeHookLookup _lookup;
    private static Component DUMMY_RENDERER = new JLabel();

    public ValidationListTableModel(CodeHookLookup codeHookLookup) {
        super(COL_NAMES, null);
        this._lookup = codeHookLookup;
    }

    @Override
    public void setTable(JTable jTable) {
        super.setTable(jTable);
        jTable.getColumnModel().getColumn(0).setMaxWidth(10);
        jTable.setDefaultEditor(CodeHook.class, new CodeHookCellEditor());
        jTable.setDefaultRenderer(CodeHook.class, new CodeHookCellRenderer());
        jTable.setSurrendersFocusOnKeystroke(true);
    }

    @Override
    protected Object getValueAt(IValidation iValidation, int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return iValidation;
            }
        }
        return null;
    }

    @Override
    protected boolean isCellEditable(IValidation iValidation, int n) {
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void setValueAt(Object object, IValidation iValidation, int n) {
        block0 : switch (n) {
            case 1: {
                if (object.equals(iValidation)) break;
                IValidation iValidation2 = (IValidation)object;
                List list = this.getRowList();
                for (int i = 0; i < list.size(); ++i) {
                    IValidation iValidation3 = (IValidation)list.get(i);
                    if (!iValidation3.equals(iValidation)) continue;
                    list.set(i, iValidation2);
                    break block0;
                }
                break;
            }
        }
    }

    @Override
    public AbstractAction getRemoveSelectedAction() {
        final AbstractAction abstractAction = super.getRemoveSelectedAction();
        AbstractAction abstractAction2 = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                int n = ValidationListTableModel.this.getSelectedRow();
                int n2 = ValidationListTableModel.this.getSelectedRowCount();
                for (int i = 0; i < n2; ++i) {
                    CodeHook codeHook;
                    String string;
                    int n3 = n + i;
                    Object object = ValidationListTableModel.this.getValueAt(n3, 1);
                    if (!(object instanceof CodeHook) || !UtUtils.isValidationUsed(string = (codeHook = (CodeHook)object).getOwnerId())) continue;
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)UiArb.getString("REFERENCED_VALIDATION"), (String)UiArb.getString("REFERENCED_VALIDATION_TITLE"), null);
                    bl = false;
                    break;
                }
                if (bl) {
                    abstractAction.actionPerformed(actionEvent);
                }
            }

            @Override
            public boolean isEnabled() {
                return abstractAction.isEnabled();
            }
        };
        return abstractAction2;
    }

    class CodeHookCellRenderer
    implements TableCellRenderer {
        CodeHookCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Border border;
            if (null == object) {
                return DUMMY_RENDERER;
            }
            CodeHookPanel codeHookPanel = new CodeHookPanel((ICodeHook)object, ValidationListTableModel.this._lookup);
            jTable.setRowHeight(n, codeHookPanel.getPreferredSize().height);
            codeHookPanel.setEditable(ValidationListTableModel.this.isEditable());
            if (bl2 && (border = UIManager.getBorder("Table.focusCellHighlightBorder")) != null) {
                codeHookPanel.setBorder(border);
            }
            return codeHookPanel;
        }
    }

    class CodeHookCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        CodeHookPanel editor;

        CodeHookCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.editor = new CodeHookPanel((ICodeHook)object, ValidationListTableModel.this._lookup);
            this.editor.setEditable(ValidationListTableModel.this.isEditable());
            final JTable jTable2 = jTable;
            final int n3 = n;
            final int n4 = n2;
            this.editor.addPropertyChangeListener("CODE_HOOK", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jTable2.getModel().setValueAt(CodeHookCellEditor.this.editor.getCodeHook(), n3, n4);
                }
            });
            return this.editor;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor == null ? null : this.editor.getCodeHook();
        }
    }
}

