/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.codehook.CodeHookDefaults;
import oracle.dbtools.unit_test.codehook.ICodeHook;
import oracle.dbtools.unit_test.editor.ScrollableJPanel;
import oracle.dbtools.unit_test.editor.UtLibraryEditor;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtLibraryItem;
import oracle.dbtools.unit_test.utils.UiUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;

public class LibraryDetails
extends JPanel {
    private static final long serialVersionUID = 1L;
    private UtLibraryItem _libItem;
    private boolean _unsavedChanges;
    private UtLibraryEditor _editor;
    private DetailsView _view;
    private JPanel _panelCenter = new ScrollableJPanel();
    private JScrollPane _scrollPane = new JScrollPane(this._panelCenter);
    private ICodeHook _codeHook;
    private boolean _editable;
    private boolean _initialized;

    public LibraryDetails(UtLibraryEditor utLibraryEditor) {
        this._editor = utLibraryEditor;
        this._view = new DetailsView();
    }

    public void updateUI(UtLibraryItem utLibraryItem) {
        this._libItem = utLibraryItem;
        this._codeHook = this._libItem.createCodeHook();
        this._codeHook.setEditable(this._editable);
        this.markDirty(false);
        this.setInitialized(false);
        this.removeAll();
        this.validate();
        this.repaint();
        this.setLayout(new BorderLayout());
        this.add((Component)this._view.getToolbar(), "North");
        this._panelCenter.removeAll();
        this._panelCenter.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this._codeHook.getHookName()));
        jPanel.add(this._codeHook.getComponent(new CodeHookDefaults()), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._panelCenter.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this._codeHook.addChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LibraryDetails.this.markDirty(true);
            }
        });
        this.add((Component)this._scrollPane, "Center");
        this.validate();
        this.repaint();
        this.setInitialized(true);
        this.toggleButtons();
    }

    void toggleButtons() {
        View.updateToolbarActions((Toolbar)this._view.getToolbar());
        this.setEditable(this._editor.isEditable());
    }

    void setEditable(boolean bl) {
        this._editable = bl;
        if (this._codeHook != null) {
            this._codeHook.setEditable(this._editable);
        }
    }

    void commit() throws ObjectUpdateException {
        this.saveImpl();
    }

    private void saveImpl() throws ObjectUpdateException {
        if (this._unsavedChanges) {
            this._libItem.setXml(this._codeHook.getXml());
            this._libItem.save();
            this._unsavedChanges = false;
            this.toggleButtons();
        }
    }

    void rollback() {
        this.revertImpl();
    }

    private void revertImpl() {
        if (this._unsavedChanges) {
            this._unsavedChanges = false;
            this.updateUI(this._libItem);
        }
    }

    private boolean isInitialized() {
        return this._initialized;
    }

    private void setInitialized(boolean bl) {
        this._initialized = bl;
    }

    private void markDirty(boolean bl) {
        if (this.isInitialized()) {
            this._editor.markDirty(bl);
            this._unsavedChanges = bl;
            this.toggleButtons();
        }
    }

    class DetailsView
    extends View {
        private Toolbar _toolbar;
        private Controller myRefreshController = new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                boolean bl = true;
                if (LibraryDetails.this._editor.isEditable() && LibraryDetails.this._unsavedChanges) {
                    bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("DISCARD_INFO"), (String)UtAddinArb.getString("DISCARD_TITLE"), null, (boolean)true);
                }
                if (bl) {
                    LibraryDetails.this._editor.updateContent(true, false);
                }
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return true;
            }
        };

        DetailsView() {
            LibraryDetails.this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    LibraryDetails.this._editor.getRefreshAction().addController(DetailsView.this.myRefreshController);
                    View.updateToolbarActions((Toolbar)DetailsView.this.getToolbar());
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    LibraryDetails.this._editor.getRefreshAction().removeController(DetailsView.this.myRefreshController);
                    View.updateToolbarActions((Toolbar)DetailsView.this.getToolbar());
                }
            });
            LibraryDetails.this._editor.getRefreshAction().addController(this.myRefreshController);
            View.updateToolbarActions((Toolbar)this.getToolbar());
        }

        public Component getGUI() {
            return LibraryDetails.this;
        }

        public Toolbar getToolbar() {
            if (null == this._toolbar) {
                this._toolbar = new Toolbar();
                this._toolbar.addToggleButton((ToggleAction)LibraryDetails.this._editor.getPinToggleAction());
                this._toolbar.add((ToggleAction)LibraryDetails.this._editor.getRefreshAction());
                this._toolbar.addSeparator();
                this._toolbar.add((ToggleAction)LibraryDetails.this._editor.getEditAction());
                this._toolbar.add((ToggleAction)LibraryDetails.this._editor.getCommitAction());
                this._toolbar.add((ToggleAction)LibraryDetails.this._editor.getRollbackAction());
                LibraryDetails.this._editor.addConnectionCombo(this._toolbar);
                UiUtils.nameButtonsForQA(this._toolbar, "LibraryDetails");
            }
            return this._toolbar;
        }
    }
}

