/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.AnonymousClassSymbol;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.TypeVariableSymbol;

class TypeSymbol
extends Symbol {
    static final byte TC_VOID = 1;
    static final byte TC_BOOLEAN = 2;
    static final byte TC_INTEGER = 4;
    static final byte TC_LONG = 8;
    static final byte TC_FLOAT = 16;
    static final byte TC_DOUBLE = 32;
    static final byte TC_OBJECT = 64;
    static final byte TC_ARRAY = -128;
    static final byte TC_REFERENCE = -64;
    static final byte TC_WIDETYPE = 40;
    static final byte TC_NUMERIC = 60;
    static final byte TC_PRIMITIVE = 63;
    static final byte TC_ERROR = -1;
    static final byte TK_ERROR = 0;
    static final byte TK_VOID = 1;
    static final byte TK_BOOLEAN = 2;
    static final byte TK_BYTE = 3;
    static final byte TK_CHAR = 4;
    static final byte TK_SHORT = 5;
    static final byte TK_INTEGER = 6;
    static final byte TK_LONG = 7;
    static final byte TK_FLOAT = 8;
    static final byte TK_DOUBLE = 9;
    static final byte TK_OBJECT = 10;
    static final byte TK_ARRAY = 11;
    static final byte TK_MAX = 12;
    static TypeSymbol voidSymbol;
    static TypeSymbol byteSymbol;
    static TypeSymbol booleanSymbol;
    static TypeSymbol charSymbol;
    static TypeSymbol shortSymbol;
    static TypeSymbol intSymbol;
    static TypeSymbol longSymbol;
    static TypeSymbol floatSymbol;
    static TypeSymbol doubleSymbol;
    static TypeSymbol errorSymbol;
    static byte[] typeKindToTypeClass;
    static char[][] typeKindToSignature;
    static String[] typeKindToName;
    static byte[] typeWidth;
    static TypeSymbol[] binNumProm;
    static TypeSymbol[] unaNumProm;
    static TypeSymbol[] tokenToTypeSymbolMap;
    static final char[][] classInternalName;
    byte typeClass;
    byte typeKind;
    short access;
    Annotation annotation;
    TypeSymbol[] arrayTypes;
    static final /* synthetic */ boolean $assertionsDisabled;

    TypeSymbol(int pos, Identifier identifier, byte typeKind, short access, Annotation annotation) {
        super((byte)32, pos, identifier);
        this.access = access;
        this.annotation = annotation;
        this.typeKind = typeKind;
        this.typeClass = typeKindToTypeClass[typeKind];
    }

    public String toString() {
        return typeKindToName[this.typeKind];
    }

    boolean isErroneous() {
        return this == errorSymbol;
    }

    String errorName() {
        if (this.isErroneous()) {
            return "";
        }
        return this.toString();
    }

    String kindName() {
        return Message.typeString;
    }

    char[] getSignature() {
        return typeKindToSignature[this.typeKind];
    }

    protected void toString(StringBuffer sb) {
        sb.append(typeKindToName[this.typeKind]);
    }

    byte getAnnotationTarget() {
        return 1;
    }

    static void initializeStatics() {
        typeKindToTypeClass = new byte[12];
        TypeSymbol.typeKindToTypeClass[0] = -1;
        TypeSymbol.typeKindToTypeClass[1] = 1;
        TypeSymbol.typeKindToTypeClass[2] = 2;
        TypeSymbol.typeKindToTypeClass[3] = 4;
        TypeSymbol.typeKindToTypeClass[4] = 4;
        TypeSymbol.typeKindToTypeClass[5] = 4;
        TypeSymbol.typeKindToTypeClass[6] = 4;
        TypeSymbol.typeKindToTypeClass[7] = 8;
        TypeSymbol.typeKindToTypeClass[8] = 16;
        TypeSymbol.typeKindToTypeClass[9] = 32;
        TypeSymbol.typeKindToTypeClass[10] = 64;
        TypeSymbol.typeKindToTypeClass[11] = -128;
        typeKindToSignature = new char[12][1];
        TypeSymbol.typeKindToSignature[1][0] = 86;
        TypeSymbol.typeKindToSignature[2][0] = 90;
        TypeSymbol.typeKindToSignature[3][0] = 66;
        TypeSymbol.typeKindToSignature[4][0] = 67;
        TypeSymbol.typeKindToSignature[5][0] = 83;
        TypeSymbol.typeKindToSignature[6][0] = 73;
        TypeSymbol.typeKindToSignature[7][0] = 74;
        TypeSymbol.typeKindToSignature[8][0] = 70;
        TypeSymbol.typeKindToSignature[9][0] = 68;
        typeKindToName = new String[12];
        TypeSymbol.typeKindToName[1] = "void";
        TypeSymbol.typeKindToName[2] = "boolean";
        TypeSymbol.typeKindToName[3] = "byte";
        TypeSymbol.typeKindToName[4] = "char";
        TypeSymbol.typeKindToName[5] = "short";
        TypeSymbol.typeKindToName[6] = "int";
        TypeSymbol.typeKindToName[7] = "long";
        TypeSymbol.typeKindToName[8] = "float";
        TypeSymbol.typeKindToName[9] = "double";
        voidSymbol = new TypeSymbol(0, Identifier.getIdentifier("void"), 1, 1, null);
        byteSymbol = new TypeSymbol(0, Identifier.getIdentifier("byte"), 3, 1, null);
        booleanSymbol = new TypeSymbol(0, Identifier.getIdentifier("boolean"), 2, 1, null);
        charSymbol = new TypeSymbol(0, Identifier.getIdentifier("char"), 4, 1, null);
        shortSymbol = new TypeSymbol(0, Identifier.getIdentifier("short"), 5, 1, null);
        intSymbol = new TypeSymbol(0, Identifier.getIdentifier("int"), 6, 1, null);
        longSymbol = new TypeSymbol(0, Identifier.getIdentifier("long"), 7, 1, null);
        floatSymbol = new TypeSymbol(0, Identifier.getIdentifier("float"), 8, 1, null);
        doubleSymbol = new TypeSymbol(0, Identifier.getIdentifier("double"), 9, 1, null);
        errorSymbol = new TypeSymbol(0, Identifier.getIdentifier("0"), 0, 1, null);
        tokenToTypeSymbolMap = new TypeSymbol[9];
        TypeSymbol.tokenToTypeSymbolMap[0] = booleanSymbol;
        TypeSymbol.tokenToTypeSymbolMap[1] = byteSymbol;
        TypeSymbol.tokenToTypeSymbolMap[2] = charSymbol;
        TypeSymbol.tokenToTypeSymbolMap[3] = doubleSymbol;
        TypeSymbol.tokenToTypeSymbolMap[4] = floatSymbol;
        TypeSymbol.tokenToTypeSymbolMap[5] = intSymbol;
        TypeSymbol.tokenToTypeSymbolMap[6] = longSymbol;
        TypeSymbol.tokenToTypeSymbolMap[7] = shortSymbol;
        TypeSymbol.tokenToTypeSymbolMap[8] = voidSymbol;
        typeWidth = new byte[12];
        TypeSymbol.typeWidth[0] = 10;
        TypeSymbol.typeWidth[2] = 10;
        TypeSymbol.typeWidth[11] = 10;
        TypeSymbol.typeWidth[10] = 10;
        TypeSymbol.typeWidth[1] = 10;
        TypeSymbol.typeWidth[3] = 0;
        TypeSymbol.typeWidth[4] = 1;
        TypeSymbol.typeWidth[5] = 1;
        TypeSymbol.typeWidth[6] = 2;
        TypeSymbol.typeWidth[7] = 3;
        TypeSymbol.typeWidth[8] = 4;
        TypeSymbol.typeWidth[9] = 5;
        unaNumProm = new TypeSymbol[12];
        TypeSymbol.unaNumProm[1] = TypeSymbol.unaNumProm[2] = errorSymbol;
        TypeSymbol.unaNumProm[0] = TypeSymbol.unaNumProm[2];
        TypeSymbol.unaNumProm[5] = TypeSymbol.unaNumProm[6] = intSymbol;
        TypeSymbol.unaNumProm[4] = TypeSymbol.unaNumProm[6];
        TypeSymbol.unaNumProm[3] = TypeSymbol.unaNumProm[6];
        TypeSymbol.unaNumProm[7] = longSymbol;
        TypeSymbol.unaNumProm[8] = floatSymbol;
        TypeSymbol.unaNumProm[9] = doubleSymbol;
        TypeSymbol.unaNumProm[10] = TypeSymbol.unaNumProm[11] = errorSymbol;
        binNumProm = new TypeSymbol[144];
        TypeSymbol.binNumProm[10] = TypeSymbol.binNumProm[11] = errorSymbol;
        TypeSymbol.binNumProm[9] = TypeSymbol.binNumProm[11];
        TypeSymbol.binNumProm[8] = TypeSymbol.binNumProm[11];
        TypeSymbol.binNumProm[7] = TypeSymbol.binNumProm[11];
        TypeSymbol.binNumProm[6] = TypeSymbol.binNumProm[11];
        TypeSymbol.binNumProm[5] = TypeSymbol.binNumProm[11];
        TypeSymbol.binNumProm[4] = TypeSymbol.binNumProm[11];
        TypeSymbol.binNumProm[3] = TypeSymbol.binNumProm[11];
        TypeSymbol.binNumProm[2] = TypeSymbol.binNumProm[11];
        TypeSymbol.binNumProm[1] = TypeSymbol.binNumProm[11];
        TypeSymbol.binNumProm[0] = TypeSymbol.binNumProm[11];
        TypeSymbol.binNumProm[22] = TypeSymbol.binNumProm[23] = errorSymbol;
        TypeSymbol.binNumProm[21] = TypeSymbol.binNumProm[23];
        TypeSymbol.binNumProm[20] = TypeSymbol.binNumProm[23];
        TypeSymbol.binNumProm[19] = TypeSymbol.binNumProm[23];
        TypeSymbol.binNumProm[18] = TypeSymbol.binNumProm[23];
        TypeSymbol.binNumProm[16] = TypeSymbol.binNumProm[23];
        TypeSymbol.binNumProm[17] = TypeSymbol.binNumProm[23];
        TypeSymbol.binNumProm[15] = TypeSymbol.binNumProm[23];
        TypeSymbol.binNumProm[14] = TypeSymbol.binNumProm[23];
        TypeSymbol.binNumProm[13] = TypeSymbol.binNumProm[23];
        TypeSymbol.binNumProm[12] = TypeSymbol.binNumProm[23];
        TypeSymbol.binNumProm[34] = TypeSymbol.binNumProm[35] = errorSymbol;
        TypeSymbol.binNumProm[33] = TypeSymbol.binNumProm[35];
        TypeSymbol.binNumProm[32] = TypeSymbol.binNumProm[35];
        TypeSymbol.binNumProm[31] = TypeSymbol.binNumProm[35];
        TypeSymbol.binNumProm[30] = TypeSymbol.binNumProm[35];
        TypeSymbol.binNumProm[29] = TypeSymbol.binNumProm[35];
        TypeSymbol.binNumProm[28] = TypeSymbol.binNumProm[35];
        TypeSymbol.binNumProm[27] = TypeSymbol.binNumProm[35];
        TypeSymbol.binNumProm[26] = TypeSymbol.binNumProm[35];
        TypeSymbol.binNumProm[25] = TypeSymbol.binNumProm[35];
        TypeSymbol.binNumProm[24] = TypeSymbol.binNumProm[35];
        TypeSymbol.binNumProm[37] = TypeSymbol.binNumProm[38] = errorSymbol;
        TypeSymbol.binNumProm[36] = TypeSymbol.binNumProm[38];
        TypeSymbol.binNumProm[41] = TypeSymbol.binNumProm[42] = intSymbol;
        TypeSymbol.binNumProm[40] = TypeSymbol.binNumProm[42];
        TypeSymbol.binNumProm[39] = TypeSymbol.binNumProm[42];
        TypeSymbol.binNumProm[43] = longSymbol;
        TypeSymbol.binNumProm[44] = floatSymbol;
        TypeSymbol.binNumProm[45] = doubleSymbol;
        TypeSymbol.binNumProm[46] = TypeSymbol.binNumProm[47] = errorSymbol;
        TypeSymbol.binNumProm[49] = TypeSymbol.binNumProm[50] = errorSymbol;
        TypeSymbol.binNumProm[48] = TypeSymbol.binNumProm[50];
        TypeSymbol.binNumProm[53] = TypeSymbol.binNumProm[54] = intSymbol;
        TypeSymbol.binNumProm[52] = TypeSymbol.binNumProm[54];
        TypeSymbol.binNumProm[51] = TypeSymbol.binNumProm[54];
        TypeSymbol.binNumProm[55] = longSymbol;
        TypeSymbol.binNumProm[56] = floatSymbol;
        TypeSymbol.binNumProm[57] = doubleSymbol;
        TypeSymbol.binNumProm[58] = TypeSymbol.binNumProm[59] = errorSymbol;
        TypeSymbol.binNumProm[61] = TypeSymbol.binNumProm[62] = errorSymbol;
        TypeSymbol.binNumProm[60] = TypeSymbol.binNumProm[62];
        TypeSymbol.binNumProm[65] = TypeSymbol.binNumProm[66] = intSymbol;
        TypeSymbol.binNumProm[64] = TypeSymbol.binNumProm[66];
        TypeSymbol.binNumProm[63] = TypeSymbol.binNumProm[66];
        TypeSymbol.binNumProm[67] = longSymbol;
        TypeSymbol.binNumProm[68] = floatSymbol;
        TypeSymbol.binNumProm[69] = doubleSymbol;
        TypeSymbol.binNumProm[70] = TypeSymbol.binNumProm[71] = errorSymbol;
        TypeSymbol.binNumProm[73] = TypeSymbol.binNumProm[74] = errorSymbol;
        TypeSymbol.binNumProm[72] = TypeSymbol.binNumProm[74];
        TypeSymbol.binNumProm[77] = TypeSymbol.binNumProm[78] = intSymbol;
        TypeSymbol.binNumProm[76] = TypeSymbol.binNumProm[78];
        TypeSymbol.binNumProm[75] = TypeSymbol.binNumProm[78];
        TypeSymbol.binNumProm[79] = longSymbol;
        TypeSymbol.binNumProm[80] = floatSymbol;
        TypeSymbol.binNumProm[81] = doubleSymbol;
        TypeSymbol.binNumProm[82] = TypeSymbol.binNumProm[83] = errorSymbol;
        TypeSymbol.binNumProm[85] = TypeSymbol.binNumProm[86] = errorSymbol;
        TypeSymbol.binNumProm[84] = TypeSymbol.binNumProm[86];
        TypeSymbol.binNumProm[90] = TypeSymbol.binNumProm[91] = longSymbol;
        TypeSymbol.binNumProm[89] = TypeSymbol.binNumProm[91];
        TypeSymbol.binNumProm[88] = TypeSymbol.binNumProm[91];
        TypeSymbol.binNumProm[87] = TypeSymbol.binNumProm[91];
        TypeSymbol.binNumProm[92] = floatSymbol;
        TypeSymbol.binNumProm[93] = doubleSymbol;
        TypeSymbol.binNumProm[94] = TypeSymbol.binNumProm[95] = errorSymbol;
        TypeSymbol.binNumProm[97] = TypeSymbol.binNumProm[98] = errorSymbol;
        TypeSymbol.binNumProm[96] = TypeSymbol.binNumProm[98];
        TypeSymbol.binNumProm[103] = TypeSymbol.binNumProm[104] = floatSymbol;
        TypeSymbol.binNumProm[102] = TypeSymbol.binNumProm[104];
        TypeSymbol.binNumProm[101] = TypeSymbol.binNumProm[104];
        TypeSymbol.binNumProm[100] = TypeSymbol.binNumProm[104];
        TypeSymbol.binNumProm[99] = TypeSymbol.binNumProm[104];
        TypeSymbol.binNumProm[105] = doubleSymbol;
        TypeSymbol.binNumProm[106] = TypeSymbol.binNumProm[107] = errorSymbol;
        TypeSymbol.binNumProm[109] = TypeSymbol.binNumProm[110] = errorSymbol;
        TypeSymbol.binNumProm[108] = TypeSymbol.binNumProm[110];
        TypeSymbol.binNumProm[116] = TypeSymbol.binNumProm[117] = doubleSymbol;
        TypeSymbol.binNumProm[115] = TypeSymbol.binNumProm[117];
        TypeSymbol.binNumProm[114] = TypeSymbol.binNumProm[117];
        TypeSymbol.binNumProm[113] = TypeSymbol.binNumProm[117];
        TypeSymbol.binNumProm[112] = TypeSymbol.binNumProm[117];
        TypeSymbol.binNumProm[111] = TypeSymbol.binNumProm[117];
        TypeSymbol.binNumProm[118] = TypeSymbol.binNumProm[119] = errorSymbol;
        TypeSymbol.binNumProm[130] = TypeSymbol.binNumProm[131] = errorSymbol;
        TypeSymbol.binNumProm[129] = TypeSymbol.binNumProm[131];
        TypeSymbol.binNumProm[128] = TypeSymbol.binNumProm[131];
        TypeSymbol.binNumProm[127] = TypeSymbol.binNumProm[131];
        TypeSymbol.binNumProm[126] = TypeSymbol.binNumProm[131];
        TypeSymbol.binNumProm[125] = TypeSymbol.binNumProm[131];
        TypeSymbol.binNumProm[124] = TypeSymbol.binNumProm[131];
        TypeSymbol.binNumProm[123] = TypeSymbol.binNumProm[131];
        TypeSymbol.binNumProm[122] = TypeSymbol.binNumProm[131];
        TypeSymbol.binNumProm[121] = TypeSymbol.binNumProm[131];
        TypeSymbol.binNumProm[120] = TypeSymbol.binNumProm[131];
        TypeSymbol.binNumProm[142] = TypeSymbol.binNumProm[143] = errorSymbol;
        TypeSymbol.binNumProm[141] = TypeSymbol.binNumProm[143];
        TypeSymbol.binNumProm[140] = TypeSymbol.binNumProm[143];
        TypeSymbol.binNumProm[139] = TypeSymbol.binNumProm[143];
        TypeSymbol.binNumProm[138] = TypeSymbol.binNumProm[143];
        TypeSymbol.binNumProm[137] = TypeSymbol.binNumProm[143];
        TypeSymbol.binNumProm[136] = TypeSymbol.binNumProm[143];
        TypeSymbol.binNumProm[135] = TypeSymbol.binNumProm[143];
        TypeSymbol.binNumProm[134] = TypeSymbol.binNumProm[143];
        TypeSymbol.binNumProm[133] = TypeSymbol.binNumProm[143];
        TypeSymbol.binNumProm[132] = TypeSymbol.binNumProm[143];
    }

    static void releaseStatics() {
        voidSymbol = null;
        byteSymbol = null;
        booleanSymbol = null;
        charSymbol = null;
        shortSymbol = null;
        intSymbol = null;
        longSymbol = null;
        floatSymbol = null;
        doubleSymbol = null;
        errorSymbol = null;
        typeKindToTypeClass = null;
        typeKindToSignature = null;
        typeKindToName = null;
        typeWidth = null;
        binNumProm = null;
        unaNumProm = null;
        tokenToTypeSymbolMap = null;
    }

    boolean equalTo(TypeSymbol typeSymbol) {
        return this.equalTo(typeSymbol, null);
    }

    boolean equalTo(TypeSymbol typeSymbol, TypeSymbol recursionCheck) {
        return this == typeSymbol;
    }

    static final TypeSymbol unaryNumericPromotion(Parser parser, TypeSymbol type) {
        if (parser.parsingAtLeastOneFive && type.isReferenceType() && (type = BoxingExpression.getPrimitiveType(parser, type)) == null) {
            return errorSymbol;
        }
        return unaNumProm[type.typeKind];
    }

    static final TypeSymbol binaryNumericPromotion(Parser parser, TypeSymbol type1, TypeSymbol type2) {
        if (parser.parsingAtLeastOneFive) {
            if (type1.isReferenceType() && (type1 = BoxingExpression.getPrimitiveType(parser, type1)) == null) {
                return errorSymbol;
            }
            if (type2.isReferenceType() && (type2 = BoxingExpression.getPrimitiveType(parser, type2)) == null) {
                return errorSymbol;
            }
        }
        return binNumProm[type1.typeKind + type2.typeKind * 12];
    }

    static final boolean isWider(byte type1Kind, byte type2Kind) {
        return typeWidth[type1Kind] > typeWidth[type2Kind];
    }

    static final boolean isWiderOrSame(byte type1Kind, byte type2Kind) {
        return typeWidth[type1Kind] >= typeWidth[type2Kind];
    }

    static final TypeSymbol tokenToTypeSymbol(byte tokenKind) {
        return tokenToTypeSymbolMap[tokenKind];
    }

    boolean isAccessible(ClassSymbol fromClass) {
        return true;
    }

    TypeSymbol resolveType(Parser parser, int pos, boolean mustBePublic, boolean checkActualTypeParameters, boolean lazy) {
        return this;
    }

    TypeSymbol resolveType(Parser parser, int pos, boolean mustBePublic, boolean checkActualTypeParameters, boolean lazy, boolean checkAccess) {
        return this.resolveType(parser, pos, mustBePublic, checkActualTypeParameters, lazy);
    }

    final boolean isPrimitiveType() {
        return (this.typeClass & 0x3F) != 0;
    }

    final boolean isNumericType() {
        return (this.typeClass & 0x3C) != 0;
    }

    boolean isReferenceType() {
        return false;
    }

    boolean isArrayType() {
        return false;
    }

    boolean isUnresolvedType() {
        return false;
    }

    boolean isReifiable() {
        return true;
    }

    boolean isCompiled() {
        return false;
    }

    boolean isClass() {
        return false;
    }

    boolean isIntersectionType() {
        return false;
    }

    boolean isRawClass() {
        return false;
    }

    boolean isInterface() {
        return false;
    }

    boolean isEnum() {
        return false;
    }

    boolean isAnnotation() {
        return false;
    }

    boolean isInnerClass() {
        return false;
    }

    boolean isLocalInnerClass() {
        return false;
    }

    boolean isStaticInnerClass() {
        return false;
    }

    boolean isNonStaticInnerClass() {
        return false;
    }

    boolean isAnonymousInnerClass() {
        return false;
    }

    boolean isNonAnonymousInnerClass() {
        return false;
    }

    boolean isGenericType() {
        return false;
    }

    boolean isTypeParameter() {
        return false;
    }

    boolean isTypeVariable() {
        return false;
    }

    boolean isMethodTypeParameter() {
        return false;
    }

    boolean isParameterizedClass() {
        return false;
    }

    boolean isErasedType() {
        return false;
    }

    boolean involvesGenerics() {
        return false;
    }

    boolean involvesTypeParameter() {
        return false;
    }

    boolean containsTypeParameterDefinedBy(Symbol definedBySymbol) {
        return false;
    }

    boolean containsTypeParameter(TypeParameterSymbol tps) {
        return false;
    }

    void getTypeParameterSymbol(ArrayList al) {
    }

    void checkDeprecated(Parser parser, int pos) {
    }

    char[] getGenericSignature() {
        return this.getSignature();
    }

    void checkForUncheckedConversion(Parser parser, int pos, TypeSymbol fromType, boolean isCastExpression) {
        RawClassSymbol fromClass;
        RawClassSymbol thisClass;
        if (fromType == ReferenceTypeSymbol.nullTypeSymbol) {
            return;
        }
        if (isCastExpression && this.involvesTypeParameter()) {
            parser.warning(null, Message.warningUncheckedConversion, pos, fromType.errorName(), this.errorName());
        } else if (this.isClass() && fromType.isClass() && !fromType.isIntersectionType() && this.isParameterizedClass() && this.involvesGenerics() && fromType.isParameterizedClass() && fromType.isErasedType() && ((thisClass = ((ClassSymbol)this).getClassSymbol()) == (fromClass = ((ClassSymbol)fromType).getClassSymbol()) || thisClass.isSuperclass(fromClass) || thisClass.isInterface() && fromClass.implementsInterface(thisClass))) {
            parser.warning(null, Message.warningUncheckedConversion, pos, fromType.errorName(), this.errorName());
        }
    }

    void changeScope(Scope scope) {
    }

    TypeSymbol replaceUnresolvedTypeParameters(TypeParameterList tpl) {
        return this;
    }

    TypeSymbol replaceTypeParameters(TypeParameterList tpl) {
        return this;
    }

    final TypeSymbol applyTypeVariable(TypeParameterSymbol tps, TypeVariableSymbol tvs) {
        return this.applyTypeVariables(new TypeParameterList(tps), new TypeVariableList(tvs));
    }

    final TypeSymbol applyTypeVariables(TypeParameterList tpl, TypeVariableList tvl) {
        return this.applyTypeVariables(tpl, tvl, true);
    }

    TypeSymbol applyTypeVariables(TypeParameterList tpl, TypeVariableList tvl, boolean topLevel) {
        return this;
    }

    private TypeSymbol replaceTypeParameter(TypeParameterSymbol tps, ParameterizedClassSymbol classSymbol) {
        TypeSymbol typeSymbol = this;
        if (classSymbol.isInterface()) {
            if (classSymbol.genericClassSymbol == tps.definingSymbol) {
                return this.applyTypeVariables(classSymbol.genericClassSymbol.cd.getTypeParameterList(), classSymbol.typeVariableList);
            }
            ImplementationList implList = classSymbol.getImplementationList();
            while (implList != null) {
                if ((typeSymbol = typeSymbol.replaceTypeParameter(tps, (ParameterizedClassSymbol)implList.interfaceSymbol)) != this) {
                    return typeSymbol;
                }
                implList = implList.next;
            }
        } else {
            do {
                if (classSymbol.genericClassSymbol == tps.definingSymbol) {
                    return this.applyTypeVariables(classSymbol.genericClassSymbol.cd.getTypeParameterList(), classSymbol.typeVariableList);
                }
                ImplementationList implList = classSymbol.getImplementationList();
                while (implList != null) {
                    if ((typeSymbol = typeSymbol.replaceTypeParameter(tps, (ParameterizedClassSymbol)implList.interfaceSymbol)) != this) {
                        return typeSymbol;
                    }
                    implList = implList.next;
                }
            } while ((classSymbol = (ParameterizedClassSymbol)classSymbol.getSuperClassSymbol()) != null);
        }
        return this;
    }

    final TypeSymbol replaceTypeParameters(RawClassSymbol currentClassIn, TypeParameterList tpl, TypeVariableList tvl, Expression thisArg) {
        RawClassSymbol currentClass;
        ParameterizedClassSymbol classSymbol;
        TypeSymbol ts;
        TypeSymbol typeSymbol = this;
        if (tvl != null) {
            typeSymbol = typeSymbol.applyTypeVariables(tpl, tvl);
        }
        ParameterizedClassSymbol thisClass = null;
        if (thisArg != null) {
            ts = thisArg.getType();
            if (ts.isErasedType()) {
                return typeSymbol.eraseType();
            }
            if (ts.isTypeParameter()) {
                ts = ((TypeParameterSymbol)ts).bound;
            }
            if (ts.isParameterizedClass()) {
                thisClass = classSymbol = (ParameterizedClassSymbol)ts;
                do {
                    typeSymbol = typeSymbol.applyTypeVariables(classSymbol.genericClassSymbol.cd.getTypeParameterList(), classSymbol.typeVariableList);
                } while ((classSymbol = classSymbol.outerClassSymbol) != null);
            } else if (ts.isClass()) {
                currentClass = ((ClassSymbol)ts).getClassSymbol();
                thisClass = ParameterizedClassSymbol.getParameterizedClassSymbol(currentClass, TypeVariableList.newTypeVariableList(currentClass.cd.getTypeParameterList()), null);
            }
        }
        ArrayList al = new ArrayList(3);
        typeSymbol.getTypeParameterSymbol(al);
        int size = al.size();
        block1: for (int i = 0; i < size; ++i) {
            TypeParameterSymbol tps = (TypeParameterSymbol)al.get(i);
            if (!$assertionsDisabled && tps == null) {
                throw new AssertionError();
            }
            ts = typeSymbol;
            for (classSymbol = thisClass; classSymbol != null; classSymbol = (ParameterizedClassSymbol)classSymbol.getSuperClassSymbol()) {
                if ((typeSymbol = typeSymbol.replaceTypeParameter(tps, classSymbol)) != ts) continue block1;
            }
            for (currentClass = currentClassIn; currentClass != null; currentClass = currentClass.getOuterClass()) {
                ParameterizedClassSymbol currentPcs;
                TypeParameterList currentClassTpl = null;
                if (currentClass.isAnonymousInnerClass()) {
                    ClassSymbol overriddenClass = ((AnonymousClassSymbol)currentClass).getOverriddenClass();
                    currentClassTpl = overriddenClass.getClassSymbol().cd.getTypeParameterList();
                } else {
                    currentClassTpl = currentClass.cd.getTypeParameterList();
                }
                for (classSymbol = currentPcs = ParameterizedClassSymbol.getParameterizedClassSymbol(currentClass, TypeVariableList.newTypeVariableList(currentClassTpl), null); classSymbol != null; classSymbol = (ParameterizedClassSymbol)classSymbol.getSuperClassSymbol()) {
                    if ((typeSymbol = typeSymbol.replaceTypeParameter(tps, classSymbol)) != ts) continue block1;
                }
                if (!currentClass.isInnerClass()) continue block1;
            }
        }
        return typeSymbol;
    }

    TypeSymbol eraseType() {
        return this;
    }

    static {
        $assertionsDisabled = !TypeSymbol.class.desiredAssertionStatus();
        classInternalName = new char[][]{null, {'j', 'a', 'v', 'a', '/', 'l', 'a', 'n', 'g', '/', 'V', 'o', 'i', 'd'}, {'j', 'a', 'v', 'a', '/', 'l', 'a', 'n', 'g', '/', 'B', 'o', 'o', 'l', 'e', 'a', 'n'}, {'j', 'a', 'v', 'a', '/', 'l', 'a', 'n', 'g', '/', 'B', 'y', 't', 'e'}, {'j', 'a', 'v', 'a', '/', 'l', 'a', 'n', 'g', '/', 'C', 'h', 'a', 'r', 'a', 'c', 't', 'e', 'r'}, {'j', 'a', 'v', 'a', '/', 'l', 'a', 'n', 'g', '/', 'S', 'h', 'o', 'r', 't'}, {'j', 'a', 'v', 'a', '/', 'l', 'a', 'n', 'g', '/', 'I', 'n', 't', 'e', 'g', 'e', 'r'}, {'j', 'a', 'v', 'a', '/', 'l', 'a', 'n', 'g', '/', 'L', 'o', 'n', 'g'}, {'j', 'a', 'v', 'a', '/', 'l', 'a', 'n', 'g', '/', 'F', 'l', 'o', 'a', 't'}, {'j', 'a', 'v', 'a', '/', 'l', 'a', 'n', 'g', '/', 'D', 'o', 'u', 'b', 'l', 'e'}, null, null};
    }
}

