/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ClassSymbolList;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.TypeVariableSymbol;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedSuperClassException;

final class TypeParameterSymbol
extends ClassSymbol {
    Symbol definingSymbol;
    boolean emptyBound;
    ClassSymbol bound;
    int boundPos;
    ClassSymbolList interfaceBounds;
    MethodSymbol[] methodTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    TypeParameterSymbol(int pos, Identifier identifier, ClassSymbol bound, int boundPos, ClassSymbolList interfaceBounds) {
        super(pos, identifier, (byte)10, (short)0, null);
        this.bound = bound;
        this.boundPos = boundPos;
        this.interfaceBounds = interfaceBounds;
    }

    TypeParameterSymbol(int pos, Identifier identifier) {
        super(pos, identifier, (byte)10, (short)0, null);
    }

    boolean isErroneous() {
        if (this.bound.isErroneous()) {
            return true;
        }
        ClassSymbolList tsl = this.interfaceBounds;
        while (tsl != null) {
            if (tsl.classSymbol.isErroneous()) {
                return true;
            }
            tsl = tsl.next;
        }
        return false;
    }

    String kindName() {
        return Message.classString;
    }

    char[] getSignature() {
        if (this.emptyBound) {
            return this.interfaceBounds.classSymbol.getSignature();
        }
        return this.bound.getSignature();
    }

    char[] getInternalName() {
        if (this.emptyBound) {
            return this.interfaceBounds.classSymbol.getInternalName();
        }
        return this.bound.getInternalName();
    }

    protected void toString(StringBuffer sb) {
        sb.append(this.identifier.toString());
    }

    boolean equalTo(TypeSymbol typeSymbol, TypeSymbol recursionCheck) {
        if (this == typeSymbol) {
            return true;
        }
        if (typeSymbol.isTypeParameter()) {
            TypeParameterSymbol tps = (TypeParameterSymbol)typeSymbol;
            if (doMethodTypeParameterConversion && (doClassTypeParameterConversion || tps.isMethodTypeParameter())) {
                return this.equalTo(tps.bound, recursionCheck);
            }
            ClassSymbol boundSymbol = this.bound;
            while (boundSymbol.isTypeParameter()) {
                if (boundSymbol == typeSymbol) {
                    return true;
                }
                boundSymbol = ((TypeParameterSymbol)boundSymbol).bound;
            }
            return false;
        }
        if (typeSymbol.isTypeVariable()) {
            TypeVariableSymbol tvs = (TypeVariableSymbol)typeSymbol;
            ClassSymbol classSymbol = (ClassSymbol)tvs.refSymbol;
            switch (tvs.typeVariableKind) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 0: {
                    return true;
                }
                case 1: {
                    return this.equalTo(classSymbol, recursionCheck);
                }
                case 2: {
                    return classSymbol == ReferenceTypeSymbol.nullTypeSymbol;
                }
                case 3: 
            }
            if (this.equalTo(classSymbol, recursionCheck)) {
                return true;
            }
            if (classSymbol.isInterface()) {
                return this.implementsInterface(classSymbol, recursionCheck);
            }
            return classSymbol.isSuperclass(this, recursionCheck);
        }
        if (this.bound.equalTo(typeSymbol, recursionCheck)) {
            return true;
        }
        if (!typeSymbol.isClass()) {
            return false;
        }
        ClassSymbol classSymbol = (ClassSymbol)typeSymbol;
        if (classSymbol.containsTypeParameter(this)) {
            return false;
        }
        if (classSymbol.isInterface()) {
            return this.bound.implementsInterface(classSymbol, recursionCheck);
        }
        return classSymbol.isSuperclass(this.bound, recursionCheck);
    }

    TypeSymbol resolveType(Parser parser, int pos, boolean mustBePublic, boolean checkActualTypeParameters, boolean lazy) {
        TypeSymbol typeSymbol = this.bound.resolveType(parser, this.boundPos, mustBePublic, checkActualTypeParameters, false, true);
        if (!typeSymbol.isClass()) {
            typeSymbol = parser.javaLangObjectPcs;
        }
        this.bound = (ClassSymbol)typeSymbol;
        ClassSymbolList tsl = this.interfaceBounds;
        while (tsl != null) {
            typeSymbol = tsl.classSymbol.resolveType(parser, tsl.getPos(), mustBePublic, checkActualTypeParameters, false, true);
            if (!typeSymbol.isClass()) {
                typeSymbol = parser.javaLangObjectPcs;
            }
            tsl.classSymbol = (ClassSymbol)typeSymbol;
            tsl = tsl.next;
        }
        return this;
    }

    boolean isTypeParameter() {
        return true;
    }

    boolean isMethodTypeParameter() {
        return this.definingSymbol instanceof MethodSymbol;
    }

    boolean involvesGenerics() {
        return true;
    }

    boolean involvesTypeParameter() {
        return true;
    }

    boolean containsTypeParameterDefinedBy(Symbol definedBySymbol) {
        return definedBySymbol == null || definedBySymbol == this.definingSymbol;
    }

    boolean containsTypeParameter(TypeParameterSymbol tps) {
        return tps == this;
    }

    void getTypeParameterSymbol(ArrayList al) {
        al.add(this);
    }

    void changeScope(Scope scope) {
        this.bound.changeScope(scope);
        ClassSymbolList tsl = this.interfaceBounds;
        while (tsl != null) {
            tsl.classSymbol.changeScope(scope);
            tsl = tsl.next;
        }
    }

    TypeSymbol replaceUnresolvedTypeParameters(TypeParameterList tpl) {
        this.bound = (ClassSymbol)this.bound.replaceUnresolvedTypeParameters(tpl);
        ClassSymbolList tsl = this.interfaceBounds;
        while (tsl != null) {
            tsl.classSymbol = (ClassSymbol)tsl.classSymbol.replaceUnresolvedTypeParameters(tpl);
            tsl = tsl.next;
        }
        return this;
    }

    TypeSymbol replaceTypeParameters(TypeParameterList tpl) {
        while (tpl != null) {
            if (this.identifier == tpl.typeParameter.identifier) {
                return tpl.typeParameter;
            }
            tpl = tpl.next;
        }
        return this;
    }

    TypeSymbol applyTypeVariables(TypeParameterList tpl, TypeVariableList tvl, boolean topLevel) {
        while (tpl != null && tvl != null) {
            if (tpl.typeParameter == this) {
                if (tvl.typeVariable.typeVariableKind == 0) {
                    return new TypeVariableSymbol(tvl.typeVariable.pos, 2, tpl.typeParameter.bound);
                }
                if (tvl.typeVariable.refSymbol != null) {
                    if (tvl.typeVariable.typeVariableKind == 1) {
                        return tvl.typeVariable.refSymbol;
                    }
                    return tvl.typeVariable;
                }
                return tpl.typeParameter.bound;
            }
            tpl = tpl.next;
            tvl = tvl.next;
        }
        return this;
    }

    char[] getGenericSignature() {
        StringBuffer sb = new StringBuffer("T");
        sb.append(this.identifier.name);
        sb.append(';');
        return sb.toString().toCharArray();
    }

    RawClassSymbol getClassSymbol() {
        return this.bound.getClassSymbol();
    }

    ClassSymbol getSuperClassSymbol() {
        return this.bound;
    }

    ClassSymbol getInterface(RawClassSymbol interfaceSymbol) {
        return this.bound.getInterface(interfaceSymbol);
    }

    ImplementationList getImplementationList() {
        return this.bound.getImplementationList();
    }

    boolean isSuperclass(ClassSymbol ofClass) {
        return this.isSuperclass(ofClass, null);
    }

    boolean isSuperclass(ClassSymbol ofClass, TypeSymbol recursionCheck) {
        if (ofClass.isTypeParameter()) {
            TypeParameterSymbol tps = (TypeParameterSymbol)ofClass;
            if (doMethodTypeParameterConversion && (doClassTypeParameterConversion || tps.isMethodTypeParameter())) {
                return this.bound.isSuperclass(tps, recursionCheck);
            }
            ClassSymbol boundSymbol = tps.bound;
            while (boundSymbol.isTypeParameter()) {
                if (boundSymbol == this) {
                    return true;
                }
                boundSymbol = ((TypeParameterSymbol)boundSymbol).bound;
            }
            return false;
        }
        return this.bound.isSuperclass(ofClass, recursionCheck);
    }

    boolean implementsInterface(ClassSymbol interfaceClass) {
        return this.implementsInterface(interfaceClass, null);
    }

    boolean implementsInterface(ClassSymbol interfaceClass, TypeSymbol recursionCheck) {
        if (this.interfaceBounds != null) {
            ClassSymbolList tsl = this.interfaceBounds;
            while (tsl != null) {
                ClassSymbol classSymbol = tsl.classSymbol;
                if (classSymbol.equalTo(interfaceClass, recursionCheck) || classSymbol.implementsInterface(interfaceClass, recursionCheck)) {
                    return true;
                }
                tsl = tsl.next;
            }
        } else {
            return this.bound.implementsInterface(interfaceClass, recursionCheck);
        }
        return false;
    }

    void checkForOutOfPackageInnerClasses(ConstantPool constantPool, RawClassSymbol outerClass) {
        constantPool.checkForOutOfPackageInnerClass(outerClass, this.bound.getClassSymbol());
        this.bound.checkForOutOfPackageInnerClasses(constantPool, outerClass);
        ClassSymbolList tsl = this.interfaceBounds;
        while (tsl != null) {
            ClassSymbol classSym = tsl.classSymbol;
            constantPool.checkForOutOfPackageInnerClass(outerClass, classSym.getClassSymbol());
            classSym.checkForOutOfPackageInnerClasses(constantPool, outerClass);
            tsl = tsl.next;
        }
    }

    TypeSymbol eraseType() {
        return this.bound.eraseType();
    }

    MethodSymbol[] getMethodTable(Parser parser) {
        if (this.methodTable == null) {
            this.buildMethodTable(parser);
        }
        return this.methodTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean buildMethodTable(Parser parser) {
        try {
            parser.currentClassesBeingResolved.add(this);
            ArrayList methodArrayList = new ArrayList();
            if (this.bound.isParameterizedClass()) {
                this.mergeIntoMethodTable(parser, methodArrayList, (ParameterizedClassSymbol)this.bound);
            }
            ClassSymbolList ibList = this.interfaceBounds;
            while (ibList != null) {
                if (ibList.classSymbol.isParameterizedClass()) {
                    this.mergeIntoMethodTable(parser, methodArrayList, (ParameterizedClassSymbol)ibList.classSymbol);
                }
                ibList = ibList.next;
            }
            this.methodTable = methodArrayList.toArray(new MethodSymbol[methodArrayList.size()]);
            Object var5_4 = null;
            int len = parser.currentClassesBeingResolved.size();
            parser.currentClassesBeingResolved.remove(len - 1);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            int len = parser.currentClassesBeingResolved.size();
            parser.currentClassesBeingResolved.remove(len - 1);
            throw throwable;
        }
        return false;
    }

    void checkBounds(Parser parser, TypeVariableSymbol tvs, TypeParameterList tpl, TypeVariableList tvl) {
        TypeSymbol typeSymbol = tvs.refSymbol;
        int pos = tvs.pos;
        if (!typeSymbol.isErroneous() && typeSymbol.isClass() && parser.currentClassSymbol != null && parser.currentClassSymbol.isCompiled()) {
            RawClassSymbol rawBound;
            ParameterizedClassSymbol boundPcs;
            if (tvs.typeVariableKind == 2 && typeSymbol.isInterface()) {
                return;
            }
            ClassSymbol classSymbol = (ClassSymbol)typeSymbol;
            ParameterizedClassSymbol classPcs = classSymbol.isParameterizedClass() ? (ParameterizedClassSymbol)classSymbol : null;
            RawClassSymbol rawClass = classSymbol.getClassSymbol();
            if (this.bound instanceof UnresolvedClassSymbol) {
                throw new UnresolvedSuperClassException(this.bound);
            }
            ClassSymbol boundSymbol = (ClassSymbol)this.bound.applyTypeVariables(tpl, tvl);
            if (!(classSymbol.equalTo(boundSymbol) || boundSymbol.isSuperclass(classSymbol) || classSymbol.implementsInterface(boundSymbol))) {
                if (!boundSymbol.isParameterizedClass() || classPcs == null) {
                    parser.error(Message.errorTypeParameterOutOfBounds, pos, false, typeSymbol.errorName());
                } else {
                    boundPcs = (ParameterizedClassSymbol)boundSymbol;
                    rawBound = boundPcs.getClassSymbol();
                    if (!(rawClass.equalTo(rawBound) || rawBound.isSuperclass(rawClass) || rawClass.implementsInterface(rawBound))) {
                        parser.error(Message.errorTypeParameterOutOfBounds, pos, false, typeSymbol.errorName());
                    } else {
                        boundPcs.checkBounds(parser, pos, classPcs);
                    }
                }
            }
            ClassSymbolList tsl = this.interfaceBounds;
            while (tsl != null) {
                boundSymbol = tsl.classSymbol;
                if (boundSymbol instanceof UnresolvedClassSymbol) {
                    throw new UnresolvedSuperClassException(boundSymbol);
                }
                if (!classSymbol.equalTo(boundSymbol = (ClassSymbol)boundSymbol.applyTypeVariables(tpl, tvl)) && !classSymbol.implementsInterface(boundSymbol)) {
                    if (!boundSymbol.isParameterizedClass() || classPcs == null) {
                        parser.error(Message.errorTypeParameterOutOfBounds, pos, false, typeSymbol.errorName());
                    } else {
                        boundPcs = (ParameterizedClassSymbol)boundSymbol;
                        rawBound = boundPcs.getClassSymbol();
                        if (!rawClass.equalTo(rawBound) && !rawClass.implementsInterface(rawBound)) {
                            parser.error(Message.errorTypeParameterOutOfBounds, pos, false, typeSymbol.errorName());
                        } else {
                            boundPcs.checkBounds(parser, pos, classPcs);
                        }
                    }
                }
                tsl = tsl.next;
            }
        }
    }

    static {
        $assertionsDisabled = !TypeParameterSymbol.class.desiredAssertionStatus();
    }
}

