/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.SynchronizedStatement;
import oracle.ojc.compiler.TryStatement;

final class TrySyncList {
    TrySyncList outerTrySync;
    TryStatement tryStmt;
    SynchronizedStatement syncStmt;
    ArrayList trySyncExcludeRanges;
    boolean resolvingCatchBlocks;
    static final /* synthetic */ boolean $assertionsDisabled;

    TrySyncList(TrySyncList outerTrySync, TryStatement tryStmt, SynchronizedStatement syncStmt) {
        this.outerTrySync = outerTrySync;
        this.tryStmt = tryStmt;
        this.syncStmt = syncStmt;
    }

    void resolveAndCheck(Parser parser) {
        TrySyncList tsl = this;
        while (tsl != null) {
            if (tsl.syncStmt == null) {
                TryStatement tryStatement = tsl.tryStmt;
                if (!$assertionsDisabled && tryStatement == null) {
                    throw new AssertionError();
                }
                if (tryStatement.finallyBody != null && parser.targetingAtLeastOneFive) {
                    ++tryStatement.finalliesNeeded;
                }
            }
            tsl = tsl.outerTrySync;
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        TrySyncList tsl = this;
        while (tsl != null) {
            TrySyncList tsl2;
            short endPC;
            short startPC;
            if (tsl.syncStmt != null) {
                startPC = byteCodeGenerator.generateGetPC();
                byteCodeGenerator.loadLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, tsl.syncStmt.localVar);
                byteCodeGenerator.generate_8((byte)-61);
                endPC = byteCodeGenerator.generateGetPC();
                byteCodeGenerator.decOpStackHeight(1);
                tsl2 = this;
                while (tsl2 != tsl) {
                    tsl2.addTrySyncExcludeRange(new short[]{startPC, endPC});
                    tsl2 = tsl2.outerTrySync;
                }
            } else {
                TryStatement tryStatement = tsl.tryStmt;
                if (!$assertionsDisabled && tryStatement == null) {
                    throw new AssertionError();
                }
                if (tryStatement.finallyBody != null) {
                    if (!byteCodeGenerator.parser.targetingAtLeastOneFive) {
                        if (tryStatement.finallyLabel == null) {
                            tryStatement.finallyLabel = new Label();
                        }
                        byteCodeGenerator.generateBranch_jsr(tryStatement.finallyLabel);
                    } else if (!tryStatement.generating) {
                        tryStatement.generating = true;
                        startPC = byteCodeGenerator.generateGetPC();
                        tryStatement.finallyBody.generateByteCode(byteCodeGenerator);
                        endPC = byteCodeGenerator.generateGetPC();
                        tsl2 = this;
                        while (tsl2 != tsl.outerTrySync) {
                            tsl2.addTrySyncExcludeRange(new short[]{startPC, endPC});
                            tsl2 = tsl2.outerTrySync;
                        }
                        tryStatement.generating = false;
                    }
                }
            }
            tsl = tsl.outerTrySync;
        }
    }

    void addTrySyncExcludeRange(short[] range) {
        if (this.trySyncExcludeRanges == null) {
            this.trySyncExcludeRanges = new ArrayList(3);
        }
        this.trySyncExcludeRanges.add(range);
    }

    static {
        $assertionsDisabled = !TrySyncList.class.desiredAssertionStatus();
    }
}

