/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CatchDescriptor;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.EndOfScopeStatement;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.LocalVariableSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.TrySyncList;
import oracle.ojc.compiler.TypeSymbol;

final class TryStatement
extends Statement {
    StatementList tryBody;
    CatchDescriptor catchDesc;
    StatementList finallyBody;
    int finallyStartPos;
    int finallyEndPos;
    int finalliesNeeded;
    boolean generating;
    Label finallyLabel;
    BitSet exitPosSet;
    static final /* synthetic */ boolean $assertionsDisabled;

    TryStatement(StatementList parent, int pos, StatementList tryBody, CatchDescriptor catchDesc, StatementList finallyBody, int finallyStartPos, int finallyEndPos) {
        super(parent, pos, (byte)17);
        this.tryBody = tryBody;
        this.catchDesc = catchDesc;
        this.finallyBody = finallyBody;
        this.finallyStartPos = finallyStartPos;
        this.finallyEndPos = finallyEndPos;
        this.finalliesNeeded = 1;
        tryBody.parent = this;
        if (finallyBody != null) {
            finallyBody.parent = this;
        }
        CatchDescriptor cd = catchDesc;
        while (cd != null) {
            cd.catchBody.parent = this;
            cd = cd.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveAndCheck(Parser parser) {
        BitSet afterTryDefSet;
        boolean canReach;
        TrySyncList tryRec;
        TrySyncList outerTrySync = parser.innerTrySync;
        parser.innerTrySync = tryRec = new TrySyncList(outerTrySync, this, null);
        this.exitPosSet = null;
        BitSet beforeTryDefSet = (BitSet)parser.defSet.clone();
        try {
            this.tryBody.resolveAndCheck(parser);
            canReach = this.tryBody.canReachNextStatement(false);
            afterTryDefSet = parser.defSet;
            if (!canReach) {
                afterTryDefSet = null;
            }
            if (this.exitPosSet != null) {
                parser.posSet.or(this.exitPosSet);
            }
            tryRec.resolvingCatchBlocks = true;
            ClassSymbol prevCatchType = null;
            CatchDescriptor cd = this.catchDesc;
            while (cd != null) {
                ++parser.estimatedLineCount;
                parser.defSet = (BitSet)beforeTryDefSet.clone();
                int index = parser.currentClassSymbol.cd.fieldCount + cd.catchVariable.varStackIndex;
                parser.defSet.set(index);
                parser.posSet.set(index);
                TypeSymbol typeSymbol = cd.catchVariable.type;
                byte typeKind = typeSymbol.typeKind;
                if (typeKind != 10) {
                    parser.error(Message.errorIncompatibleTypes, cd.pos, typeSymbol.isErroneous(), typeSymbol.errorName(), parser.javaLangThrowableSymbol.errorName());
                    cd.catchVariable.type = parser.javaLangThrowableSymbol;
                } else {
                    ClassSymbol catchType = (ClassSymbol)typeSymbol.resolveType(parser, cd.pos, false, false, false);
                    if (!catchType.equalTo(parser.javaLangThrowableSymbol) && !parser.javaLangThrowableSymbol.isSuperclass(catchType) || catchType.isTypeParameter()) {
                        parser.error(Message.errorIncompatibleTypes, cd.pos, catchType.isErroneous(), catchType.errorName(), parser.javaLangThrowableSymbol.errorName());
                    }
                    if (!cd.catchesExceptions && parser.javaLangExceptionSymbol.isSuperclass(catchType) && !parser.javaLangRuntimeExceptionSymbol.equalTo(catchType) && !parser.javaLangRuntimeExceptionSymbol.isSuperclass(catchType)) {
                        parser.error(Message.errorExceptionNeverThrown, cd.pos, catchType.isErroneous(), catchType.identifier.toString());
                    } else if (prevCatchType != null && (prevCatchType == catchType || prevCatchType.isSuperclass(catchType))) {
                        parser.error(Message.errorUnreachableCatch, cd.pos, false);
                    } else {
                        prevCatchType = catchType;
                        cd.catchVariable.type = catchType;
                    }
                }
                StatementList catchStatements = cd.catchBody;
                catchStatements.resolveAndCheck(parser);
                if (catchStatements.first == null || parser.options.localVariables && catchStatements.first == catchStatements.last && catchStatements.first instanceof EndOfScopeStatement) {
                    parser.warning(null, Message.warningEmptyCatchStatement, cd.pos);
                }
                if (catchStatements.canReachNextStatement(true)) {
                    canReach = true;
                    if (afterTryDefSet == null) {
                        afterTryDefSet = parser.defSet;
                    } else {
                        afterTryDefSet.and(parser.defSet);
                    }
                }
                cd = cd.next;
            }
            Object var17_14 = null;
            parser.innerTrySync = outerTrySync;
        }
        catch (Throwable throwable) {
            Object var17_15 = null;
            parser.innerTrySync = outerTrySync;
            throw throwable;
        }
        StatementList finallyStatements = this.finallyBody;
        if (finallyStatements != null) {
            parser.defSet = (BitSet)beforeTryDefSet.clone();
            parser.estimatedLineCount += 2;
            int estimatedLineCount = parser.estimatedLineCount;
            finallyStatements.resolveAndCheck(parser);
            if (parser.targetingAtLeastOneFive) {
                estimatedLineCount = parser.estimatedLineCount - estimatedLineCount;
                parser.estimatedLineCount += (estimatedLineCount *= this.finalliesNeeded);
            }
            if (canReach && !(canReach = finallyStatements.canReachNextStatement(false))) {
                parser.warning(null, Message.warningUnterminatedFinally, finallyStatements.first.pos);
            }
            if (afterTryDefSet != null) {
                if (!canReach) {
                    parser.defSet = (BitSet)beforeTryDefSet.clone();
                } else {
                    parser.defSet.or(afterTryDefSet);
                }
            }
        } else {
            parser.defSet = afterTryDefSet == null ? beforeTryDefSet : afterTryDefSet;
        }
        if (this.catchDesc == null && finallyStatements == null) {
            parser.error(Message.errorTryWithoutCatch, this.pos, false);
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
        if (this.next != null && this.next.isCodeStatement() && !this.canReachNextStatement(false)) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    private boolean catches(Parser parser, ClassSymbol thrownClass) {
        CatchDescriptor cd = this.catchDesc;
        while (cd != null) {
            TypeSymbol typeSymbol = cd.catchVariable.type;
            if (typeSymbol.isErroneous() || thrownClass.isAssignmentCompatible(parser, (ClassSymbol)typeSymbol)) {
                return true;
            }
            cd = cd.next;
        }
        return false;
    }

    void updateDefUseSetsAfterReturn(Parser parser) {
        if (this.exitPosSet == null) {
            this.exitPosSet = (BitSet)parser.posSet.clone();
        } else {
            this.exitPosSet.or(parser.posSet);
        }
        this.parent.updateDefUseSetsAfterReturn(parser);
    }

    void updateDefUseSetsAfterThrow(Parser parser, ClassSymbol thrownClass) {
        if (this.exitPosSet == null) {
            this.exitPosSet = (BitSet)parser.posSet.clone();
        } else {
            this.exitPosSet.or(parser.posSet);
        }
        if (!this.catches(parser, thrownClass)) {
            this.parent.updateDefUseSetsAfterThrow(parser, thrownClass);
        }
    }

    void updateDefUseSetsAfterBreak(Parser parser, LabelSymbol labelSymbol) {
        if (this.exitPosSet == null) {
            this.exitPosSet = (BitSet)parser.posSet.clone();
        } else {
            this.exitPosSet.or(parser.posSet);
        }
        this.parent.updateDefUseSetsAfterBreak(parser, labelSymbol);
    }

    void updateDefUseSetsAfterContinue(Parser parser, LabelSymbol labelSymbol) {
        if (this.exitPosSet == null) {
            this.exitPosSet = (BitSet)parser.posSet.clone();
        } else {
            this.exitPosSet.or(parser.posSet);
        }
        this.parent.updateDefUseSetsAfterContinue(parser, labelSymbol);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        TrySyncList tryRec;
        TrySyncList outerTrySync = byteCodeGenerator.parser.innerTrySync;
        byteCodeGenerator.parser.innerTrySync = tryRec = new TrySyncList(outerTrySync, this, null);
        short startPC = byteCodeGenerator.generateGetPC();
        this.tryBody.generateByteCode(byteCodeGenerator);
        short endPC = byteCodeGenerator.generateGetPC();
        boolean finallyCanReachNext = true;
        StatementList finallyStatements = this.finallyBody;
        if (finallyStatements != null) {
            finallyCanReachNext = finallyStatements.canReachNextStatement(false);
        }
        if (startPC == endPC) {
            byteCodeGenerator.parser.innerTrySync = outerTrySync;
            if (finallyStatements != null) {
                finallyStatements.generateByteCode(byteCodeGenerator);
            }
        } else if (!byteCodeGenerator.parser.targetingAtLeastOneFive) {
            short handlerPC;
            boolean canReachNext;
            Label continueLabel = new Label();
            if (finallyStatements != null && this.finallyLabel == null) {
                this.finallyLabel = new Label();
            }
            if (canReachNext = this.tryBody.canReachNextStatement(false)) {
                if (finallyStatements != null) {
                    byteCodeGenerator.generateBranch_jsr(this.finallyLabel);
                    if (finallyCanReachNext) {
                        byteCodeGenerator.generateBranch_goto(continueLabel);
                    }
                } else {
                    byteCodeGenerator.generateBranch_goto(continueLabel);
                }
            }
            CatchDescriptor cd = this.catchDesc;
            while (cd != null) {
                handlerPC = byteCodeGenerator.generateGetPC();
                TypeSymbol catchType = null;
                StatementList catchStatements = cd.catchBody;
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(cd.pos));
                byteCodeGenerator.setOpStackHeight(1);
                if (catchStatements == null) {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                } else {
                    LocalVariableSymbol catchVar = cd.catchVariable;
                    catchType = catchVar.type;
                    byteCodeGenerator.storeLocalVariable(catchType, catchVar.varStackIndex);
                    catchVar.startPC = catchVar.endPC = byteCodeGenerator.generateGetPC();
                    catchStatements.generateByteCode(byteCodeGenerator);
                }
                short index = 0;
                if (catchType != null) {
                    index = byteCodeGenerator.constantPool.enterConstantPoolClass(catchType.getInternalName());
                }
                byteCodeGenerator.generateExceptionHandler(startPC, endPC, handlerPC, index);
                if (catchStatements == null || catchStatements.canReachNextStatement(false)) {
                    if (this.finallyLabel != null) {
                        byteCodeGenerator.generateBranch_jsr(this.finallyLabel);
                    }
                    if (cd.next == null && this.finallyLabel == null) break;
                    if (finallyCanReachNext) {
                        byteCodeGenerator.generateBranch_goto(continueLabel);
                    }
                }
                cd = cd.next;
            }
            byteCodeGenerator.parser.innerTrySync = outerTrySync;
            if (this.finallyLabel != null) {
                endPC = handlerPC = byteCodeGenerator.generateGetPC();
                byteCodeGenerator.setOpStackHeight(1);
                byteCodeGenerator.generateExceptionHandler(startPC, endPC, handlerPC, (short)0);
                short s = byteCodeGenerator.methodSymbol.localVarCount;
                byteCodeGenerator.methodSymbol.localVarCount = (short)(s + 1);
                short localVar = s;
                byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
                byteCodeGenerator.storeLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, localVar);
                byteCodeGenerator.generateBranch_jsr(this.finallyLabel);
                byteCodeGenerator.loadLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, localVar);
                byteCodeGenerator.generate_8((byte)-65);
                byteCodeGenerator.setOpStackHeight(1);
                byteCodeGenerator.setLabel(this.finallyLabel);
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.finallyStartPos));
                short s2 = byteCodeGenerator.methodSymbol.localVarCount;
                byteCodeGenerator.methodSymbol.localVarCount = (short)(s2 + 1);
                localVar = s2;
                byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
                byteCodeGenerator.storeLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, localVar);
                finallyStatements.generateByteCode(byteCodeGenerator);
                if (finallyCanReachNext) {
                    byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.finallyEndPos));
                    if (localVar > 255) {
                        byteCodeGenerator.generate_8_8_16((byte)-60, (byte)-87, localVar);
                    } else {
                        byteCodeGenerator.generate_8_8((byte)-87, (byte)localVar);
                    }
                }
            }
            byteCodeGenerator.setLabel(continueLabel);
        } else {
            short handlerPC;
            Label continueLabel = new Label();
            boolean canReachNext = this.tryBody.canReachNextStatement(false);
            if (canReachNext) {
                if (finallyStatements != null) {
                    byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.finallyEndPos));
                }
                byteCodeGenerator.generateBranch_goto(continueLabel);
            }
            CatchDescriptor cd = this.catchDesc;
            while (cd != null) {
                handlerPC = byteCodeGenerator.generateGetPC();
                TypeSymbol catchType = null;
                StatementList catchStatements = cd.catchBody;
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(cd.pos));
                byteCodeGenerator.setOpStackHeight(1);
                if (catchStatements == null) {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                } else {
                    LocalVariableSymbol catchVar = cd.catchVariable;
                    catchType = catchVar.type;
                    byteCodeGenerator.storeLocalVariable(catchType, catchVar.varStackIndex);
                    catchVar.startPC = catchVar.endPC = byteCodeGenerator.generateGetPC();
                    catchStatements.generateByteCode(byteCodeGenerator);
                }
                if (startPC != endPC) {
                    short index = 0;
                    if (catchType != null) {
                        index = byteCodeGenerator.constantPool.enterConstantPoolClass(catchType.getInternalName());
                    }
                    this.generateExceptionHandlers(byteCodeGenerator, startPC, endPC, handlerPC, tryRec, index);
                }
                if (!(catchStatements != null && !catchStatements.canReachNextStatement(false) || cd.next == null && finallyStatements == null)) {
                    canReachNext = true;
                    byteCodeGenerator.generateBranch_goto(continueLabel);
                }
                cd = cd.next;
            }
            byteCodeGenerator.parser.innerTrySync = outerTrySync;
            if (finallyStatements != null) {
                endPC = handlerPC = byteCodeGenerator.generateGetPC();
                byteCodeGenerator.setOpStackHeight(1);
                this.generateExceptionHandlers(byteCodeGenerator, startPC, endPC, handlerPC, tryRec, (short)0);
                short s = byteCodeGenerator.methodSymbol.localVarCount;
                byteCodeGenerator.methodSymbol.localVarCount = (short)(s + 1);
                short localVar = s;
                byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.finallyStartPos));
                byteCodeGenerator.storeLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, localVar);
                finallyStatements.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.finallyEndPos));
                byteCodeGenerator.loadLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, localVar);
                byteCodeGenerator.generate_8((byte)-65);
                byteCodeGenerator.decOpStackHeight(1);
            }
            byteCodeGenerator.setLabel(continueLabel);
            if (finallyStatements != null && canReachNext) {
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.finallyStartPos));
                finallyStatements.generateByteCode(byteCodeGenerator);
                if (finallyStatements.canReachNextStatement(true)) {
                    byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.finallyEndPos));
                }
            }
        }
    }

    boolean canReachNextStatement(boolean strict) {
        if (this.finallyBody != null && !this.finallyBody.canReachNextStatement(strict)) {
            return false;
        }
        boolean canReach = this.tryBody.canReachNextStatement(strict);
        CatchDescriptor cd = this.catchDesc;
        while (cd != null) {
            if (cd.catchBody != null) {
                canReach |= cd.catchBody.canReachNextStatement(strict);
            }
            cd = cd.next;
        }
        return canReach;
    }

    static boolean catchesType(Parser parser, ClassSymbol classSymbol) {
        boolean exceptionCaught = false;
        ReferenceTypeSymbol catchingType = null;
        TrySyncList tsl = parser.innerTrySync;
        while (tsl != null && tsl.resolvingCatchBlocks) {
            tsl = tsl.outerTrySync;
        }
        while (tsl != null) {
            if (tsl.syncStmt == null) {
                TryStatement tryStatement = tsl.tryStmt;
                if (!$assertionsDisabled && tryStatement == null) {
                    throw new AssertionError();
                }
                CatchDescriptor cd = tryStatement.catchDesc;
                while (cd != null) {
                    TypeSymbol typeSymbol = cd.catchVariable.type.resolveType(parser, cd.pos, false, false, false);
                    if (typeSymbol.isErroneous()) {
                        cd.catchesExceptions = true;
                    } else {
                        ClassSymbol catchType = (ClassSymbol)typeSymbol;
                        if (classSymbol.isAssignmentCompatible(parser, catchType)) {
                            if (catchingType == null) {
                                cd.catchesExceptions = true;
                                exceptionCaught = true;
                                catchingType = catchType;
                            } else if (catchingType.isAssignmentCompatible(parser, catchType)) {
                                cd.catchesExceptions = true;
                                catchingType = catchType;
                            }
                        } else if (catchType.isAssignmentCompatible(parser, classSymbol)) {
                            cd.catchesExceptions = true;
                        }
                    }
                    cd = cd.next;
                }
            }
            if (exceptionCaught) {
                return true;
            }
            tsl = tsl.outerTrySync;
        }
        return false;
    }

    static {
        $assertionsDisabled = !TryStatement.class.desiredAssertionStatus();
    }
}

