/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.NullConstantExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.TrySyncList;
import oracle.ojc.compiler.TypeSymbol;

final class SynchronizedStatement
extends Statement {
    Expression syncExpr;
    StatementList bodyStatements;
    int endPos;
    short localVar;

    SynchronizedStatement(StatementList parent, int pos, int endPos, Expression syncExpr, StatementList bodyStatements) {
        super(parent, pos, (byte)15);
        this.syncExpr = syncExpr;
        this.bodyStatements = bodyStatements;
        this.endPos = endPos;
        bodyStatements.parent = this;
    }

    void resolveAndCheck(Parser parser) {
        Expression expr = this.syncExpr;
        expr = expr.resolveAndCheck(parser);
        TypeSymbol exprType = expr.getType();
        byte typeClass = exprType.typeClass;
        if ((typeClass & 0xFFFFFFC0) == 0) {
            parser.error(Message.errorIncompatibleTypes, expr.pos, exprType.isErroneous(), exprType.errorName(), parser.javaLangObjectSymbol.errorName());
        } else if (expr instanceof NullConstantExpression) {
            parser.error(Message.errorCannotSynchronizedNull, expr.pos, false);
        }
        this.syncExpr = expr;
        this.bodyStatements.resolveAndCheck(parser);
        parser.estimatedLineCount += 2;
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
        if (this.next != null && this.next.isCodeStatement() && !this.canReachNextStatement(false)) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        TrySyncList syncRec;
        Expression expr = this.syncExpr;
        expr.generateByteCode(byteCodeGenerator);
        byteCodeGenerator.generate_8((byte)89);
        byteCodeGenerator.incOpStackHeight(1);
        short s = byteCodeGenerator.methodSymbol.localVarCount;
        byteCodeGenerator.methodSymbol.localVarCount = (short)(s + 1);
        this.localVar = s;
        byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
        TypeSymbol exprType = expr.getType();
        byteCodeGenerator.storeLocalVariable(exprType, this.localVar);
        byteCodeGenerator.generate_8((byte)-62);
        byteCodeGenerator.decOpStackHeight(1);
        short startPC = byteCodeGenerator.generateGetPC();
        TrySyncList outerTrySync = byteCodeGenerator.parser.innerTrySync;
        byteCodeGenerator.parser.innerTrySync = syncRec = new TrySyncList(outerTrySync, null, this);
        this.bodyStatements.generateByteCode(byteCodeGenerator);
        byteCodeGenerator.parser.innerTrySync = outerTrySync;
        short endPC = byteCodeGenerator.generateGetPC();
        Label continueLabel = new Label();
        if (this.bodyStatements.canReachNextStatement(false)) {
            byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.endPos));
            byteCodeGenerator.loadLocalVariable(exprType, this.localVar);
            byteCodeGenerator.generate_8((byte)-61);
            byteCodeGenerator.decOpStackHeight(1);
            endPC = byteCodeGenerator.generateGetPC();
            byteCodeGenerator.generateBranch_goto(continueLabel);
        }
        short handlerPC = byteCodeGenerator.generateGetPC();
        if (startPC != endPC) {
            this.generateExceptionHandlers(byteCodeGenerator, startPC, endPC, handlerPC, syncRec, (short)0);
        }
        byteCodeGenerator.setOpStackHeight(1);
        byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.endPos));
        byteCodeGenerator.loadLocalVariable(exprType, this.localVar);
        byteCodeGenerator.generate_8((byte)-61);
        byteCodeGenerator.decOpStackHeight(1);
        endPC = byteCodeGenerator.generateGetPC();
        byteCodeGenerator.generateExceptionHandler(handlerPC, endPC, handlerPC, (short)0);
        byteCodeGenerator.generate_8((byte)-65);
        byteCodeGenerator.decOpStackHeight(1);
        byteCodeGenerator.setLabel(continueLabel);
    }

    boolean canReachNextStatement(boolean strict) {
        return this.bodyStatements.canReachNextStatement(strict);
    }
}

