/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.ImportDescriptor;
import oracle.ojc.compiler.ImportSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeSymbolList;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedStaticImportList;
import oracle.ojc.compiler.UnresolvedSuperClassException;
import oracle.ojc.interfaces.Log2;
import oracle.ojc.interfaces.Storage;

final class SourceFile {
    Storage storage;
    String canonicalPath;
    File preprocessorFile;
    ArrayList messageList;
    PackageScope packageScope;
    ImportDescriptor importList;
    Symbol[] importDeclarations;
    UnresolvedStaticImportList usil;
    boolean deprecatedWarningFound;
    RawClassSymbol topLevelClass;

    SourceFile(Storage storage) {
        this.storage = storage;
        this.messageList = new ArrayList();
    }

    String getName() {
        if (this.preprocessorFile != null) {
            return this.preprocessorFile.getName();
        }
        return this.storage.getName();
    }

    String getPath() {
        if (this.preprocessorFile != null) {
            return this.preprocessorFile.getPath();
        }
        return this.storage.getPath();
    }

    String getCanonicalPath() {
        if (this.canonicalPath == null) {
            if (this.preprocessorFile != null) {
                try {
                    this.canonicalPath = this.preprocessorFile.getCanonicalPath();
                }
                catch (IOException iOException) {}
            } else {
                this.canonicalPath = this.storage.getCanonicalPath();
            }
        }
        return this.canonicalPath;
    }

    private void addImportSymbol(Parser parser, ImportDescriptor importDesc, Symbol symbol, boolean onDemandImport) {
        ImportSymbol importSymbol = parser.currentPackageScope.lookupImportSymbol(symbol.identifier, symbol.kind);
        if (importSymbol != null) {
            if (importSymbol.importedSymbol == symbol) {
                if (importDesc.pos != importSymbol.pos) {
                    parser.warning(null, Message.warningDuplicateImport, importDesc.pos, symbol.errorName());
                }
                return;
            }
            if ((importSymbol.flags & 4) == 0 && !onDemandImport) {
                if (symbol.kind != 8) {
                    if (importDesc.importSymbolList.contains(importSymbol)) {
                        return;
                    }
                    parser.error(Message.errorDoubleImport, importDesc.pos, false, symbol.errorName());
                    return;
                }
            } else if (importSymbol.importedSymbol.kind == 2 && symbol.kind == 2 && importDesc.importSymbolList.contains(importSymbol)) {
                return;
            }
        }
        importSymbol = new ImportSymbol(importDesc.pos, symbol, importDesc);
        importSymbol.flags = !onDemandImport ? (byte)(importSymbol.flags | 3) : (symbol.kind == 32 && ((ClassSymbol)symbol).isInnerClass() ? (byte)(importSymbol.flags | 0xB) : (byte)(importSymbol.flags | 7));
        importDesc.importSymbolList.add(importSymbol);
        this.packageScope.enterSymbol(importSymbol);
    }

    private static boolean isImportable(Parser parser, Scope scope, RawClassSymbol classSymbol, short access) {
        if ((access & 8) == 0) {
            return false;
        }
        if ((access & 1) == 0) {
            return scope == parser.currentPackageScope;
        }
        if (classSymbol != null) {
            while (true) {
                if ((classSymbol.access & 1) == 0) {
                    return scope == parser.currentPackageScope;
                }
                if (!classSymbol.isInnerClass()) break;
                classSymbol = classSymbol.getOuterClass();
            }
        }
        return true;
    }

    private boolean importStaticSymbol(Parser parser, UnresolvedStaticImportList usil, ClassSymbol clsSym) {
        FieldSymbol fieldSymbol;
        MethodSymbol methodSymbol;
        if (clsSym instanceof UnresolvedClassSymbol) {
            throw new UnresolvedSuperClassException(clsSym);
        }
        boolean found = false;
        RawClassSymbol classSymbol = clsSym.getClassSymbol();
        Scope packageScope = classSymbol.getPackageScope();
        if (usil.identifier == null) {
            found = true;
            methodSymbol = classSymbol.cd.methodList;
            while (methodSymbol != null) {
                if (SourceFile.isImportable(parser, packageScope, classSymbol, methodSymbol.access) && !methodSymbol.isSynthetic() && !methodSymbol.isGenerated() && !methodSymbol.isClassInitializer()) {
                    this.addImportSymbol(parser, usil.importDesc, methodSymbol, true);
                }
                methodSymbol = methodSymbol.nextInClass;
            }
            fieldSymbol = classSymbol.cd.fieldList;
            while (fieldSymbol != null) {
                if (SourceFile.isImportable(parser, packageScope, classSymbol, fieldSymbol.access) && !fieldSymbol.isSynthetic()) {
                    this.addImportSymbol(parser, usil.importDesc, fieldSymbol, true);
                }
                fieldSymbol = fieldSymbol.nextInClass;
            }
            TypeSymbolList innerClassList = classSymbol.cd.innerClassList;
            while (innerClassList != null) {
                TypeSymbol innerClass = innerClassList.typeSymbol;
                if ((innerClass.isStaticInnerClass() || innerClass.isInterface()) && ((innerClass.access & 1) != 0 || packageScope == parser.currentPackageScope)) {
                    this.addImportSymbol(parser, usil.importDesc, innerClassList.typeSymbol, true);
                }
                innerClassList = innerClassList.next;
            }
        } else {
            TypeSymbol typeSymbol;
            Symbol symbol = classSymbol.classScope.lookupSpecificSymbolInScope(usil.identifier, 2, true);
            if (symbol != null) {
                fieldSymbol = (FieldSymbol)symbol;
                if (SourceFile.isImportable(parser, packageScope, classSymbol, fieldSymbol.access)) {
                    found = true;
                    this.addImportSymbol(parser, usil.importDesc, fieldSymbol, false);
                }
            }
            if ((symbol = classSymbol.classScope.lookupSpecificSymbolInScope(usil.identifier, 8, true)) != null) {
                methodSymbol = (MethodSymbol)symbol;
                symbol = null;
                while (methodSymbol != null) {
                    if (SourceFile.isImportable(parser, packageScope, classSymbol, methodSymbol.access)) {
                        found = true;
                        this.addImportSymbol(parser, usil.importDesc, methodSymbol, false);
                    }
                    methodSymbol = methodSymbol.nextWithSameName;
                }
            }
            if ((symbol = classSymbol.classScope.lookupSpecificSymbolInScope(usil.identifier, 32, true)) != null && (((typeSymbol = (TypeSymbol)symbol).isStaticInnerClass() || typeSymbol.isInterface()) && (typeSymbol.access & 1) != 0 || packageScope == parser.currentPackageScope)) {
                found = true;
                this.addImportSymbol(parser, usil.importDesc, typeSymbol, false);
            }
        }
        ImplementationList implList = clsSym.getImplementationList();
        while (implList != null) {
            found |= this.importStaticSymbol(parser, usil, implList.interfaceSymbol);
            implList = implList.next;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void resolveStaticImports(Parser parser) {
        parser.currentPackageScope.enterDeclarations(parser.sourceFile.importDeclarations);
        ArrayList fileImportList = new ArrayList();
        parser.currentPackageScope.recordDeclarations(fileImportList);
        try {
            UnresolvedStaticImportList usil = this.usil;
            while (usil != null) {
                if (usil.unresolvedClass.qualifierList == null) {
                    parser.error(Message.errorNotFound, usil.importDesc.pos, false, usil.unresolvedClass.toString(), "");
                } else {
                    TypeSymbol typeSymbol = usil.unresolvedClass.resolveType(parser, usil.importDesc.pos, true, true, false);
                    if (!typeSymbol.isErroneous()) {
                        if (!typeSymbol.toString().equals(usil.unresolvedClass.toString())) {
                            parser.error(Message.errorNonCanonicalImport, usil.importDesc.pos, false, usil.unresolvedClass.toString());
                        } else {
                            boolean found = false;
                            for (ClassSymbol clsSym = (ClassSymbol)typeSymbol; clsSym != null; found |= this.importStaticSymbol(parser, usil, clsSym), clsSym = clsSym.getSuperClassSymbol()) {
                            }
                            if (!found) {
                                parser.error(Message.errorNotFound, usil.importDesc.pos, typeSymbol.isErroneous(), Message.memberString + " " + usil.identifier.toString(), Message.inString + " " + typeSymbol.errorName());
                            }
                        }
                    }
                }
                usil = usil.next;
            }
            Object var11_7 = null;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            parser.currentPackageScope.recordDeclarations(null);
            int size = fileImportList.size();
            if (size <= 0) {
                parser.currentPackageScope.removeDeclarations(parser.sourceFile.importDeclarations);
                throw throwable;
            }
            int length = 0;
            if (parser.sourceFile.importDeclarations != null) {
                length = parser.sourceFile.importDeclarations.length;
            }
            Symbol[] fileImportArray = fileImportList.toArray(new Symbol[size + length]);
            if (length > 0) {
                System.arraycopy(parser.sourceFile.importDeclarations, 0, fileImportArray, size, length);
            }
            parser.currentPackageScope.removeDeclarations(fileImportArray);
            parser.sourceFile.importDeclarations = fileImportArray;
            throw throwable;
        }
        parser.currentPackageScope.recordDeclarations(null);
        int size = fileImportList.size();
        if (size > 0) {
            int length = 0;
            if (parser.sourceFile.importDeclarations != null) {
                length = parser.sourceFile.importDeclarations.length;
            }
            Symbol[] fileImportArray = fileImportList.toArray(new Symbol[size + length]);
            if (length > 0) {
                System.arraycopy(parser.sourceFile.importDeclarations, 0, fileImportArray, size, length);
            }
            parser.currentPackageScope.removeDeclarations(fileImportArray);
            parser.sourceFile.importDeclarations = fileImportArray;
        } else {
            parser.currentPackageScope.removeDeclarations(parser.sourceFile.importDeclarations);
        }
        this.usil = null;
    }

    boolean printMessages(Parser parser, Log2 log) {
        int count = this.messageList.size();
        if (count == 0) {
            return true;
        }
        Message[] messages = this.messageList.toArray(new Message[count]);
        this.messageList = null;
        int i = count;
        while (--i >= 0) {
            for (int j = 0; j < i; ++j) {
                Message message1 = messages[j];
                Message message2 = messages[j + 1];
                if (message1.pos <= message2.pos) continue;
                messages[j] = message2;
                messages[j + 1] = message1;
            }
        }
        Message prevMessage = new Error(null, Message.errorCannotCopy, 0);
        for (i = 0; i < count; ++i) {
            Message message = messages[i];
            if (message.pos != prevMessage.pos || message.message.getNumber() != prevMessage.message.getNumber() || !message.message.getMessage().equals(prevMessage.message.getMessage())) {
                if (message instanceof Error || parser.options.warningsAreErrors) {
                    log.printError(this.storage, message.pos, message.message);
                    ++parser.errorCount;
                } else if (!parser.errorFound) {
                    log.printWarning(this.storage, message.pos, message.message);
                    ++parser.warningCount;
                }
                if (parser.errorCount + parser.warningCount > parser.options.messageLimit || parser.errorCount > parser.options.errorLimit || parser.warningCount > parser.options.warningLimit) {
                    log.printError(Message.tooManyErrorsAndWarningsString);
                    return false;
                }
            }
            prevMessage = message;
        }
        return true;
    }
}

