/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedSymbol;

abstract class Scope {
    static final byte SC_GLOBAL = 0;
    static final byte SC_PACKAGE = 1;
    static final byte SC_CLASS = 2;
    static final byte SC_METHOD = 3;
    static final byte SC_BLOCK = 4;
    byte kind;
    ArrayList declList;
    Parser parser;
    int symbolCount;
    Object symbolTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    Scope(byte kind, int size, Parser parser) {
        this.kind = kind;
        this.parser = parser;
        if (size > 0) {
            this.symbolTable = new Symbol[size];
        }
    }

    final ArrayList recordDeclarations(ArrayList declList) {
        ArrayList oldDeclList = this.declList;
        this.declList = declList;
        return oldDeclList;
    }

    final void enterDeclarations(Symbol[] declList) {
        if (declList != null) {
            int size = declList.length;
            for (int i = 0; i < size; ++i) {
                this.enterSymbol(declList[i]);
            }
        }
    }

    final void removeDeclarations(Symbol[] declList) {
        if (declList != null) {
            int size = declList.length;
            for (int i = 0; i < size; ++i) {
                this.removeSymbol(declList[i]);
            }
        }
    }

    void removeSymbol(Symbol symbol) {
        Symbol[] symbolTable = (Symbol[])this.symbolTable;
        int hash = symbol.identifier.hashCode() & symbolTable.length - 1;
        Symbol sym = symbolTable[hash];
        if (sym == symbol) {
            symbolTable[hash] = symbol.nextHashed;
        } else {
            while (true) {
                Symbol nsym = sym.nextHashed;
                if (!$assertionsDisabled && nsym == null) {
                    throw new AssertionError();
                }
                if (nsym == symbol) {
                    sym.nextHashed = symbol.nextHashed;
                    break;
                }
                sym = nsym;
            }
        }
        --this.symbolCount;
    }

    private final int rehash() {
        Symbol[] oldSymbolTable = (Symbol[])this.symbolTable;
        int oldLength = oldSymbolTable.length;
        int cnt = this.symbolCount;
        int newLength = oldLength << 1;
        Symbol[] newSymbolTable = new Symbol[newLength];
        for (int i = 0; i < oldLength; ++i) {
            Symbol nsym;
            Symbol sym = oldSymbolTable[i];
            if (sym == null) continue;
            do {
                --cnt;
                nsym = sym.nextHashed;
                int hash = sym.identifier.hashCode() & newLength - 1;
                sym.nextHashed = newSymbolTable[hash];
                newSymbolTable[hash] = sym;
            } while ((sym = nsym) != null);
            if (cnt == 0) break;
        }
        this.symbolTable = newSymbolTable;
        return newLength;
    }

    void enterSymbol(Symbol symbol) {
        if (!$assertionsDisabled && (symbol instanceof UnresolvedSymbol || symbol instanceof UnresolvedClassSymbol)) {
            throw new AssertionError();
        }
        int count = this.symbolCount;
        Symbol[] symbolTable = (Symbol[])this.symbolTable;
        int length = symbolTable.length;
        if (count > length - (length >> 2)) {
            length = this.rehash();
            symbolTable = (Symbol[])this.symbolTable;
        }
        this.symbolCount = count + 1;
        int hash = symbol.identifier.hashCode() & length - 1;
        symbol.scope = this;
        symbol.nextHashed = symbolTable[hash];
        symbolTable[hash] = symbol;
        if (this.declList != null && (this.kind > 1 || (symbol.kind & 4) != 0) && (symbol.kind & 0xFFFFFF80) == 0) {
            this.declList.add(symbol);
        }
    }

    Symbol lookupSymbolInScope(Identifier identifier, boolean ignoreImports) {
        Symbol[] symbolTable = (Symbol[])this.symbolTable;
        int hash = identifier.hashCode() & symbolTable.length - 1;
        Symbol symbol = symbolTable[hash];
        while (symbol != null) {
            if (!(identifier != symbol.identifier || ignoreImports && (symbol.kind & 4) != 0)) {
                return symbol;
            }
            symbol = symbol.nextHashed;
        }
        return null;
    }

    Symbol lookupSpecificSymbolInScope(Identifier identifier, int symbolKind, boolean ignoreImports) {
        Symbol[] symbolTable = (Symbol[])this.symbolTable;
        int hash = identifier.hashCode() & symbolTable.length - 1;
        Symbol symbol = symbolTable[hash];
        while (symbol != null) {
            if (!((symbol.kind & symbolKind) == 0 || identifier != symbol.identifier || ignoreImports && (symbol.kind & 4) != 0)) {
                return symbol;
            }
            symbol = symbol.nextHashed;
        }
        return null;
    }

    Symbol[] getSymbols() {
        ArrayList<Symbol> declList = new ArrayList<Symbol>();
        Symbol[] symbolTable = (Symbol[])this.symbolTable;
        for (int i = 0; i < symbolTable.length; ++i) {
            Symbol symbol = symbolTable[i];
            while (symbol != null) {
                declList.add(symbol);
                symbol = symbol.nextHashed;
            }
        }
        return declList.toArray(new Symbol[declList.size()]);
    }

    abstract Symbol lookupSymbol(Identifier var1, boolean var2);

    abstract Symbol lookupSpecificSymbol(Identifier var1, int var2, boolean var3);

    abstract String errorName();

    abstract boolean isSubScopeOf(Scope var1);

    abstract Scope getOuterScope();

    static {
        $assertionsDisabled = !Scope.class.desiredAssertionStatus();
    }
}

