/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.Hashtable;
import java.util.Iterator;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;

class ReferenceTypeSymbol
extends TypeSymbol {
    static ReferenceTypeSymbol nullTypeSymbol;
    static final /* synthetic */ boolean $assertionsDisabled;

    ReferenceTypeSymbol(int pos, Identifier identifier, byte kind, short access, Annotation annotation) {
        super(pos, identifier, kind, access, annotation);
    }

    char[] getSignature() {
        if (this == nullTypeSymbol) {
            return Identifier.javaLangObjectSignature.name;
        }
        return super.getSignature();
    }

    boolean isReferenceType() {
        return true;
    }

    static void initializeStatics() {
        nullTypeSymbol = new ReferenceTypeSymbol(0, Identifier.getIdentifier("null"), 10, 1, null);
    }

    static void releaseStatics() {
        nullTypeSymbol = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAssignmentCompatible(Parser parser, ReferenceTypeSymbol targetType) {
        boolean saveDoMethodTypeParameterConversion = ClassSymbol.doMethodTypeParameterConversion;
        ClassSymbol.doMethodTypeParameterConversion = false;
        try {
            if (this.isArrayType() && targetType.isArrayType()) {
                ArraySymbol sourceArray = (ArraySymbol)this;
                ArraySymbol targetArray = (ArraySymbol)targetType;
                TypeSymbol sourceBaseType = ArraySymbol.getArrayType(sourceArray.baseType, sourceArray.dimension - 1);
                TypeSymbol targetBaseType = ArraySymbol.getArrayType(targetArray.baseType, targetArray.dimension - 1);
                if (sourceBaseType.isPrimitiveType() || targetBaseType.isPrimitiveType()) {
                    boolean bl = sourceBaseType == targetBaseType;
                    return bl;
                }
                boolean bl = ((ReferenceTypeSymbol)sourceBaseType).isAssignmentCompatible(parser, (ReferenceTypeSymbol)targetBaseType);
                return bl;
            }
            if (this.equalTo(targetType)) {
                boolean bl = true;
                return bl;
            }
            if (this == nullTypeSymbol || targetType == nullTypeSymbol) {
                boolean bl = true;
                return bl;
            }
            if (targetType.isTypeParameter()) {
                boolean bl = false;
                return bl;
            }
            if (this.isTypeParameter()) {
                boolean bl = ((TypeParameterSymbol)this).bound.isAssignmentCompatible(parser, targetType);
                return bl;
            }
            if (this.isClass()) {
                ClassSymbol sourceClass = (ClassSymbol)this;
                if (!sourceClass.isInterface()) {
                    if (targetType.isClass()) {
                        ClassSymbol targetClass = (ClassSymbol)targetType;
                        if (!targetClass.isInterface()) {
                            boolean bl = targetClass.isSuperclass(sourceClass);
                            return bl;
                        }
                        boolean bl = sourceClass.implementsInterface(targetClass);
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                if (targetType.isClass()) {
                    ClassSymbol targetClass = (ClassSymbol)targetType;
                    if (!targetClass.isInterface()) {
                        boolean bl = targetClass.equalTo(parser.javaLangObjectSymbol);
                        return bl;
                    }
                    boolean bl = sourceClass.implementsInterface(targetClass);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (targetType.isClass()) {
                ClassSymbol targetClass = (ClassSymbol)targetType;
                if (!targetClass.isInterface()) {
                    boolean bl = targetClass.equalTo(parser.javaLangObjectSymbol);
                    return bl;
                }
                boolean bl = parser.javaLangCloneableSymbol != null && targetClass.equalTo(parser.javaLangCloneableSymbol) || parser.javaIoSerializableSymbol != null && targetClass.equalTo(parser.javaIoSerializableSymbol);
                return bl;
            }
        }
        finally {
            ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
        }
        return false;
    }

    boolean isReturnSubstitutable(Parser parser, ReferenceTypeSymbol otherType) {
        ReferenceTypeSymbol thisType = this;
        if (thisType.isTypeParameter() && !otherType.isTypeParameter()) {
            thisType = (ReferenceTypeSymbol)thisType.eraseType();
        }
        if (otherType.equalTo(thisType)) {
            return true;
        }
        if (this.isClass()) {
            ClassSymbol thisClass = (ClassSymbol)thisType;
            if (!thisClass.isInterface()) {
                if (otherType.isClass()) {
                    ClassSymbol otherClass = (ClassSymbol)otherType;
                    if (!otherClass.isInterface()) {
                        return thisClass.isSuperclass(otherClass);
                    }
                    return thisClass.equalTo(parser.javaLangObjectSymbol);
                }
                return thisClass.equalTo(parser.javaLangObjectSymbol);
            }
            if (otherType.isClass()) {
                ClassSymbol otherClass = (ClassSymbol)otherType;
                return otherClass.implementsInterface(thisClass);
            }
            return parser.javaLangCloneableSymbol != null && thisClass.equalTo(parser.javaLangCloneableSymbol) || parser.javaIoSerializableSymbol != null && thisClass.equalTo(parser.javaIoSerializableSymbol);
        }
        if (otherType.isClass()) {
            return false;
        }
        ArraySymbol thisArray = (ArraySymbol)thisType;
        ArraySymbol otherArray = (ArraySymbol)otherType;
        TypeSymbol thisBaseType = ArraySymbol.getArrayType(thisArray.baseType, thisArray.dimension - 1);
        TypeSymbol otherBaseType = ArraySymbol.getArrayType(otherArray.baseType, otherArray.dimension - 1);
        if (thisBaseType.isPrimitiveType() || otherBaseType.isPrimitiveType()) {
            return thisBaseType == otherBaseType;
        }
        return ((ReferenceTypeSymbol)thisBaseType).isReturnSubstitutable(parser, (ReferenceTypeSymbol)otherBaseType);
    }

    static boolean compareMethods(MethodSymbol method1, MethodSymbol method2) {
        if (method1.identifier != method2.identifier) {
            return false;
        }
        if (method1.argCount != method2.argCount) {
            return false;
        }
        if (method1.argumentList == null || method2.argumentList == null) {
            return method1.argumentList == null && method2.argumentList == null;
        }
        return method1.argumentList.equals(method2.argumentList);
    }

    private static boolean checkInterfaces(Parser parser, ClassSymbol interface1, ClassSymbol interface2) {
        if (!($assertionsDisabled || interface1.isInterface() && interface2.isInterface())) {
            throw new AssertionError();
        }
        MethodSymbol[] methodArray1 = interface1.getClassSymbol().getMethodTable(parser);
        MethodSymbol[] methodArray2 = interface2.getClassSymbol().getMethodTable(parser);
        int i = methodArray1.length;
        block0: while (--i >= 0) {
            MethodSymbol methodSymbol1 = methodArray1[i];
            if (methodSymbol1.definingClass == parser.javaLangObjectSymbol) continue;
            int j = methodArray2.length;
            while (--j >= 0) {
                MethodSymbol methodSymbol2 = methodArray2[j];
                if (methodSymbol2.definingClass == parser.javaLangObjectSymbol || !ReferenceTypeSymbol.compareMethods(methodSymbol1, methodSymbol2)) continue;
                if (methodSymbol1.resultType.equalTo(methodSymbol2.resultType)) continue block0;
                return false;
            }
        }
        return true;
    }

    boolean isCastCompatible(Parser parser, ReferenceTypeSymbol targetType) {
        if (this.equalTo(targetType)) {
            return true;
        }
        if (this == nullTypeSymbol || targetType == nullTypeSymbol) {
            return true;
        }
        if (this.isClass()) {
            ClassSymbol sourceClass = (ClassSymbol)this;
            if (sourceClass.isTypeParameter()) {
                return ((TypeParameterSymbol)this).bound.isCastCompatible(parser, targetType);
            }
            if (!sourceClass.isInterface()) {
                if (targetType.isClass()) {
                    ClassSymbol targetClass = (ClassSymbol)targetType;
                    if (targetClass.isTypeParameter()) {
                        return this.isCastCompatible(parser, ((TypeParameterSymbol)targetType).bound);
                    }
                    if (!targetClass.isInterface()) {
                        if (targetClass.equalTo(sourceClass) || targetClass.isSuperclass(sourceClass) || sourceClass.isSuperclass(targetClass)) {
                            return !this.hasDistinctParameterizedSupers(parser, sourceClass, targetClass);
                        }
                        return false;
                    }
                    if ((sourceClass.access & 0x10) == 0) {
                        return !this.hasDistinctParameterizedSupers(parser, sourceClass, targetClass);
                    }
                    return sourceClass.implementsInterface(targetClass);
                }
                return sourceClass.equalTo(parser.javaLangObjectSymbol);
            }
            if (targetType.isClass()) {
                ClassSymbol targetClass = (ClassSymbol)targetType;
                if ((targetClass.access & 0x10) == 0 && this.hasDistinctParameterizedSupers(parser, sourceClass, targetClass)) {
                    return false;
                }
                if (!targetClass.isInterface()) {
                    if ((targetClass.access & 0x10) == 0) {
                        return true;
                    }
                    return targetClass.implementsInterface(sourceClass);
                }
                if (parser.parsingAtLeastOneFive) {
                    if ((targetClass.access & 0x10) == 0) {
                        return true;
                    }
                    return targetClass.implementsInterface(sourceClass);
                }
                return ReferenceTypeSymbol.checkInterfaces(parser, sourceClass, targetClass);
            }
            return parser.javaLangCloneableSymbol != null && sourceClass.equalTo(parser.javaLangCloneableSymbol) || parser.javaIoSerializableSymbol != null && sourceClass.equalTo(parser.javaIoSerializableSymbol);
        }
        if (targetType.isClass()) {
            ClassSymbol targetClass = (ClassSymbol)targetType;
            if (targetClass.isTypeParameter()) {
                return this.isCastCompatible(parser, ((TypeParameterSymbol)targetType).bound);
            }
            if (!targetClass.isInterface()) {
                return targetClass.equalTo(parser.javaLangObjectSymbol);
            }
            return parser.javaLangCloneableSymbol != null && targetClass.equalTo(parser.javaLangCloneableSymbol) || parser.javaIoSerializableSymbol != null && targetClass.equalTo(parser.javaIoSerializableSymbol);
        }
        ArraySymbol sourceArray = (ArraySymbol)this;
        ArraySymbol targetArray = (ArraySymbol)targetType;
        TypeSymbol sourceBaseType = ArraySymbol.getArrayType(sourceArray.baseType, sourceArray.dimension - 1);
        TypeSymbol targetBaseType = ArraySymbol.getArrayType(targetArray.baseType, targetArray.dimension - 1);
        if (sourceBaseType.isPrimitiveType() || targetBaseType.isPrimitiveType()) {
            return sourceBaseType == targetBaseType;
        }
        return ((ReferenceTypeSymbol)sourceBaseType).isCastCompatible(parser, (ReferenceTypeSymbol)targetBaseType);
    }

    private boolean hasDistinctParameterizedSupers(Parser parser, ClassSymbol sourceClass, ClassSymbol targetClass) {
        if (parser.parsingAtLeastOneFive) {
            Hashtable sourceSupers = new Hashtable();
            Hashtable targetSupers = new Hashtable();
            this.collectSupers(sourceClass, sourceSupers);
            this.collectSupers(targetClass, targetSupers);
            Iterator sourceIter = sourceSupers.keySet().iterator();
            while (sourceIter.hasNext()) {
                ClassSymbol sourceSuper;
                TypeSymbol erasedSource = (TypeSymbol)sourceIter.next();
                ClassSymbol targetSuper = (ClassSymbol)targetSupers.get(erasedSource);
                if (targetSuper == null || !ParameterizedClassSymbol.areDistinctParameterizedTypes(sourceSuper = (ClassSymbol)sourceSupers.get(erasedSource), targetSuper)) continue;
                return true;
            }
        }
        return false;
    }

    private void collectSupers(ClassSymbol classSymbol, Hashtable table) {
        if (classSymbol != null) {
            table.put(classSymbol.eraseType(), classSymbol);
            this.collectInterfaces(classSymbol, table);
            this.collectSupers(classSymbol.getSuperClassSymbol(), table);
        }
    }

    private void collectInterfaces(ClassSymbol classSymbol, Hashtable table) {
        if (classSymbol != null) {
            ImplementationList impls = classSymbol.getImplementationList();
            while (impls != null) {
                table.put(impls.interfaceSymbol.eraseType(), impls.interfaceSymbol);
                this.collectInterfaces(impls.interfaceSymbol, table);
                impls = impls.next;
            }
        }
    }

    static {
        $assertionsDisabled = !ReferenceTypeSymbol.class.desiredAssertionStatus();
    }
}

