/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.AnonymousClassSymbol;
import oracle.ojc.compiler.ArgumentVariableList;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassFileReader;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ClassSymbolList;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.DynamicInitializationStatement;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionStatement;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.ImportSymbol;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.InvokeExpression;
import oracle.ojc.compiler.LocalScope;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodScope;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.NewSourceException;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.PackageSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.SourceFile;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.StringConstantExpression;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeSymbolList;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedSuperClassException;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;

class RawClassSymbol
extends ClassSymbol {
    static final short CSF_NONE = 0;
    static final short CSF_ASSERTIONS = 1;
    static final short CSF_CONSTANTVALUES = 2;
    static final short CSF_ANONYMOUS_THIS_NOT_INITIALIZED = 4;
    static final short CSF_CLASSLOADERMETHOD = 8;
    static final short CSF_ERRORFLAGGED = 16;
    static final short CSF_COMPILED = 32;
    static final short CSF_RESOLVED = 64;
    static final short CSF_LOCALCLASS = 128;
    static final short CSF_SYNTHETIC = 256;
    static final short CSF_DEPRECATED = 512;
    static final short CSF_IMPLEMENTSINTERFACES = 1024;
    static final short CSF_SERIALIZABLE = 2048;
    static final short CSF_ANNOTATION_USED = 4096;
    static final short CSF_SPECIAL_ANNOTATION = 8192;
    static final short CSF_INVOLVES_GENERICS = 16384;
    static final short CSF_PROPAGATED_INHERITED_FLAGS = Short.MIN_VALUE;
    static RawClassSymbol javaLangObjectSymbol;
    ClassSymbol superClass;
    private ImplementationList implementationList;
    ClassScope classScope;
    ClassData cd;
    short flags;
    private ArrayList nonConstStaticInitializerList;
    static final /* synthetic */ boolean $assertionsDisabled;

    private RawClassSymbol() {
        super(0, Identifier.getIdentifier("1"), (byte)10, (short)1, null);
        this.flags = (short)(this.flags | 0x10);
        this.classScope = new ClassScope(this, null, null);
        this.cd = new ClassData();
        this.cd.internalName = new char[0];
        this.nonConstStaticInitializerList = null;
    }

    RawClassSymbol(int pos, Identifier identifier, short access, TypeParameterList typeParameterList, Annotation annotation, boolean compiled, boolean unresolved) {
        super(pos, identifier, (byte)10, access, annotation);
        if (!unresolved) {
            if ((access & 0x2000) != 0) {
                this.cd = new AnnotationClassData();
            } else if (typeParameterList != null) {
                this.cd = new GenericClassData(typeParameterList);
                this.flags = (short)(this.flags | 0x4000);
            } else {
                this.cd = new ClassData();
            }
            if (compiled) {
                this.cd.ccd = new CompiledClassData();
            }
        }
        this.nonConstStaticInitializerList = null;
    }

    boolean isSynthetic() {
        return (this.flags & 0x100) != 0;
    }

    boolean isDeprecated() {
        return (this.flags & 0x200) != 0;
    }

    void deprecate() {
        this.flags = (short)(this.flags | 0x200);
    }

    boolean isErroneous() {
        return (this.flags & 0x10) != 0;
    }

    String errorName() {
        if (this.scope == null) {
            return "";
        }
        return this.kindName() + " " + this.toString();
    }

    String errorNameWithPath() {
        Scope outerScope;
        if (this.scope == null) {
            return "";
        }
        for (outerScope = this.scope; outerScope != null && outerScope.kind != 1; outerScope = outerScope.getOuterScope()) {
        }
        if (outerScope != null) {
            PackageScope packageScope = (PackageScope)outerScope;
            PackageSymbol packageSymbol = packageScope.packageSymbol;
            if (packageSymbol != null) {
                int x;
                String className;
                Storage foundParentStorage = null;
                if (!this.isCompiled() && packageSymbol.classStorage != null) {
                    className = new String(this.identifier.name);
                    className = className + ".class";
                    for (x = 0; x < packageSymbol.classStorage.length; ++x) {
                        Storage classStorage = packageSymbol.classStorage[x];
                        if (classStorage.open(className) == null) continue;
                        foundParentStorage = classStorage;
                        break;
                    }
                }
                if (foundParentStorage == null && packageSymbol.sourceStorage != null && packageSymbol.sourceStorage != null) {
                    className = new String(this.identifier.name);
                    className = className + ".java";
                    for (x = 0; x < packageSymbol.sourceStorage.length; ++x) {
                        Storage sourceStorage = packageSymbol.sourceStorage[x];
                        if (sourceStorage.open(className) == null) continue;
                        foundParentStorage = sourceStorage;
                        break;
                    }
                }
                if (foundParentStorage != null) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(this.kindName());
                    buf.append(" ");
                    buf.append(foundParentStorage.getPath());
                    char c = buf.charAt(buf.length() - 1);
                    if (c != '/' && c != '\\') {
                        buf.append(File.separatorChar);
                    }
                    buf.append(this.identifier.name);
                    return buf.toString();
                }
            }
        }
        return this.kindName() + " " + this.toString();
    }

    String kindName() {
        if (this.isAnnotation()) {
            return Message.annotationString;
        }
        if (this.isInterface()) {
            return Message.interfaceString;
        }
        if (this.isEnum()) {
            return Message.enumString;
        }
        return Message.classString;
    }

    char[] getInternalName() {
        if (this.cd.internalName == null) {
            char[] className = this.getClassName();
            Scope scp = this.getPackageScope();
            if (scp.kind == 1) {
                PackageScope packageScope = (PackageScope)scp;
                PackageSymbol packageSymbol = packageScope.packageSymbol;
                if (packageSymbol != null) {
                    char[] packageName = packageSymbol.getSignature();
                    int size = packageName.length + 1 + className.length;
                    this.cd.internalName = new char[size];
                    System.arraycopy(packageName, 0, this.cd.internalName, 0, packageName.length);
                    this.cd.internalName[packageName.length] = 47;
                    System.arraycopy(className, 0, this.cd.internalName, packageName.length + 1, className.length);
                } else {
                    this.cd.internalName = className;
                }
            } else {
                this.cd.internalName = className;
            }
        }
        return this.cd.internalName;
    }

    char[] getSignature() {
        if (this.cd.signature == null) {
            char[] internal = this.getInternalName();
            int size = 1 + internal.length + 1;
            this.cd.signature = new char[size];
            this.cd.signature[0] = 76;
            System.arraycopy(internal, 0, this.cd.signature, 1, internal.length);
            this.cd.signature[internal.length + 1] = 59;
        }
        return this.cd.signature;
    }

    Annotation getAnnotations() {
        return this.annotation;
    }

    byte getAnnotationTarget() {
        if (this.isAnnotation()) {
            return 65;
        }
        if (this.getClassSymbol().identifier == Identifier.packageInfoIdentifier) {
            return -128;
        }
        return 1;
    }

    boolean equalTo(TypeSymbol typeSymbol, TypeSymbol recursionCheck) {
        if (!(typeSymbol instanceof ClassSymbol)) {
            return false;
        }
        RawClassSymbol classSymbol = ((ClassSymbol)typeSymbol).getClassSymbol();
        return this == classSymbol;
    }

    boolean isCompiled() {
        return (this.flags & 0x20) != 0;
    }

    boolean isRawClass() {
        return true;
    }

    boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    boolean isEnum() {
        return (this.access & 0x4000) != 0;
    }

    boolean isAnnotation() {
        return (this.access & 0x2000) != 0;
    }

    boolean isLocalInnerClass() {
        return (this.flags & 0x80) != 0;
    }

    boolean isGenericType() {
        return this.cd instanceof GenericClassData;
    }

    boolean involvesGenerics() {
        return (this.flags & 0x4000) != 0;
    }

    boolean isReifiable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeSymbol resolveType(Parser parser, int pos, boolean mustBePublic, boolean checkActualTypeParameters, boolean lazy) {
        block12: {
            if ((this.flags & 0x50) == 0) {
                if ((this.flags & 0x20) == 0) {
                    try {
                        parser.currentClassesBeingResolved.add(this);
                        if (this.classScope == null) {
                            this.loadType(parser, pos, lazy, false);
                        } else if (!lazy) {
                            ImplementationList implList;
                            this.flags = (short)(this.flags | 0x40);
                            if (this.superClass != null) {
                                this.superClass = (ClassSymbol)this.superClass.resolveType(parser, pos, false, false, false);
                                this.flags = (short)(this.flags | this.superClass.getClassSymbol().flags & 0xC00);
                            }
                            if ((implList = this.implementationList) != null) {
                                this.flags = (short)(this.flags | 0x400);
                                do {
                                    implList.interfaceSymbol = (ClassSymbol)implList.interfaceSymbol.resolveType(parser, pos, false, false, false);
                                } while ((implList = implList.next) != null);
                            }
                        }
                        Object var8_7 = null;
                        int len = parser.currentClassesBeingResolved.size();
                        parser.currentClassesBeingResolved.remove(len - 1);
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        int len = parser.currentClassesBeingResolved.size();
                        parser.currentClassesBeingResolved.remove(len - 1);
                        throw throwable;
                    }
                    {
                        break block12;
                    }
                }
                this.flags = (short)(this.flags | 0x40);
                if (this.superClass != null && !this.superClass.equalTo(parser.javaLangObjectSymbol) && this.isInterface() != this.superClass.isInterface()) {
                    parser.error(Message.errorNoInterfaceAllowed, this.cd.ccd.tpos, false);
                }
                if (this.superClass != null && (this.superClass.access & 0x10) != 0) {
                    parser.error(Message.errorFinalCannotBeInherited, this.cd.ccd.tpos, this.superClass.isErroneous(), this.superClass.errorName());
                }
            }
        }
        return this;
    }

    protected void toString(StringBuffer sb) {
        if (this.scope == null) {
            return;
        }
        Scope scp = this.getPackageScope();
        if (scp.kind == 1) {
            PackageScope packageScope = (PackageScope)scp;
            PackageSymbol packageSymbol = packageScope.packageSymbol;
            if (packageSymbol != null) {
                packageSymbol.toString(sb);
                sb.append('.');
            }
        }
        sb.append(this.getClassName());
    }

    boolean isAccessible(ClassSymbol fromClass) {
        if (this.equalTo(fromClass)) {
            return true;
        }
        switch (this.access & 7) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
            case 4: {
                if (!this.isSuperclass(fromClass)) break;
                return true;
            }
        }
        return this.inSamePackage(fromClass);
    }

    RawClassSymbol getClassSymbol() {
        return this;
    }

    ClassSymbol getSuperClassSymbol() {
        return this.superClass;
    }

    ClassSymbol getInterface(RawClassSymbol interfaceSymbol) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    ImplementationList getImplementationList() {
        return this.implementationList;
    }

    RawClassSymbol getOuterClass() {
        if (!$assertionsDisabled && !this.isInnerClass()) {
            throw new AssertionError();
        }
        if (this.scope.kind == 2) {
            return ((ClassScope)this.scope).classSymbol;
        }
        if (!$assertionsDisabled && this.scope.kind < 3) {
            throw new AssertionError();
        }
        Scope outerScope = this.scope;
        do {
            outerScope = outerScope.getOuterScope();
        } while (outerScope.kind >= 3);
        if (!$assertionsDisabled && outerScope.kind != 2) {
            throw new AssertionError();
        }
        return ((ClassScope)outerScope).classSymbol;
    }

    RawClassSymbol getTopLevelClass() {
        RawClassSymbol classSymbol = this;
        while (classSymbol.isInnerClass()) {
            classSymbol = classSymbol.getOuterClass();
        }
        return classSymbol;
    }

    void checkForOutOfPackageInnerClasses(ConstantPool constantPool, RawClassSymbol outerClass) {
        TypeParameterList tpl = this.cd.getTypeParameterList();
        while (tpl != null) {
            tpl.typeParameter.checkForOutOfPackageInnerClasses(constantPool, outerClass);
            tpl = tpl.next;
        }
    }

    static RawClassSymbol getErrorClassSymbol() {
        return new RawClassSymbol();
    }

    static void initializeStatics() {
    }

    static void releaseStatics() {
        javaLangObjectSymbol = null;
    }

    boolean hasCompiledSuperclasses() {
        RawClassSymbol classSymbol = this;
        while (classSymbol.superClass != null) {
            classSymbol = classSymbol.superClass.getClassSymbol();
            if ((classSymbol.flags & 0x20) == 0) continue;
            return true;
        }
        return false;
    }

    void propagateFlagsFromSuperclasses() {
        if ((this.flags & Short.MIN_VALUE) != 0) {
            return;
        }
        ClassSymbol superClassSymbol = this.getSuperClassSymbol();
        if (superClassSymbol != null) {
            if (superClassSymbol instanceof UnresolvedClassSymbol) {
                throw new UnresolvedSuperClassException(superClassSymbol);
            }
            RawClassSymbol rawClassSymbol = superClassSymbol.getClassSymbol();
            rawClassSymbol.propagateFlagsFromSuperclasses();
            this.flags = (short)(this.flags | rawClassSymbol.flags & 0xC00);
        }
        this.flags = (short)(this.flags | Short.MIN_VALUE);
    }

    void setImplementationList(ImplementationList implementationList) {
        this.implementationList = implementationList;
    }

    void addField(FieldSymbol fieldSymbol) {
        if (!$assertionsDisabled && this.cd == null) {
            throw new AssertionError();
        }
        fieldSymbol.nextInClass = this.cd.fieldList;
        this.cd.fieldList = fieldSymbol;
        short s = this.cd.fieldCount;
        this.cd.fieldCount = (short)(s + 1);
        fieldSymbol.index = s;
    }

    void addInnerClass(ClassSymbol classSymbol) {
        if (!$assertionsDisabled && this.cd == null) {
            throw new AssertionError();
        }
        TypeSymbolList tsl = new TypeSymbolList(classSymbol);
        tsl.next = this.cd.innerClassList;
        this.cd.innerClassList = tsl;
    }

    void checkDeprecated(Parser parser, int pos) {
        if (this.isDeprecated() && this != parser.currentClassSymbol) {
            parser.warning(this, Message.warningIsDeprecated, pos, this.errorName());
        }
    }

    MethodSymbol[] getMethodTable(Parser parser) {
        MethodSymbol[] methodTable = this.cd.methodTable;
        if (methodTable == null) {
            if ((this.flags & 0x20) != 0) {
                return null;
            }
            this.buildMethodTable(parser);
            methodTable = this.cd.methodTable;
        }
        return methodTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildMethodTable(Parser parser) {
        RawClassSymbol saveCurrentClassSymbol = parser.currentClassSymbol;
        parser.currentClassSymbol = this;
        try {
            parser.currentClassesBeingResolved.add(this);
            if (this.cd.methodTable == null) {
                ImplementationList impl;
                MethodSymbol methodSymbol;
                if ((this.flags & 0x60) == 0) {
                    this.loadType(parser, 0, false, true);
                }
                if (!this.isCompiled()) {
                    boolean savedSuspendStaticContextChecking = parser.suspendStaticContextChecking;
                    parser.suspendStaticContextChecking = true;
                    this.resolveTypeParameters(parser);
                    methodSymbol = this.cd.methodList;
                    while (methodSymbol != null) {
                        methodSymbol.resolveTypeParameters(parser);
                        TypeSymbol typeSymbol = methodSymbol.resultType;
                        if (typeSymbol.isUnresolvedType()) {
                            methodSymbol.resultType = typeSymbol.resolveType(parser, 0, false, true, false);
                        }
                        ArgumentVariableList args = methodSymbol.argumentList;
                        while (args != null) {
                            ArgumentVariableSymbol argSymbol = args.argSymbol;
                            typeSymbol = argSymbol.type;
                            if (typeSymbol.isUnresolvedType()) {
                                argSymbol.type = typeSymbol.resolveType(parser, 0, false, true, false);
                            }
                            args = args.next;
                        }
                        MethodSymbol.ThrowsList tl = methodSymbol.throwsList;
                        while (tl != null) {
                            typeSymbol = tl.throwsType;
                            if (typeSymbol.isUnresolvedType()) {
                                tl.throwsType = typeSymbol.resolveType(parser, 0, false, true, false);
                            }
                            tl = tl.next;
                        }
                        methodSymbol = methodSymbol.nextInClass;
                    }
                    parser.suspendStaticContextChecking = savedSuspendStaticContextChecking;
                }
                int count = this.cd.methodCount;
                if (this.superClass != null) {
                    count += this.superClass.getClassSymbol().cd.methodCount;
                }
                ArrayList<MethodSymbol> methodArrayList = new ArrayList<MethodSymbol>(count);
                methodSymbol = this.cd.methodList;
                while (methodSymbol != null) {
                    methodArrayList.add(methodSymbol);
                    methodSymbol = methodSymbol.nextInClass;
                }
                if (this.isInterface()) {
                    if (this.implementationList != null) {
                        impl = this.implementationList;
                        while (impl != null) {
                            this.mergeIntoMethodTable(parser, methodArrayList, (ParameterizedClassSymbol)impl.interfaceSymbol);
                            impl = impl.next;
                        }
                    } else {
                        if (!$assertionsDisabled && this.superClass == null) {
                            throw new AssertionError();
                        }
                        this.mergeIntoMethodTable(parser, methodArrayList, (ParameterizedClassSymbol)this.superClass);
                    }
                } else {
                    boolean bridgesNeeded = false;
                    if (this.superClass != null) {
                        bridgesNeeded |= this.mergeIntoMethodTable(parser, methodArrayList, (ParameterizedClassSymbol)this.superClass);
                    }
                    impl = this.implementationList;
                    while (impl != null) {
                        ClassSymbol interfaceSymbol = impl.interfaceSymbol;
                        bridgesNeeded |= this.mergeIntoMethodTable(parser, methodArrayList, (ParameterizedClassSymbol)interfaceSymbol);
                        impl = impl.next;
                    }
                    if (this.isCompiled()) {
                        if (!parser.targetingAtLeastOneFive) {
                            bridgesNeeded = false;
                        } else if (!bridgesNeeded) {
                            RawClassSymbol rawClassSymbol = this.getClassSymbol();
                            do {
                                bridgesNeeded |= rawClassSymbol.checkInterfacesForBridgesNeeded();
                                if (rawClassSymbol.superClass == null) break;
                                rawClassSymbol = rawClassSymbol.superClass.getClassSymbol();
                            } while (!bridgesNeeded && (rawClassSymbol.access & 0x400) != 0);
                            if (!bridgesNeeded) {
                                for (ParameterizedClassSymbol pcs = (ParameterizedClassSymbol)this.superClass; pcs != null; pcs = (ParameterizedClassSymbol)pcs.getSuperClassSymbol()) {
                                    if (!pcs.isGenericType()) continue;
                                    bridgesNeeded = true;
                                    break;
                                }
                            }
                        }
                        if (bridgesNeeded) {
                            this.addBridgeMethods(parser);
                        }
                    }
                }
                this.cd.methodTable = methodArrayList.toArray(new MethodSymbol[methodArrayList.size()]);
                methodSymbol = this.cd.methodList;
                while (methodSymbol != null) {
                    if ((methodSymbol.flags & 0x80) != 0) {
                        parser.error(Message.errorDoesNotOverride, methodSymbol.pos, false, methodSymbol.errorName());
                    }
                    methodSymbol = methodSymbol.nextInClass;
                }
            }
            Object var17_16 = null;
            int len = parser.currentClassesBeingResolved.size();
            parser.currentClassesBeingResolved.remove(len - 1);
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            int len = parser.currentClassesBeingResolved.size();
            parser.currentClassesBeingResolved.remove(len - 1);
            parser.currentClassSymbol = saveCurrentClassSymbol;
            throw throwable;
        }
        parser.currentClassSymbol = saveCurrentClassSymbol;
    }

    private boolean checkInterfacesForBridgesNeeded() {
        ImplementationList impl = this.implementationList;
        while (impl != null) {
            ClassSymbol interfaceSymbol = impl.interfaceSymbol;
            if (interfaceSymbol.isGenericType()) {
                return true;
            }
            if (interfaceSymbol.getClassSymbol().checkInterfacesForBridgesNeeded()) {
                return true;
            }
            impl = impl.next;
        }
        return false;
    }

    void fixConstructors(Parser parser) {
        if (this.cd.ccd.dynamicInitializer == null) {
            return;
        }
        MethodSymbol constructor = (MethodSymbol)this.classScope.lookupSpecificSymbolInScope(Identifier.initializerIdentifier, 8, true);
        while (constructor != null) {
            if ((constructor.flags & 2) == 0) {
                StatementList stmtList = constructor.cmd.statementList;
                if (stmtList == null) {
                    constructor.cmd.statementList = stmtList = new StatementList();
                }
                DynamicInitializationStatement statement = new DynamicInitializationStatement(stmtList, this.cd.ccd.dynamicInitializer);
                ((Statement)statement).resolveAndCheck(parser);
                if (stmtList.first == null) {
                    stmtList.add(statement);
                } else if (constructor.definingClass.superClass != null) {
                    stmtList.first.insertAfter(statement);
                } else {
                    stmtList.first.insertBefore(statement);
                }
            }
            constructor = constructor.nextWithSameName;
        }
    }

    protected void removeDynamicInitializer() {
        if (this.cd.ccd.dynamicInitializer != null) {
            MethodSymbol dynamicInitializer = this.cd.ccd.dynamicInitializer;
            MethodSymbol prev = null;
            MethodSymbol methodSymbol = this.cd.methodList;
            while (methodSymbol != null) {
                if (methodSymbol == dynamicInitializer) {
                    if (prev == null) {
                        this.cd.methodList = methodSymbol.nextInClass;
                        break;
                    }
                    prev.nextInClass = methodSymbol.nextInClass;
                    break;
                }
                prev = methodSymbol;
                methodSymbol = methodSymbol.nextInClass;
            }
            this.cd.ccd.dynamicInitializer = null;
        }
    }

    void pruneUnresolvedClassSymbols(Parser parser) {
        ImplementationList implList;
        Object rState = parser.saveResolutionState(this);
        if (this.superClass instanceof UnresolvedClassSymbol) {
            parser.error(Error.errorNotFound, this.cd.ccd.tpos, false, this.superClass.errorName(), "");
            this.superClass = parser.javaLangObjectPcs;
        }
        if ((implList = this.getImplementationList()) != null) {
            ImplementationList implListFirst = implList;
            ImplementationList implListPrev = null;
            do {
                if (implList.interfaceSymbol instanceof UnresolvedClassSymbol) {
                    parser.error(Error.errorNotFound, this.cd.ccd.tpos, false, implList.interfaceSymbol.errorName(), "");
                    if (implListPrev == null) {
                        implListFirst = implList.next;
                        continue;
                    }
                    implListPrev.next = implList.next;
                    continue;
                }
                implListPrev = implList;
            } while ((implList = implList.next) != null);
            this.setImplementationList(implListFirst);
        }
        TypeParameterList tpl = this.cd.getTypeParameterList();
        while (tpl != null) {
            if (tpl.typeParameter.bound instanceof UnresolvedClassSymbol) {
                parser.error(Error.errorNotFound, tpl.typeParameter.boundPos, false, tpl.typeParameter.bound.errorName(), "");
                tpl.typeParameter.bound = parser.javaLangObjectPcs;
            }
            tpl = tpl.next;
        }
        TypeSymbolList tsl = this.cd.innerClassList;
        while (tsl != null) {
            ((RawClassSymbol)tsl.typeSymbol).pruneUnresolvedClassSymbols(parser);
            tsl = tsl.next;
        }
        parser.restoreResolutionState(rState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int resolveSuperClass(Parser parser, boolean mustBePublic) {
        if (this.superClass != null) {
            boolean saveParserSuspendTypeBoundsChecking = parser.suspendTypeBoundsChecking;
            parser.suspendTypeBoundsChecking = true;
            try {
                try {
                    TypeSymbol typeSymbol = this.superClass.resolveType(parser, this.superClass.pos, mustBePublic, true, false);
                    if (typeSymbol.isErroneous()) {
                        typeSymbol = parser.javaLangObjectPcs;
                    } else {
                        parser.currentClassSymbol.addNameReference(parser, typeSymbol, this.superClass.pos);
                        parser.currentClassSymbol.addSuperReference(parser, this, (ClassSymbol)typeSymbol);
                    }
                    this.superClass = (ClassSymbol)typeSymbol;
                    if (this.superClass.getClassSymbol() == parser.javaLangEnumSymbol) {
                        if (!this.isEnum()) {
                            parser.error(Message.errorExtendingEnum, this.cd.ccd.tpos, false);
                        }
                    } else if ((this.superClass.access & 0x10) != 0) {
                        parser.error(Message.errorFinalCannotBeInherited, this.cd.ccd.tpos, this.superClass.isErroneous(), this.superClass.errorName());
                    } else if (this.superClass.isTypeParameter()) {
                        parser.error(Message.errorFinalTypeParameter, this.cd.ccd.tpos, false);
                    } else if (this.isStaticInnerClass() && this.superClass.isNonStaticInnerClass()) {
                        parser.error(Message.errorUndefinedThis, this.cd.ccd.tpos, this.superClass.isErroneous(), this.superClass.errorName());
                    }
                    if (this.superClass.isDeprecated() && !this.isDeprecated()) {
                        parser.warning(this, Message.warningOverridesDeprecated, this.pos, this.superClass.errorName(), Message.classString);
                    }
                    if (this.superClass.isParameterizedClass()) {
                        ParameterizedClassSymbol pcs = (ParameterizedClassSymbol)this.superClass;
                        TypeVariableList tvl = pcs.typeVariableList;
                        while (tvl != null) {
                            if (tvl.typeVariable.typeVariableKind != 1) {
                                parser.error(Message.errorNoWildCardsInExtendsTypeArgs, tvl.typeVariable.pos, this.superClass.isErroneous());
                            }
                            tvl = tvl.next;
                        }
                    }
                    if (this.superClass.isGenericType()) {
                        this.flags = (short)(this.flags | 0x4000);
                    }
                    this.flags = (short)(this.flags | this.superClass.getClassSymbol().flags & 0x400);
                }
                catch (UnresolvedSuperClassException e) {
                    int n = 1;
                    Object var8_10 = null;
                    parser.suspendTypeBoundsChecking = saveParserSuspendTypeBoundsChecking;
                    return n;
                }
                Object var8_9 = null;
                parser.suspendTypeBoundsChecking = saveParserSuspendTypeBoundsChecking;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                parser.suspendTypeBoundsChecking = saveParserSuspendTypeBoundsChecking;
                throw throwable;
            }
        }
        return 0;
    }

    boolean isGenericThrowableDerived(Parser parser) {
        RawClassSymbol currentClass = this;
        while (true) {
            if (((TypeSymbol)currentClass).isGenericType()) {
                return parser.javaLangThrowableSymbol.isSuperclass(this);
            }
            if (!currentClass.isInnerClass() || (currentClass.access & 8) != 0) break;
            currentClass = ((ClassSymbol)currentClass).getOuterClass();
        }
        return false;
    }

    private void checkComplexCyclicInheritance(Parser parser, InnerClassSymbol classSymbol) {
        if (!this.isErroneous()) {
            ClassSymbol thisClass = this;
            if (classSymbol.isInterface()) {
                block0: do {
                    ImplementationList implList = thisClass.getImplementationList();
                    while (implList != null) {
                        if (classSymbol.equalTo(implList.interfaceSymbol)) {
                            parser.error(Message.errorCyclicInheritance, this.pos, false, this.errorName());
                            continue block0;
                        }
                        implList = implList.next;
                    }
                } while ((thisClass = thisClass.getSuperClassSymbol()) != null);
            } else {
                do {
                    RawClassSymbol outerClass;
                    if (classSymbol.equalTo(thisClass) || classSymbol.isSuperclass(thisClass)) {
                        parser.error(Message.errorCyclicInheritance, this.pos, false, this.errorName());
                        break;
                    }
                    if (!thisClass.isInnerClass() || !classSymbol.equalTo(outerClass = thisClass.getOuterClass()) && !classSymbol.isSuperclass(outerClass)) continue;
                    parser.error(Message.errorCyclicInheritance, this.pos, false, this.errorName());
                    break;
                } while ((thisClass = thisClass.getSuperClassSymbol()) != null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int resolveInterfaces(Parser parser) {
        int resolutionFailures = 0;
        ImplementationList implList = this.implementationList;
        if (implList != null) {
            this.flags = (short)(this.flags | 0x400);
            ImplementationList prevImplList = null;
            do {
                Object var12_12;
                boolean saveParserSuspendTypeBoundsChecking = parser.suspendTypeBoundsChecking;
                parser.suspendTypeBoundsChecking = true;
                try {
                    block16: {
                        try {
                            int typePos = implList.interfaceSymbol.pos;
                            TypeSymbol typeSymbol = implList.interfaceSymbol.resolveType(parser, typePos, true, true, false);
                            if (typeSymbol.isErroneous()) {
                                typeSymbol = TypeSymbol.errorSymbol;
                            }
                            if (!(typeSymbol instanceof ClassSymbol)) {
                                if (prevImplList == null) {
                                    this.implementationList = implList.next;
                                } else {
                                    prevImplList.next = implList.next;
                                }
                                break block16;
                            }
                            parser.currentClassSymbol.addNameReference(parser, typeSymbol, typePos);
                            parser.currentClassSymbol.addImplementsReference(parser, this, (ClassSymbol)typeSymbol);
                            if (parser.javaIoSerializableSymbol != null && typeSymbol.equalTo(parser.javaIoSerializableSymbol)) {
                                this.flags = (short)(this.flags | 0x800);
                            }
                            implList.interfaceSymbol = (ClassSymbol)typeSymbol;
                            ClassSymbol classSymbol = (ClassSymbol)typeSymbol;
                            if (classSymbol.isDeprecated() && !this.isDeprecated()) {
                                parser.warning(this, Message.warningOverridesDeprecated, this.pos, classSymbol.errorName(), Message.implementedString, Message.classString);
                            }
                            if (classSymbol.isParameterizedClass()) {
                                ParameterizedClassSymbol pcs = (ParameterizedClassSymbol)classSymbol;
                                TypeVariableList tvl = pcs.typeVariableList;
                                while (tvl != null) {
                                    if (tvl.typeVariable.typeVariableKind != 1) {
                                        parser.error(Message.errorNoWildCardsInImplementsTypeArgs, tvl.typeVariable.pos, classSymbol.isErroneous());
                                    }
                                    tvl = tvl.next;
                                }
                            }
                            if (classSymbol.isGenericType()) {
                                this.flags = (short)(this.flags | 0x4000);
                            }
                            prevImplList = implList;
                        }
                        catch (UnresolvedSuperClassException e) {
                            ++resolutionFailures;
                            var12_12 = null;
                            parser.suspendTypeBoundsChecking = saveParserSuspendTypeBoundsChecking;
                            continue;
                        }
                    }
                    var12_12 = null;
                    parser.suspendTypeBoundsChecking = saveParserSuspendTypeBoundsChecking;
                }
                catch (Throwable throwable) {
                    var12_12 = null;
                    parser.suspendTypeBoundsChecking = saveParserSuspendTypeBoundsChecking;
                    throw throwable;
                }
            } while ((implList = implList.next) != null);
        }
        return resolutionFailures;
    }

    int resolveTypeParameters(Parser parser) {
        TypeParameterList tpl = this.cd.getTypeParameterList();
        if (tpl != null) {
            return tpl.resolve(parser);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int resolveInnerClasses(Parser parser) {
        int resolutionFailures = 0;
        TypeSymbolList tsl = this.cd.innerClassList;
        while (tsl != null) {
            TypeSymbol typeSymbol = tsl.typeSymbol;
            if (!typeSymbol.isAnonymousInnerClass()) {
                Object var15_14;
                RawClassSymbol classSymbol = (RawClassSymbol)typeSymbol.resolveType(parser, 0, true, true, false);
                Object state = parser.saveResolutionState(classSymbol);
                try {
                    RawClassSymbol orgInnerClassSymbol = classSymbol;
                    RawClassSymbol innerClassSymbol = classSymbol;
                    StringBuffer nameBuf = new StringBuffer();
                    nameBuf.append(innerClassSymbol.identifier.name);
                    while (innerClassSymbol.isInnerClass()) {
                        RawClassSymbol outerClass = innerClassSymbol.getOuterClass();
                        nameBuf.insert(0, '$');
                        nameBuf.insert(0, outerClass.identifier.name);
                        Identifier classIdent = Identifier.getIdentifier(nameBuf.toString());
                        Scope outerScope = outerClass.scope;
                        Symbol otherClassSymbol = outerScope.lookupSpecificSymbolInScope(classIdent, 32, true);
                        if (otherClassSymbol != null) {
                            parser.error(Message.errorDuplicateDefinition, orgInnerClassSymbol.pos, false, orgInnerClassSymbol.errorName());
                        }
                        innerClassSymbol = innerClassSymbol.getOuterClass();
                    }
                    resolutionFailures += classSymbol.resolveSuperClass(parser, false);
                    resolutionFailures += classSymbol.resolveInterfaces(parser);
                    resolutionFailures += classSymbol.resolveTypeParameters(parser);
                    resolutionFailures += classSymbol.resolveInnerClasses(parser);
                    tsl.typeSymbol = classSymbol;
                    var15_14 = null;
                    parser.restoreResolutionState(state);
                }
                catch (Throwable throwable) {
                    var15_14 = null;
                    parser.restoreResolutionState(state);
                    throw throwable;
                }
            }
            tsl = tsl.next;
        }
        return resolutionFailures;
    }

    void checkInnerClasses(Parser parser) {
        TypeSymbolList tsl = this.cd.innerClassList;
        while (tsl != null) {
            TypeSymbol typeSymbol = tsl.typeSymbol;
            if (!typeSymbol.isAnonymousInnerClass()) {
                this.checkComplexCyclicInheritance(parser, (InnerClassSymbol)typeSymbol);
            }
            tsl = tsl.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveFields(Parser parser) {
        FieldSymbol fieldSymbol;
        FieldSymbol saveCurrentFieldSymbol = parser.currentFieldSymbol;
        try {
            fieldSymbol = this.cd.fieldList;
            while (fieldSymbol != null) {
                parser.currentFieldSymbol = fieldSymbol;
                parser.currentResolveTypePos = fieldSymbol.tpos;
                fieldSymbol.type = fieldSymbol.type.resolveType(parser, fieldSymbol.tpos, true, true, false, true);
                if (parser.currentClassSymbol != null && !fieldSymbol.isSynthetic()) {
                    parser.currentClassSymbol.addNameReference(parser, fieldSymbol.type, fieldSymbol.tpos);
                    parser.currentClassSymbol.addNameDeclaration(parser, fieldSymbol, fieldSymbol.pos);
                }
                fieldSymbol = fieldSymbol.nextInClass;
            }
            Object var5_4 = null;
            parser.currentFieldSymbol = saveCurrentFieldSymbol;
            parser.currentResolveTypePos = 0;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            parser.currentFieldSymbol = saveCurrentFieldSymbol;
            parser.currentResolveTypePos = 0;
            throw throwable;
        }
        if (!(this.isEnum() || this.isAnonymousInnerClass() || !this.isSerializable() || (fieldSymbol = (FieldSymbol)this.classScope.lookupSpecificSymbolInScope(Identifier.serialVersionUIDIdentifier, 2, false)) != null && (fieldSymbol.access & 0x18) == 24 && fieldSymbol.type == TypeSymbol.longSymbol)) {
            parser.warning(this, Message.warningNoSerialVersionUID, this.pos, this.errorName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveMethods(Parser parser) {
        try {
            MethodSymbol methodSymbol = this.cd.methodList;
            while (methodSymbol != null) {
                TypeSymbol typeSymbol;
                parser.currentMethodSymbol = methodSymbol;
                TypeParameterList tpl = methodSymbol.typeParameterList;
                if (tpl != null) {
                    methodSymbol.flags = (short)(methodSymbol.flags | 0x100);
                    do {
                        parser.currentResolveTypePos = tpl.typeParameter.pos;
                        typeSymbol = tpl.typeParameter.resolveType(parser, 0, true, true, false);
                        if (typeSymbol.isErroneous()) {
                            tpl.typeParameter.bound = parser.javaLangObjectPcs;
                            tpl.typeParameter.interfaceBounds = null;
                            continue;
                        }
                        tpl.typeParameter = (TypeParameterSymbol)typeSymbol;
                        if (parser.currentClassSymbol == null) continue;
                        parser.currentClassSymbol.addNameReference(parser, tpl.typeParameter.bound, tpl.typeParameter.boundPos);
                        ClassSymbolList interfaceBounds = tpl.typeParameter.interfaceBounds;
                        while (interfaceBounds != null) {
                            parser.currentClassSymbol.addNameReference(parser, interfaceBounds.classSymbol, interfaceBounds.getPos());
                            interfaceBounds = interfaceBounds.next;
                        }
                    } while ((tpl = tpl.next) != null);
                }
                MethodSymbol.ThrowsList tl = methodSymbol.throwsList;
                while (tl != null) {
                    parser.currentResolveTypePos = tl.getPos();
                    typeSymbol = tl.throwsType.resolveType(parser, tl.getPos(), true, true, false);
                    if (parser.currentClassSymbol != null) {
                        parser.currentClassSymbol.addNameReference(parser, typeSymbol, tl.getPos());
                    }
                    if (typeSymbol.involvesGenerics()) {
                        methodSymbol.flags = (short)(methodSymbol.flags | 0x100);
                    }
                    tl.throwsType = typeSymbol;
                    tl = tl.next;
                }
                parser.currentResolveTypePos = methodSymbol.tpos;
                methodSymbol.resultType = typeSymbol = methodSymbol.resultType.resolveType(parser, methodSymbol.tpos, false, true, false, true);
                if (typeSymbol.involvesGenerics()) {
                    methodSymbol.flags = (short)(methodSymbol.flags | 0x100);
                }
                if (parser.currentClassSymbol != null) {
                    parser.currentClassSymbol.addNameReference(parser, typeSymbol, methodSymbol.tpos);
                }
                if (methodSymbol.actualArgCount > 255) {
                    parser.error(Error.errorTooManyParameters, methodSymbol.pos, methodSymbol.isErroneous(), methodSymbol.errorName());
                }
                for (int i = 0; i < methodSymbol.localVarCount; ++i) {
                    MethodVariableSymbol varSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i);
                    if (varSymbol == null) continue;
                    parser.currentResolveTypePos = varSymbol.tpos;
                    varSymbol.type = typeSymbol = varSymbol.type.resolveType(parser, varSymbol.tpos, false, true, false, true);
                    if (parser.currentClassSymbol != null) {
                        parser.currentClassSymbol.addNameReference(parser, typeSymbol, varSymbol.tpos);
                    }
                    if (i >= methodSymbol.actualArgCount || !typeSymbol.involvesGenerics()) continue;
                    methodSymbol.flags = (short)(methodSymbol.flags | 0x100);
                }
                if (parser.currentClassSymbol != null && !methodSymbol.isDefaultConstructor()) {
                    int declPos = methodSymbol.isConstructor() ? methodSymbol.tpos : methodSymbol.pos;
                    parser.currentClassSymbol.addNameDeclaration(parser, methodSymbol, declPos);
                }
                methodSymbol = methodSymbol.nextInClass;
            }
            Object var10_10 = null;
            parser.currentMethodSymbol = null;
            parser.currentResolveTypePos = 0;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            parser.currentMethodSymbol = null;
            parser.currentResolveTypePos = 0;
            throw throwable;
        }
    }

    void checkInterfaces(Parser parser, int pos) {
        for (ClassSymbol classSymbol = this; classSymbol != null; classSymbol = ((ClassSymbol)classSymbol).getSuperClassSymbol()) {
            ImplementationList implList1 = ((ClassSymbol)classSymbol).getImplementationList();
            while (implList1 != null) {
                ClassSymbol interfaceSymbol = implList1.interfaceSymbol;
                if (interfaceSymbol instanceof UnresolvedClassSymbol) {
                    implList1.interfaceSymbol = interfaceSymbol = (ClassSymbol)interfaceSymbol.resolveType(parser, 0, true, true, false);
                }
                if (!interfaceSymbol.isErroneous()) {
                    RawClassSymbol classSym = interfaceSymbol.getClassSymbol();
                    ImplementationList implList2 = implList1.next;
                    while (implList2 != null) {
                        if (classSym.equalTo(implList2.interfaceSymbol.getClassSymbol())) {
                            parser.error(Message.errorRepeatedInheritance, pos, false, classSym.errorName());
                        }
                        implList2 = implList2.next;
                    }
                    if (!classSym.isInterface()) {
                        parser.error(Message.errorNotInterface, pos, false, classSym.errorName());
                    }
                    classSym.checkInterfaces(parser, pos);
                }
                implList1 = implList1.next;
            }
        }
    }

    void addInheritedInterfaceMethods(Parser parser) {
        if (!$assertionsDisabled && (this.access & 0x400) == 0) {
            throw new AssertionError();
        }
        int i = this.cd.methodTable.length;
        while (--i >= 0) {
            MethodSymbol methodSymbol = this.cd.methodTable[i];
            if ((methodSymbol.access & 0x400) == 0 || this == methodSymbol.definingClass || !methodSymbol.definingClass.isInterface()) continue;
            MethodSymbol method = new MethodSymbol(0, this, methodSymbol.identifier, methodSymbol.resultType, 0, methodSymbol.access, null, true);
            method.argumentList = methodSymbol.argumentList;
            method.argCount = methodSymbol.argCount;
            method.localVarCount = method.actualArgCount = methodSymbol.actualArgCount;
            i = method.localVarCount;
            while (--i >= 0) {
                method.cmd.localVariables.add(null);
            }
            method.nextInClass = this.cd.methodList;
            this.cd.methodList = method;
        }
    }

    static void makeEnumAbstract(RawClassSymbol rawClassSymbol) {
        if (!($assertionsDisabled || rawClassSymbol.isEnum() && !rawClassSymbol.isAnonymousInnerClass())) {
            throw new AssertionError();
        }
        rawClassSymbol.access = (short)(rawClassSymbol.access | 0x400);
        TypeSymbolList tsl = rawClassSymbol.cd.innerClassList;
        while (tsl != null) {
            if (tsl.typeSymbol.isEnum() && tsl.typeSymbol.isAnonymousInnerClass()) {
                AnonymousClassSymbol enumConstant = (AnonymousClassSymbol)tsl.typeSymbol;
                enumConstant.superClass.access = (short)(enumConstant.superClass.access | 0x400);
            }
            tsl = tsl.next;
        }
    }

    void checkImplementationsOfAbstractMethods(Parser parser) {
        boolean hasAbstractSuperClass = false;
        ClassSymbol superClass = this.getSuperClassSymbol();
        if (superClass != null && (superClass.access & 0x400) != 0) {
            hasAbstractSuperClass = true;
        }
        int i = this.cd.methodTable.length;
        while (--i >= 0) {
            MethodSymbol methodSymbol = this.cd.methodTable[i];
            if ((methodSymbol.access & 0x400) == 0 || methodSymbol.definingClass != this && !this.implementsInterfaceDirectlyIndirectly(methodSymbol.definingClass) && !hasAbstractSuperClass) continue;
            boolean isEnumWithConstants = false;
            if (this.isEnum() && !this.isAnonymousInnerClass()) {
                TypeSymbolList tsl = this.cd.innerClassList;
                while (tsl != null) {
                    if (tsl.typeSymbol.isEnum() && tsl.typeSymbol.isAnonymousInnerClass()) {
                        isEnumWithConstants = true;
                        break;
                    }
                    tsl = tsl.next;
                }
            }
            if (isEnumWithConstants) {
                RawClassSymbol.makeEnumAbstract(this);
                continue;
            }
            parser.error(Message.errorShouldBeAbstract, this.pos, methodSymbol.isErroneous(), this.errorName(), methodSymbol.errorName(), methodSymbol.definingClass.errorName());
        }
    }

    final void loadType(Parser parser, int pos, boolean lazy, boolean pushSymbolForErrorMessages) {
        RawClassSymbol context = parser.currentClassSymbol;
        this.loadType(parser, pos, context, lazy, pushSymbolForErrorMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void loadType(Parser parser, int pos, ClassSymbol fromClass, boolean lazy, boolean pushSymbolForErrorMessages) {
        block15: {
            if (this.classScope == null && (this.flags & 0x10) == 0) {
                if (pushSymbolForErrorMessages) {
                    parser.currentClassesBeingResolved.add(this);
                }
                try {
                    Storage sourceFile;
                    boolean savedSuspendStaticContextChecking = parser.suspendStaticContextChecking;
                    parser.suspendStaticContextChecking = true;
                    try {
                        ClassFileReader.readClassFile(parser, pos, this, lazy);
                        Object var10_7 = null;
                        parser.suspendStaticContextChecking = savedSuspendStaticContextChecking;
                    }
                    catch (Throwable throwable) {
                        Object var10_8 = null;
                        parser.suspendStaticContextChecking = savedSuspendStaticContextChecking;
                        throw throwable;
                    }
                    if (this.classScope == null && (sourceFile = parser.options.findStorageOfSource(this)) != null && parser.addSourceFile(sourceFile)) {
                        throw new NewSourceException();
                    }
                    if (this.classScope == null) {
                        this.flags = (short)(this.flags | 0x10);
                        StringBuffer location = new StringBuffer();
                        HashSet<String> previousClasses = new HashSet<String>();
                        for (int x = parser.currentClassesBeingResolved.size() - 2; x >= 0; --x) {
                            String name;
                            ClassSymbol loadClass = (ClassSymbol)parser.currentClassesBeingResolved.get(x);
                            if (loadClass == null || previousClasses.contains(name = loadClass.errorName())) continue;
                            previousClasses.add(name);
                            location.append(" ");
                            location.append(Message.inString);
                            location.append(" ");
                            location.append(name);
                        }
                        if (fromClass != null) {
                            location.append(" ");
                            location.append(Message.inString);
                            location.append(" ");
                            location.append(fromClass.errorName());
                        }
                        if (pos == 0) {
                            if (parser.currentResolveTypePos != 0) {
                                pos = parser.currentResolveTypePos;
                            } else if (parser.currentStatement != null) {
                                pos = parser.currentStatement.pos;
                            }
                        }
                        parser.error(Message.errorNotFound, pos, false, this.errorName(), location.toString());
                        this.classScope = new ClassScope(this, this.scope, parser);
                        this.superClass = parser.javaLangObjectPcs;
                        this.access = (short)(this.access | 1);
                        this.cd.methodTable = new MethodSymbol[0];
                    }
                    Object var14_16 = null;
                    if (!pushSymbolForErrorMessages) break block15;
                    int len = parser.currentClassesBeingResolved.size();
                    parser.currentClassesBeingResolved.remove(len - 1);
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    if (pushSymbolForErrorMessages) {
                        int len = parser.currentClassesBeingResolved.size();
                        parser.currentClassesBeingResolved.remove(len - 1);
                    }
                    throw throwable;
                }
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveFieldInitializers(Parser parser) {
        FieldSymbol saveCurrentFieldSymbol = parser.currentFieldSymbol;
        try {
            short access;
            ArrayList<FieldSymbol> al = new ArrayList<FieldSymbol>();
            FieldSymbol fieldSymbol = this.cd.fieldList;
            while (fieldSymbol != null) {
                if (fieldSymbol.initializer != null) {
                    al.add(fieldSymbol);
                }
                fieldSymbol = fieldSymbol.nextInClass;
            }
            parser.suspendDataFlowChecking = true;
            int size = al.size();
            parser.defSet = new BitSet(size);
            parser.posSet = new BitSet(size);
            parser.useSet = new BitSet(size);
            int i = size;
            while (--i >= 0) {
                fieldSymbol = (FieldSymbol)al.get(i);
                if (!$assertionsDisabled && fieldSymbol.initializer == null) {
                    throw new AssertionError();
                }
                access = fieldSymbol.access;
                if ((access & 8) == 0) continue;
                parser.currentFieldSymbol = fieldSymbol;
                if (fieldSymbol.initializer.takeAssignmentContext()) {
                    parser.assignmentContext = fieldSymbol.type;
                }
                parser.currentResolveTypePos = fieldSymbol.initializer.pos;
                Expression initializer = fieldSymbol.initializer.resolveAndCheck(parser);
                this.makeNonConstInitializerConst(parser, fieldSymbol, initializer);
                fieldSymbol.initializer = initializer;
                fieldSymbol.flags = (short)(fieldSymbol.flags | 4);
            }
            i = size;
            while (--i >= 0) {
                fieldSymbol = (FieldSymbol)al.get(i);
                access = fieldSymbol.access;
                if ((access & 8) != 0) continue;
                parser.currentFieldSymbol = fieldSymbol;
                if (fieldSymbol.initializer.takeAssignmentContext()) {
                    parser.assignmentContext = fieldSymbol.type;
                }
                parser.currentResolveTypePos = fieldSymbol.initializer.pos;
                fieldSymbol.initializer = fieldSymbol.initializer.resolveAndCheck(parser);
                fieldSymbol.flags = (short)(fieldSymbol.flags | 4);
            }
            Object var10_9 = null;
            parser.currentResolveTypePos = 0;
            parser.suspendDataFlowChecking = false;
            parser.defSet = null;
            parser.posSet = null;
            parser.useSet = null;
            parser.currentStatement = null;
            parser.currentFieldSymbol = saveCurrentFieldSymbol;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            parser.currentResolveTypePos = 0;
            parser.suspendDataFlowChecking = false;
            parser.defSet = null;
            parser.posSet = null;
            parser.useSet = null;
            parser.currentStatement = null;
            parser.currentFieldSymbol = saveCurrentFieldSymbol;
            throw throwable;
        }
    }

    boolean findConstantFields(Parser parser) {
        boolean newConstFound = false;
        FieldSymbol fieldSymbol = this.cd.fieldList;
        while (fieldSymbol != null) {
            short access;
            Expression initializer = fieldSymbol.initializer;
            if (initializer != null && ((access = fieldSymbol.access) & 8) != 0 && (fieldSymbol.flags & 2) == 0 && (initializer = initializer.constantFolding(parser)) != fieldSymbol.initializer) {
                if (this.makeNonConstInitializerConst(parser, fieldSymbol, initializer)) {
                    newConstFound = true;
                }
                fieldSymbol.initializer = initializer;
            }
            fieldSymbol = fieldSymbol.nextInClass;
        }
        return newConstFound;
    }

    private boolean makeNonConstInitializerConst(Parser parser, FieldSymbol fieldSymbol, Expression initializer) {
        short access = fieldSymbol.access;
        if ((access & 0x10) != 0 && initializer.kind == 2) {
            boolean assignConstantValue = false;
            if (initializer instanceof StringConstantExpression && fieldSymbol.type.equalTo(parser.javaLangStringSymbol)) {
                assignConstantValue = true;
            } else if ((initializer.getType().typeClass & 0xFFFFFFC0) == 0 && (fieldSymbol.type.typeClass & 0xFFFFFFC0) == 0) {
                assignConstantValue = true;
            }
            if (assignConstantValue) {
                this.flags = (short)(this.flags | 2);
                fieldSymbol.flags = (short)(fieldSymbol.flags | 2);
                this.removeNonConstStaticInitializer(fieldSymbol);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void assignFieldInitializers(Parser parser) {
        saveCurrentFieldSymbol = parser.currentFieldSymbol;
        try {
            fieldSymbol = this.cd.fieldList;
            while (fieldSymbol != null) {
                block5: {
                    block6: {
                        parser.currentFieldSymbol = fieldSymbol;
                        initializer = fieldSymbol.initializer;
                        if (initializer == null) break block5;
                        fType = fieldSymbol.type;
                        iType = initializer.getType();
                        if (!iType.isErroneous() && !fType.isErroneous()) break block6;
                        fieldSymbol.initializer = ErrorExpression.errorExpression;
                        break block5;
                    }
                    if (!fType.isReferenceType() || !iType.isReferenceType()) ** GOTO lbl22
                    iRefType = (ReferenceTypeSymbol)iType;
                    fRefType = (ReferenceTypeSymbol)fType;
                    if (!iRefType.isAssignmentCompatible(parser, fRefType)) {
                        error = parser.error(Message.errorIncompatibleTypes, initializer.pos, false, iType.errorName(), fType.errorName());
                        fieldSymbol.initializer = new ErrorExpression(error);
                    } else {
                        fType.checkForUncheckedConversion(parser, initializer.pos, iType, false);
lbl22:
                        // 2 sources

                        fieldSymbol.initializer = initializer.promoteType(parser, fType);
                    }
                }
                fieldSymbol = fieldSymbol.nextInClass;
            }
            var11_10 = null;
            parser.currentFieldSymbol = saveCurrentFieldSymbol;
        }
        catch (Throwable var10_12) {
            var11_11 = null;
            parser.currentFieldSymbol = saveCurrentFieldSymbol;
            throw var10_12;
        }
        this.flushNonConstStaticInitializers();
    }

    void resolveMethodBodies(Parser parser) {
        long ms = System.currentTimeMillis();
        MethodSymbol methodSymbol = this.cd.methodList;
        while (methodSymbol != null) {
            if (!methodSymbol.isConstructor()) {
                methodSymbol.resolveMethod(parser);
            }
            methodSymbol = methodSymbol.nextInClass;
        }
        if ((this.access & 0x200) == 0) {
            methodSymbol = this.cd.methodList;
            while (methodSymbol != null) {
                if (methodSymbol.isConstructor() && (this.isEnum() || !this.isAnonymousInnerClass())) {
                    methodSymbol.resolveMethod(parser);
                }
                methodSymbol = methodSymbol.nextInClass;
            }
        }
        FieldSymbol fieldSymbol = this.cd.fieldList;
        while (fieldSymbol != null) {
            if (!fieldSymbol.isSynthetic()) {
                if ((fieldSymbol.access & 0x10) != 0 && (fieldSymbol.flags & Short.MIN_VALUE) == 0) {
                    if ((fieldSymbol.access & 8) != 0) {
                        parser.error(Message.errorNotInitialized, fieldSymbol.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName());
                    } else if ((fieldSymbol.flags & 0x4000) != 0) {
                        parser.error(Message.errorNotInitialized, fieldSymbol.pos, fieldSymbol.isErroneous(), fieldSymbol.errorName());
                    }
                }
                if ((fieldSymbol.access & 8) != 0 && (fieldSymbol.flags & 2) == 0 && !this.isEnum() && !this.isInterface() && (this.isNonStaticInnerClass() || this.isLocalInnerClass())) {
                    parser.error(Message.errorInnerCannotHaveStatics, fieldSymbol.pos, false);
                }
            }
            fieldSymbol = fieldSymbol.nextInClass;
        }
        methodSymbol = (MethodSymbol)this.classScope.lookupSpecificSymbolInScope(Identifier.initializerIdentifier, 8, true);
        while (methodSymbol != null) {
            if ((methodSymbol.flags & 2) != 0) {
                ExpressionStatement exprStmt;
                StatementList stmtList;
                MethodSymbol method = methodSymbol;
                while ((stmtList = method.cmd.statementList) != null && (exprStmt = (ExpressionStatement)stmtList.first) != null && !(exprStmt.expr instanceof ErrorExpression)) {
                    InvokeExpression invokeExpr = (InvokeExpression)exprStmt.expr;
                    method = (MethodSymbol)invokeExpr.method;
                    if (method == null || (method.flags & 2) == 0) break;
                    if (method != methodSymbol) continue;
                    parser.error(Error.errorCyclicConstructors, methodSymbol.pos, false, methodSymbol.errorName());
                    break;
                }
            }
            methodSymbol = methodSymbol.nextWithSameName;
        }
        if (!this.isInterface() && !this.isAnonymousInnerClass() && (this.isNonStaticInnerClass() || this.isLocalInnerClass())) {
            TypeSymbolList tsl = this.cd.innerClassList;
            while (tsl != null) {
                if ((tsl.typeSymbol.access & 8) != 0 && !tsl.typeSymbol.isSynthetic()) {
                    parser.error(Message.errorInnerCannotHaveStatics, tsl.typeSymbol.pos, false);
                }
                tsl = tsl.next;
            }
        }
        if (parser.options.verbose) {
            parser.options.log.println("[" + Message.resolvingString + " " + this.toString() + " " + (System.currentTimeMillis() - ms) + "ms ]");
        }
    }

    private static boolean isValidElementType(Parser parser, TypeSymbol typeSymbol) {
        if (typeSymbol.isArrayType()) {
            ArraySymbol arraySymbol = (ArraySymbol)typeSymbol;
            if (arraySymbol.dimension > 1) {
                return false;
            }
            typeSymbol = arraySymbol.baseType;
        }
        return typeSymbol.isNumericType() || typeSymbol.typeKind == 2 || typeSymbol.equalTo(parser.javaLangStringSymbol) || typeSymbol.equalTo(parser.javaLangClassSymbol) || (typeSymbol.access & 0x6000) != 0;
    }

    void resolveClassAnnotationTypes(Parser parser) {
        if (this.annotation != null) {
            this.annotation.resolveAnnotationType(parser, this);
        }
    }

    void resolveMethodAndFieldAnnotationTypes(Parser parser) {
        MethodSymbol methodSymbol = this.cd.methodList;
        while (methodSymbol != null) {
            Annotation annot = methodSymbol.getAnnotations();
            if (annot != null) {
                annot.resolveAnnotationType(parser, methodSymbol);
                for (int i = 0; i < methodSymbol.localVarCount; ++i) {
                    MethodVariableSymbol varSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i);
                    if (varSymbol == null || varSymbol.annotation == null) continue;
                    varSymbol.annotation.resolveAnnotationType(parser, varSymbol);
                    methodSymbol.flags = (short)(methodSymbol.flags | 0x40);
                }
            }
            methodSymbol = methodSymbol.nextInClass;
        }
        FieldSymbol fieldSymbol = this.cd.fieldList;
        while (fieldSymbol != null) {
            if (fieldSymbol.annotation != null) {
                fieldSymbol.annotation.resolveAnnotationType(parser, fieldSymbol);
            }
            fieldSymbol = fieldSymbol.nextInClass;
        }
    }

    void resolveClassAnnotations(Parser parser) {
        if (this.annotation != null) {
            this.annotation.resolveAndCheck(parser, this);
        }
    }

    void resolveMethodAndFieldAnnotations(Parser parser) {
        parser.suspendDataFlowChecking = true;
        short size = this.cd.fieldCount;
        parser.defSet = new BitSet(size);
        parser.posSet = new BitSet(size);
        parser.useSet = new BitSet(size);
        MethodSymbol methodSymbol = this.cd.methodList;
        while (methodSymbol != null) {
            Annotation annot;
            TypeSymbol typeSymbol;
            if (this.isAnnotation() && !methodSymbol.isClassInitializer() && !RawClassSymbol.isValidElementType(parser, typeSymbol = methodSymbol.resultType)) {
                parser.error(Message.errorTypeNotAllowed, methodSymbol.tpos, typeSymbol.isErroneous(), typeSymbol.errorName());
            }
            if ((annot = methodSymbol.getAnnotations()) != null) {
                annot.resolveAndCheck(parser, methodSymbol);
            }
            for (int i = 0; i < methodSymbol.localVarCount; ++i) {
                MethodVariableSymbol varSymbol = (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(i);
                if (varSymbol == null || varSymbol.annotation == null) continue;
                varSymbol.annotation.resolveAndCheck(parser, varSymbol);
            }
            methodSymbol = methodSymbol.nextInClass;
        }
        FieldSymbol fieldSymbol = this.cd.fieldList;
        while (fieldSymbol != null) {
            if (fieldSymbol.annotation != null) {
                fieldSymbol.annotation.resolveAndCheck(parser, fieldSymbol);
            }
            fieldSymbol = fieldSymbol.nextInClass;
        }
        parser.suspendDataFlowChecking = false;
        parser.defSet = null;
        parser.posSet = null;
        parser.useSet = null;
    }

    void checkBoundsOfSupers(Parser parser) {
        if (this.superClass != null && this.superClass.isParameterizedClass()) {
            ((ParameterizedClassSymbol)this.superClass).checkBounds(parser);
        }
        ImplementationList implList = this.getImplementationList();
        while (implList != null) {
            ClassSymbol interfaceSymbol = implList.interfaceSymbol;
            if (interfaceSymbol.isParameterizedClass()) {
                ((ParameterizedClassSymbol)interfaceSymbol).checkBounds(parser);
            }
            implList = implList.next;
        }
    }

    private MethodSymbol findMethod(Identifier identifier, ArgumentVariableList argList) {
        MethodSymbol methodSymbol = this.cd.methodList;
        while (methodSymbol != null) {
            if (!methodSymbol.isSynthetic() && methodSymbol.compareMethod(identifier, argList, null)) {
                return methodSymbol;
            }
            methodSymbol = methodSymbol.nextInClass;
        }
        return null;
    }

    boolean findBridgeMethod(MethodSymbol method) {
        MethodSymbol methodSymbol = this.cd.methodList;
        while (methodSymbol != null) {
            if (methodSymbol.isBridgeMethod() && methodSymbol.identifier == method.identifier && methodSymbol.argCount == method.argCount && Identifier.compare(methodSymbol.getSignature(), method.getSignature())) {
                return true;
            }
            methodSymbol = methodSymbol.nextInClass;
        }
        return false;
    }

    private void checkForAndCreateBridgeMethod(MethodSymbol methodSymbol, TypeParameterList tpl, TypeVariableList tvl) {
        ArgumentVariableList argList;
        if ((methodSymbol.access & 8) != 0 || methodSymbol.isConstructor() || methodSymbol.isGenerated() || methodSymbol.isSynthetic()) {
            return;
        }
        if (tvl == null) {
            argList = methodSymbol.argumentList;
        } else {
            TypeSymbol resultType = methodSymbol.resultType;
            ArgumentVariableList argLast = null;
            argList = null;
            short index = 1;
            ArgumentVariableList sl = methodSymbol.argumentList;
            while (sl != null) {
                TypeSymbol typeSymbol = sl.argSymbol.type;
                if (typeSymbol.containsTypeParameterDefinedBy(null)) {
                    typeSymbol = typeSymbol.applyTypeVariables(tpl, tvl);
                }
                short s = index;
                index = (short)(index + 1);
                ArgumentVariableList sl2 = new ArgumentVariableList(new ArgumentVariableSymbol(0, null, null, typeSymbol, 0, 0, null, s));
                if (argList == null) {
                    argList = argLast = sl2;
                } else {
                    argLast.next = sl2;
                    argLast = sl2;
                }
                sl = sl.next;
            }
        }
        MethodSymbol methSym = this.findMethod(methodSymbol.identifier, argList);
        if (methSym != null && !Identifier.compare(methSym.getSignature(), methodSymbol.getSignature()) && this.compareMethods(methSym, methodSymbol.definingClass, methodSymbol) && !this.findBridgeMethod(methodSymbol)) {
            this.createBridgeMethod(methodSymbol, methSym);
        }
    }

    void createBridgeMethod(MethodSymbol copyMethod, MethodSymbol bridgeToMethod) {
        MethodSymbol bridgeMethod = new MethodSymbol(0, this, copyMethod.identifier, copyMethod.resultType, 0, (short)(copyMethod.access & 0xFFFFFAFF | 0x40 | 0x1000), null, true);
        bridgeMethod.argumentList = copyMethod.argumentList;
        bridgeMethod.argCount = copyMethod.argCount;
        bridgeMethod.localVarCount = bridgeMethod.actualArgCount = copyMethod.actualArgCount;
        bridgeMethod.flags = (short)(bridgeMethod.flags | 1);
        bridgeMethod.throwsList = MethodSymbol.ThrowsList.copyIntoCompiledThrowsList(copyMethod.throwsList);
        short i = bridgeMethod.localVarCount;
        while ((i = (short)(i - 1)) >= 0) {
            bridgeMethod.cmd.localVariables.add(null);
        }
        bridgeMethod.annotation = bridgeToMethod;
        bridgeMethod.nextInClass = this.cd.methodList;
        this.cd.methodList = bridgeMethod;
    }

    private void addBridgeMethodsToClass(Parser parser, ParameterizedClassSymbol pcs) {
        TypeParameterList tpl = pcs.genericClassSymbol.cd.getTypeParameterList();
        TypeVariableList tvl = pcs.typeVariableList;
        MethodSymbol methodSymbol = pcs.genericClassSymbol.cd.methodList;
        while (methodSymbol != null) {
            this.checkForAndCreateBridgeMethod(methodSymbol, tpl, tvl);
            methodSymbol = methodSymbol.nextInClass;
        }
    }

    private void addBridgeMethodsToInterface(Parser parser, ClassSymbol classSymbol) {
        ImplementationList impl = classSymbol.getImplementationList();
        while (impl != null) {
            ParameterizedClassSymbol ipcs = (ParameterizedClassSymbol)impl.interfaceSymbol;
            this.addBridgeMethodsToClass(parser, ipcs);
            this.addBridgeMethodsToInterface(parser, ipcs);
            impl = impl.next;
        }
    }

    private void addBridgeMethods(Parser parser) {
        if (this.isInterface()) {
            return;
        }
        for (ParameterizedClassSymbol pcs = (ParameterizedClassSymbol)this.superClass; pcs != null; pcs = (ParameterizedClassSymbol)pcs.getSuperClassSymbol()) {
            this.addBridgeMethodsToClass(parser, pcs);
            this.addBridgeMethodsToInterface(parser, pcs);
        }
        this.addBridgeMethodsToInterface(parser, this);
    }

    void checkPrivateFieldAndMethodUsage(Parser parser) {
        FieldSymbol fieldSymbol = this.cd.fieldList;
        while (fieldSymbol != null) {
            if ((fieldSymbol.access & 2) != 0 && (fieldSymbol.flags & 0x2000) == 0 && !fieldSymbol.isSynthetic() && fieldSymbol.identifier != Identifier.serialVersionUIDIdentifier) {
                if (parser.defSet != null && parser.defSet.get(fieldSymbol.index) || fieldSymbol.initializer != null) {
                    parser.warning(fieldSymbol, Message.warningVarAssignmentNeverRead, fieldSymbol.pos, fieldSymbol.errorName());
                } else {
                    parser.warning(fieldSymbol, Message.warningVariableNeverRead, fieldSymbol.pos, fieldSymbol.errorName());
                }
            }
            fieldSymbol = fieldSymbol.nextInClass;
        }
        MethodSymbol methodSymbol = this.cd.methodList;
        while (methodSymbol != null) {
            if (!((methodSymbol.access & 2) == 0 || (methodSymbol.flags & 0x10) != 0 || methodSymbol.isSynthetic() || methodSymbol.isConstructor() || methodSymbol.isClassInitializer())) {
                parser.warning(methodSymbol, Message.warningMethodNeverCalled, methodSymbol.pos, methodSymbol.errorName());
            }
            methodSymbol = methodSymbol.nextInClass;
        }
    }

    private MethodSymbol findGeneratedMethod(Identifier identifier) {
        MethodSymbol methodSymbol = (MethodSymbol)this.classScope.lookupSpecificSymbolInScope(identifier, 8, true);
        if (!$assertionsDisabled && methodSymbol == null) {
            throw new AssertionError();
        }
        while ((methodSymbol.flags & 0x20) == 0) {
            methodSymbol = methodSymbol.nextWithSameName;
            if (!$assertionsDisabled && methodSymbol == null) {
                throw new AssertionError();
            }
        }
        return methodSymbol;
    }

    void generateCode(Parser parser) {
        long ms = System.currentTimeMillis();
        if (this.cd.ccd.constantPool == null) {
            this.cd.ccd.constantPool = new ConstantPool(parser);
        }
        this.removeDynamicInitializer();
        ByteCodeGenerator byteCodeGenerator = null;
        MethodSymbol methodSymbol = null;
        try {
            if ((this.flags & 8) != 0) {
                this.cd.ccd.classLoaderMethod = methodSymbol = this.getClassLoaderMethod(parser);
                ++methodSymbol.cmd.estimatedLineCount;
                byteCodeGenerator = new ByteCodeGenerator(parser, methodSymbol);
                byteCodeGenerator.generateClassDollarMethod();
                byteCodeGenerator.finish();
            }
            if (this.isEnum() && !this.isAnonymousInnerClass()) {
                MethodSymbol m = this.findGeneratedMethod(Identifier.valuesIdentifier);
                ++m.cmd.estimatedLineCount;
                byteCodeGenerator = new ByteCodeGenerator(parser, m);
                byteCodeGenerator.generateEnumValuesMethod();
                byteCodeGenerator.finish();
                m = this.findGeneratedMethod(Identifier.valueOfIdentifier);
                ++m.cmd.estimatedLineCount;
                byteCodeGenerator = new ByteCodeGenerator(parser, m);
                byteCodeGenerator.generateEnumValueOfMethod();
                byteCodeGenerator.finish();
            }
            methodSymbol = this.cd.methodList;
            while (methodSymbol != null) {
                if (methodSymbol.isBridgeMethod()) {
                    ++methodSymbol.cmd.estimatedLineCount;
                    byteCodeGenerator = new ByteCodeGenerator(parser, methodSymbol);
                    byteCodeGenerator.generateBridgeMethod((MethodSymbol)methodSymbol.annotation);
                    byteCodeGenerator.finish();
                } else {
                    byteCodeGenerator = null;
                    methodSymbol.generateMethod(parser);
                }
                methodSymbol = methodSymbol.nextInClass;
            }
        }
        catch (RuntimeException e) {
            parser.stateAtInternalError = new Parser.ResolutionState();
            parser.stateAtInternalError.currentClassSymbol = this;
            parser.stateAtInternalError.currentMethodSymbol = methodSymbol;
            parser.stateAtInternalError.currentStatement = parser.currentStatement;
            parser.stateAtInternalError.sourceFile = this.cd.ccd.sourceFile;
            throw e;
        }
        if (parser.options.verbose) {
            parser.options.log.println("[" + Message.generatingString + " " + this.toString() + " " + (System.currentTimeMillis() - ms) + "ms ]");
        }
    }

    void generateClass(Parser parser) {
        long ms = System.currentTimeMillis();
        Options options = parser.options;
        try {
            String internalName;
            String className;
            Storage storage;
            if (options.destinationDir != null) {
                int index;
                if (options.destinationFile == null) {
                    File destFile = new File(options.destinationDir);
                    if (!destFile.exists() && !destFile.mkdirs()) {
                        parser.error(Message.errorUnableToCreateOutputDir, 0, false, options.destinationDir);
                    }
                    options.destinationFile = new DirectoryStorage(destFile);
                }
                storage = options.destinationFile;
                className = new String(this.getInternalName());
                int prevIndex = 0;
                while ((index = className.indexOf(47, prevIndex)) >= 0) {
                    String packageName = className.substring(prevIndex, index);
                    if (!(storage = storage.createDir(packageName)).isDirectory()) {
                        parser.error(Message.errorUnableToCreateOutputDir, 0, false, storage.getPath());
                        return;
                    }
                    prevIndex = index + 1;
                }
                className = className.substring(prevIndex);
            } else {
                storage = new DirectoryStorage(new File(this.cd.ccd.sourceFile.getPath()).getParentFile());
                className = new String(this.getClassName());
            }
            storage = storage.create(className + ".class");
            ClassFileWriter classFileWriter = new ClassFileWriter(parser, this, storage, parser.writeBuffer);
            classFileWriter.createClassFile(this.cd.ccd.sourceFile.getName());
            storage.close();
            long lastModifiedDate = -1L;
            if (System.getProperty("resetClassTimestampToSource") != null && storage instanceof FileStorage) {
                lastModifiedDate = this.cd.ccd.sourceFile.storage.modDate();
                ((FileStorage)storage).setLastModified(lastModifiedDate);
            }
            if (parser.options.makeFile != null) {
                parser.depInfo.addClassDate(this, storage.modDate());
                if (lastModifiedDate != -1L && lastModifiedDate != storage.modDate()) {
                    System.out.println("ojc error: modified date for " + storage.getPath() + " should be " + lastModifiedDate + " instead of " + storage.modDate());
                }
            }
            ++parser.classFileCount;
            if (options.ideEnv != null && !options.ideEnv.authorizeWriting(storage, internalName = new String(this.getInternalName()).replace('/', '.').replace('+', '$'), null, 0, 0)) {
                throw new RuntimeException("user aborted");
            }
            if (options.verbose) {
                options.log.println("[" + Message.writingString + " " + storage.getPath() + " " + (System.currentTimeMillis() - ms) + "ms ]");
            }
        }
        catch (IOException e) {
            parser.error(Message.errorWriteError, 0, false, this.errorName());
        }
    }

    MethodSymbol getClassInitializer() {
        MethodSymbol methodSymbol = this.cd.ccd.classInitializer;
        if (methodSymbol == null) {
            short methodAccess = 8;
            if ((this.access & 0x800) != 0) {
                methodAccess = (short)(methodAccess | 0x800);
            }
            methodSymbol = new MethodSymbol(0, this, Identifier.classInitializerIdentifier, voidSymbol, 0, methodAccess, null, true);
            methodSymbol.cmd.statementList = new StatementList();
            methodSymbol.nextInClass = this.cd.methodList;
            this.cd.methodList = methodSymbol;
            this.cd.ccd.classInitializer = methodSymbol;
        }
        if (this.nonConstStaticInitializerList != null) {
            for (int i = 0; i < this.nonConstStaticInitializerList.size(); ++i) {
                FieldSymbol fieldSymbol = (FieldSymbol)this.nonConstStaticInitializerList.get(i);
                methodSymbol.addFieldInitializer(fieldSymbol, fieldSymbol.pos);
            }
            this.nonConstStaticInitializerList = null;
        }
        return methodSymbol;
    }

    boolean hasClassInitializer() {
        return this.cd.ccd.classInitializer != null;
    }

    void storeNonConstStaticInitializer(FieldSymbol fieldSymbol) {
        if (this.nonConstStaticInitializerList == null) {
            this.nonConstStaticInitializerList = new ArrayList();
        }
        this.nonConstStaticInitializerList.add(fieldSymbol);
    }

    void removeNonConstStaticInitializer(FieldSymbol fieldSymbol) {
        if (this.nonConstStaticInitializerList == null) {
            return;
        }
        for (int i = 0; i < this.nonConstStaticInitializerList.size(); ++i) {
            if (this.nonConstStaticInitializerList.get(i) != fieldSymbol) continue;
            this.nonConstStaticInitializerList.remove(i);
            break;
        }
        if (this.nonConstStaticInitializerList.isEmpty()) {
            this.nonConstStaticInitializerList = null;
        }
    }

    void flushNonConstStaticInitializers() {
        if (this.nonConstStaticInitializerList != null) {
            this.getClassInitializer();
        }
    }

    MethodSymbol getDynamicInitializer() {
        MethodSymbol methodSymbol = this.cd.ccd.dynamicInitializer;
        if (methodSymbol == null) {
            short methodAccess = 2;
            if ((this.access & 0x800) != 0) {
                methodAccess = (short)(methodAccess | 0x800);
            }
            methodSymbol = new MethodSymbol(0, this, Identifier.dynamicInitializerIdentifier, voidSymbol, 0, methodAccess, null, true);
            methodSymbol.cmd.statementList = new StatementList();
            methodSymbol.flags = (short)(methodSymbol.flags | 1);
            methodSymbol.localVarCount = 1;
            methodSymbol.actualArgCount = 1;
            methodSymbol.cmd.localVariables.add(null);
            methodSymbol.nextInClass = this.cd.methodList;
            this.cd.methodList = methodSymbol;
            this.cd.ccd.dynamicInitializer = methodSymbol;
        }
        return methodSymbol;
    }

    private Identifier getSyntheticName(String fieldName, int level) {
        StringBuffer sb = new StringBuffer();
        while (--level >= 0) {
            sb.append(Identifier.dollarCharacter);
        }
        sb.append(fieldName);
        return Identifier.getIdentifier(sb.toString());
    }

    private MethodSymbol getClassLoaderMethod(Parser parser) {
        Identifier identifier;
        RawClassSymbol loaderClass;
        if (this.isInterface()) {
            AnonymousClassSymbol anonClass = new AnonymousClassSymbol(0, 25);
            anonClass.superClass = parser.javaLangObjectPcs;
            anonClass.flags = (short)(anonClass.flags | 0x20);
            anonClass.cd.ccd.sourceFile = this.cd.ccd.sourceFile;
            anonClass.scope = this.classScope;
            anonClass.classScope = new ClassScope(anonClass, this.classScope, parser);
            anonClass.cd.ccd.constantPool = new ConstantPool(parser);
            if (parser.targetingAtLeastOneFive) {
                anonClass.access = (short)(anonClass.access | 0x1000);
            } else {
                anonClass.flags = (short)(anonClass.flags | 0x100);
            }
            parser.classResolutionList.classSymbolList.add(anonClass);
            TypeSymbolList tsl = new TypeSymbolList(anonClass);
            tsl.next = this.cd.innerClassList;
            this.cd.innerClassList = tsl;
            loaderClass = anonClass;
        } else {
            loaderClass = this;
        }
        int level = 0;
        while (this.classScope.lookupSpecificSymbolInScope(identifier = this.getSyntheticName("class$", level), 8, true) != null) {
            ++level;
        }
        MethodSymbol methodSymbol = new MethodSymbol(0, loaderClass, identifier, parser.javaLangClassSymbol, 0, 8, null, true);
        methodSymbol.flags = (short)(methodSymbol.flags | 0x21);
        methodSymbol.addArgument(parser.javaLangStringSymbol);
        methodSymbol.nextInClass = loaderClass.cd.methodList;
        loaderClass.cd.methodList = methodSymbol;
        return methodSymbol;
    }

    FieldSymbol getClassFieldSymbol(Parser parser, String name) {
        int level = 0;
        while (true) {
            Identifier identifier;
            FieldSymbol fieldSymbol;
            if ((fieldSymbol = (FieldSymbol)this.classScope.lookupSpecificSymbolInScope(identifier = this.getSyntheticName(name, level), 2, true)) == null) {
                fieldSymbol = new FieldSymbol(0, this, identifier, (TypeSymbol)parser.javaLangClassPcs, 0, 10, null);
                fieldSymbol.flags = (short)(fieldSymbol.flags | 0xFFFFA001);
                this.addField(fieldSymbol);
                this.classScope.enterSymbol(fieldSymbol);
                return fieldSymbol;
            }
            if ((fieldSymbol.flags & 1) != 0) {
                return fieldSymbol;
            }
            ++level;
        }
    }

    private int getClassNumber(RawClassSymbol outerClass) {
        if (!$assertionsDisabled && outerClass.cd.innerClassList == null) {
            throw new AssertionError();
        }
        int classNumber = 0;
        classNumber = 0;
        TypeSymbolList tsl = outerClass.cd.innerClassList;
        while (tsl != null) {
            if (this.equalTo(tsl.typeSymbol)) {
                classNumber = 0;
            }
            if (tsl.typeSymbol.identifier == this.identifier) {
                ++classNumber;
            }
            tsl = tsl.next;
        }
        return classNumber;
    }

    char[] getClassName() {
        if (!this.isInnerClass()) {
            return this.identifier.name;
        }
        if (this.scope.kind == 2 && !this.isAnonymousInnerClass()) {
            ClassScope classScope = (ClassScope)this.scope;
            char[] className = classScope.classSymbol.getClassName();
            int size = className.length + 1 + this.identifier.name.length;
            char[] fullClassName = new char[size];
            System.arraycopy(className, 0, fullClassName, 0, className.length);
            fullClassName[className.length] = 36;
            System.arraycopy(this.identifier.name, 0, fullClassName, className.length + 1, this.identifier.name.length);
            return fullClassName;
        }
        Scope outerScope = this.scope;
        while (outerScope.kind >= 3) {
            outerScope = outerScope.getOuterScope();
        }
        ClassScope classScope = (ClassScope)outerScope;
        RawClassSymbol outerClass = classScope.classSymbol;
        String classNumberString = Integer.toString(this.getClassNumber(outerClass));
        int classNumberLength = classNumberString.length();
        char[] className = outerClass.getClassName();
        int size = className.length + 1 + classNumberLength + this.identifier.name.length;
        char[] fullClassName = new char[size];
        System.arraycopy(className, 0, fullClassName, 0, className.length);
        int index = className.length;
        fullClassName[index++] = Identifier.dollarCharacter;
        System.arraycopy(classNumberString.toCharArray(), 0, fullClassName, index, classNumberLength);
        System.arraycopy(this.identifier.name, 0, fullClassName, index += classNumberLength, this.identifier.name.length);
        return fullClassName;
    }

    void detectCyclicInheritance(Parser parser) {
        if (this.superClass != null) {
            ClassSymbol super2;
            ClassSymbol super1 = super2 = this;
            while ((super1 = super1.getSuperClassSymbol()) != null && (super2 = super2.getSuperClassSymbol()) != null) {
                this.flags = (short)(this.flags | super2.getClassSymbol().flags & 0xC00);
                if ((super2 = super2.getSuperClassSymbol()) == null) break;
                this.flags = (short)(this.flags | super2.getClassSymbol().flags & 0xC00);
                if (!super1.equalTo(super2)) continue;
                parser.error(Message.errorCyclicInheritance, this.pos, false, this.errorName());
                this.superClass = parser.javaLangObjectPcs;
                break;
            }
        }
        ImplementationList prevImplList = null;
        ImplementationList implList = this.implementationList;
        while (implList != null) {
            ClassSymbol typeSymbol = implList.interfaceSymbol;
            if (this.equalTo(typeSymbol) || ((TypeSymbol)typeSymbol).isClass() && this.isInterface() && typeSymbol.implementsInterface(this)) {
                parser.error(Message.errorCyclicInheritance, this.pos, this.isErroneous(), this.errorName());
                if (prevImplList == null) {
                    this.implementationList = implList.next;
                } else {
                    prevImplList.next = implList.next;
                }
            }
            prevImplList = implList;
            implList = implList.next;
        }
    }

    void detectCyclicElementTypes(Parser parser) {
        if (this.isAnnotation()) {
            this.flags = (short)(this.flags | 0x1000);
            MethodSymbol methodSymbol = this.cd.methodList;
            while (methodSymbol != null) {
                RawClassSymbol elementType;
                if (methodSymbol.resultType.isClass() && (elementType = ((ClassSymbol)methodSymbol.resultType).getClassSymbol()).isAnnotation()) {
                    if ((elementType.flags & 0x1000) != 0) {
                        parser.error(Message.errorCyclicAnnotation, methodSymbol.tpos, false, methodSymbol.identifier.toString());
                    } else {
                        elementType.detectCyclicElementTypes(parser);
                    }
                }
                methodSymbol = methodSymbol.nextInClass;
            }
            this.flags = (short)(this.flags & 0xFFFFEFFF);
        }
    }

    boolean isInnerClass(MethodSymbol methodSymbol) {
        if (this.isInnerClass()) {
            Scope innerScope = this.scope;
            do {
                if (innerScope.kind == 2) {
                    innerScope = innerScope.getOuterScope();
                    continue;
                }
                if (innerScope.kind == 3 && ((MethodScope)innerScope).methodSymbol == methodSymbol) {
                    return true;
                }
                innerScope = innerScope.getOuterScope();
            } while (innerScope.kind >= 2);
        }
        return false;
    }

    boolean isInnerClass(ClassSymbol outerClass) {
        if (this.isInnerClass()) {
            Scope innerScope = this.scope;
            ClassScope outerScope = outerClass.getClassScope();
            do {
                if (innerScope == outerScope) {
                    return true;
                }
                innerScope = innerScope.getOuterScope();
            } while (innerScope.kind >= 2);
        }
        return false;
    }

    ClassSymbol getTopLevelClass(MethodSymbol methodSymbol) {
        if (!$assertionsDisabled && !this.isInnerClass()) {
            throw new AssertionError();
        }
        RawClassSymbol classSymbol = this;
        Scope outerScope = this.scope;
        block5: while (true) {
            switch (outerScope.kind) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return null;
                }
                case 2: {
                    ClassScope outerClassScope = (ClassScope)outerScope;
                    classSymbol = outerClassScope.classSymbol;
                    outerScope = outerClassScope.outerScope;
                    continue block5;
                }
                case 4: {
                    outerScope = ((LocalScope)outerScope).outerScope;
                    continue block5;
                }
                case 3: 
            }
            MethodScope outerMethodScope = (MethodScope)outerScope;
            if (outerMethodScope.methodSymbol == methodSymbol) {
                return classSymbol;
            }
            outerScope = outerMethodScope.outerScope;
        }
    }

    int findInnerClassDepth() {
        int depth = 0;
        Scope scp = this.scope;
        if (scp.kind == 2) {
            while (true) {
                ClassScope classScope = (ClassScope)scp;
                if ((classScope.classSymbol.access & 8) != 0) break;
                scp = classScope.outerScope;
                if (scp.kind != 2) break;
                ++depth;
            }
        }
        return depth;
    }

    Scope getPackageScope() {
        Scope scp = this.scope;
        while (true) {
            if (scp.kind == 2) {
                scp = ((ClassScope)scp).outerScope;
                continue;
            }
            if (scp.kind < 3) break;
            scp = ((LocalScope)scp).outerScope;
        }
        return scp;
    }

    boolean inSamePackage(ClassSymbol otherClass) {
        return this.getPackageScope() == otherClass.getClassSymbol().getPackageScope();
    }

    boolean isSerializable() {
        return (this.flags & 0x800) != 0;
    }

    Symbol lookupSpecificSymbolInClass(Parser parser, Identifier identifier, int kind, boolean includeInnerClasses) {
        return this.lookupSpecificSymbolInClass(parser, identifier, kind, includeInnerClasses, false);
    }

    private Symbol lookupSpecificSymbolInClass(Parser parser, Identifier identifier, int kind, boolean includeInnerClasses, boolean ignoreOuterClasses) {
        RawClassSymbol classSym;
        TypeSymbol typeSymbol;
        Symbol symbol;
        RawClassSymbol classSymbol = this;
        block3: while (true) {
            if (classSymbol.classScope == null) {
                classSymbol.loadType(parser, 0, false, true);
            }
            if ((symbol = classSymbol.classScope.lookupSpecificSymbolInScope(identifier, kind, true)) != null) {
                switch (kind) {
                    default: {
                        break block3;
                    }
                    case 32: {
                        typeSymbol = (TypeSymbol)symbol;
                        if (typeSymbol.isTypeParameter()) {
                            TypeParameterSymbol tps = (TypeParameterSymbol)typeSymbol;
                            if (tps.definingSymbol != this && (!(tps.definingSymbol instanceof ClassSymbol) || !(classSym = (RawClassSymbol)tps.definingSymbol).isInnerClass(this))) break;
                            break block3;
                        }
                        typeSymbol.resolveType(parser, typeSymbol.pos, false, true, true);
                        if (typeSymbol.isAccessible(this)) break block3;
                    }
                }
            }
            if (classSymbol.superClass == null) break;
            if (classSymbol.superClass instanceof UnresolvedClassSymbol) {
                if (parser.errorFound && classSymbol.isAnonymousInnerClass() && (classSymbol.flags & 0x40) == 0) {
                    ((AnonymousClassSymbol)classSymbol).completeAnonymousClass(parser);
                    if (classSymbol.superClass instanceof UnresolvedClassSymbol) {
                        throw new UnresolvedSuperClassException(classSymbol.superClass);
                    }
                } else {
                    throw new UnresolvedSuperClassException(classSymbol.superClass);
                }
            }
            classSymbol = classSymbol.superClass.getClassSymbol();
        }
        if (symbol == null) {
            classSymbol = this;
            block4: while (true) {
                ImplementationList list = classSymbol.implementationList;
                while (list != null) {
                    ClassSymbol interfaceSymbol = list.interfaceSymbol;
                    if (interfaceSymbol instanceof UnresolvedClassSymbol) {
                        throw new UnresolvedSuperClassException(interfaceSymbol);
                    }
                    if ((!classSymbol.isInnerClass(interfaceSymbol) || !ignoreOuterClasses) && (symbol = interfaceSymbol.getClassSymbol().lookupSpecificSymbolInClass(parser, identifier, kind, includeInnerClasses, true)) != null) break block4;
                    list = list.next;
                }
                if (classSymbol.superClass == null) break;
                classSymbol = classSymbol.superClass.getClassSymbol();
            }
        }
        if (includeInnerClasses && symbol == null) {
            classSymbol = this;
            block6: while (true) {
                TypeSymbolList tsl = classSymbol.cd.innerClassList;
                while (tsl != null) {
                    typeSymbol = tsl.typeSymbol;
                    if (!this.equalTo(typeSymbol) && typeSymbol.isClass() && !typeSymbol.isAnonymousInnerClass() && !classSymbol.isSuperclass(classSym = ((ClassSymbol)typeSymbol).getClassSymbol()) && (symbol = classSym.lookupSpecificSymbolInClass(parser, identifier, kind, includeInnerClasses, ignoreOuterClasses)) != null) break block6;
                    tsl = tsl.next;
                }
                if (classSymbol.superClass == null) break;
                classSymbol = classSymbol.superClass.getClassSymbol();
            }
        }
        return symbol;
    }

    RawClassSymbol lookupInnerClassByName(Identifier innerName) {
        RawClassSymbol outerClass = this;
        while (true) {
            TypeSymbolList tsl = outerClass.cd.innerClassList;
            while (tsl != null) {
                if (tsl.typeSymbol.identifier == innerName) {
                    return (RawClassSymbol)tsl.typeSymbol;
                }
                tsl = tsl.next;
            }
            if (outerClass.superClass == null) break;
            outerClass = outerClass.superClass.getClassSymbol();
        }
        outerClass = this;
        while (true) {
            ImplementationList list = outerClass.implementationList;
            while (list != null) {
                RawClassSymbol innerClass = list.interfaceSymbol.getClassSymbol().lookupInnerClassByName(innerName);
                if (innerClass != null) {
                    return innerClass;
                }
                list = list.next;
            }
            if (outerClass.superClass == null) break;
            outerClass = outerClass.superClass.getClassSymbol();
        }
        return null;
    }

    boolean checkForTypeAmbiguity(Parser parser, RawClassSymbol classSymbol) {
        ImportSymbol otherImport;
        ImportSymbol importSymbol;
        RawClassSymbol otherClass;
        boolean match = false;
        RawClassSymbol outerClass = this;
        block0: while (true) {
            TypeSymbolList tsl = outerClass.cd.innerClassList;
            while (tsl != null) {
                if (tsl.typeSymbol.identifier == classSymbol.identifier) {
                    if (classSymbol.equalTo(tsl.typeSymbol) || !(otherClass = (RawClassSymbol)tsl.typeSymbol).isAccessible(this)) break block0;
                    parser.error(Message.errorAmbiguousReference, this.pos, classSymbol.isErroneous() | otherClass.isErroneous(), classSymbol.errorName(), classSymbol.errorName() + " " + Message.inString + " " + classSymbol.scope.errorName(), otherClass.errorName() + " " + Message.inString + " " + otherClass.scope.errorName());
                    match = true;
                    break block0;
                }
                tsl = tsl.next;
            }
            ImplementationList list = outerClass.implementationList;
            while (list != null) {
                match |= list.interfaceSymbol.getClassSymbol().checkForTypeAmbiguity(parser, classSymbol);
                list = list.next;
            }
            if (match) {
                return true;
            }
            if (outerClass.superClass == null) break;
            outerClass = outerClass.superClass.getClassSymbol();
        }
        if ((importSymbol = parser.currentPackageScope.lookupImportSymbol(classSymbol.identifier, (byte)32)) != null && (importSymbol.flags & 1) == 0 && (otherImport = (ImportSymbol)importSymbol.importSymbolHidesOtherImport()) != null && !(otherClass = (RawClassSymbol)otherImport.importedSymbol).equalTo(classSymbol)) {
            parser.error(Message.errorAmbiguousReference, this.pos, classSymbol.isErroneous() | otherClass.isErroneous(), classSymbol.errorName(), classSymbol.errorName() + " " + Message.inString + " " + parser.currentPackageScope.errorName(), otherClass.errorName() + " " + Message.inString + " " + otherClass.scope.errorName());
            return true;
        }
        return false;
    }

    void checkSyntheticFieldsInInnerClass(Parser parser, MethodVariableSymbol localVar, int thisStatementPos, int thisExpressionPos, int nextStatementPos) {
        TypeSymbolList tsl = this.cd.innerClassList;
        while (tsl != null) {
            InnerClassSymbol innerClass = (InnerClassSymbol)tsl.typeSymbol;
            boolean variablePossiblyNotInitialized = false;
            if (thisStatementPos == thisExpressionPos && innerClass.isAnonymousInnerClass() && innerClass.scope == localVar.scope && (innerClass.pos < nextStatementPos || nextStatementPos <= 0)) {
                variablePossiblyNotInitialized = true;
            } else if (innerClass.pos < thisExpressionPos) {
                variablePossiblyNotInitialized = true;
            }
            if (variablePossiblyNotInitialized && innerClass.isInnerClass(parser.currentMethodSymbol) && innerClass.scope.isSubScopeOf(localVar.scope) && parser.lookupSyntheticFieldForLocalInInnerClass(innerClass, localVar) != null) {
                parser.error(Message.errorNotInitialized, innerClass.pos, localVar.isErroneous(), localVar.errorName());
            }
            innerClass.checkSyntheticFieldsInInnerClass(parser, localVar, thisStatementPos, thisExpressionPos, nextStatementPos);
            tsl = tsl.next;
        }
    }

    char[] getClassSignature() {
        StringBuffer sb = new StringBuffer();
        TypeParameterList tpl = this.cd.getTypeParameterList();
        if (tpl != null) {
            tpl.getSignature(sb);
        }
        sb.append(this.superClass.getGenericSignature());
        ImplementationList list = this.implementationList;
        while (list != null) {
            sb.append(list.interfaceSymbol.getGenericSignature());
            list = list.next;
        }
        return sb.toString().toCharArray();
    }

    void addNameReference(Parser parser, Symbol symbol, int pos) {
        if (!(symbol.isSynthetic() || symbol instanceof MethodSymbol && ((MethodSymbol)symbol).isGenerated())) {
            this.addNameReference(parser, symbol, pos, false);
        }
    }

    void addNameDeclaration(Parser parser, Symbol symbol, int pos) {
        if (!(symbol.isSynthetic() || symbol instanceof MethodSymbol && ((MethodSymbol)symbol).isGenerated())) {
            this.addNameReference(parser, symbol, pos, true);
        }
    }

    void addSuperReference(Parser parser, ClassSymbol symbol, ClassSymbol superSymbol) {
        if (superSymbol.getClassSymbol() != parser.javaLangObjectSymbol) {
            parser.depInfo.addSuperRelation(symbol.getClassSymbol(), superSymbol.getClassSymbol());
        }
    }

    void addImplementsReference(Parser parser, ClassSymbol symbol, ClassSymbol interfaceSymbol) {
        parser.depInfo.addImplementsRelation(symbol.getClassSymbol(), interfaceSymbol.getClassSymbol());
    }

    private void addNameReference(Parser parser, Symbol symbol, int pos, boolean isDeclaration) {
        if (parser.options.addNameReferences && pos > 0) {
            if (symbol.kind == 2) {
                if (isDeclaration) {
                    parser.depInfo.addFieldDeclaration(this, (FieldSymbol)symbol, pos);
                } else {
                    parser.depInfo.addFieldReference(this, (FieldSymbol)symbol, pos);
                }
            } else if (symbol.kind == 8) {
                if (isDeclaration) {
                    parser.depInfo.addMethodDeclaration(this, (MethodSymbol)symbol, pos);
                } else {
                    parser.depInfo.addMethodReference(this, (MethodSymbol)symbol, pos);
                }
            } else if (symbol.kind == 32) {
                TypeSymbol typeSymbol = (TypeSymbol)symbol;
                if (typeSymbol.isArrayType()) {
                    typeSymbol = ((ArraySymbol)typeSymbol).baseType;
                }
                if (typeSymbol.isClass()) {
                    ClassSymbol classSymbol = (ClassSymbol)typeSymbol;
                    if (isDeclaration) {
                        parser.depInfo.addTypeDeclaration(this, classSymbol.getClassSymbol(), pos);
                    } else {
                        parser.depInfo.addTypeReference(this, classSymbol.getClassSymbol(), pos);
                    }
                    if (classSymbol.isParameterizedClass()) {
                        ParameterizedClassSymbol pcs = (ParameterizedClassSymbol)classSymbol;
                        TypeVariableList tvl = pcs.typeVariableList;
                        while (tvl != null) {
                            TypeSymbol tvlSymbol = tvl.typeVariable.refSymbol;
                            if (tvlSymbol != null) {
                                this.addNameReference(parser, tvlSymbol, tvl.typeVariable.pos);
                            }
                            tvl = tvl.next;
                        }
                    }
                }
            }
        }
    }

    static {
        $assertionsDisabled = !RawClassSymbol.class.desiredAssertionStatus();
        javaLangObjectSymbol = null;
    }

    static final class GenericClassData
    extends ClassData {
        TypeParameterList typeParameterList;

        GenericClassData(TypeParameterList typeParameterList) {
            this.typeParameterList = typeParameterList;
        }

        GenericClassData(ClassData cd) {
            this.copy(cd);
        }

        TypeParameterList getTypeParameterList() {
            return this.typeParameterList;
        }
    }

    static final class AnnotationClassData
    extends ClassData {
        static final byte RETENTION_SOURCE = 0;
        static final byte RETENTION_CLASS = 1;
        static final byte RETENTION_RUNTIME = 2;
        static final byte TARGET_NONE = 0;
        static final byte TARGET_TYPE = 1;
        static final byte TARGET_FIELD = 2;
        static final byte TARGET_METHOD = 4;
        static final byte TARGET_PARAMETER = 8;
        static final byte TARGET_CONSTRUCTOR = 16;
        static final byte TARGET_LOCAL_VARIABLE = 32;
        static final byte TARGET_ANNOTATION_TYPE = 64;
        static final byte TARGET_PACKAGE = -128;
        static final byte TARGET_ANY = -1;
        byte retention = 1;
        byte target = (byte)-1;

        AnnotationClassData() {
        }

        byte getAnnotationRetention() {
            return this.retention;
        }

        byte getAnnotationTarget() {
            return this.target;
        }
    }

    static class ClassData {
        CompiledClassData ccd;
        TypeSymbolList innerClassList;
        MethodSymbol methodList;
        FieldSymbol fieldList;
        short methodCount;
        short fieldCount;
        MethodSymbol[] methodTable;
        char[] internalName;
        char[] signature;
        static final /* synthetic */ boolean $assertionsDisabled;

        ClassData() {
        }

        byte getAnnotationRetention() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }

        byte getAnnotationTarget() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return -1;
        }

        TypeParameterList getTypeParameterList() {
            return null;
        }

        void copy(ClassData cd) {
            this.ccd = cd.ccd;
            this.innerClassList = cd.innerClassList;
            this.methodList = cd.methodList;
            this.fieldList = cd.fieldList;
            this.methodCount = cd.methodCount;
            this.fieldCount = cd.fieldCount;
            this.methodTable = cd.methodTable;
            this.internalName = cd.internalName;
            this.signature = cd.signature;
        }

        static {
            $assertionsDisabled = !(class$oracle$ojc$compiler$RawClassSymbol == null ? (class$oracle$ojc$compiler$RawClassSymbol = RawClassSymbol.class$("oracle.ojc.compiler.RawClassSymbol")) : class$oracle$ojc$compiler$RawClassSymbol).desiredAssertionStatus();
        }
    }

    static final class CompiledClassData {
        int tpos;
        ConstantPool constantPool;
        SourceFile sourceFile;
        MethodSymbol classInitializer;
        MethodSymbol dynamicInitializer;
        MethodSymbol classLoaderMethod;

        CompiledClassData() {
        }
    }
}

