/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.AnnotationElementValue;
import oracle.ojc.compiler.AnonymousClassSymbol;
import oracle.ojc.compiler.ArgumentVariableList;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.ArrayExpression;
import oracle.ojc.compiler.ArrayInitializerExpression;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.AssertStatement;
import oracle.ojc.compiler.AssignmentBitAndExpression;
import oracle.ojc.compiler.AssignmentBitOrExpression;
import oracle.ojc.compiler.AssignmentBitXorExpression;
import oracle.ojc.compiler.AssignmentDivideExpression;
import oracle.ojc.compiler.AssignmentExpression;
import oracle.ojc.compiler.AssignmentMinusExpression;
import oracle.ojc.compiler.AssignmentModuloExpression;
import oracle.ojc.compiler.AssignmentMultiplyExpression;
import oracle.ojc.compiler.AssignmentPlusExpression;
import oracle.ojc.compiler.AssignmentShiftLeftExpression;
import oracle.ojc.compiler.AssignmentShiftRightExpression;
import oracle.ojc.compiler.AssignmentUnsignedShiftRightExpression;
import oracle.ojc.compiler.BinaryComplementExpression;
import oracle.ojc.compiler.BitAndExpression;
import oracle.ojc.compiler.BitOrExpression;
import oracle.ojc.compiler.BitXorExpression;
import oracle.ojc.compiler.BlockScope;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.BreakStatement;
import oracle.ojc.compiler.CaseStatement;
import oracle.ojc.compiler.CastExpression;
import oracle.ojc.compiler.CatchDescriptor;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassExpression;
import oracle.ojc.compiler.ClassResolutionList;
import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ClassSymbolPosList;
import oracle.ojc.compiler.CompiledImplementationList;
import oracle.ojc.compiler.Compiler;
import oracle.ojc.compiler.ConditionalExpression;
import oracle.ojc.compiler.ContinueStatement;
import oracle.ojc.compiler.DefaultStatement;
import oracle.ojc.compiler.DepInfo;
import oracle.ojc.compiler.DivideExpression;
import oracle.ojc.compiler.DoStatement;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.ElementValue;
import oracle.ojc.compiler.EmptyStatement;
import oracle.ojc.compiler.EndOfScopeStatement;
import oracle.ojc.compiler.EnhancedForStatement;
import oracle.ojc.compiler.EqualExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionElementValue;
import oracle.ojc.compiler.ExpressionList;
import oracle.ojc.compiler.ExpressionStatement;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.ForStatement;
import oracle.ojc.compiler.GlobalScope;
import oracle.ojc.compiler.GreaterExpression;
import oracle.ojc.compiler.GreaterOrEqualExpression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.IdentifierList;
import oracle.ojc.compiler.IfElseStatement;
import oracle.ojc.compiler.IfStatement;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.ImportDescriptor;
import oracle.ojc.compiler.ImportSymbol;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.InstanceOfExpression;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.InvokeExpression;
import oracle.ojc.compiler.KeywordTable;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.LabeledStatement;
import oracle.ojc.compiler.LessExpression;
import oracle.ojc.compiler.LessOrEqualExpression;
import oracle.ojc.compiler.LocalScope;
import oracle.ojc.compiler.LocalVarInitializationStatement;
import oracle.ojc.compiler.LocalVariableSymbol;
import oracle.ojc.compiler.LogicalAndExpression;
import oracle.ojc.compiler.LogicalNotExpression;
import oracle.ojc.compiler.LogicalOrExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodScope;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.MethodVariableExpression;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.MinusExpression;
import oracle.ojc.compiler.ModuloExpression;
import oracle.ojc.compiler.MultiplyExpression;
import oracle.ojc.compiler.NegateExpression;
import oracle.ojc.compiler.NewExpression;
import oracle.ojc.compiler.NewSourceException;
import oracle.ojc.compiler.NotEqualExpression;
import oracle.ojc.compiler.NullConstantExpression;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.PackageSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.PlusExpression;
import oracle.ojc.compiler.PostDecrementExpression;
import oracle.ojc.compiler.PostIncrementExpression;
import oracle.ojc.compiler.PreDecrementExpression;
import oracle.ojc.compiler.PreIncrementExpression;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.ReturnStatement;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.ShiftLeftExpression;
import oracle.ojc.compiler.ShiftRightExpression;
import oracle.ojc.compiler.SourceFile;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.StorageScope;
import oracle.ojc.compiler.StringConstantExpression;
import oracle.ojc.compiler.SuperExpression;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.SwitchStatement;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.SymbolList;
import oracle.ojc.compiler.SynchronizedStatement;
import oracle.ojc.compiler.SyntaxError;
import oracle.ojc.compiler.SyntaxErrorEndOfBlock;
import oracle.ojc.compiler.SyntaxErrorEndOfFile;
import oracle.ojc.compiler.SyntaxErrorEndOfStatement;
import oracle.ojc.compiler.ThisExpression;
import oracle.ojc.compiler.ThrowStatement;
import oracle.ojc.compiler.Token;
import oracle.ojc.compiler.TryStatement;
import oracle.ojc.compiler.TrySyncList;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.TypeVariableSymbol;
import oracle.ojc.compiler.UnaryPlusExpression;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedSuperClassException;
import oracle.ojc.compiler.UnresolvedSymbol;
import oracle.ojc.compiler.UnsignedShiftRightExpression;
import oracle.ojc.compiler.Warning;
import oracle.ojc.compiler.WhileStatement;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.Log2;
import oracle.ojc.interfaces.Storage;

final class Parser {
    private static final int PL_UNARY = 14;
    private static final int PL_MULTIPLICATION = 13;
    private static final int PL_ADDITION = 12;
    private static final int PL_SHIFT = 11;
    private static final int PL_RELATION = 10;
    private static final int PL_EQUALITY = 9;
    private static final int PL_BIT_AND = 8;
    private static final int PL_BIT_XOR = 7;
    private static final int PL_BIT_OR = 6;
    private static final int PL_LOGICAL_AND = 5;
    private static final int PL_LOGICAL_OR = 4;
    private static final int PL_CONDITIONAL = 3;
    private static final int PL_ASSIGNMENT = 2;
    private static final int PL_DECLARATION = 1;
    private static final int PL_FORDECLARATION = 0;
    private static final byte PC_CLASS = 0;
    private static final byte PC_DECLARATION = 1;
    private static final byte PC_STATEMENT = 2;
    private static final byte PC_EXPRESSION = 3;
    ClassResolutionList classResolutionList;
    Options options;
    ArrayList sourceFileList;
    SourceFile sourceFile;
    ArrayList loadedClassesWithCompiledSuperclassesList;
    int nextParseSourceFileIndex;
    int nextResolveImportsIndex;
    int nextResolveStaticImportsIndex;
    int nextImportSourceFileIndex;
    int resolutionFailures;
    int prevResolutionFailures;
    int resolutionRound;
    KeywordTable keywordTable;
    Scanner scanner;
    Token token;
    boolean errorFound;
    int errorCount;
    int warningCount;
    Annotation currentAnnotation;
    TypeParameterList typeParameterList;
    ArrayList forStatementDeclList;
    StorageScope globalScope;
    StorageScope unnamedPackageScope;
    Scope currentScope;
    StorageScope currentPackageScope;
    ClassScope currentClassScope;
    Symbol[] currentImportDeclarations;
    RawClassSymbol currentClassSymbol;
    MethodSymbol currentMethodSymbol;
    FieldSymbol currentFieldSymbol;
    Statement currentStatement;
    ArrayList currentClassesBeingResolved;
    int currentResolveTypePos;
    boolean parsingExplicitConstructorInvoke;
    StatementList statementList;
    int estimatedLineCount;
    SwitchLoopList innerSwitchLoop;
    TrySyncList innerTrySync;
    AmbiguityCheckRecord ambiguityCheckList;
    RawClassSymbol javaLangObjectSymbol;
    RawClassSymbol javaLangClassSymbol;
    RawClassSymbol javaLangStringSymbol;
    RawClassSymbol javaLangThrowableSymbol;
    RawClassSymbol javaLangExceptionSymbol;
    RawClassSymbol javaLangErrorSymbol;
    RawClassSymbol javaLangRuntimeExceptionSymbol;
    RawClassSymbol javaLangNullPointerExceptionSymbol;
    RawClassSymbol javaLangCloneableSymbol;
    RawClassSymbol javaLangComparableSymbol;
    RawClassSymbol javaIoSerializableSymbol;
    RawClassSymbol javaLangBooleanSymbol;
    RawClassSymbol javaLangByteSymbol;
    RawClassSymbol javaLangCharacterSymbol;
    RawClassSymbol javaLangShortSymbol;
    RawClassSymbol javaLangIntegerSymbol;
    RawClassSymbol javaLangLongSymbol;
    RawClassSymbol javaLangFloatSymbol;
    RawClassSymbol javaLangDoubleSymbol;
    RawClassSymbol javaLangNumberSymbol;
    RawClassSymbol javaLangDeprecatedSymbol;
    RawClassSymbol javaLangOverrideSymbol;
    RawClassSymbol javaLangSuppressWarningsSymbol;
    RawClassSymbol javaLangEnumSymbol;
    RawClassSymbol javaLangIterableSymbol;
    RawClassSymbol javaLangAnnotationAnnotationSymbol;
    RawClassSymbol javaLangAnnotationTargetSymbol;
    RawClassSymbol javaLangAnnotationRetentionSymbol;
    ParameterizedClassSymbol javaLangObjectPcs;
    ParameterizedClassSymbol javaLangClassPcs;
    ParameterizedClassSymbol javaLangStringPcs;
    ParameterizedClassSymbol javaLangBooleanPcs;
    ParameterizedClassSymbol javaLangBytePcs;
    ParameterizedClassSymbol javaLangCharacterPcs;
    ParameterizedClassSymbol javaLangShortPcs;
    ParameterizedClassSymbol javaLangIntegerPcs;
    ParameterizedClassSymbol javaLangLongPcs;
    ParameterizedClassSymbol javaLangFloatPcs;
    ParameterizedClassSymbol javaLangDoublePcs;
    int sourceLineCount;
    int classFileCount;
    byte[] writeBuffer;
    TypeSymbol assignmentContext;
    boolean suspendStaticContextChecking;
    boolean suspendTypeBoundsChecking;
    boolean suspendDataFlowChecking;
    boolean thisInitialized;
    boolean resolvingForCondition;
    BitSet defSet;
    BitSet posSet;
    BitSet useSet;
    BitSet exitDefSet;
    boolean deprecatedFlag;
    ResolutionState stateAtInternalError;
    Hashtable errorStatements;
    DepInfo depInfo;
    boolean parsingAtLeastOneFive;
    boolean targetingAtLeastOneFive;
    static final /* synthetic */ boolean $assertionsDisabled;

    Parser(Options options) {
        PackageSymbol packageSymbol;
        Symbol symbol;
        PackageScope packageScope;
        this.options = options;
        this.parsingAtLeastOneFive = options.sourceJDKVersion >= 150;
        this.targetingAtLeastOneFive = options.targetJDKVersion >= 150;
        this.depInfo = new DepInfo();
        this.depInfo.writeNameReferences = options.addNameReferences;
        this.keywordTable = new KeywordTable();
        this.errorFound = false;
        this.globalScope = new GlobalScope(this);
        this.errorStatements = new Hashtable();
        this.classResolutionList = new ClassResolutionList(false, true);
        this.currentClassesBeingResolved = new ArrayList();
        this.loadedClassesWithCompiledSuperclassesList = new ArrayList();
        this.javaLangObjectSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Object"), false);
        if (this.javaLangObjectSymbol == null) {
            Error error = new Error(null, Error.errorCannotReadSource, 0, "java.lang.Object");
            options.getLog().printError(error.message.getMessage());
            this.errorFound = true;
            return;
        }
        this.javaLangObjectPcs = ParameterizedClassSymbol.getParameterizedClassSymbol(this.javaLangObjectSymbol, null, null);
        this.javaLangClassSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Class"), false);
        this.javaLangStringSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("String"), false);
        this.javaLangThrowableSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Throwable"), false);
        this.javaLangExceptionSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Exception"), false);
        this.javaLangErrorSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Error"), false);
        this.javaLangRuntimeExceptionSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("RuntimeException"), false);
        this.javaLangNullPointerExceptionSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("NullPointerException"), false);
        this.javaLangCloneableSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Cloneable"), false);
        this.javaLangComparableSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Comparable"), false);
        this.javaLangClassPcs = ParameterizedClassSymbol.getParameterizedClassSymbol(this.javaLangClassSymbol, null, null);
        this.javaLangStringPcs = ParameterizedClassSymbol.getParameterizedClassSymbol(this.javaLangStringSymbol, null, null);
        if (options.sourceTargetJDKDefault) {
            options.sourceJDKVersion = options.targetJDKVersion = options.javaLangObjectJDKVersion;
            Identifier.initializeIdentifiers(options.sourceJDKVersion);
        }
        if (this.parsingAtLeastOneFive) {
            this.javaLangEnumSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Enum"), false);
            if (this.javaLangEnumSymbol == null) {
                Error error = options.sourceJDKVersion != options.javaLangObjectJDKVersion ? new Error(null, Error.errorWrongJDKForSource, 0, Options.JDKVersionToString(options.javaLangObjectJDKVersion), Options.JDKVersionToString(options.sourceJDKVersion)) : new Error(null, Error.errorWrongJDKForSource, 0, "java.lang.Enum");
                options.getLog().printError(error.message.getMessage());
                this.errorFound = true;
                return;
            }
            this.javaLangIterableSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Iterable"), false);
            this.javaLangDeprecatedSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Deprecated"), false);
            this.javaLangOverrideSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Override"), false);
            this.javaLangSuppressWarningsSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("SuppressWarnings"), false);
            packageScope = (PackageScope)this.javaLangObjectSymbol.scope;
            if (!$assertionsDisabled && packageScope.packageSymbol.identifier != Identifier.getIdentifier("lang")) {
                throw new AssertionError();
            }
            symbol = packageScope.lookupSpecificSymbolInScope(Identifier.getIdentifier("annotation"), 16, false);
            if (symbol == null) {
                packageScope = new PackageScope(this, packageScope);
                packageSymbol = new PackageSymbol(0, Identifier.getIdentifier("annotation"), packageScope);
                packageScope.outerScope.enterSymbol(packageSymbol);
                packageScope.packageSymbol = packageSymbol;
            } else {
                packageSymbol = (PackageSymbol)symbol;
                packageScope = packageSymbol.packageScope;
            }
            RawClassSymbol classSymbol = (RawClassSymbol)packageScope.lookupSymbolInScope(Identifier.getIdentifier("Annotation"), false);
            if (classSymbol == null) {
                classSymbol = new RawClassSymbol(0, Identifier.getIdentifier("Annotation"), 1, null, null, false, false);
                packageScope.enterSymbol(classSymbol);
            }
            this.javaLangAnnotationAnnotationSymbol = classSymbol;
            classSymbol = (RawClassSymbol)packageScope.lookupSymbolInScope(Identifier.getIdentifier("Target"), false);
            if (classSymbol == null) {
                classSymbol = new RawClassSymbol(0, Identifier.getIdentifier("Target"), 1, null, null, false, false);
                packageScope.enterSymbol(classSymbol);
            }
            this.javaLangAnnotationTargetSymbol = classSymbol;
            classSymbol = (RawClassSymbol)packageScope.lookupSymbolInScope(Identifier.getIdentifier("Retention"), false);
            if (classSymbol == null) {
                classSymbol = new RawClassSymbol(0, Identifier.getIdentifier("Retention"), 1, null, null, false, false);
                packageScope.enterSymbol(classSymbol);
            }
            this.javaLangAnnotationRetentionSymbol = classSymbol;
            classSymbol = (RawClassSymbol)packageScope.lookupSymbolInScope(Identifier.getIdentifier("Documented"), false);
            if (classSymbol == null) {
                classSymbol = new RawClassSymbol(0, Identifier.getIdentifier("Documented"), 1, null, null, false, false);
                packageScope.enterSymbol(classSymbol);
            }
            if ((classSymbol = (RawClassSymbol)packageScope.lookupSymbolInScope(Identifier.getIdentifier("Inherited"), false)) == null) {
                classSymbol = new RawClassSymbol(0, Identifier.getIdentifier("Inherited"), 1, null, null, false, false);
                packageScope.enterSymbol(classSymbol);
            }
            this.javaLangDeprecatedSymbol.flags = (short)(this.javaLangDeprecatedSymbol.flags | 0x2000);
            this.javaLangOverrideSymbol.flags = (short)(this.javaLangOverrideSymbol.flags | 0x2000);
            this.javaLangSuppressWarningsSymbol.flags = (short)(this.javaLangSuppressWarningsSymbol.flags | 0x2000);
            this.javaLangAnnotationTargetSymbol.flags = (short)(this.javaLangAnnotationTargetSymbol.flags | 0x2000);
            this.javaLangAnnotationRetentionSymbol.flags = (short)(this.javaLangAnnotationRetentionSymbol.flags | 0x2000);
            this.javaLangBooleanSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Boolean"), false);
            this.javaLangByteSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Byte"), false);
            this.javaLangCharacterSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Character"), false);
            this.javaLangShortSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Short"), false);
            this.javaLangIntegerSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Integer"), false);
            this.javaLangLongSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Long"), false);
            this.javaLangFloatSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Float"), false);
            this.javaLangDoubleSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Double"), false);
            this.javaLangNumberSymbol = (RawClassSymbol)this.globalScope.lookupSymbolInScope(Identifier.getIdentifier("Number"), false);
            this.javaLangBooleanPcs = ParameterizedClassSymbol.getParameterizedClassSymbol(this.javaLangBooleanSymbol, null, null);
            this.javaLangBytePcs = ParameterizedClassSymbol.getParameterizedClassSymbol(this.javaLangByteSymbol, null, null);
            this.javaLangCharacterPcs = ParameterizedClassSymbol.getParameterizedClassSymbol(this.javaLangCharacterSymbol, null, null);
            this.javaLangShortPcs = ParameterizedClassSymbol.getParameterizedClassSymbol(this.javaLangShortSymbol, null, null);
            this.javaLangIntegerPcs = ParameterizedClassSymbol.getParameterizedClassSymbol(this.javaLangIntegerSymbol, null, null);
            this.javaLangLongPcs = ParameterizedClassSymbol.getParameterizedClassSymbol(this.javaLangLongSymbol, null, null);
            this.javaLangFloatPcs = ParameterizedClassSymbol.getParameterizedClassSymbol(this.javaLangFloatSymbol, null, null);
            this.javaLangDoublePcs = ParameterizedClassSymbol.getParameterizedClassSymbol(this.javaLangDoubleSymbol, null, null);
        }
        packageSymbol = (PackageSymbol)this.globalScope.lookupSpecificSymbolInScope(Identifier.getIdentifier("java"), 16, false);
        if (!$assertionsDisabled && packageSymbol == null) {
            throw new AssertionError();
        }
        symbol = packageSymbol.packageScope.lookupSpecificSymbolInScope(Identifier.getIdentifier("io"), 16, false);
        if (symbol == null) {
            packageScope = new PackageScope(this, packageSymbol.packageScope);
            packageSymbol = new PackageSymbol(0, Identifier.getIdentifier("io"), packageScope);
            packageScope.outerScope.enterSymbol(packageSymbol);
            packageScope.packageSymbol = packageSymbol;
        } else {
            packageSymbol = (PackageSymbol)symbol;
            packageScope = packageSymbol.packageScope;
        }
        this.javaIoSerializableSymbol = (RawClassSymbol)packageScope.lookupSpecificSymbolInScope(Identifier.getIdentifier("Serializable"), 32, true);
        this.writeBuffer = new byte[32768];
    }

    void print(PrintStream out) {
        out.println("\terrorFound:         " + this.errorFound);
        if (this.stateAtInternalError != null) {
            out.print("\n\tclass:              ");
            if (this.stateAtInternalError.currentClassSymbol != null) {
                out.print(this.stateAtInternalError.currentClassSymbol.toString());
            }
            out.println();
            out.print("\tmethod:              ");
            if (this.stateAtInternalError.currentMethodSymbol != null) {
                out.print(this.stateAtInternalError.currentMethodSymbol.toString());
            }
            out.println();
            out.print("\tfield:               ");
            if (this.stateAtInternalError.currentFieldSymbol != null) {
                out.print(this.stateAtInternalError.currentFieldSymbol.identifier.toString());
            }
            out.println();
            out.print("\n\tsource:              ");
            if (this.stateAtInternalError.sourceFile != null) {
                out.print(this.stateAtInternalError.sourceFile.storage.getPath());
            }
            out.println();
            out.print("\tline:                ");
            if (this.stateAtInternalError.currentStatement != null) {
                out.print(Scanner.positionToLine(this.stateAtInternalError.currentStatement.pos));
            }
            out.println();
        }
    }

    Object copyResolutionState() {
        ResolutionState rs = new ResolutionState();
        rs.currentImportDeclarations = this.currentImportDeclarations;
        rs.currentPackageScope = this.currentPackageScope;
        rs.sourceFile = this.sourceFile;
        rs.currentClassSymbol = this.currentClassSymbol;
        rs.currentMethodSymbol = this.currentMethodSymbol;
        rs.currentFieldSymbol = this.currentFieldSymbol;
        rs.currentStatement = this.currentStatement;
        rs.innerSwitchLoop = this.innerSwitchLoop;
        rs.estimatedLineCount = this.estimatedLineCount;
        rs.suspendDataFlowChecking = this.suspendDataFlowChecking;
        rs.defSet = this.defSet;
        rs.posSet = this.posSet;
        rs.useSet = this.useSet;
        rs.exitDefSet = this.exitDefSet;
        return rs;
    }

    Object saveResolutionState() {
        ResolutionState rs = new ResolutionState();
        if (this.currentImportDeclarations != null) {
            this.currentPackageScope.removeDeclarations(this.currentImportDeclarations);
        }
        rs.currentImportDeclarations = this.currentImportDeclarations;
        this.currentImportDeclarations = null;
        rs.currentPackageScope = this.currentPackageScope;
        this.currentPackageScope = null;
        rs.sourceFile = this.sourceFile;
        this.sourceFile = null;
        rs.currentClassSymbol = this.currentClassSymbol;
        this.currentClassSymbol = null;
        rs.currentMethodSymbol = this.currentMethodSymbol;
        this.currentMethodSymbol = null;
        rs.currentFieldSymbol = this.currentFieldSymbol;
        this.currentFieldSymbol = null;
        rs.currentStatement = this.currentStatement;
        this.currentStatement = null;
        rs.innerSwitchLoop = this.innerSwitchLoop;
        this.innerSwitchLoop = null;
        rs.estimatedLineCount = this.estimatedLineCount;
        this.estimatedLineCount = 0;
        rs.suspendDataFlowChecking = this.suspendDataFlowChecking;
        this.suspendDataFlowChecking = false;
        rs.defSet = this.defSet;
        this.defSet = null;
        rs.posSet = this.posSet;
        this.posSet = null;
        rs.useSet = this.useSet;
        this.useSet = null;
        rs.exitDefSet = this.exitDefSet;
        this.exitDefSet = null;
        return rs;
    }

    Object saveResolutionState(RawClassSymbol classSymbol) {
        ResolutionState rs = new ResolutionState();
        if (this.sourceFile == classSymbol.cd.ccd.sourceFile) {
            rs.sameSourceOnRestore = true;
        } else {
            if (this.currentImportDeclarations != null) {
                this.currentPackageScope.removeDeclarations(this.currentImportDeclarations);
            }
            rs.sourceFile = this.sourceFile;
            this.sourceFile = classSymbol.cd.ccd.sourceFile;
            rs.currentPackageScope = this.currentPackageScope;
            this.currentPackageScope = this.sourceFile.packageScope;
            rs.currentImportDeclarations = this.currentImportDeclarations;
            this.currentImportDeclarations = this.sourceFile.importDeclarations;
            if (this.currentImportDeclarations != null) {
                this.currentPackageScope.enterDeclarations(this.currentImportDeclarations);
            }
        }
        rs.currentClassSymbol = this.currentClassSymbol;
        this.currentClassSymbol = classSymbol;
        rs.currentMethodSymbol = this.currentMethodSymbol;
        this.currentMethodSymbol = null;
        rs.currentFieldSymbol = this.currentFieldSymbol;
        this.currentFieldSymbol = null;
        rs.currentStatement = this.currentStatement;
        this.currentStatement = null;
        rs.innerSwitchLoop = this.innerSwitchLoop;
        this.innerSwitchLoop = null;
        rs.estimatedLineCount = this.estimatedLineCount;
        this.estimatedLineCount = 0;
        rs.suspendDataFlowChecking = this.suspendDataFlowChecking;
        this.suspendDataFlowChecking = false;
        rs.defSet = this.defSet;
        this.defSet = null;
        rs.posSet = this.posSet;
        this.posSet = null;
        rs.useSet = this.useSet;
        this.useSet = null;
        rs.exitDefSet = this.exitDefSet;
        this.exitDefSet = null;
        return rs;
    }

    void restoreResolutionState(Object state) {
        ResolutionState rs = (ResolutionState)state;
        if (!rs.sameSourceOnRestore) {
            if (this.currentImportDeclarations != null) {
                this.currentPackageScope.removeDeclarations(this.currentImportDeclarations);
            }
            this.sourceFile = rs.sourceFile;
            this.currentPackageScope = rs.currentPackageScope;
            this.currentImportDeclarations = rs.currentImportDeclarations;
            if (this.currentImportDeclarations != null) {
                this.currentPackageScope.enterDeclarations(this.currentImportDeclarations);
            }
        }
        this.currentClassSymbol = rs.currentClassSymbol;
        this.currentMethodSymbol = rs.currentMethodSymbol;
        this.currentFieldSymbol = rs.currentFieldSymbol;
        this.currentStatement = rs.currentStatement;
        this.innerSwitchLoop = rs.innerSwitchLoop;
        this.estimatedLineCount = rs.estimatedLineCount;
        this.suspendDataFlowChecking = rs.suspendDataFlowChecking;
        this.defSet = rs.defSet;
        this.posSet = rs.posSet;
        this.useSet = rs.useSet;
        this.exitDefSet = rs.exitDefSet;
    }

    void setResolutionState(RawClassSymbol classSymbol) {
        this.sourceFile = classSymbol.cd.ccd.sourceFile;
        this.currentPackageScope = this.sourceFile.packageScope;
        this.currentClassSymbol = classSymbol;
        Symbol[] importDeclarations = this.sourceFile.importDeclarations;
        if (importDeclarations != null) {
            this.currentImportDeclarations = importDeclarations;
            this.currentPackageScope.enterDeclarations(importDeclarations);
        }
    }

    void error(Message message) {
        this.errorFound = true;
        if (this.sourceFile != null) {
            this.sourceFile.messageList.add(message);
        } else {
            this.options.getLog().printError(message.message.getMessage());
        }
    }

    private void warning(Symbol symbol, Message message) {
        if (!this.options.noWarnings) {
            int messageNumber = message.message.getNumber();
            boolean optionSuppress = false;
            boolean annotationSuppress = false;
            if (Annotation.isSuppressedWarning(this, symbol, messageNumber)) {
                annotationSuppress = true;
            } else if (messageNumber < Warning.warnings.size() && !Warning.warnings.get(messageNumber)) {
                optionSuppress = true;
            }
            if (messageNumber == Message.warningIsDeprecated.getNumber()) {
                if (!Warning.warnings.get(Message.warningUseDeprecationWarning.getNumber())) {
                    optionSuppress = true;
                } else if (optionSuppress && !this.sourceFile.deprecatedWarningFound) {
                    this.sourceFile.deprecatedWarningFound = true;
                    this.warning(symbol, new Warning(this.sourceFile.storage, Message.warningUseDeprecationWarning, 0));
                }
            }
            if (!optionSuppress && !annotationSuppress) {
                if (this.options.warningsAreErrors) {
                    this.errorFound = true;
                }
                this.sourceFile.messageList.add(message);
            }
        }
    }

    void warning(Message message) {
        int messageNumber;
        if (!this.options.noWarnings && ((messageNumber = message.message.getNumber()) >= Warning.warnings.size() || Warning.warnings.get(messageNumber))) {
            if (this.options.warningsAreErrors) {
                this.errorFound = true;
                this.options.getLog().printError("#" + messageNumber + " " + message.message.getMessage());
            } else {
                this.options.getLog().printWarning("#" + messageNumber + " " + message.message.getMessage());
            }
        }
    }

    Error error(ErrorInfo error, int pos, boolean ignore) {
        Error err = null;
        if (!ignore) {
            Storage storage = this.sourceFile != null ? this.sourceFile.storage : null;
            err = new Error(storage, error, pos);
            this.error(err);
            if (this.currentStatement != null && !this.errorStatements.containsKey(this.currentStatement)) {
                this.errorStatements.put(this.currentStatement, err);
            }
        }
        return err;
    }

    Error error(ErrorInfo error, int pos, boolean ignore, String s1) {
        Error err = null;
        if (!ignore) {
            Storage storage = this.sourceFile != null ? this.sourceFile.storage : null;
            err = new Error(storage, error, pos, s1);
            this.error(err);
            if (this.currentStatement != null && !this.errorStatements.containsKey(this.currentStatement)) {
                this.errorStatements.put(this.currentStatement, err);
            }
        }
        return err;
    }

    Error error(ErrorInfo error, int pos, boolean ignore, String s1, String s2) {
        Error err = null;
        if (!ignore) {
            Storage storage = this.sourceFile != null ? this.sourceFile.storage : null;
            err = new Error(storage, error, pos, s1, s2);
            this.error(err);
            if (this.currentStatement != null && !this.errorStatements.containsKey(this.currentStatement)) {
                this.errorStatements.put(this.currentStatement, err);
            }
        }
        return err;
    }

    Error error(ErrorInfo error, int pos, boolean ignore, String s1, String s2, String s3) {
        Error err = null;
        if (!ignore) {
            Storage storage = this.sourceFile != null ? this.sourceFile.storage : null;
            err = new Error(storage, error, pos, s1, s2, s3);
            this.error(err);
            if (this.currentStatement != null && !this.errorStatements.containsKey(this.currentStatement)) {
                this.errorStatements.put(this.currentStatement, err);
            }
        }
        return err;
    }

    void warning(Symbol symbol, ErrorInfo error, int pos) {
        Storage storage = this.sourceFile != null ? this.sourceFile.storage : null;
        this.warning(symbol, new Warning(storage, error, pos));
    }

    void warning(Symbol symbol, ErrorInfo error, int pos, String s1) {
        Storage storage = this.sourceFile != null ? this.sourceFile.storage : null;
        this.warning(symbol, new Warning(storage, error, pos, s1));
    }

    void warning(Symbol symbol, ErrorInfo error, int pos, String s1, String s2) {
        Storage storage = this.sourceFile != null ? this.sourceFile.storage : null;
        this.warning(symbol, new Warning(storage, error, pos, s1, s2));
    }

    void warning(Symbol symbol, ErrorInfo error, int pos, String s1, String s2, String s3) {
        Storage storage = this.sourceFile != null ? this.sourceFile.storage : null;
        this.warning(symbol, new Warning(storage, error, pos, s1, s2, s3));
    }

    void printMessages(Log2 log) {
        SourceFile sourceFile;
        int count = this.sourceFileList.size();
        for (int i = 0; i < count && (sourceFile = (SourceFile)this.sourceFileList.get(i)).printMessages(this, log); ++i) {
        }
    }

    private void tryToRecoverFromSyntaxErrorInExpression() {
        int nesting = 0;
        while (true) {
            switch (this.token.kind) {
                default: {
                    break;
                }
                case 80: {
                    ++nesting;
                    break;
                }
                case 17: 
                case 19: 
                case 24: 
                case 26: 
                case 33: 
                case 35: 
                case 47: 
                case 51: 
                case 52: 
                case 54: 
                case 58: 
                case 60: 
                case 63: {
                    if (nesting != 0) break;
                    throw new SyntaxErrorEndOfStatement();
                }
                case 81: {
                    if (--nesting >= 0) break;
                    throw new SyntaxErrorEndOfBlock();
                }
                case 9: {
                    throw new SyntaxErrorEndOfFile();
                }
            }
            this.scanner.scan();
        }
    }

    private void tryToRecoverFromSyntaxErrorInClassDeclaration() {
        while (this.token.kind != 9) {
            this.scanner.scan();
        }
        throw new SyntaxErrorEndOfFile();
    }

    private void tryToRecoverFromSyntaxErrorInDeclaration() {
        int nesting = 0;
        while (true) {
            switch (this.token.kind) {
                default: {
                    break;
                }
                case 80: {
                    ++nesting;
                    break;
                }
                case 81: {
                    if (--nesting >= 0) break;
                    throw new SyntaxErrorEndOfBlock();
                }
                case 9: {
                    throw new SyntaxErrorEndOfFile();
                }
            }
            this.scanner.scan();
        }
    }

    private void tryToRecoverFromSyntaxErrorInStatement() {
        int nesting = 0;
        while (true) {
            switch (this.token.kind) {
                default: {
                    break;
                }
                case 80: {
                    ++nesting;
                    break;
                }
                case 17: 
                case 19: 
                case 24: 
                case 26: 
                case 33: 
                case 35: 
                case 47: 
                case 51: 
                case 52: 
                case 54: 
                case 58: 
                case 60: 
                case 63: {
                    if (nesting != 0) break;
                    throw new SyntaxErrorEndOfStatement();
                }
                case 81: {
                    if (--nesting >= 0) break;
                    throw new SyntaxErrorEndOfBlock();
                }
                case 9: {
                    throw new SyntaxErrorEndOfFile();
                }
            }
            this.scanner.scan();
        }
    }

    private void tryToRecoverFromSyntaxError(byte context) {
        switch (context) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 0: {
                this.tryToRecoverFromSyntaxErrorInClassDeclaration();
                break;
            }
            case 1: {
                this.tryToRecoverFromSyntaxErrorInDeclaration();
                break;
            }
            case 2: {
                this.tryToRecoverFromSyntaxErrorInStatement();
                break;
            }
            case 3: {
                this.tryToRecoverFromSyntaxErrorInExpression();
            }
        }
    }

    private void syntaxError(byte context, byte expectedToken) {
        this.error(Message.errorDifferentSymbolExpected, this.token.pos, false, Token.tokenToString(expectedToken));
        this.tryToRecoverFromSyntaxError(context);
    }

    private void syntaxError(byte context) {
        this.tryToRecoverFromSyntaxError(context);
    }

    private void parseAssertStatement() {
        if (!$assertionsDisabled && this.token.kind != 17) {
            throw new AssertionError();
        }
        int pos = this.token.pos;
        this.scanner.scan();
        Expression assertion = this.parseExpression(2);
        if (assertion == null) {
            Error error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            assertion = new ErrorExpression(error);
        }
        Expression detail = null;
        if (this.token.kind == 79) {
            this.scanner.scan();
            detail = this.parseExpression(2);
            if (detail == null) {
                this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            }
        }
        if (!this.options.omitAssertions) {
            this.statementList.add(new AssertStatement(this.statementList, pos, this, assertion, detail));
        }
    }

    private void parseDoStatement() {
        if (!$assertionsDisabled && this.token.kind != 26) {
            throw new AssertionError();
        }
        int pos = this.token.pos;
        this.scanner.scan();
        StatementList savedStatementList = this.statementList;
        StatementList bodyStatements = this.statementList = new StatementList();
        int bodyPos = this.token.pos;
        this.parseStatement(false);
        this.statementList = savedStatementList;
        int whilePos = this.token.pos;
        if (this.token.kind != 60) {
            this.syntaxError((byte)2, (byte)60);
        }
        if (this.scanner.scan() != 101) {
            this.syntaxError((byte)2, (byte)101);
        }
        this.scanner.scan();
        Expression condition = this.parseExpression(2);
        if (condition == null) {
            Error error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            condition = new ErrorExpression(error);
        }
        if (this.token.kind != 102) {
            this.syntaxError((byte)2, (byte)102);
        } else {
            this.scanner.scan();
        }
        this.statementList.add(new DoStatement(this.statementList, pos, bodyPos, whilePos, condition, bodyStatements));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseEnhancedForStatement(int pos, Identifier identifier, TypeSymbol typeSymbol, int tpos, short access) {
        Expression expr;
        MethodVariableSymbol localVar;
        ArrayList<MethodVariableSymbol> declList;
        this.forStatementDeclList = declList = new ArrayList<MethodVariableSymbol>();
        ArrayList savedDeclList = this.currentScope.recordDeclarations(null);
        try {
            Symbol symbol = this.currentScope.lookupSpecificSymbol(identifier, 64, false);
            if (symbol != null) {
                localVar = (MethodVariableSymbol)symbol;
                if (localVar.methodSymbol.definingClass.equalTo(this.currentClassSymbol) && (!(localVar instanceof LocalVariableSymbol) || localVar.methodSymbol == this.currentMethodSymbol)) {
                    this.error(Message.errorDuplicateDefinition, this.token.pos, false, symbol.errorName() + " " + Message.inString + " " + this.currentMethodSymbol.errorName());
                }
            }
            short s = this.currentMethodSymbol.localVarCount;
            this.currentMethodSymbol.localVarCount = (short)(s + 1);
            localVar = new LocalVariableSymbol(this.token.pos, this.currentMethodSymbol, identifier, typeSymbol, tpos, access, null, s);
            this.currentMethodSymbol.cmd.localVariables.add(localVar);
            this.currentScope.enterSymbol(localVar);
            declList.add(localVar);
            if ((typeSymbol.typeClass & 0x28) != 0) {
                this.currentMethodSymbol.localVarCount = (short)(this.currentMethodSymbol.localVarCount + 1);
                this.currentMethodSymbol.cmd.localVariables.add(null);
            }
            if (!$assertionsDisabled && this.token.kind != 79) {
                throw new AssertionError();
            }
            this.scanner.scan();
            expr = this.parseExpression(2);
            if (expr == null) {
                Error error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
                expr = new ErrorExpression(error);
            }
        }
        finally {
            this.forStatementDeclList = null;
            this.currentScope.recordDeclarations(savedDeclList);
        }
        if (this.token.kind != 102) {
            this.syntaxError((byte)2, (byte)102);
        }
        this.scanner.scan();
        StatementList savedStatementList = this.statementList;
        int bodyPos = this.token.pos;
        StatementList bodyStatements = this.statementList = new StatementList();
        this.parseStatement(false);
        this.statementList = savedStatementList;
        if (expr.kind == 0) {
            this.statementList.add(new ExpressionStatement(this.statementList, pos, expr));
        } else {
            this.statementList.add(new EnhancedForStatement(this.statementList, pos, bodyPos, localVar, expr, bodyStatements));
        }
        int size = declList.size();
        if (size > 0) {
            Symbol[] declArray = declList.toArray(new Symbol[size]);
            this.currentScope.removeDeclarations(declArray);
            if (this.options.localVariables) {
                this.statementList.add(new EndOfScopeStatement(this.statementList, declArray));
            }
        }
    }

    private TypeSymbol parseArrayDimensions(TypeSymbol typeSymbol) {
        if (this.token.kind == 76) {
            int dim = 0;
            do {
                if (this.scanner.scan() != 77) {
                    this.syntaxError((byte)3, (byte)77);
                }
                ++dim;
            } while (this.scanner.scan() == 76);
            typeSymbol = ArraySymbol.getArrayType(typeSymbol, dim);
        }
        return typeSymbol;
    }

    private boolean scanAheadForColon() {
        if (!$assertionsDisabled && this.token.kind != 10) {
            throw new AssertionError();
        }
        Object savedScannerState = this.scanner.saveScannerState();
        if (this.scanner.scan() == 76) {
            do {
                if (this.scanner.scan() == 77) continue;
                this.scanner.restoreScannerState(savedScannerState);
                return false;
            } while (this.scanner.scan() == 76);
        }
        byte tokenKind = this.token.kind;
        this.scanner.restoreScannerState(savedScannerState);
        return tokenKind == 79;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseForStatement() {
        Error error;
        int spos;
        ArrayList declList;
        if (!$assertionsDisabled && this.token.kind != 33) {
            throw new AssertionError();
        }
        int pos = this.token.pos;
        if (this.scanner.scan() != 101) {
            this.syntaxError((byte)2, (byte)101);
        }
        this.scanner.scan();
        short access = this.parseModifiers((short)-17);
        Expression stepExpr = null;
        Expression initExpr = null;
        Expression condition = null;
        StatementList savedStatementList = this.statementList;
        StatementList initStatements = this.statementList = new StatementList();
        this.forStatementDeclList = declList = new ArrayList();
        ArrayList savedDeclList = this.currentScope.recordDeclarations(null);
        try {
            if (this.token.kind != 63) {
                block4 : switch (this.token.kind) {
                    default: {
                        if (access == 16) {
                            this.error(Message.errorIllegalStartOfType, this.token.pos, false);
                        }
                        while (true) {
                            spos = this.token.pos;
                            initExpr = this.parseExpression(2);
                            if (initExpr == null) {
                                error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
                                initExpr = new ErrorExpression(error);
                            }
                            this.statementList.add(new ExpressionStatement(this.statementList, spos, initExpr));
                            if (this.token.kind != 62) break block4;
                            this.scanner.scan();
                        }
                    }
                    case 10: {
                        TypeSymbol typeSymbol;
                        int tpos;
                        if (access != 0) {
                            tpos = this.token.pos;
                            Symbol symbol = this.parseQualifiedIdentifier(false);
                            if ((symbol.kind & 1) == 0) {
                                if (!$assertionsDisabled && (symbol.kind & 0xFFFFFFC0) == 0) {
                                    throw new AssertionError();
                                }
                                symbol = new UnresolvedSymbol(pos, this.currentScope, symbol.identifier);
                            }
                            TypeVariableList typeVariableList = null;
                            if (this.parsingAtLeastOneFive && this.token.kind == 89) {
                                typeVariableList = this.parseActualTypeParameterList();
                            }
                            typeSymbol = new UnresolvedClassSymbol((UnresolvedSymbol)symbol, typeVariableList, this.currentScope);
                            typeSymbol = this.parseArrayDimensions(typeSymbol);
                            if (this.parsingAtLeastOneFive && this.token.kind == 10 && this.scanAheadForColon()) {
                                Identifier identifier = this.token.id;
                                this.scanner.scan();
                                typeSymbol = this.parseArrayDimensions(typeSymbol);
                                this.parseEnhancedForStatement(pos, identifier, typeSymbol, tpos, access);
                                this.statementList = savedStatementList;
                                this.statementList.merge(initStatements);
                                return;
                            }
                            this.parseVariableDeclaration(typeSymbol, tpos, access, 0);
                            break;
                        }
                        while (true) {
                            spos = this.token.pos;
                            initExpr = this.parseExpression(0);
                            if (initExpr == ErrorExpression.markerExpression) {
                                this.statementList = savedStatementList;
                                this.statementList.merge(initStatements);
                                return;
                            }
                            if (initExpr != null) {
                                this.statementList.add(new ExpressionStatement(this.statementList, spos, initExpr));
                            }
                            if (this.token.kind != 62) break block4;
                            this.scanner.scan();
                        }
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        int tpos = this.token.pos;
                        TypeSymbol typeSymbol = TypeSymbol.tokenToTypeSymbol(this.token.kind);
                        this.scanner.scan();
                        typeSymbol = this.parseArrayDimensions(typeSymbol);
                        if (this.parsingAtLeastOneFive && this.token.kind == 10 && this.scanAheadForColon()) {
                            Identifier identifier = this.token.id;
                            this.scanner.scan();
                            typeSymbol = this.parseArrayDimensions(typeSymbol);
                            this.parseEnhancedForStatement(pos, identifier, typeSymbol, tpos, access);
                            this.statementList = savedStatementList;
                            this.statementList.merge(initStatements);
                            return;
                        }
                        this.parseVariableDeclaration(typeSymbol, tpos, access, 0);
                    }
                }
                if (this.token.kind != 63) {
                    this.syntaxError((byte)2, (byte)63);
                }
            }
        }
        finally {
            this.forStatementDeclList = null;
            this.currentScope.recordDeclarations(savedDeclList);
        }
        this.statementList = savedStatementList;
        int bodyPos = this.token.pos;
        if (this.scanner.scan() != 63) {
            condition = this.parseExpression(2);
            if (condition == null) {
                error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
                condition = new ErrorExpression(error);
            }
            if (this.token.kind != 63) {
                this.syntaxError((byte)2, (byte)63);
            }
        }
        StatementList updateStatements = new StatementList();
        if (this.scanner.scan() != 102) {
            while (true) {
                spos = this.token.pos;
                stepExpr = this.parseExpression(2);
                if (stepExpr == null) {
                    error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
                    stepExpr = new ErrorExpression(error);
                }
                updateStatements.add(new ExpressionStatement(updateStatements, spos, stepExpr));
                if (this.token.kind != 62) break;
                this.scanner.scan();
            }
            if (this.token.kind != 102) {
                this.syntaxError((byte)2, (byte)102);
            } else {
                this.scanner.scan();
            }
        } else {
            this.scanner.scan();
        }
        savedStatementList = this.statementList;
        StatementList bodyStatements = this.statementList = new StatementList();
        this.parseStatement(false);
        this.statementList = savedStatementList;
        this.statementList.add(new ForStatement(this.statementList, pos, bodyPos, condition, initStatements, bodyStatements, updateStatements));
        int size = declList.size();
        if (size > 0) {
            Symbol[] declArray = declList.toArray(new Symbol[size]);
            this.currentScope.removeDeclarations(declArray);
            if (this.options.localVariables) {
                this.statementList.add(new EndOfScopeStatement(this.statementList, declArray));
            }
        }
    }

    private void parseIfStatement() {
        Statement statement;
        if (!$assertionsDisabled && this.token.kind != 35) {
            throw new AssertionError();
        }
        int pos = this.token.pos;
        if (this.scanner.scan() != 101) {
            this.syntaxError((byte)2, (byte)101);
        }
        this.scanner.scan();
        Expression condition = this.parseExpression(2);
        if (condition == null) {
            Error error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            condition = new ErrorExpression(error);
        }
        if (this.token.kind != 102) {
            this.syntaxError((byte)2, (byte)102);
        } else {
            this.scanner.scan();
        }
        StatementList savedStatementList = this.statementList;
        StatementList thenStatements = this.statementList = new StatementList();
        this.parseStatement(false);
        if (this.token.kind == 27) {
            this.scanner.scan();
            StatementList elseStatements = this.statementList = new StatementList();
            this.parseStatement(false);
            statement = new IfElseStatement(savedStatementList, pos, condition, thenStatements, elseStatements);
        } else {
            statement = new IfStatement(savedStatementList, pos, condition, thenStatements);
        }
        this.statementList = savedStatementList;
        this.statementList.add(statement);
    }

    private void parseReturnStatement() {
        int pos = this.token.pos;
        if (this.currentMethodSymbol.isClassInitializer()) {
            this.error(Message.errorReturnFromStatic, pos, false);
        } else if (this.currentMethodSymbol.isDynamicInitializer()) {
            this.error(Message.errorReturnFromInitializer, pos, false);
        }
        this.scanner.scan();
        Expression expr = this.parseExpression(2);
        if (expr != null) {
            pos = expr.pos;
        }
        this.statementList.add(new ReturnStatement(this.statementList, pos, expr));
    }

    private void parseSwitchStatement() {
        if (!$assertionsDisabled && this.token.kind != 51) {
            throw new AssertionError();
        }
        int pos = this.token.pos;
        if (this.scanner.scan() != 101) {
            this.syntaxError((byte)2, (byte)101);
        }
        this.scanner.scan();
        Expression expr = this.parseExpression(2);
        if (expr == null) {
            Error error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            expr = new ErrorExpression(error);
        }
        if (this.token.kind != 102) {
            this.syntaxError((byte)2, (byte)102);
        } else if (this.scanner.scan() != 80) {
            this.syntaxError((byte)2, (byte)80);
        }
        StatementList savedStatementList = this.statementList;
        StatementList bodyStatements = this.statementList = new StatementList();
        byte tokenKind = this.scanner.scan();
        int tokenPos = this.token.pos;
        this.parseBlockNewScope();
        if (this.statementList.first != null && tokenKind != 20 && tokenKind != 25) {
            this.error(Message.errorDifferentSymbolExpected, tokenPos, false, "case " + Message.orString + " default");
        }
        this.statementList = savedStatementList;
        this.statementList.add(new SwitchStatement(this.statementList, pos, expr, bodyStatements));
    }

    private void parseSynchronizedStatement() {
        if (!$assertionsDisabled && this.token.kind != 52) {
            throw new AssertionError();
        }
        int pos = this.token.pos;
        if (this.scanner.scan() != 101) {
            this.syntaxError((byte)2, (byte)101);
        }
        this.scanner.scan();
        Expression expr = this.parseExpression(2);
        if (expr == null) {
            Error error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            expr = new ErrorExpression(error);
        }
        if (this.token.kind != 102) {
            this.syntaxError((byte)2, (byte)102);
        } else if (this.scanner.scan() != 80) {
            this.syntaxError((byte)2, (byte)80);
        }
        StatementList savedStatementList = this.statementList;
        StatementList bodyStatements = this.statementList = new StatementList();
        this.scanner.scan();
        this.parseBlockNewScope();
        int endPos = this.token.prevEndPos;
        this.statementList = savedStatementList;
        this.statementList.add(new SynchronizedStatement(this.statementList, pos, endPos, expr, bodyStatements));
    }

    private void parseThrowStatement() {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression expr = this.parseExpression(2);
        if (expr == null) {
            Error error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            expr = new ErrorExpression(error);
        }
        this.statementList.add(new ThrowStatement(this.statementList, pos, expr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseTryStatement() {
        if (!$assertionsDisabled && this.token.kind != 58) {
            throw new AssertionError();
        }
        int pos = this.token.pos;
        if (this.scanner.scan() != 80) {
            this.syntaxError((byte)2, (byte)80);
        }
        StatementList savedStatementList = this.statementList;
        StatementList tryBody = this.statementList = new StatementList();
        this.scanner.scan();
        this.parseBlockNewScope();
        this.statementList = savedStatementList;
        CatchDescriptor cdLast = null;
        CatchDescriptor cdList = null;
        while (this.token.kind == 21) {
            Symbol[] declArray;
            Identifier identifier;
            Symbol symbol;
            LocalVariableSymbol catchVar = null;
            StatementList catchBody = null;
            if (this.scanner.scan() != 101) {
                this.syntaxError((byte)2, (byte)101);
            }
            short access = 0;
            if (this.scanner.scan() == 31) {
                access = 16;
                this.scanner.scan();
            }
            int tpos = this.token.pos;
            TypeSymbol catchType = this.parseType(false, false, false);
            if (this.token.kind != 10) {
                this.syntaxError((byte)2, (byte)10);
            }
            if ((symbol = this.currentScope.lookupSpecificSymbol(identifier = this.token.id, 64, false)) != null) {
                MethodVariableSymbol localVar = (MethodVariableSymbol)symbol;
                if (localVar.methodSymbol.definingClass.equalTo(this.currentClassSymbol) && (!(localVar instanceof LocalVariableSymbol) || localVar.methodSymbol == this.currentMethodSymbol)) {
                    this.error(Message.errorDuplicateDefinition, this.token.pos, false, symbol.errorName() + " " + Message.inString + " " + this.currentMethodSymbol.errorName());
                }
            }
            ArrayList declList = new ArrayList(1);
            if (!$assertionsDisabled && !(this.currentScope instanceof LocalScope)) {
                throw new AssertionError();
            }
            LocalScope scope = (LocalScope)this.currentScope;
            ArrayList savedDeclList = scope.recordDeclarations(declList);
            savedStatementList = this.statementList;
            try {
                short s = this.currentMethodSymbol.localVarCount;
                this.currentMethodSymbol.localVarCount = (short)(s + 1);
                catchVar = new LocalVariableSymbol(this.token.pos, this.currentMethodSymbol, identifier, catchType, tpos, access, null, s);
                catchVar.flags = (byte)(catchVar.flags | 4);
                this.currentMethodSymbol.cmd.localVariables.add(catchVar);
                scope.enterSymbol(catchVar);
                if (this.scanner.scan() != 102) {
                    this.syntaxError((byte)2, (byte)102);
                } else if (this.scanner.scan() != 80) {
                    this.syntaxError((byte)2, (byte)80);
                }
                catchBody = this.statementList = new StatementList();
                this.scanner.scan();
                this.parseBlock();
            }
            finally {
                scope.recordDeclarations(savedDeclList);
                declArray = declList.toArray(new Symbol[declList.size()]);
                scope.removeDeclarations(declArray);
            }
            if (this.options.localVariables) {
                this.statementList.add(new EndOfScopeStatement(this.statementList, declArray));
            }
            this.statementList = savedStatementList;
            CatchDescriptor cd = new CatchDescriptor(tpos, catchVar, catchBody);
            if (cdList == null) {
                cdList = cdLast = cd;
                continue;
            }
            cdLast.next = cd;
            cdLast = cd;
        }
        StatementList finallyBody = null;
        int fendpos = 0;
        int fstartpos = 0;
        if (this.token.kind == 32) {
            if (this.scanner.scan() != 80) {
                this.syntaxError((byte)2, (byte)80);
            }
            savedStatementList = this.statementList;
            finallyBody = this.statementList = new StatementList();
            this.scanner.scan();
            fstartpos = this.token.pos;
            this.parseBlock();
            fendpos = this.token.prevEndPos;
            this.statementList = savedStatementList;
        }
        this.statementList.add(new TryStatement(this.statementList, pos, tryBody, cdList, finallyBody, fstartpos, fendpos));
    }

    private void parseWhileStatement() {
        if (!$assertionsDisabled && this.token.kind != 60) {
            throw new AssertionError();
        }
        int pos = this.token.pos;
        if (this.scanner.scan() != 101) {
            this.syntaxError((byte)2, (byte)101);
        }
        this.scanner.scan();
        Expression condition = this.parseExpression(2);
        if (condition == null) {
            Error error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            condition = new ErrorExpression(error);
        }
        if (this.token.kind != 102) {
            this.syntaxError((byte)2, (byte)102);
        } else {
            this.scanner.scan();
        }
        StatementList savedStatementList = this.statementList;
        StatementList bodyStatements = this.statementList = new StatementList();
        int bodyPos = this.token.pos;
        this.parseStatement(false);
        this.statementList = savedStatementList;
        this.statementList.add(new WhileStatement(this.statementList, pos, bodyPos, condition, bodyStatements));
    }

    private InvokeExpression parseActualParameterList(int pos, Symbol unresolvedMethodSymbol, TypeVariableList typeArguments, Expression thisExpr, ExpressionList actualArgumentList) {
        ExpressionList actualArgumentLast;
        if (this.token.kind != 101) {
            this.syntaxError((byte)2, (byte)101);
        }
        if ((actualArgumentLast = actualArgumentList) != null) {
            while (actualArgumentLast.next != null) {
                actualArgumentLast = actualArgumentLast.next;
            }
        }
        while (true) {
            this.scanner.scan();
            Expression expr = this.parseExpression(2);
            if (expr == null) {
                if (this.token.kind != 102) {
                    this.syntaxError((byte)2, (byte)102);
                    break;
                }
                if (actualArgumentList != null) {
                    this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
                    this.syntaxError((byte)2);
                    break;
                }
                this.scanner.scan();
                break;
            }
            ExpressionList actualArgument = new ExpressionList(expr);
            if (actualArgumentList == null) {
                actualArgumentList = actualArgumentLast = actualArgument;
            } else {
                actualArgumentLast.next = actualArgument;
                actualArgumentLast = actualArgument;
            }
            if (this.token.kind == 102) {
                this.scanner.scan();
                break;
            }
            if (this.token.kind == 62) continue;
            this.syntaxError((byte)2, (byte)62);
        }
        return new InvokeExpression(pos, unresolvedMethodSymbol, typeArguments, thisExpr, actualArgumentList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnonymousClassSymbol parseAnonymousInnerClass(ClassSymbol superClass, InvokeExpression invokeExpr, NewExpression newExpr) {
        AnonymousClassSymbol classSymbol;
        short access = 16;
        if (this.currentMethodSymbol != null && (this.currentMethodSymbol.access & 8) != 0 || this.currentFieldSymbol != null && (this.currentFieldSymbol.access & 8) != 0) {
            access = (short)(access | 8);
        }
        RawClassSymbol outerClassSymbol = this.currentClassSymbol;
        ClassScope outerClassScope = this.currentClassScope;
        MethodSymbol savedCurrentMethod = this.currentMethodSymbol;
        this.currentMethodSymbol = null;
        FieldSymbol savedCurrentField = this.currentFieldSymbol;
        this.currentFieldSymbol = null;
        boolean savedParsingExplicitConstructorInvoke = this.parsingExplicitConstructorInvoke;
        this.parsingExplicitConstructorInvoke = false;
        try {
            ClassScope classScope;
            classSymbol = new AnonymousClassSymbol(this.token.pos, access);
            this.currentClassSymbol = classSymbol;
            classSymbol.scope = this.currentScope;
            classSymbol.superClass = superClass;
            classSymbol.cd.ccd.sourceFile = this.sourceFile;
            classSymbol.flags = (short)(classSymbol.flags | 0x20);
            classSymbol.invokeExpr = invokeExpr;
            this.currentClassScope = classScope = new ClassScope(classSymbol, this.currentScope, this);
            classSymbol.classScope = classScope;
            Scope outerScope = this.currentScope;
            this.currentScope = classScope;
            try {
                block11: {
                    outerClassSymbol.addInnerClass(classSymbol);
                    try {
                        this.scanner.scan();
                        this.parseClassBody(classSymbol);
                    }
                    catch (SyntaxError e) {
                        classSymbol.flags = (short)(classSymbol.flags | 0x10);
                        if (!(e instanceof SyntaxErrorEndOfBlock)) break block11;
                        this.scanner.scan();
                    }
                }
                if ((access & 8) == 0 && !savedParsingExplicitConstructorInvoke) {
                    Identifier thisDollarIdentifier = this.getThisDollarIdentifier(classSymbol);
                    FieldSymbol fieldSymbol = this.addSyntheticField(classSymbol, thisDollarIdentifier, outerClassSymbol, (short)16);
                    fieldSymbol.flags = (short)(fieldSymbol.flags | 0x20);
                    classSymbol.addHiddenOuterThisArgument(outerClassSymbol, fieldSymbol);
                }
                MethodSymbol methodSymbol = new MethodSymbol(0, classSymbol, Identifier.initializerIdentifier, TypeSymbol.voidSymbol, 0, 1, null, true);
                classSymbol.classScope.enterSymbol(methodSymbol);
                methodSymbol.localVarCount = 1;
                methodSymbol.actualArgCount = 1;
                methodSymbol.cmd.localVariables.add(null);
                methodSymbol.nextInClass = classSymbol.cd.methodList;
                classSymbol.cd.methodList = methodSymbol;
                classSymbol.constructorSymbol = methodSymbol;
            }
            finally {
                if (!$assertionsDisabled && this.currentScope != classScope) {
                    throw new AssertionError();
                }
                this.currentScope = outerScope;
            }
        }
        finally {
            this.parsingExplicitConstructorInvoke = savedParsingExplicitConstructorInvoke;
            this.currentMethodSymbol = savedCurrentMethod;
            this.currentFieldSymbol = savedCurrentField;
            this.currentClassSymbol = outerClassSymbol;
            this.currentClassScope = outerClassScope;
        }
        return classSymbol;
    }

    private Expression parseNewExpression(Expression outerClassExpr) {
        if (!$assertionsDisabled && this.token.kind != 41) {
            throw new AssertionError();
        }
        TypeVariableList typeVariableList = null;
        if (this.scanner.scan() == 89 && this.parsingAtLeastOneFive) {
            typeVariableList = this.parseActualTypeParameterList();
        }
        int pos = this.token.pos;
        TypeSymbol typeSymbol = this.parseTypeWithoutArray(true, false);
        if (typeSymbol.isErroneous()) {
            typeSymbol = this.javaLangObjectPcs;
        }
        if (this.token.kind == 76) {
            Error error;
            if (outerClassExpr != null) {
                this.error(Message.errorMalformedExpr, outerClassExpr.pos, false);
            }
            ExpressionList elast = null;
            ExpressionList elist = null;
            int dpos = this.token.pos;
            int dimension = 0;
            boolean emptyBracketsFound = false;
            do {
                ++dimension;
                if (this.scanner.scan() != 77) {
                    if (!emptyBracketsFound) {
                        Expression expr = this.parseExpression(2);
                        if (expr == null) {
                            error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
                            expr = new ErrorExpression(error);
                        }
                        ExpressionList el = new ExpressionList(expr);
                        if (elist != null) {
                            elast.next = el;
                            elast = el;
                        } else {
                            elist = elast = el;
                        }
                    }
                    if (this.token.kind == 77) continue;
                    this.syntaxError((byte)3, (byte)77);
                    continue;
                }
                emptyBracketsFound = true;
            } while (this.scanner.scan() == 76);
            if (dimension > 0) {
                typeSymbol = ArraySymbol.getArrayType(typeSymbol, dimension);
            }
            if (this.token.kind == 80) {
                if (elist != null) {
                    this.error(Message.errorArrayDimensionNotAllowed, dpos, false);
                }
                return this.parseArrayInitializer(typeSymbol);
            }
            if (elist == null) {
                error = this.error(Message.errorMissingArrayDimension, dpos, false);
                return new ErrorExpression(error);
            }
            return new NewExpression(pos, typeSymbol, null, elist);
        }
        NewExpression newExpr = new NewExpression(pos, typeSymbol, outerClassExpr, null);
        UnresolvedSymbol unresolvedMethodSymbol = new UnresolvedSymbol(pos, null, Identifier.initializerIdentifier);
        InvokeExpression invokeExpr = this.parseActualParameterList(pos, unresolvedMethodSymbol, typeVariableList, newExpr, null);
        if (this.token.kind == 80) {
            if (typeSymbol.typeKind != 10) {
                this.error(Message.errorObjectRequired, pos, false, typeSymbol.errorName());
                typeSymbol = this.javaLangObjectPcs;
            }
            newExpr.newType = this.parseAnonymousInnerClass((ClassSymbol)typeSymbol, invokeExpr, newExpr);
        }
        return invokeExpr;
    }

    private Expression parseAssignmentExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(2);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new AssignmentExpression(pos, leftExpr, rightExpr);
    }

    private Expression parsePlusAssignmentExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(2);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new AssignmentPlusExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseMinusAssignmentExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(2);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new AssignmentMinusExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseMultiplyAssignmentExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(2);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new AssignmentMultiplyExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseDivideAssignmentExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(2);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new AssignmentDivideExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseModuloAssignmentExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(2);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new AssignmentModuloExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseAndAssignmentExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(2);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new AssignmentBitAndExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseOrAssignmentExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(2);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new AssignmentBitOrExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseXorAssignmentExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(2);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new AssignmentBitXorExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseShiftLeftAssignmentExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(2);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new AssignmentShiftLeftExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseShiftRightAssignmentExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(2);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new AssignmentShiftRightExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseUnsignedShiftRightAssignmentExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(2);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new AssignmentUnsignedShiftRightExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseConditionalExpression(Expression condition) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression trueExpr = this.parseExpression(2);
        if (trueExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        if (this.token.kind != 79) {
            this.syntaxError((byte)3, (byte)79);
        }
        this.scanner.scan();
        Expression falseExpr = this.parseExpression(3);
        if (falseExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new ConditionalExpression(pos, condition, trueExpr, falseExpr);
    }

    private Expression parseLogicalOrExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(5);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new LogicalOrExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseLogicalAndExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(6);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new LogicalAndExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseBitOrExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(7);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new BitOrExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseBitXorExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(8);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new BitXorExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseBitAndExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(9);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new BitAndExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseEqualExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(10);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new EqualExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseNotEqualExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(10);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new NotEqualExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseLessExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(11);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new LessExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseGreaterExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(11);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new GreaterExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseLessOrEqualExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(11);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new LessOrEqualExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseGreaterOrEqualExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(11);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new GreaterOrEqualExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseInstanceOfExpression(Expression expr) {
        int pos = this.token.pos;
        this.scanner.scan();
        TypeSymbol typeSymbol = this.parseType(true, false, true);
        return new InstanceOfExpression(pos, expr, typeSymbol);
    }

    private Expression parseShiftLeftExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(12);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new ShiftLeftExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseShiftRightExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(12);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new ShiftRightExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseUnsignedShiftRightExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(12);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new UnsignedShiftRightExpression(pos, leftExpr, rightExpr);
    }

    private Expression parsePlusExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(13);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new PlusExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseMinusExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(13);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new MinusExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseMultiplyExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(14);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new MultiplyExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseDivideExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(14);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new DivideExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseModuloExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        Expression rightExpr = this.parseExpression(14);
        if (rightExpr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        return new ModuloExpression(pos, leftExpr, rightExpr);
    }

    private Expression parseSuperCallExpression(TypeVariableList typeVariableList, Expression leftExpr, int pos) {
        UnresolvedSymbol symbol = new UnresolvedSymbol(0, this.currentScope, Identifier.initializerIdentifier);
        SuperExpression expr = new SuperExpression(pos, this.currentClassSymbol, leftExpr);
        InvokeExpression invokeExpr = this.parseActualParameterList(pos, symbol, typeVariableList, expr, null);
        invokeExpr.flags = (byte)(invokeExpr.flags | 2);
        if (this.currentMethodSymbol == null || !this.currentMethodSymbol.isConstructor()) {
            this.error(Message.errorSelfMethodNotAllowed, pos, false, "super");
        } else {
            Statement stmt = this.statementList.first;
            if (this.statementList.parent == null && stmt instanceof ExpressionStatement) {
                ExpressionStatement exprStmt = (ExpressionStatement)stmt;
                if (exprStmt.expr instanceof InvokeExpression && (((InvokeExpression)exprStmt.expr).flags & 2) != 0) {
                    stmt.parent.remove(stmt);
                }
            }
        }
        return invokeExpr;
    }

    private Expression parseDotExpression(Expression leftExpr) {
        if (!$assertionsDisabled && this.token.kind != 61) {
            throw new AssertionError();
        }
        switch (this.scanner.scan()) {
            case 89: {
                if (this.parsingAtLeastOneFive) {
                    TypeVariableList typeVariableList = this.parseActualTypeParameterList();
                    int pos = this.token.pos;
                    UnresolvedSymbol symbol = new UnresolvedSymbol(pos, null, this.token.id);
                    if (this.scanner.scan() != 101) {
                        this.syntaxError((byte)3, (byte)101);
                    }
                    return this.parseActualParameterList(pos, symbol, typeVariableList, leftExpr, null);
                }
            }
            default: {
                this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
                this.syntaxError((byte)3);
            }
            case 50: {
                int pos = this.token.pos;
                if (this.scanner.scan() != 101) {
                    this.syntaxError((byte)3, (byte)101);
                }
                return this.parseSuperCallExpression(null, leftExpr, pos);
            }
            case 41: {
                return this.parseNewExpression(leftExpr);
            }
            case 10: 
        }
        int pos = this.token.pos;
        UnresolvedSymbol symbol = new UnresolvedSymbol(pos, null, this.token.id);
        if (this.scanner.scan() == 101) {
            return this.parseActualParameterList(pos, symbol, null, leftExpr, null);
        }
        return new FieldExpression(pos, symbol, leftExpr);
    }

    private Expression parseArrayAccess(Expression leftExpr) {
        if (!$assertionsDisabled && this.token.kind != 76) {
            throw new AssertionError();
        }
        this.scanner.scan();
        Expression expr = this.parseExpression(2);
        if (expr == null) {
            this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
            this.syntaxError((byte)3);
        }
        if (this.token.kind != 77) {
            this.syntaxError((byte)3, (byte)77);
        } else {
            this.scanner.scan();
        }
        return new ArrayExpression(leftExpr, expr);
    }

    private Expression parsePostIncrementExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        return new PostIncrementExpression(pos, leftExpr);
    }

    private Expression parsePostDecrementExpression(Expression leftExpr) {
        int pos = this.token.pos;
        this.scanner.scan();
        return new PostDecrementExpression(pos, leftExpr);
    }

    private TypeSymbol symbolToTypeSymbol(Symbol symbol, TypeVariableList typeVariableList) {
        if ((symbol.kind & 0x20) != 0) {
            if (!$assertionsDisabled && typeVariableList != null) {
                throw new AssertionError();
            }
            return (TypeSymbol)symbol;
        }
        if ((symbol.kind & 0xFFFFFFC0) != 0) {
            return new UnresolvedClassSymbol(null, symbol.identifier, typeVariableList, this.currentScope);
        }
        return new UnresolvedClassSymbol((UnresolvedSymbol)symbol, typeVariableList, this.currentScope);
    }

    private Expression tryParsingCastExpression() {
        int pos = this.token.pos;
        Symbol symbol = this.parseQualifiedIdentifier(false);
        boolean isType = false;
        if (this.token.kind == 89) {
            if (!this.parsingAtLeastOneFive) {
                return null;
            }
            switch (this.scanner.scanAhead()) {
                default: {
                    return null;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    Object scannerState = this.scanner.saveScannerState();
                    this.scanner.scan();
                    this.scanner.scan();
                    if (this.token.kind != 76 || this.scanner.scanAhead() != 77) {
                        return null;
                    }
                    this.scanner.restoreScannerState(scannerState);
                    break;
                }
                case 10: {
                    Object scannerState = this.scanner.saveScannerState();
                    this.scanner.scan();
                    this.parseQualifiedIdentifier(false);
                    if (this.token.kind != 90 && this.token.kind != 89 && this.token.kind != 62 && (this.token.kind != 76 || this.scanner.scanAhead() != 77)) {
                        return null;
                    }
                    this.scanner.restoreScannerState(scannerState);
                }
                case 78: 
            }
            TypeVariableList typeVariableList = this.parseActualTypeParameterList();
            symbol = this.symbolToTypeSymbol(symbol, typeVariableList);
            isType = true;
        }
        if (this.token.kind == 76) {
            if (this.scanner.scanAhead() != 77) {
                if (isType) {
                    this.error(Message.errorIllegalStartOfExpr, pos, false);
                }
                return null;
            }
            int dim = 0;
            do {
                if (this.scanner.scan() != 77) {
                    this.syntaxError((byte)3, (byte)77);
                }
                ++dim;
            } while (this.scanner.scan() == 76);
            symbol = ArraySymbol.getArrayType(this.symbolToTypeSymbol(symbol, null), dim);
        }
        if (this.token.kind == 102) {
            this.scanner.scan();
            this.checkIdentifierNewerKeywordsConflict();
            if (Token.isStartOfExpressionToken(this.token.kind)) {
                TypeSymbol typeSymbol = this.symbolToTypeSymbol(symbol, null);
                Expression expr = this.parseExpression(14);
                return new CastExpression(pos, expr, typeSymbol);
            }
            if (isType) {
                this.error(Message.errorIllegalStartOfExpr, pos, false);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Expression parseExpression(int pLevel) {
        pos = this.token.pos;
        block1 : switch (this.token.kind) {
            default: {
                return null;
            }
            case 89: {
                if (!this.parsingAtLeastOneFive) {
                    return null;
                }
                typeVariableList = this.parseActualTypeParameterList();
                if (this.token.kind != 50) {
                    this.syntaxError((byte)3, (byte)10);
                }
                if (this.scanner.scan() != 101) {
                    this.syntaxError((byte)3, (byte)101);
                }
                expr = this.parseSuperCallExpression(typeVariableList, null, pos);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                typeSymbol = TypeSymbol.tokenToTypeSymbol(this.token.kind);
                if (this.scanner.scan() == 76) {
                    dim = 0;
                    do {
                        if (this.scanner.scan() != 77) {
                            this.syntaxError((byte)3, (byte)77);
                        }
                        ++dim;
                    } while (this.scanner.scan() == 76);
                    if (typeSymbol == TypeSymbol.voidSymbol) {
                        this.error(Message.errorTypeNotAllowed, pos, false, typeSymbol.errorName());
                        typeSymbol = TypeSymbol.errorSymbol;
                    } else {
                        typeSymbol = ArraySymbol.getArrayType(typeSymbol, dim);
                    }
                }
                if (this.token.kind != 61) {
                    return null;
                }
                if (this.scanner.scan() != 22) {
                    this.syntaxError((byte)3, (byte)22);
                }
                expr = new ClassExpression(pos, typeSymbol, this);
                this.scanner.scan();
                break;
            }
            case 17: 
            case 28: {
                this.checkIdentifierNewerKeywordsConflict();
            }
            case 10: {
                symbol = this.parseQualifiedIdentifier(false);
                if (symbol.isErroneous()) {
                    this.syntaxError((byte)3, (byte)10);
                }
                kind = symbol.kind;
                typeFound = false;
                atplPos = 0;
                typeVariableList = null;
                if (pLevel <= 1 && this.parsingAtLeastOneFive && this.token.kind == 89) {
                    atplPos = this.token.pos;
                    typeVariableList = this.parseActualTypeParameterList();
                }
                block26 : switch (this.token.kind) {
                    default: {
                        if (symbol.isErroneous() || (kind & 67) != 0) break;
                        try {
                            sym = this.currentScope.lookupSpecificSymbol(symbol.identifier, 66, false);
                        }
                        catch (UnresolvedSuperClassException ex) {
                            sym = null;
                        }
                        if (sym != null) {
                            symbol = sym;
                            break;
                        }
                        symbol = new UnresolvedSymbol(symbol.pos, this.currentScope, symbol.identifier);
                        break;
                    }
                    case 101: {
                        if ((kind & 1) != 0) break;
                        if (!Parser.$assertionsDisabled && (kind & -64) == 0) {
                            throw new AssertionError();
                        }
                        symbol = new UnresolvedSymbol(symbol.pos, this.currentScope, symbol.identifier);
                        break;
                    }
                    case 10: 
                    case 17: 
                    case 28: {
                        symbol = this.symbolToTypeSymbol(symbol, typeVariableList);
                        typeFound = true;
                        break;
                    }
                    case 76: {
                        if (this.scanner.scanAhead() != 77) break;
                        typeSymbol = this.symbolToTypeSymbol(symbol, typeVariableList);
                        typeFound = true;
                        dim = 0;
                        do {
                            this.scanner.scan();
                            if (this.token.kind != 77) {
                                this.syntaxError((byte)3, (byte)77);
                            }
                            ++dim;
                        } while (this.scanner.scan() == 76);
                        symbol = ArraySymbol.getArrayType(typeSymbol, dim);
                        break;
                    }
                    case 61: {
                        switch (this.scanner.scanAhead()) {
                            default: {
                                break block26;
                            }
                            case 10: {
                                if (typeVariableList == null) break block26;
                                baseQualifier = (UnresolvedClassSymbol)this.symbolToTypeSymbol(symbol, typeVariableList);
                                typeVariableList = null;
                                this.scanner.scan();
                                idLast = null;
                                idList = null;
                                idPos = this.token.pos;
                                id = this.token.id;
                                this.scanner.scan();
                                while (true) {
                                    if (this.token.kind == 61) {
                                        this.scanner.scan();
                                        if (this.token.kind != 10) {
                                            this.syntaxError((byte)1, (byte)10);
                                        }
                                        il = new IdentifierList(idPos, id);
                                        if (idList == null) {
                                            idList = idLast = il;
                                        } else {
                                            idLast.next = il;
                                            idLast = il;
                                        }
                                        idPos = this.token.pos;
                                        id = this.token.id;
                                        this.scanner.scan();
                                        continue;
                                    }
                                    if (this.token.kind == 89) {
                                        typeVariableList = this.parseActualTypeParameterList();
                                    }
                                    baseQualifier = new UnresolvedClassSymbol(baseQualifier, idList, id, typeVariableList);
                                    typeVariableList = null;
                                    if (this.token.kind != 61) break;
                                    this.scanner.scan();
                                    if (this.token.kind != 10) {
                                        this.syntaxError((byte)1, (byte)10);
                                    }
                                    idLast = null;
                                    idList = null;
                                    idPos = this.token.pos;
                                    id = this.token.id;
                                    this.scanner.scan();
                                }
                                symbol = baseQualifier;
                                typeFound = true;
                                break block26;
                            }
                            case 89: {
                                if (!this.parsingAtLeastOneFive) break block26;
                                this.scanner.scan();
                                if (typeVariableList != null) {
                                    this.syntaxError((byte)3, (byte)10);
                                }
                                atplPos = this.token.pos;
                                typeVariableList = this.parseActualTypeParameterList();
                                switch (this.token.kind) {
                                    default: {
                                        this.syntaxError((byte)3, (byte)10);
                                    }
                                    case 50: {
                                        if (this.scanner.scan() != 101) {
                                            this.syntaxError((byte)3, (byte)101);
                                        }
                                        if ((kind & 1) != 0) {
                                            expr = new FieldExpression(pos, symbol, null);
                                        } else if ((kind & 64) != 0) {
                                            expr = new MethodVariableExpression(pos, (MethodVariableSymbol)symbol);
                                        } else {
                                            error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
                                            expr = new ErrorExpression(error);
                                        }
                                        expr = this.parseSuperCallExpression(typeVariableList, expr, pos);
                                        break block1;
                                    }
                                    case 10: 
                                }
                                typeFound = true;
                                pos = this.token.pos;
                                id = this.token.id;
                                if (this.scanner.scan() != 101) {
                                    this.syntaxError((byte)3, (byte)101);
                                }
                                if ((kind & 64) != 0) {
                                    expr = new MethodVariableExpression(pos, (MethodVariableSymbol)symbol);
                                    expr = this.parseActualParameterList(pos, new UnresolvedSymbol(pos, this.currentScope, null, id), typeVariableList, expr, null);
                                    break block1;
                                }
                                qualifierList = new IdentifierList(pos, symbol.identifier);
                                if ((kind & 1) != 0) {
                                    unresSymbol = (UnresolvedSymbol)symbol;
                                    if (unresSymbol.qualifierList == null) {
                                        unresSymbol.qualifierList = qualifierList;
                                    } else {
                                        qualifierList = unresSymbol.qualifierList.add(qualifierList);
                                    }
                                }
                                symbol = new UnresolvedSymbol(pos, this.currentScope, qualifierList, id);
                                break block26;
                            }
                            case 50: {
                                this.scanner.scan();
                                if (this.scanner.scan() == 101) {
                                    if ((kind & 1) != 0) {
                                        expr = new FieldExpression(pos, symbol, null);
                                    } else if ((kind & 64) != 0) {
                                        expr = new MethodVariableExpression(pos, (MethodVariableSymbol)symbol);
                                    } else {
                                        error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
                                        expr = new ErrorExpression(error);
                                    }
                                    expr = this.parseSuperCallExpression(typeVariableList, expr, pos);
                                    break block1;
                                }
                                if (this.token.kind == 61 || !this.parsingAtLeastOneFive) {
                                    if (typeVariableList != null) {
                                        this.error(Message.errorDifferentSymbolExpected, atplPos, false, Token.tokenToString((byte)61));
                                    }
                                    typeSymbol = this.symbolToTypeSymbol(symbol, typeVariableList);
                                    typeFound = true;
                                    thisExpr = new SuperExpression(pos, this.currentClassSymbol, null);
                                    thisExpr.outerClassSymbol = typeSymbol;
                                    expr = thisExpr;
                                    break block1;
                                }
                                error = this.error(Message.errorDifferentSymbolExpected, this.token.pos, false, Token.tokenToString((byte)61));
                                expr = new ErrorExpression(error);
                                break block1;
                            }
                            case 22: 
                            case 53: {
                                if (typeVariableList != null) {
                                    this.error(Message.errorDifferentSymbolExpected, atplPos, false, Token.tokenToString((byte)61));
                                }
                                symbol = this.symbolToTypeSymbol(symbol, typeVariableList);
                                typeFound = true;
                            }
                        }
                    }
                }
                if (!typeFound && typeVariableList != null) {
                    this.error(Message.errorDifferentSymbolExpected, atplPos, false, Token.tokenToString((byte)10));
                }
                switch (symbol.kind & -5) {
                    default: {
                        if (!Parser.$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case -128: {
                        error = this.error(Message.errorIllegalStartOfExpr, pos, false);
                        expr = new ErrorExpression(error);
                        break block1;
                    }
                    case 32: {
                        if (this.token.kind == 61) {
                            switch (this.scanner.scan()) {
                                default: {
                                    error = this.error(Message.errorIllegalStartOfExpr, pos, false);
                                    expr = new ErrorExpression(error);
                                    break block1;
                                }
                                case 22: {
                                    typeSymbol = (TypeSymbol)symbol;
                                    expr = new ClassExpression(pos, typeSymbol, this);
                                    this.scanner.scan();
                                    break block1;
                                }
                                case 53: 
                            }
                            typeSymbol = (TypeSymbol)symbol;
                            thisExpr = new ThisExpression(pos, this.currentClassSymbol);
                            thisExpr.outerClassSymbol = typeSymbol;
                            this.scanner.scan();
                            expr = thisExpr;
                            break block1;
                        }
                        typeSymbol = (TypeSymbol)symbol;
                        if (pLevel > 1) {
                            error = this.error(Message.errorStatementRequired, pos, false);
                            return new ErrorExpression(error);
                        }
                        if (!this.parsingAtLeastOneFive || this.token.kind != 10) ** GOTO lbl278
                        id = this.token.id;
                        tokenKind = this.scanner.scanAhead();
                        if (tokenKind == 79) {
                            this.scanner.scan();
                            this.parseEnhancedForStatement(pos, id, typeSymbol, pos, (short)0);
                            return ErrorExpression.markerExpression;
                        }
                        if (tokenKind != 76) ** GOTO lbl278
                        scannerState = this.scanner.saveScannerState();
                        dim = 0;
                        this.scanner.scan();
                        do {
                            ++dim;
                            if (this.scanner.scan() == 77) ** GOTO lbl270
                            this.scanner.restoreScannerState(scannerState);
                            ** GOTO lbl278
lbl270:
                            // 1 sources

                            if (this.scanner.scanAhead() != 79) continue;
                            typeSymbol = ArraySymbol.getArrayType(typeSymbol, dim);
                            this.scanner.scan();
                            this.parseEnhancedForStatement(pos, id, typeSymbol, pos, (short)0);
                            return ErrorExpression.markerExpression;
                        } while (this.scanner.scan() == 76);
                        this.scanner.restoreScannerState(scannerState);
lbl278:
                        // 4 sources

                        this.parseVariableDeclaration(typeSymbol, pos, (short)0, 0);
                        return null;
                    }
                    case 1: {
                        if (this.token.kind == 101) {
                            expr = this.parseActualParameterList(pos, symbol, typeVariableList, null, null);
                            break block1;
                        }
                        expr = new FieldExpression(pos, symbol, null);
                        break block1;
                    }
                    case 64: 
                }
                expr = new MethodVariableExpression(pos, (MethodVariableSymbol)symbol);
                break;
            }
            case 11: {
                expr = new CharConstantExpression(pos, this.token.cval);
                this.scanner.scan();
                break;
            }
            case 12: {
                expr = new StringConstantExpression(pos, this.javaLangStringPcs, this.token.sval);
                this.scanner.scan();
                break;
            }
            case 14: {
                expr = new LongConstantExpression(pos, this.token.lval);
                this.scanner.scan();
                break;
            }
            case 15: {
                expr = new FloatConstantExpression(pos, this.token.fval);
                this.scanner.scan();
                break;
            }
            case 16: {
                expr = new DoubleConstantExpression(pos, this.token.dval);
                this.scanner.scan();
                break;
            }
            case 13: {
                expr = new IntConstantExpression(pos, TypeSymbol.intSymbol, this.token.ival);
                this.scanner.scan();
                break;
            }
            case 30: {
                expr = new BooleanConstantExpression(pos, false);
                this.scanner.scan();
                break;
            }
            case 57: {
                expr = new BooleanConstantExpression(pos, true);
                this.scanner.scan();
                break;
            }
            case 42: {
                expr = new NullConstantExpression(pos);
                this.scanner.scan();
                if (this.token.kind != 61) break;
                error = this.error(Message.errorNullDeref, pos, false);
                expr = new ErrorExpression(error);
                break;
            }
            case 53: {
                expr = new ThisExpression(pos, this.currentClassSymbol);
                this.scanner.scan();
                if (this.token.kind != 101) break;
                error = this.error(Message.errorSelfMethodNotAllowed, pos, false, "this");
                expr = new ErrorExpression(error);
                break;
            }
            case 50: {
                expr = new SuperExpression(pos, this.currentClassSymbol, null);
                this.scanner.scan();
                if (this.token.kind == 101) {
                    error = this.error(Message.errorSelfMethodNotAllowed, pos, false, "super");
                    expr = new ErrorExpression(error);
                }
                if (!this.parsingAtLeastOneFive || this.token.kind == 61) break;
                error = this.error(Message.errorDifferentSymbolExpected, this.token.pos, false, Token.tokenToString((byte)61));
                expr = new ErrorExpression(error);
                break;
            }
            case 96: {
                this.scanner.scan();
                expr = this.parseExpression(14);
                if (expr == null) {
                    error = this.error(Message.errorIllegalStartOfExpr, pos, false);
                    expr = new ErrorExpression(error);
                    break;
                }
                expr = new UnaryPlusExpression(pos, expr);
                break;
            }
            case 97: {
                this.scanner.scan();
                expr = this.parseExpression(14);
                if (expr == null) {
                    error = this.error(Message.errorIllegalStartOfExpr, pos, false);
                    expr = new ErrorExpression(error);
                    break;
                }
                expr = new NegateExpression(pos, expr);
                break;
            }
            case 101: {
                switch (this.scanner.scan()) {
                    default: {
                        expr = this.parseExpression(2);
                        if (this.token.kind != 102) {
                            this.syntaxError((byte)3, (byte)102);
                        }
                        this.scanner.scan();
                        break;
                    }
                    case 10: {
                        scannerState = this.scanner.saveScannerState();
                        expr = this.tryParsingCastExpression();
                        if (expr != null) break block1;
                        this.scanner.restoreScannerState(scannerState);
                        expr = this.parseExpression(2);
                        if (this.token.kind != 102) {
                            this.syntaxError((byte)3, (byte)102);
                        }
                        this.scanner.scan();
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        scannerState = this.scanner.saveScannerState();
                        typeSymbol = TypeSymbol.tokenToTypeSymbol(this.token.kind);
                        if (this.scanner.scan() == 76) {
                            dim = 0;
                            do {
                                if (this.scanner.scan() != 77) {
                                    this.syntaxError((byte)3, (byte)77);
                                }
                                ++dim;
                            } while (this.scanner.scan() == 76);
                            if (typeSymbol == TypeSymbol.voidSymbol) {
                                this.error(Message.errorTypeNotAllowed, pos, false, typeSymbol.errorName());
                                typeSymbol = TypeSymbol.errorSymbol;
                            } else {
                                typeSymbol = ArraySymbol.getArrayType(typeSymbol, dim);
                            }
                        }
                        if (this.token.kind == 61) {
                            this.scanner.restoreScannerState(scannerState);
                            expr = this.parseExpression(2);
                            if (this.token.kind != 102) {
                                this.syntaxError((byte)3, (byte)102);
                            }
                            this.scanner.scan();
                            break;
                        }
                        if (this.token.kind != 102) {
                            this.syntaxError((byte)3, (byte)102);
                        }
                        if (typeSymbol.typeKind == 1) {
                            this.error(Message.errorTypeNotAllowed, pos, false, typeSymbol.errorName());
                            typeSymbol = TypeSymbol.errorSymbol;
                        }
                        this.scanner.scan();
                        pos = this.token.pos;
                        expr = this.parseExpression(14);
                        if (expr == null) {
                            error = this.error(Message.errorIllegalStartOfExpr, pos, false);
                            expr = new ErrorExpression(error);
                        }
                        expr = new CastExpression(pos, expr, typeSymbol);
                        break;
                    }
                }
                break;
            }
            case 103: {
                this.scanner.scan();
                expr = this.parseExpression(14);
                if (expr == null) {
                    error = this.error(Message.errorIllegalStartOfExpr, pos, false);
                    expr = new ErrorExpression(error);
                    break;
                }
                expr = new PreIncrementExpression(pos, expr);
                break;
            }
            case 104: {
                this.scanner.scan();
                expr = this.parseExpression(14);
                if (expr == null) {
                    error = this.error(Message.errorIllegalStartOfExpr, pos, false);
                    expr = new ErrorExpression(error);
                    break;
                }
                expr = new PreDecrementExpression(pos, expr);
                break;
            }
            case 105: {
                this.scanner.scan();
                expr = this.parseExpression(14);
                if (expr == null) {
                    error = this.error(Message.errorIllegalStartOfExpr, pos, false);
                    expr = new ErrorExpression(error);
                    break;
                }
                expr = new LogicalNotExpression(pos, expr);
                break;
            }
            case 106: {
                this.scanner.scan();
                expr = this.parseExpression(14);
                if (expr == null) {
                    error = this.error(Message.errorIllegalStartOfExpr, pos, false);
                    expr = new ErrorExpression(error);
                    break;
                }
                expr = new BinaryComplementExpression(pos, expr);
                break;
            }
            case 41: {
                expr = this.parseNewExpression(null);
            }
        }
        block101: while (true) {
            switch (this.token.kind) {
                default: {
                    return expr;
                }
                case 64: {
                    if (pLevel > 2) {
                        return expr;
                    }
                    expr = this.parseAssignmentExpression(expr);
                    continue block101;
                }
                case 65: {
                    if (pLevel > 2) {
                        return expr;
                    }
                    expr = this.parsePlusAssignmentExpression(expr);
                    continue block101;
                }
                case 66: {
                    if (pLevel > 2) {
                        return expr;
                    }
                    expr = this.parseMinusAssignmentExpression(expr);
                    continue block101;
                }
                case 67: {
                    if (pLevel > 2) {
                        return expr;
                    }
                    expr = this.parseMultiplyAssignmentExpression(expr);
                    continue block101;
                }
                case 68: {
                    if (pLevel > 2) {
                        return expr;
                    }
                    expr = this.parseDivideAssignmentExpression(expr);
                    continue block101;
                }
                case 72: {
                    if (pLevel > 2) {
                        return expr;
                    }
                    expr = this.parseModuloAssignmentExpression(expr);
                    continue block101;
                }
                case 69: {
                    if (pLevel > 2) {
                        return expr;
                    }
                    expr = this.parseAndAssignmentExpression(expr);
                    continue block101;
                }
                case 70: {
                    if (pLevel > 2) {
                        return expr;
                    }
                    expr = this.parseOrAssignmentExpression(expr);
                    continue block101;
                }
                case 71: {
                    if (pLevel > 2) {
                        return expr;
                    }
                    expr = this.parseXorAssignmentExpression(expr);
                    continue block101;
                }
                case 73: {
                    if (pLevel > 2) {
                        return expr;
                    }
                    expr = this.parseShiftLeftAssignmentExpression(expr);
                    continue block101;
                }
                case 74: {
                    if (pLevel > 2) {
                        return expr;
                    }
                    expr = this.parseShiftRightAssignmentExpression(expr);
                    continue block101;
                }
                case 75: {
                    if (pLevel > 2) {
                        return expr;
                    }
                    expr = this.parseUnsignedShiftRightAssignmentExpression(expr);
                    continue block101;
                }
                case 78: {
                    if (pLevel > 3) {
                        return expr;
                    }
                    expr = this.parseConditionalExpression(expr);
                    continue block101;
                }
                case 83: {
                    if (pLevel > 4) {
                        return expr;
                    }
                    expr = this.parseLogicalOrExpression(expr);
                    continue block101;
                }
                case 82: {
                    if (pLevel > 5) {
                        return expr;
                    }
                    expr = this.parseLogicalAndExpression(expr);
                    continue block101;
                }
                case 85: {
                    if (pLevel > 6) {
                        return expr;
                    }
                    expr = this.parseBitOrExpression(expr);
                    continue block101;
                }
                case 86: {
                    if (pLevel > 7) {
                        return expr;
                    }
                    expr = this.parseBitXorExpression(expr);
                    continue block101;
                }
                case 84: {
                    if (pLevel > 8) {
                        return expr;
                    }
                    expr = this.parseBitAndExpression(expr);
                    continue block101;
                }
                case 87: {
                    if (pLevel > 9) {
                        return expr;
                    }
                    expr = this.parseEqualExpression(expr);
                    continue block101;
                }
                case 88: {
                    if (pLevel > 9) {
                        return expr;
                    }
                    expr = this.parseNotEqualExpression(expr);
                    continue block101;
                }
                case 89: {
                    if (pLevel > 10) {
                        return expr;
                    }
                    expr = this.parseLessExpression(expr);
                    continue block101;
                }
                case 90: {
                    if (pLevel > 10) {
                        return expr;
                    }
                    expr = this.parseGreaterExpression(expr);
                    continue block101;
                }
                case 91: {
                    if (pLevel > 10) {
                        return expr;
                    }
                    expr = this.parseLessOrEqualExpression(expr);
                    continue block101;
                }
                case 92: {
                    if (pLevel > 10) {
                        return expr;
                    }
                    expr = this.parseGreaterOrEqualExpression(expr);
                    continue block101;
                }
                case 38: {
                    if (pLevel > 10) {
                        return expr;
                    }
                    expr = this.parseInstanceOfExpression(expr);
                    continue block101;
                }
                case 93: {
                    if (pLevel > 11) {
                        return expr;
                    }
                    expr = this.parseShiftLeftExpression(expr);
                    continue block101;
                }
                case 94: {
                    if (pLevel > 11) {
                        return expr;
                    }
                    expr = this.parseShiftRightExpression(expr);
                    continue block101;
                }
                case 95: {
                    if (pLevel > 11) {
                        return expr;
                    }
                    expr = this.parseUnsignedShiftRightExpression(expr);
                    continue block101;
                }
                case 96: {
                    if (pLevel > 12) {
                        return expr;
                    }
                    expr = this.parsePlusExpression(expr);
                    continue block101;
                }
                case 97: {
                    if (pLevel > 12) {
                        return expr;
                    }
                    expr = this.parseMinusExpression(expr);
                    continue block101;
                }
                case 98: {
                    if (pLevel > 13) {
                        return expr;
                    }
                    expr = this.parseMultiplyExpression(expr);
                    continue block101;
                }
                case 99: {
                    if (pLevel > 13) {
                        return expr;
                    }
                    expr = this.parseDivideExpression(expr);
                    continue block101;
                }
                case 100: {
                    if (pLevel > 13) {
                        return expr;
                    }
                    expr = this.parseModuloExpression(expr);
                    continue block101;
                }
                case 61: {
                    expr = this.parseDotExpression(expr);
                    continue block101;
                }
                case 76: {
                    expr = this.parseArrayAccess(expr);
                    continue block101;
                }
                case 103: {
                    expr = this.parsePostIncrementExpression(expr);
                    continue block101;
                }
                case 104: 
            }
            expr = this.parsePostDecrementExpression(expr);
        }
    }

    private void parseStatement(boolean allowDeclaration) {
        block60: {
            int mpos = this.token.pos;
            Symbol symbol = null;
            short access = this.parseModifiers((short)32);
            int pos = this.token.pos;
            try {
                switch (this.token.kind) {
                    default: {
                        Expression expr = this.parseExpression(2);
                        if (expr == null) {
                            this.error(Message.errorIllegalStartOfExpr, pos, false);
                            break;
                        }
                        if (access != 0) {
                            this.error(Message.errorIllegalStartOfExpr, mpos, false);
                        }
                        this.statementList.add(new ExpressionStatement(this.statementList, pos, expr));
                        break;
                    }
                    case 63: {
                        this.statementList.add(new EmptyStatement(this.statementList, pos));
                        this.scanner.scan();
                        return;
                    }
                    case 22: {
                        if (!allowDeclaration) {
                            this.error(Message.errorStatementRequired, pos, false);
                        }
                        this.parseClassDeclaration(pos, access, 22);
                        return;
                    }
                    case 28: {
                        if (!allowDeclaration) {
                            this.error(Message.errorStatementRequired, pos, false);
                        }
                        this.parseClassDeclaration(pos, access, 28);
                        return;
                    }
                    case 39: {
                        if (!allowDeclaration) {
                            this.error(Message.errorStatementRequired, pos, false);
                        }
                        this.parseClassDeclaration(pos, access, 39);
                        return;
                    }
                    case 10: {
                        if (access != 0) {
                            int tpos = this.token.pos;
                            symbol = this.parseQualifiedIdentifier(false);
                            if ((symbol.kind & 1) == 0) {
                                if (!$assertionsDisabled && (symbol.kind & 0xFFFFFFC0) == 0) {
                                    throw new AssertionError();
                                }
                                symbol = new UnresolvedSymbol(symbol.pos, this.currentScope, symbol.identifier);
                            }
                            UnresolvedClassSymbol typeSymbol = new UnresolvedClassSymbol((UnresolvedSymbol)symbol, null, this.currentScope);
                            if (!allowDeclaration) {
                                this.error(Message.errorStatementRequired, pos, false);
                            }
                            this.parseVariableDeclaration(typeSymbol, tpos, access, pos);
                            break;
                        }
                        if (this.scanner.scanAhead() == 79) {
                            LabelSymbol labelSymbol;
                            SymbolList labelList = null;
                            do {
                                if ((symbol = this.currentScope.lookupSpecificSymbol(this.token.id, -128, false)) != null) {
                                    this.error(Message.errorDuplicateLabel, this.token.pos, false, this.token.id.toString());
                                } else {
                                    labelSymbol = new LabelSymbol(pos, this.token.id);
                                    this.currentScope.enterSymbol(labelSymbol);
                                    SymbolList sl = new SymbolList(labelSymbol);
                                    sl.next = labelList;
                                    labelList = sl;
                                }
                                this.scanner.scan();
                                this.scanner.scan();
                            } while (this.token.kind == 10 && this.scanner.scanAhead() == 79);
                            StatementList savedStatementList = this.statementList;
                            StatementList labeledStatements = this.statementList = new StatementList();
                            this.parseStatement(false);
                            this.statementList = savedStatementList;
                            LabeledStatement labeledStatement = new LabeledStatement(this.statementList, pos, labelList, labeledStatements);
                            this.statementList.add(labeledStatement);
                            while (labelList != null) {
                                labelSymbol = (LabelSymbol)labelList.symbol;
                                labelSymbol.labeledStatement = labeledStatement;
                                this.currentScope.removeSymbol(labelSymbol);
                                labelList = labelList.next;
                            }
                            return;
                        }
                        Expression expr = this.parseExpression(allowDeclaration ? 1 : 2);
                        if (expr == null) break;
                        this.statementList.add(new ExpressionStatement(this.statementList, pos, expr));
                        break;
                    }
                    case 8: {
                        if (this.scanner.scanAhead() == 61) {
                            Expression expr = this.parseExpression(2);
                            if (expr == null) {
                                this.error(Message.errorIllegalStartOfExpr, pos, false);
                                break;
                            }
                            if (access != 0) {
                                this.error(Message.errorIllegalStartOfExpr, mpos, false);
                            }
                            this.statementList.add(new ExpressionStatement(this.statementList, pos, expr));
                            break;
                        }
                        this.error(Message.errorIllegalStartOfExpr, mpos, false);
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (this.scanner.scanAhead() == 61) {
                            Expression expr = this.parseExpression(2);
                            if (expr == null) {
                                this.error(Message.errorIllegalStartOfExpr, pos, false);
                                break;
                            }
                            if (access != 0) {
                                this.error(Message.errorIllegalStartOfExpr, mpos, false);
                            }
                            this.statementList.add(new ExpressionStatement(this.statementList, pos, expr));
                            break;
                        }
                        int tpos = this.token.pos;
                        TypeSymbol typeSymbol = TypeSymbol.tokenToTypeSymbol(this.token.kind);
                        this.scanner.scan();
                        if (!allowDeclaration) {
                            this.error(Message.errorStatementRequired, pos, false);
                        }
                        this.parseVariableDeclaration(typeSymbol, tpos, access, pos);
                        break;
                    }
                    case 17: {
                        this.parseAssertStatement();
                        break;
                    }
                    case 19: {
                        LabelSymbol labelSymbol = null;
                        if (this.scanner.scan() == 10) {
                            labelSymbol = (LabelSymbol)this.currentScope.lookupSpecificSymbol(this.token.id, -128, false);
                            if (labelSymbol == null) {
                                Error error = this.error(Message.errorUndefinedLabel, this.token.pos, false, this.token.id.toString());
                                this.statementList.add(new ExpressionStatement(this.statementList, pos, new ErrorExpression(error)));
                                this.scanner.scan();
                                break;
                            }
                            this.scanner.scan();
                        }
                        this.statementList.add(new BreakStatement(this.statementList, pos, labelSymbol));
                        break;
                    }
                    case 20: {
                        Expression expr;
                        this.scanner.scan();
                        if (this.token.kind == 53 || this.token.kind == 50) {
                            this.error(Message.errorConstantRequired, pos, false);
                        }
                        if ((expr = this.parseExpression(2)) == null) {
                            this.error(Message.errorIllegalStartOfExpr, pos, false);
                        } else {
                            this.statementList.add(new CaseStatement(this.statementList, pos, expr));
                        }
                        if (this.token.kind != 79) {
                            this.syntaxError((byte)2, (byte)79);
                        } else {
                            this.scanner.scan();
                        }
                        return;
                    }
                    case 24: {
                        LabelSymbol labelSymbol = null;
                        if (this.scanner.scan() == 10) {
                            labelSymbol = (LabelSymbol)this.currentScope.lookupSpecificSymbol(this.token.id, -128, false);
                            if (labelSymbol == null) {
                                Error error = this.error(Message.errorUndefinedLabel, this.token.pos, false, this.token.id.toString());
                                this.statementList.add(new ExpressionStatement(this.statementList, pos, new ErrorExpression(error)));
                                this.scanner.scan();
                                break;
                            }
                            this.scanner.scan();
                        }
                        this.statementList.add(new ContinueStatement(this.statementList, pos, labelSymbol));
                        break;
                    }
                    case 25: {
                        this.statementList.add(new DefaultStatement(this.statementList, pos));
                        if (this.scanner.scan() != 79) {
                            this.syntaxError((byte)2, (byte)79);
                        } else {
                            this.scanner.scan();
                        }
                        return;
                    }
                    case 26: {
                        this.parseDoStatement();
                        break;
                    }
                    case 33: {
                        this.parseForStatement();
                        return;
                    }
                    case 35: {
                        this.parseIfStatement();
                        return;
                    }
                    case 47: {
                        this.parseReturnStatement();
                        break;
                    }
                    case 51: {
                        this.parseSwitchStatement();
                        return;
                    }
                    case 52: {
                        this.parseSynchronizedStatement();
                        return;
                    }
                    case 54: {
                        this.parseThrowStatement();
                        break;
                    }
                    case 58: {
                        this.parseTryStatement();
                        return;
                    }
                    case 60: {
                        this.parseWhileStatement();
                        return;
                    }
                    case 80: {
                        this.scanner.scan();
                        this.parseBlockNewScope();
                        return;
                    }
                }
                if (this.token.kind != 63) {
                    this.syntaxError((byte)2, (byte)63);
                } else {
                    this.scanner.scan();
                }
            }
            catch (SyntaxErrorEndOfStatement e) {
                if (this.token.kind != 63) break block60;
                this.scanner.scan();
            }
        }
    }

    private void parseElementValuePair(Annotation annotation) {
        boolean longFormat;
        boolean shortFormat;
        int shortPos;
        block7: {
            shortPos = 0;
            shortFormat = false;
            longFormat = false;
            if (!$assertionsDisabled && this.token.kind != 101) {
                throw new AssertionError();
            }
            if (this.scanner.scan() == 102) {
                this.scanner.scan();
                return;
            }
            while (this.token.kind == 10 && this.scanner.scanAhead() == 64) {
                longFormat = true;
                Identifier id = this.token.id;
                this.scanner.scan();
                this.scanner.scan();
                this.parseAnnotationValue(annotation, null, id);
                if (this.token.kind == 102) {
                    this.scanner.scan();
                    break block7;
                }
                if (this.token.kind != 62) {
                    this.syntaxError((byte)1, (byte)62);
                }
                this.scanner.scan();
            }
            shortPos = this.token.pos;
            shortFormat = true;
            this.parseAnnotationValue(annotation, null, Identifier.valueIdentifier);
            if (this.token.kind != 102) {
                this.syntaxError((byte)1, (byte)102);
            }
            this.scanner.scan();
        }
        if (shortFormat & longFormat) {
            this.error(Message.errorAnnotationFormat, shortPos, false);
        }
    }

    private boolean parseAnnotation() {
        if (!$assertionsDisabled && this.token.kind != 107) {
            throw new AssertionError();
        }
        byte nextToken = this.scanner.scanAhead();
        if (nextToken != 10) {
            if (nextToken == 39) {
                return false;
            }
            this.syntaxError((byte)1, (byte)10);
        }
        this.scanner.scan();
        int pos = this.token.pos;
        Symbol symbol = this.parseQualifiedIdentifier(false);
        if (!(symbol instanceof UnresolvedSymbol)) {
            symbol = new UnresolvedSymbol(pos, this.currentScope, symbol.identifier);
        }
        Annotation annotation = new Annotation(new UnresolvedClassSymbol((UnresolvedSymbol)symbol, null, this.currentScope), pos, false);
        if (this.token.kind == 101) {
            this.parseElementValuePair(annotation);
        }
        annotation.next = this.currentAnnotation;
        this.currentAnnotation = annotation;
        return true;
    }

    private short parseModifiers(short exclude) {
        this.currentAnnotation = null;
        short modifiers = 0;
        block14: while (true) {
            int access = 0;
            switch (this.token.kind) {
                default: {
                    break;
                }
                case 107: {
                    if (!this.parseAnnotation()) break;
                    continue block14;
                }
                case 46: {
                    access = 1;
                    break;
                }
                case 45: {
                    access = 4;
                    break;
                }
                case 44: {
                    access = 2;
                    break;
                }
                case 48: {
                    access = 8;
                    break;
                }
                case 18: {
                    access = 1024;
                    break;
                }
                case 31: {
                    access = 16;
                    break;
                }
                case 40: {
                    access = 256;
                    break;
                }
                case 52: {
                    access = 32;
                    break;
                }
                case 56: {
                    access = 128;
                    break;
                }
                case 59: {
                    access = 64;
                    break;
                }
                case 49: {
                    access = 2048;
                }
            }
            if (access == 0 || (access & exclude) != 0) break;
            if ((modifiers & access) != 0) {
                this.error(Message.errorRepeatedModifier, this.token.pos, false);
            }
            modifiers = (short)(modifiers | access);
            this.scanner.scan();
        }
        return modifiers;
    }

    private TypeVariableList parseActualTypeParameterList() {
        if (!$assertionsDisabled && this.token.kind != 89) {
            throw new AssertionError();
        }
        TypeVariableList varLast = null;
        TypeVariableList varList = null;
        block6: while (true) {
            TypeSymbol typeSymbol;
            int pos;
            byte kind;
            if (this.scanner.scan() == 78) {
                if (this.scanner.scan() == 29) {
                    kind = 2;
                    this.scanner.scan();
                    pos = this.token.pos;
                    typeSymbol = this.parseType(false, false, true);
                    if (typeSymbol.isErroneous()) {
                        typeSymbol = this.javaLangObjectPcs;
                    }
                } else if (this.token.kind == 50) {
                    kind = 3;
                    this.scanner.scan();
                    pos = this.token.pos;
                    typeSymbol = this.parseType(false, false, true);
                    if (typeSymbol.isErroneous()) {
                        typeSymbol = this.javaLangObjectPcs;
                    }
                } else {
                    kind = 0;
                    pos = this.token.pos;
                    typeSymbol = null;
                }
            } else {
                kind = 1;
                pos = this.token.pos;
                typeSymbol = this.parseType(true, false, true);
                if (typeSymbol.isPrimitiveType()) {
                    this.error(Message.errorObjectRequired, pos, typeSymbol.isErroneous(), typeSymbol.errorName());
                    typeSymbol = this.javaLangObjectPcs;
                }
            }
            TypeVariableList tvl = new TypeVariableList(new TypeVariableSymbol(pos, kind, (ReferenceTypeSymbol)typeSymbol));
            if (varList == null) {
                varList = varLast = tvl;
            } else {
                varLast.next = tvl;
                varLast = tvl;
            }
            switch (this.token.kind) {
                default: {
                    this.syntaxError((byte)0, (byte)90);
                    continue block6;
                }
                case 62: {
                    continue block6;
                }
                case 90: {
                    this.scanner.scan();
                    break block6;
                }
                case 94: {
                    this.token.kind = (byte)90;
                    break block6;
                }
                case 95: {
                    this.token.kind = (byte)94;
                    break block6;
                }
            }
            break;
        }
        return varList;
    }

    private Symbol parseQualifiedIdentifierRest(int position, Identifier identifier, boolean flagErrors) {
        UnresolvedSymbol unresolvedSymbol;
        if (!$assertionsDisabled && this.token.kind != 61) {
            throw new AssertionError();
        }
        byte tokenKind = this.scanner.scanAhead();
        block0 : switch (tokenKind) {
            case 22: 
            case 41: 
            case 50: 
            case 53: 
            case 89: {
                unresolvedSymbol = new UnresolvedSymbol(position, this.currentScope, identifier);
                break;
            }
            default: {
                IdentifierList il;
                IdentifierList identifierLast;
                IdentifierList identifierList = identifierLast = (il = new IdentifierList(position, identifier));
                while (true) {
                    if (this.scanner.scan() != 10) {
                        if (flagErrors) {
                            this.error(Message.errorDifferentSymbolExpected, this.token.pos, false, Token.tokenToString((byte)10));
                        }
                        return TypeSymbol.errorSymbol;
                    }
                    identifier = this.token.id;
                    position = this.token.pos;
                    if (this.scanner.scan() != 61) {
                        unresolvedSymbol = new UnresolvedSymbol(position, this.currentScope, identifier);
                        unresolvedSymbol.qualifierList = identifierList;
                        break block0;
                    }
                    switch (this.scanner.scanAhead()) {
                        case 22: 
                        case 41: 
                        case 50: 
                        case 53: 
                        case 89: {
                            unresolvedSymbol = new UnresolvedSymbol(position, this.currentScope, identifier);
                            unresolvedSymbol.qualifierList = identifierList;
                            break block0;
                        }
                    }
                    identifierLast.next = il = new IdentifierList(position, identifier);
                    identifierLast = il;
                }
            }
        }
        return unresolvedSymbol;
    }

    private Symbol parseQualifiedIdentifier(boolean ignoreLocals) {
        Symbol symbol;
        if (!$assertionsDisabled && this.token.kind != 10) {
            throw new AssertionError();
        }
        Identifier identifier = this.token.id;
        int position = this.token.pos;
        this.scanner.scan();
        Scope scope = this.currentScope;
        Scope surroundingMethodScope = null;
        Scope scopeRightNow = scope;
        while (scopeRightNow.kind >= 2) {
            if (scopeRightNow.kind >= 3) {
                surroundingMethodScope = scopeRightNow;
                break;
            }
            scopeRightNow = scopeRightNow.getOuterScope();
        }
        if (!ignoreLocals && surroundingMethodScope != null && this.token.kind != 101 && this.token.kind != 10 && (symbol = surroundingMethodScope.lookupSpecificSymbol(identifier, -64, false)) != null) {
            if (symbol.kind == 64) {
                MethodVariableSymbol localVar = (MethodVariableSymbol)symbol;
                if (this.token.kind == 61) {
                    Object scannerState = this.scanner.saveScannerState();
                    symbol = this.parseQualifiedIdentifierRest(position, identifier, false);
                    if (symbol != TypeSymbol.errorSymbol) {
                        if (this.token.kind == 10) {
                            return symbol;
                        }
                        if (this.token.kind == 76 && this.scanner.scanAhead() == 77) {
                            return symbol;
                        }
                        if (this.token.kind == 61) {
                            Object innerScannerState = this.scanner.saveScannerState();
                            this.scanner.scan();
                            if (this.token.kind == 22 || this.token.kind == 53) {
                                this.scanner.restoreScannerState(innerScannerState);
                                return symbol;
                            }
                            if (this.token.kind == 50) {
                                this.scanner.scan();
                                if (this.token.kind == 61) {
                                    this.scanner.restoreScannerState(innerScannerState);
                                    return symbol;
                                }
                            }
                        }
                    }
                    this.scanner.restoreScannerState(scannerState);
                }
                if (localVar.methodSymbol == this.currentMethodSymbol) {
                    return localVar;
                }
                symbol = this.currentClassScope.lookupSpecificSymbolInScope(identifier, 2, true);
                if (symbol == null) {
                    UnresolvedSymbol refSymbol = this.getReferenceForLocalInInnerClass(localVar, position);
                    if ((localVar.access & 0x10) == 0) {
                        refSymbol.symbolFlags = (byte)(refSymbol.symbolFlags | 4);
                    }
                    return refSymbol;
                }
            } else if (this.token.kind != 61) {
                return symbol;
            }
        }
        if (this.token.kind != 61) {
            return new UnresolvedSymbol(position, this.currentScope, identifier);
        }
        return this.parseQualifiedIdentifierRest(position, identifier, true);
    }

    private TypeSymbol parseTypeWithoutArray(boolean primitiveTypeOK, boolean voidTypeOK) {
        TypeSymbol typeSymbol;
        int pos = this.token.pos;
        switch (this.token.kind) {
            default: {
                this.error(Message.errorIllegalStartOfType, pos, false);
                this.syntaxError((byte)1);
            }
            case 10: {
                Symbol symbol = this.parseQualifiedIdentifier(true);
                if ((symbol.kind & 1) == 0) {
                    if (!$assertionsDisabled && (symbol.kind & 0xFFFFFFC0) == 0 && !symbol.isErroneous()) {
                        throw new AssertionError();
                    }
                    symbol = new UnresolvedSymbol(symbol.pos, this.currentScope, symbol.identifier);
                }
                if (this.parsingAtLeastOneFive && this.token.kind == 89) {
                    TypeVariableList typeVariableList = this.parseActualTypeParameterList();
                    UnresolvedClassSymbol unresolvedClassSymbol = new UnresolvedClassSymbol((UnresolvedSymbol)symbol, typeVariableList, this.currentScope);
                    if (this.token.kind != 61 || this.scanner.scanAhead() != 10) {
                        typeSymbol = unresolvedClassSymbol;
                        break;
                    }
                    this.scanner.scan();
                    typeSymbol = this.parseTypeWithoutArray(false, false);
                    if (typeSymbol == TypeSymbol.errorSymbol) break;
                    ((UnresolvedClassSymbol)typeSymbol).baseQualifier = unresolvedClassSymbol;
                    break;
                }
                typeSymbol = new UnresolvedClassSymbol((UnresolvedSymbol)symbol, null, this.currentScope);
                break;
            }
            case 8: {
                if (!voidTypeOK) {
                    this.error(Message.errorTypeNotAllowed, pos, false, TypeSymbol.voidSymbol.errorName());
                    typeSymbol = TypeSymbol.errorSymbol;
                } else {
                    typeSymbol = TypeSymbol.voidSymbol;
                }
                this.scanner.scan();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                typeSymbol = TypeSymbol.tokenToTypeSymbol(this.token.kind);
                this.scanner.scan();
            }
        }
        if (!primitiveTypeOK && typeSymbol.isPrimitiveType()) {
            this.error(Message.errorObjectRequired, pos, typeSymbol.isErroneous(), typeSymbol.errorName());
            typeSymbol = TypeSymbol.errorSymbol;
        }
        return typeSymbol;
    }

    private TypeSymbol parseType(boolean primitiveTypeOK, boolean voidTypeOK, boolean arrayTypeOK) {
        int position = this.token.pos;
        TypeSymbol typeSymbol = this.parseTypeWithoutArray(primitiveTypeOK, voidTypeOK);
        if (this.token.kind == 76) {
            int dimension = 0;
            do {
                if (this.scanner.scan() != 77) {
                    this.syntaxError((byte)1, (byte)77);
                }
                ++dimension;
            } while (this.scanner.scan() == 76);
            if (typeSymbol == TypeSymbol.voidSymbol) {
                this.error(Message.errorTypeNotAllowed, position, false, typeSymbol.errorName());
                typeSymbol = TypeSymbol.errorSymbol;
            } else if (!arrayTypeOK) {
                this.error(Message.errorUnexpectedType, position, false);
                typeSymbol = TypeSymbol.errorSymbol;
            } else {
                typeSymbol = ArraySymbol.getArrayType(typeSymbol, dimension);
            }
        }
        return typeSymbol;
    }

    private void skipTypeList() {
        while (true) {
            this.parseType(false, false, true);
            if (this.token.kind != 62) break;
            this.scanner.scan();
        }
    }

    private CompiledImplementationList parseImpementationList() {
        CompiledImplementationList root = null;
        CompiledImplementationList last = null;
        while (true) {
            TypeSymbol typeSymbol;
            if ((typeSymbol = this.parseType(false, false, true)).isClass()) {
                CompiledImplementationList current = new CompiledImplementationList((ClassSymbol)typeSymbol);
                if (root == null) {
                    root = current;
                } else {
                    last.next = current;
                }
                last = current;
            }
            if (this.token.kind != 62) break;
            this.scanner.scan();
        }
        return root;
    }

    private MethodSymbol.CompiledThrowsList parseThrowsList() {
        MethodSymbol.CompiledThrowsList last = null;
        MethodSymbol.CompiledThrowsList throwsList = null;
        while (true) {
            int typePos = this.token.pos;
            MethodSymbol.CompiledThrowsList list = new MethodSymbol.CompiledThrowsList(this.parseType(false, false, true), typePos);
            if (throwsList == null) {
                throwsList = last = list;
            } else {
                last.next = list;
                last = list;
            }
            if (this.token.kind != 62) break;
            this.scanner.scan();
        }
        return throwsList;
    }

    private Expression parseArrayInitializer(TypeSymbol typeSymbol) {
        Expression expr;
        int dimension;
        ArraySymbol arraySymbol;
        if (!$assertionsDisabled && this.token.kind != 80) {
            throw new AssertionError();
        }
        if (!(typeSymbol instanceof ArraySymbol)) {
            this.error(Message.errorArrayRequired, this.token.pos, false, typeSymbol.errorName());
            arraySymbol = (ArraySymbol)ArraySymbol.getArrayType(TypeSymbol.errorSymbol, 1);
            dimension = 1;
        } else {
            arraySymbol = (ArraySymbol)typeSymbol;
            dimension = arraySymbol.dimension;
        }
        if (!$assertionsDisabled && dimension <= 0) {
            throw new AssertionError();
        }
        int pos = this.token.pos;
        int size = 0;
        ExpressionList exprLast = null;
        ExpressionList exprList = null;
        while (true) {
            if (this.scanner.scan() == 81) {
                this.scanner.scan();
                break;
            }
            if (this.token.kind == 80) {
                expr = this.parseArrayInitializer(ArraySymbol.getArrayType(arraySymbol.baseType, dimension - 1));
            } else {
                expr = this.parseExpression(2);
                if (expr == null) {
                    Error error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
                    expr = new ErrorExpression(error);
                }
            }
            ++size;
            ExpressionList el = new ExpressionList(expr);
            if (exprList == null) {
                exprList = exprLast = el;
            } else {
                exprLast.next = el;
                exprLast = el;
            }
            if (this.token.kind == 81) {
                this.scanner.scan();
                break;
            }
            if (this.token.kind == 62) continue;
            this.syntaxError((byte)1, (byte)62);
        }
        expr = new IntConstantExpression(0, TypeSymbol.intSymbol, size);
        NewExpression newExpr = new NewExpression(pos, arraySymbol, null, new ExpressionList(expr));
        return new ArrayInitializerExpression(newExpr, exprList, pos);
    }

    private void parseVariableDeclaration(TypeSymbol typeSymbol, int tpos, short access, int mpos) {
        this.checkAllowedAccessModifiers(mpos, access, (short)16);
        TypeVariableList typeVariableList = null;
        if (this.parsingAtLeastOneFive && this.token.kind == 89 && typeSymbol instanceof UnresolvedClassSymbol) {
            typeVariableList = this.parseActualTypeParameterList();
            UnresolvedClassSymbol classSymbol = (UnresolvedClassSymbol)typeSymbol;
            if (!$assertionsDisabled && classSymbol.typeVariableList != null) {
                throw new AssertionError();
            }
            classSymbol.typeVariableList = typeVariableList;
        }
        int dimension = 0;
        while (this.token.kind == 76) {
            if (this.scanner.scan() != 77) {
                this.syntaxError((byte)1, (byte)77);
            } else {
                ++dimension;
            }
            this.scanner.scan();
        }
        if (dimension > 0) {
            typeSymbol = ArraySymbol.getArrayType(typeSymbol, dimension);
        }
        while (true) {
            this.checkIdentifierNewerKeywordsConflict();
            if (this.token.kind != 10) {
                this.syntaxError((byte)1, (byte)10);
                return;
            }
            int idPos = this.token.pos;
            Identifier identifier = this.token.id;
            Symbol symbol = this.currentScope.lookupSpecificSymbol(identifier, 64, false);
            if (symbol != null && ((MethodVariableSymbol)symbol).methodSymbol == this.currentMethodSymbol) {
                this.error(Message.errorDuplicateDefinition, this.token.pos, false, symbol.errorName() + " " + Message.inString + " " + this.currentMethodSymbol.errorName());
            }
            dimension = 0;
            while (this.scanner.scan() == 76) {
                if (this.scanner.scan() != 77) {
                    this.syntaxError((byte)1, (byte)77);
                    continue;
                }
                ++dimension;
            }
            TypeSymbol varTypeSymbol = typeSymbol;
            if (dimension > 0) {
                varTypeSymbol = ArraySymbol.getArrayType(varTypeSymbol, dimension);
            }
            if (this.currentMethodSymbol == null) {
                if (!$assertionsDisabled && !this.errorFound) {
                    throw new AssertionError();
                }
                return;
            }
            short s = this.currentMethodSymbol.localVarCount;
            this.currentMethodSymbol.localVarCount = (short)(s + 1);
            LocalVariableSymbol localVar = new LocalVariableSymbol(idPos, this.currentMethodSymbol, identifier, varTypeSymbol, tpos, access, this.currentAnnotation, s);
            this.currentMethodSymbol.cmd.localVariables.add(localVar);
            this.currentScope.enterSymbol(localVar);
            if (this.forStatementDeclList != null) {
                this.forStatementDeclList.add(localVar);
            }
            if ((varTypeSymbol.typeClass & 0x28) != 0) {
                this.currentMethodSymbol.localVarCount = (short)(this.currentMethodSymbol.localVarCount + 1);
                this.currentMethodSymbol.cmd.localVariables.add(null);
            }
            if (this.token.kind == 64) {
                Expression expr;
                int pos = this.token.pos;
                if (this.scanner.scan() == 80) {
                    expr = this.parseArrayInitializer(varTypeSymbol);
                } else {
                    expr = this.parseExpression(2);
                    if (expr == null) {
                        Error error = this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
                        expr = new ErrorExpression(error);
                    }
                    if ((access & 0x10) != 0) {
                        localVar.initializer = expr;
                    }
                }
                expr = new AssignmentExpression(pos, new MethodVariableExpression(idPos, localVar), expr);
                this.statementList.add(new LocalVarInitializationStatement(this.statementList, idPos, expr));
            }
            if (this.token.kind != 62) break;
            this.scanner.scan();
        }
    }

    private void parseBlock() {
        try {
            while (true) {
                if (this.token.kind == 9) {
                    this.syntaxError((byte)2, (byte)81);
                }
                if (this.token.kind != 81) {
                    this.parseStatement(true);
                    continue;
                }
                break;
            }
        }
        catch (SyntaxErrorEndOfBlock syntaxErrorEndOfBlock) {
            // empty catch block
        }
        this.currentMethodSymbol.cmd.lastLine = (short)Scanner.positionToLine(this.token.pos);
        this.scanner.scan();
    }

    private void parseBlockNewScope() {
        BlockScope scope = new BlockScope(this.currentScope, this);
        Scope outerScope = this.currentScope;
        this.currentScope = scope;
        try {
            this.parseBlock();
            if (this.options.localVariables) {
                this.statementList.add(new EndOfScopeStatement(this.statementList, scope));
            }
        }
        catch (SyntaxError e) {
            throw e;
        }
        finally {
            if (!$assertionsDisabled && this.currentScope != scope) {
                throw new AssertionError();
            }
            this.currentScope = outerScope;
        }
    }

    private Identifier getThisDollarIdentifier(RawClassSymbol classSymbol, int level) {
        if (!($assertionsDisabled || classSymbol.isNonStaticInnerClass() || this.errorFound)) {
            throw new AssertionError();
        }
        String thisDollarString = "this" + Identifier.dollarString;
        thisDollarString = thisDollarString + classSymbol.findInnerClassDepth();
        while (--level >= 0) {
            thisDollarString = thisDollarString + "$";
        }
        return Identifier.getIdentifier(thisDollarString);
    }

    private Identifier getThisDollarIdentifier(RawClassSymbol classSymbol) {
        int level = 0;
        while (true) {
            Identifier identifier = this.getThisDollarIdentifier(classSymbol, level);
            FieldSymbol fieldSymbol = (FieldSymbol)classSymbol.classScope.lookupSpecificSymbolInScope(identifier, 2, true);
            if (classSymbol.isCompiled() ? fieldSymbol == null || (fieldSymbol.flags & 0x20) != 0 : fieldSymbol != null && fieldSymbol.isSynthetic()) {
                return identifier;
            }
            ++level;
        }
    }

    FieldSymbol getThisDollarSymbol(RawClassSymbol classSymbol) {
        FieldSymbol fieldSymbol = (FieldSymbol)classSymbol.classScope.lookupSymbol(this.getThisDollarIdentifier(classSymbol), false);
        if (!$assertionsDisabled && fieldSymbol == null) {
            throw new AssertionError();
        }
        return fieldSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseExplicitConstructorInvocation(MethodSymbol methodSymbol, int pos) {
        boolean isSuper = false;
        RawClassSymbol classSymbol = methodSymbol.definingClass;
        ExpressionList exprList = null;
        TypeVariableList typeVariableList = null;
        if (classSymbol.isEnum()) {
            exprList = new ExpressionList(new MethodVariableExpression(0, (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(1)));
            exprList.next = new ExpressionList(new MethodVariableExpression(0, (MethodVariableSymbol)methodSymbol.cmd.localVariables.get(2)));
        }
        if (this.token.kind == 89 && this.parsingAtLeastOneFive) {
            typeVariableList = this.parseActualTypeParameterList();
        }
        switch (this.token.kind) {
            default: {
                this.addImplicitSuperConstructorInvoke(classSymbol, pos, this.statementList, exprList);
                break;
            }
            case 50: {
                if (classSymbol.isEnum()) {
                    this.error(Message.errorCannotCallSuperInEnum, this.token.pos, false);
                }
                isSuper = true;
            }
            case 53: {
                InvokeExpression invokeExpr;
                ThisExpression expr;
                if (this.scanner.scanAhead() != 101) {
                    this.addImplicitSuperConstructorInvoke(classSymbol, pos, this.statementList, exprList);
                    Expression expr2 = this.parseExpression(2);
                    if (expr2 == null) {
                        this.error(Message.errorIllegalStartOfExpr, this.token.pos, false);
                        this.syntaxError((byte)2);
                        break;
                    }
                    this.statementList.add(new ExpressionStatement(this.statementList, expr2.pos, expr2));
                    if (this.token.kind != 63) {
                        this.syntaxError((byte)2, (byte)63);
                        break;
                    }
                    this.scanner.scan();
                    break;
                }
                this.scanner.scan();
                if (!$assertionsDisabled && this.token.kind != 101) {
                    throw new AssertionError();
                }
                pos = this.token.pos;
                UnresolvedSymbol unresolvedSymbol = new UnresolvedSymbol(0, this.currentScope, Identifier.initializerIdentifier);
                if (isSuper) {
                    expr = new SuperExpression(pos, this.currentClassSymbol, null);
                } else {
                    methodSymbol.flags = (short)(methodSymbol.flags | 2);
                    expr = new ThisExpression(pos, this.currentClassSymbol);
                }
                boolean saveParsingExplicitConstructorInvoke = this.parsingExplicitConstructorInvoke;
                this.parsingExplicitConstructorInvoke = true;
                try {
                    invokeExpr = this.parseActualParameterList(pos, unresolvedSymbol, typeVariableList, expr, exprList);
                    invokeExpr.flags = (byte)(invokeExpr.flags | (isSuper ? 2 : 1));
                }
                finally {
                    this.parsingExplicitConstructorInvoke = saveParsingExplicitConstructorInvoke;
                }
                this.statementList.add(new ExpressionStatement(this.statementList, pos, invokeExpr));
                if (this.token.kind != 63) {
                    this.syntaxError((byte)2, (byte)63);
                    break;
                }
                this.scanner.scan();
            }
        }
    }

    private Identifier getSyntheticFieldForLocalName(MethodVariableSymbol localVar, int level) {
        StringBuffer sb = new StringBuffer("v");
        while (--level >= 0) {
            sb.append(Identifier.dollarCharacter);
        }
        sb.append(localVar.identifier.name);
        return Identifier.getIdentifier(sb.toString());
    }

    FieldSymbol lookupSyntheticFieldForLocalInInnerClass(InnerClassSymbol innerClassSymbol, MethodVariableSymbol localVar) {
        int level = 1;
        Identifier identifier;
        FieldSymbol fieldSymbol;
        while ((fieldSymbol = (FieldSymbol)innerClassSymbol.classScope.lookupSpecificSymbolInScope(identifier = this.getSyntheticFieldForLocalName(localVar, level), 2, true)) != null && (fieldSymbol.type != localVar.type || (fieldSymbol.flags & 0x10) == 0)) {
            ++level;
        }
        return fieldSymbol;
    }

    FieldSymbol getSyntheticFieldForLocalInInnerClass(MethodVariableSymbol localVar) {
        InnerClassSymbol innerClassSymbol = (InnerClassSymbol)this.currentClassSymbol.getTopLevelClass(localVar.methodSymbol);
        int level = 1;
        while (true) {
            Identifier identifier;
            FieldSymbol fieldSymbol;
            if ((fieldSymbol = (FieldSymbol)innerClassSymbol.classScope.lookupSpecificSymbolInScope(identifier = this.getSyntheticFieldForLocalName(localVar, level), 2, true)) == null) {
                fieldSymbol = this.addSyntheticField(innerClassSymbol, identifier, localVar.type, (short)18);
                fieldSymbol.flags = (short)(fieldSymbol.flags | 0x10);
                innerClassSymbol.addHiddenFinalLocalArgument(localVar, fieldSymbol);
                localVar.flags = (byte)(localVar.flags | 1);
                return fieldSymbol;
            }
            if (fieldSymbol.type == localVar.type && (fieldSymbol.flags & 0x10) != 0) {
                return fieldSymbol;
            }
            ++level;
        }
    }

    private UnresolvedSymbol getReferenceForLocalInInnerClass(MethodVariableSymbol localVar, int position) {
        FieldSymbol fieldSymbol = this.getSyntheticFieldForLocalInInnerClass(localVar);
        return new UnresolvedSymbol(position, this.currentScope, fieldSymbol.identifier);
    }

    FieldSymbol addSyntheticField(RawClassSymbol classSymbol, Identifier identifier, TypeSymbol typeSymbol, short access) {
        if (this.targetingAtLeastOneFive) {
            access = (short)(access | 0x1000);
        }
        FieldSymbol fieldSymbol = new FieldSymbol(0, classSymbol, identifier, typeSymbol, 0, access, null);
        fieldSymbol.flags = (short)(fieldSymbol.flags | 0xFFFFA001);
        classSymbol.classScope.enterSymbol(fieldSymbol);
        classSymbol.addField(fieldSymbol);
        return fieldSymbol;
    }

    void addReturnStatement(MethodSymbol methodSymbol, StatementList statementList) {
        Statement lastStatement = statementList.last;
        if (lastStatement == null || lastStatement.canReachNextStatement(false)) {
            if (methodSymbol.resultType.typeKind == 1) {
                ReturnStatement returnStmt = new ReturnStatement(statementList, 0, null);
                if (lastStatement != null && lastStatement.kind == 21) {
                    if (statementList.first == lastStatement) {
                        statementList.first = returnStmt;
                    } else {
                        lastStatement.prev.next = returnStmt;
                    }
                    returnStmt.next = lastStatement;
                } else {
                    statementList.add(returnStmt);
                }
                ++this.estimatedLineCount;
            } else {
                this.error(Message.errorMissingReturn, methodSymbol.pos, false);
            }
        }
    }

    private void addImplicitSuperConstructorInvoke(RawClassSymbol classSymbol, int pos, StatementList statementList, ExpressionList argumentList) {
        if (classSymbol.superClass != null) {
            UnresolvedSymbol unresolvedSymbol = new UnresolvedSymbol(0, this.currentScope, Identifier.initializerIdentifier);
            InvokeExpression invokeExpr = new InvokeExpression(pos, unresolvedSymbol, null, new SuperExpression(pos, classSymbol, null), argumentList);
            invokeExpr.flags = (byte)(invokeExpr.flags | 2);
            statementList.add(new ExpressionStatement(statementList, pos, invokeExpr));
        }
    }

    private void parseMethodBody(MethodSymbol methodSymbol) {
        if (!$assertionsDisabled && this.token.kind != 80) {
            throw new AssertionError();
        }
        int pos = this.token.pos;
        this.scanner.scan();
        MethodSymbol savedMethodSymbol = this.currentMethodSymbol;
        this.currentMethodSymbol = methodSymbol;
        StatementList savedStatementList = this.statementList;
        this.statementList = new StatementList();
        if (methodSymbol.isConstructor()) {
            this.parseExplicitConstructorInvocation(methodSymbol, pos);
        }
        try {
            this.parseBlock();
            if (this.options.localVariables) {
                this.statementList.add(new EndOfScopeStatement(this.statementList, this.currentScope));
            }
            methodSymbol.cmd.statementList = this.statementList;
        }
        catch (SyntaxError e) {
            throw e;
        }
        finally {
            this.currentMethodSymbol = savedMethodSymbol;
            this.statementList = savedStatementList;
        }
    }

    private void parseFormalParameters(MethodSymbol methodSymbol) {
        ArgumentVariableList argumentLast;
        if (!$assertionsDisabled && this.token.kind != 101) {
            throw new AssertionError();
        }
        short localVarCount = methodSymbol.localVarCount;
        short argCount = methodSymbol.argCount;
        ArgumentVariableList argumentList = argumentLast = methodSymbol.argumentList;
        int ellipsisPos = 0;
        if (argumentLast != null) {
            while (argumentLast.next != null) {
                argumentLast = argumentLast.next;
            }
        }
        if ((methodSymbol.access & 8) == 0 && localVarCount == 0) {
            localVarCount = (short)(localVarCount + 1);
            methodSymbol.cmd.localVariables.add(null);
        }
        if (this.scanner.scan() != 102) {
            if (this.currentClassSymbol.isAnnotation()) {
                this.error(Message.errorAnnotationMembersNoParms, this.token.pos, false);
            }
            while (true) {
                Identifier identifier;
                short access = this.parseModifiers((short)-17);
                int tpos = this.token.pos;
                TypeSymbol type = this.parseType(true, false, true);
                if (this.parsingAtLeastOneFive && this.token.kind == 108) {
                    ellipsisPos = this.token.pos;
                    methodSymbol.access = (short)(methodSymbol.access | 0x80);
                    this.scanner.scan();
                }
                this.checkIdentifierNewerKeywordsConflict();
                if (this.token.kind != 10) {
                    this.error(Message.errorDifferentSymbolExpected, this.token.pos, false, Token.tokenToString((byte)10));
                    identifier = Identifier.getIdentifier("2");
                } else {
                    identifier = this.token.id;
                    Symbol symbol = this.currentScope.lookupSpecificSymbolInScope(identifier, 64, false);
                    if (symbol != null) {
                        this.error(Message.errorDuplicateDefinition, this.token.pos, false, symbol.errorName() + " " + Message.inString + " " + methodSymbol.errorName());
                    }
                }
                short s = localVarCount;
                localVarCount = (short)(localVarCount + 1);
                ArgumentVariableSymbol arg = new ArgumentVariableSymbol(this.token.pos, methodSymbol, identifier, type, tpos, access, this.currentAnnotation, s);
                methodSymbol.cmd.localVariables.add(arg);
                this.currentScope.enterSymbol(arg);
                argCount = (short)(argCount + 1);
                ArgumentVariableList al = new ArgumentVariableList(arg);
                if (argumentList == null) {
                    argumentList = argumentLast = al;
                } else {
                    argumentLast.next = al;
                    argumentLast = al;
                }
                int dimension = 0;
                while (this.scanner.scan() == 76) {
                    if (this.scanner.scan() != 77) {
                        this.syntaxError((byte)1, (byte)77);
                        continue;
                    }
                    ++dimension;
                }
                if (dimension > 0) {
                    arg.type = ArraySymbol.getArrayType(type, dimension);
                }
                if (ellipsisPos != 0) {
                    arg.type = ArraySymbol.getArrayType(arg.type, 1);
                }
                if ((arg.type.typeClass & 0x28) != 0) {
                    localVarCount = (short)(localVarCount + 1);
                    methodSymbol.cmd.localVariables.add(null);
                }
                if (this.token.kind != 62) break;
                if (ellipsisPos != 0) {
                    this.error(Message.errorEllipsesMustBeLast, ellipsisPos, false);
                    ellipsisPos = 0;
                }
                this.scanner.scan();
            }
            if (this.token.kind != 102) {
                this.syntaxError((byte)1, (byte)102);
            }
        }
        methodSymbol.actualArgCount = methodSymbol.localVarCount = localVarCount;
        methodSymbol.argCount = argCount;
        methodSymbol.argumentList = argumentList;
    }

    private void parseConstructorDeclaratorRest(MethodSymbol methodSymbol) {
        if (this.token.kind != 101) {
            this.syntaxError((byte)1, (byte)101);
        }
        MethodScope scope = new MethodScope(methodSymbol, this.currentScope, this);
        Scope outerScope = this.currentScope;
        this.currentScope = scope;
        RawClassSymbol classSymbol = this.currentClassSymbol;
        if (classSymbol.isEnum()) {
            methodSymbol.localVarCount = 1;
            methodSymbol.actualArgCount = 1;
            methodSymbol.cmd.localVariables.add(null);
            methodSymbol.addArgument(this.javaLangStringSymbol);
            methodSymbol.addArgument(TypeSymbol.intSymbol);
        }
        try {
            TypeParameterList tpl = this.typeParameterList;
            while (tpl != null) {
                tpl.typeParameter.definingSymbol = methodSymbol;
                scope.enterSymbol(tpl.typeParameter);
                tpl = tpl.next;
            }
            tpl = this.typeParameterList;
            while (tpl != null) {
                tpl.typeParameter = (TypeParameterSymbol)tpl.typeParameter.replaceUnresolvedTypeParameters(this.typeParameterList);
                tpl = tpl.next;
            }
            methodSymbol.typeParameterList = this.typeParameterList;
            this.typeParameterList = null;
            this.parseFormalParameters(methodSymbol);
            if (this.scanner.scan() == 55) {
                this.scanner.scan();
                methodSymbol.throwsList = this.parseThrowsList();
            }
            if (this.token.kind != 80) {
                if (this.token.kind == 63 && classSymbol.isInterface()) {
                } else {
                    this.syntaxError((byte)1, (byte)80);
                }
            } else {
                this.parseMethodBody(methodSymbol);
            }
        }
        catch (SyntaxError e) {
            throw e;
        }
        finally {
            if (!$assertionsDisabled && this.currentScope != scope) {
                throw new AssertionError();
            }
            this.currentScope = outerScope;
        }
    }

    private void parseAnnotationValue(Annotation annotation, ArrayList values, Identifier elementName) {
        int pos = this.token.pos;
        switch (this.token.kind) {
            case 107: {
                this.scanner.scan();
                TypeSymbol annotationType = this.parseTypeWithoutArray(false, false);
                Annotation annot = new Annotation(annotationType, pos, false);
                if (annotation != null) {
                    annotation.addAnnotationElementValuePair(elementName, annot, pos);
                } else {
                    if (!$assertionsDisabled && values == null) {
                        throw new AssertionError();
                    }
                    values.add(new AnnotationElementValue(elementName, annot, pos, false, true));
                }
                if (this.token.kind != 101) break;
                this.parseElementValuePair(annot);
                break;
            }
            case 80: {
                if (annotation == null) {
                    this.error(Message.errorIllegalStartOfExpr, pos, false);
                }
                values = new ArrayList<ElementValue>();
                if (this.scanner.scan() == 81) {
                    this.scanner.scan();
                } else {
                    while (true) {
                        this.parseAnnotationValue(null, values, elementName);
                        if (this.token.kind == 81) {
                            this.scanner.scan();
                            break;
                        }
                        if (this.token.kind != 62) {
                            this.syntaxError((byte)1, (byte)62);
                        }
                        this.scanner.scan();
                    }
                }
                if (annotation == null) break;
                annotation.addArrayElementValuePair(elementName, values, pos);
                break;
            }
            default: {
                Expression expr = this.parseExpression(2);
                if (expr == null) {
                    Error error = this.error(Message.errorIllegalStartOfExpr, pos, false);
                    expr = new ErrorExpression(error);
                }
                if (annotation != null) {
                    annotation.addExpressionElementValuePair(elementName, expr, pos);
                    break;
                }
                if (!$assertionsDisabled && values == null) {
                    throw new AssertionError();
                }
                values.add(new ExpressionElementValue(elementName, expr, pos, false, true));
            }
        }
    }

    private void parseMethodDeclaratorRest(int pos, MethodSymbol methodSymbol) {
        if (!$assertionsDisabled && this.token.kind != 101) {
            throw new AssertionError();
        }
        MethodScope scope = new MethodScope(methodSymbol, this.currentScope, this);
        Scope outerScope = this.currentScope;
        this.currentScope = scope;
        try {
            methodSymbol.resultType.changeScope(scope);
            TypeParameterList tpl = this.typeParameterList;
            while (tpl != null) {
                tpl.typeParameter.definingSymbol = methodSymbol;
                scope.enterSymbol(tpl.typeParameter);
                tpl = tpl.next;
            }
            tpl = this.typeParameterList;
            while (tpl != null) {
                tpl.typeParameter = (TypeParameterSymbol)tpl.typeParameter.replaceUnresolvedTypeParameters(this.typeParameterList);
                tpl = tpl.next;
            }
            methodSymbol.typeParameterList = this.typeParameterList;
            this.typeParameterList = null;
            this.parseFormalParameters(methodSymbol);
            int dimension = 0;
            while (this.scanner.scan() == 76) {
                if (this.scanner.scan() != 77) {
                    this.syntaxError((byte)1, (byte)77);
                    continue;
                }
                ++dimension;
            }
            if (dimension > 0) {
                methodSymbol.resultType = ArraySymbol.getArrayType(methodSymbol.resultType, dimension);
            }
            if (this.token.kind == 55) {
                if (this.currentClassSymbol.isAnnotation()) {
                    this.error(Message.errorAnnotationNoThrows, this.token.pos, false);
                }
                this.scanner.scan();
                methodSymbol.throwsList = this.parseThrowsList();
            }
            if (this.token.kind == 25 && this.parsingAtLeastOneFive) {
                if (!this.currentClassSymbol.isAnnotation()) {
                    this.error(Message.errorIllegalDefault, this.token.pos, false);
                }
                this.scanner.scan();
                Annotation annotation = new Annotation(this.currentClassSymbol, this.token.pos, true);
                annotation.next = (Annotation)methodSymbol.annotation;
                methodSymbol.annotation = annotation;
                methodSymbol.flags = (short)(methodSymbol.flags | 0x40);
                this.parseAnnotationValue(annotation, null, methodSymbol.identifier);
            }
            if (this.token.kind != 63) {
                if ((methodSymbol.access & 0x500) != 0) {
                    String methodStr = methodSymbol.definingClass.isInterface() ? Message.interfaceMethodsString : ((methodSymbol.access & 0x100) != 0 ? Message.nativeMethodsString : Message.abstractMethodsString);
                    this.error(Message.errorCannotHaveBody, pos, false, methodStr);
                }
                if (this.token.kind != 80) {
                    this.syntaxError((byte)1, (byte)80);
                }
                this.parseMethodBody(methodSymbol);
            } else if ((methodSymbol.access & 0x500) == 0) {
                this.error(Message.errorMissingBody, pos, false);
            }
        }
        catch (SyntaxError e) {
            throw e;
        }
        finally {
            if (!$assertionsDisabled && this.currentScope != scope) {
                throw new AssertionError();
            }
            this.currentScope = outerScope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFieldDeclaratorRest(FieldSymbol fieldSymbol) {
        int dimension = 0;
        while (this.token.kind == 76) {
            if (this.scanner.scan() != 77) {
                this.syntaxError((byte)1, (byte)77);
                continue;
            }
            ++dimension;
            this.scanner.scan();
        }
        if (dimension > 0) {
            fieldSymbol.type = ArraySymbol.getArrayType(fieldSymbol.type, dimension);
        }
        if ((fieldSymbol.access & 0x10) == 0) {
            fieldSymbol.flags = (short)(fieldSymbol.flags | Short.MIN_VALUE);
        }
        if (this.token.kind == 64) {
            Expression expr;
            int pos;
            FieldSymbol savedFieldSymbol = this.currentFieldSymbol;
            this.currentFieldSymbol = fieldSymbol;
            try {
                pos = this.token.pos;
                if (this.scanner.scan() == 80) {
                    expr = this.parseArrayInitializer(fieldSymbol.type);
                } else {
                    expr = this.parseExpression(2);
                    if (expr == null) {
                        Error error = this.error(Message.errorIllegalStartOfExpr, pos, false);
                        expr = new ErrorExpression(error);
                    }
                }
            }
            finally {
                this.currentFieldSymbol = savedFieldSymbol;
            }
            fieldSymbol.initializer = expr;
            fieldSymbol.flags = (short)(fieldSymbol.flags | Short.MIN_VALUE);
            if ((fieldSymbol.flags & 2) == 0) {
                MethodSymbol methodSymbol = null;
                if ((fieldSymbol.access & 8) != 0) {
                    if (this.currentClassSymbol.hasClassInitializer()) {
                        methodSymbol = this.currentClassSymbol.getClassInitializer();
                    } else {
                        this.currentClassSymbol.storeNonConstStaticInitializer(fieldSymbol);
                    }
                } else {
                    methodSymbol = this.currentClassSymbol.getDynamicInitializer();
                }
                if (methodSymbol != null) {
                    methodSymbol.addFieldInitializer(fieldSymbol, pos);
                }
            }
        } else if (this.currentClassSymbol.isInterface()) {
            this.error(Message.errorMissingInitializer, this.token.pos, false);
        }
    }

    private void checkAllowedAccessModifiers(int pos, short access, short allowedAccess) {
        short illegalAccess = (short)(access & ~allowedAccess);
        if (illegalAccess != 0) {
            this.error(Message.errorModifierNotAllowed, pos, false, Symbol.accessToString(illegalAccess));
        }
    }

    private void checkConflictingAccessModifiers(int pos, short access, short conflictAccess, short withAccess) {
        if ((conflictAccess = (short)(conflictAccess & access)) != 0 && (withAccess = (short)(withAccess & access)) != 0) {
            this.error(Message.errorIllegalModifierCombo, pos, false, Symbol.accessToString(conflictAccess), Symbol.accessToString(withAccess));
        }
    }

    private void checkExcludingAccessModifiers(int pos, short access, short oneOfAccess) {
        if ((access = (short)(access & oneOfAccess)) != 0 && (access & access - 1) != 0) {
            short access1 = (short)(access & access - 1);
            short access2 = (short)(access & ~access1);
            this.error(Message.errorIllegalModifierCombo, pos, false, Symbol.accessToString(access1), Symbol.accessToString(access2));
        }
    }

    private void checkAndAddMethod(int modPos, int idPos, RawClassSymbol classSymbol, MethodSymbol methodSymbol, boolean isConstructor) {
        Identifier identifier;
        Symbol symbol;
        short access = methodSymbol.access;
        if (isConstructor) {
            if (classSymbol.isEnum()) {
                this.checkAllowedAccessModifiers(modPos, access, (short)2);
            } else {
                this.checkAllowedAccessModifiers(modPos, access, (short)135);
            }
        } else if (classSymbol.isInterface()) {
            this.checkAllowedAccessModifiers(modPos, access, (short)1439);
        } else {
            this.checkAllowedAccessModifiers(modPos, access, (short)3519);
        }
        this.checkConflictingAccessModifiers(modPos, access, (short)1024, (short)2362);
        this.checkConflictingAccessModifiers(modPos, access, (short)256, (short)2048);
        this.checkExcludingAccessModifiers(modPos, access, (short)7);
        if ((access & 0x400) != 0 && (classSymbol.access & 0x400) == 0) {
            if (classSymbol.isEnum() && !classSymbol.isAnonymousInnerClass()) {
                RawClassSymbol.makeEnumAbstract(classSymbol);
            } else {
                String classString = classSymbol.errorName();
                this.error(Message.errorShouldBeAbstract, modPos, false, classString, methodSymbol.errorName(), classString);
            }
        }
        if ((symbol = this.currentScope.lookupSpecificSymbolInScope(identifier = methodSymbol.identifier, 8, true)) == null) {
            this.currentScope.enterSymbol(methodSymbol);
        } else {
            MethodSymbol baseMethodSymbol = (MethodSymbol)symbol;
            methodSymbol.nextWithSameName = baseMethodSymbol.nextWithSameName;
            baseMethodSymbol.nextWithSameName = methodSymbol;
        }
    }

    private void checkIdentifierNewerKeywordsConflict() {
        String jdk;
        switch (this.token.kind) {
            default: {
                return;
            }
            case 28: {
                this.token.id = Identifier.enumIdentifier;
                jdk = "1.5";
                break;
            }
            case 17: {
                this.token.id = Identifier.assertIdentifier;
                jdk = "1.4";
            }
        }
        this.token.kind = (byte)10;
        this.error(Message.warningKeywordShouldNotBeUsed, this.token.pos, false, this.token.id.toString(), jdk);
    }

    private void parseMemberDecl(RawClassSymbol classSymbol, int pos, short access) {
        boolean isDeprecated = this.deprecatedFlag;
        this.deprecatedFlag = false;
        block0 : switch (this.token.kind) {
            default: {
                TypeParameterList tpl;
                this.typeParameterList = null;
                if (this.token.kind == 89 && this.parsingAtLeastOneFive) {
                    this.parseFormalTypeParameterList();
                    tpl = this.typeParameterList;
                    while (tpl != null) {
                        this.currentScope.enterSymbol(tpl.typeParameter);
                        tpl = tpl.next;
                    }
                }
                int tpos = this.token.pos;
                TypeSymbol typeSymbol = this.parseType(true, true, true);
                tpl = this.typeParameterList;
                while (tpl != null) {
                    this.currentScope.removeSymbol(tpl.typeParameter);
                    tpl = tpl.next;
                }
                int position = this.token.pos;
                this.checkIdentifierNewerKeywordsConflict();
                if (this.token.kind == 10) {
                    Identifier identifier = this.token.id;
                    if (this.scanner.scan() == 101) {
                        if (classSymbol.isInterface()) {
                            access = (short)(access | 0x401);
                        }
                        if ((access & 0x80) != 0) {
                            this.error(Message.errorModifierNotAllowed, pos, false, "transient");
                            access = (short)(access & 0xFFFFFF7F);
                        }
                        if ((access & 0x40) != 0) {
                            this.error(Message.errorModifierNotAllowed, pos, false, "volatile");
                            access = (short)(access & 0xFFFFFFBF);
                        }
                        MethodSymbol methodSymbol = new MethodSymbol(position, classSymbol, identifier, typeSymbol, tpos, access, this.currentAnnotation, true);
                        this.parseMethodDeclaratorRest(position, methodSymbol);
                        this.checkAndAddMethod(pos, position, classSymbol, methodSymbol, false);
                        if ((classSymbol.access & 0x800) != 0) {
                            methodSymbol.access = (short)(methodSymbol.access | 0x800);
                        }
                        if (isDeprecated) {
                            methodSymbol.deprecate();
                        }
                        methodSymbol.nextInClass = classSymbol.cd.methodList;
                        classSymbol.cd.methodList = methodSymbol;
                        break;
                    }
                    if (this.typeParameterList != null) {
                        this.typeParameterList = null;
                        this.syntaxError((byte)1, (byte)101);
                    }
                    if (typeSymbol == TypeSymbol.voidSymbol) {
                        this.error(Message.errorTypeNotAllowed, position, false, typeSymbol.errorName());
                        typeSymbol = TypeSymbol.errorSymbol;
                    }
                    if (classSymbol.isInterface()) {
                        access = (short)(access | 0x19);
                        this.checkAllowedAccessModifiers(pos, access, (short)25);
                    } else {
                        this.checkAllowedAccessModifiers(pos, access, (short)223);
                        this.checkConflictingAccessModifiers(pos, access, (short)16, (short)64);
                        this.checkExcludingAccessModifiers(pos, access, (short)7);
                    }
                    while (true) {
                        Symbol symbol;
                        if ((symbol = this.currentScope.lookupSpecificSymbolInScope(identifier, 2, true)) != null) {
                            this.error(Message.errorDuplicateDefinition, position, false, symbol.errorName() + " " + Message.inString + " " + this.currentClassSymbol.errorName());
                        }
                        FieldSymbol fieldSymbol = new FieldSymbol(position, classSymbol, identifier, typeSymbol, tpos, access, this.currentAnnotation);
                        this.currentScope.enterSymbol(fieldSymbol);
                        if (isDeprecated) {
                            fieldSymbol.deprecate();
                        }
                        this.parseFieldDeclaratorRest(fieldSymbol);
                        classSymbol.addField(fieldSymbol);
                        if (this.token.kind == 63) {
                            this.scanner.scan();
                            break block0;
                        }
                        if (this.token.kind != 62) {
                            this.syntaxError((byte)1, (byte)62);
                            break block0;
                        }
                        if (this.scanner.scan() != 10) {
                            this.syntaxError((byte)1, (byte)10);
                        }
                        identifier = this.token.id;
                        position = this.token.pos;
                        this.scanner.scan();
                    }
                }
                if (typeSymbol.identifier == classSymbol.identifier && typeSymbol instanceof UnresolvedClassSymbol && ((UnresolvedClassSymbol)typeSymbol).qualifierList == null) {
                    if (classSymbol.isInterface()) {
                        this.error(Message.errorConstructorsNotAllowed, pos, false, Message.interfaceString);
                        this.tryToRecoverFromSyntaxError((byte)1);
                    } else if (classSymbol.isEnum()) {
                        access = (short)(access | 2);
                    }
                    Identifier identifier = Identifier.initializerIdentifier;
                    MethodSymbol methodSymbol = new MethodSymbol(pos, classSymbol, identifier, TypeSymbol.voidSymbol, tpos, access, this.currentAnnotation, true);
                    this.parseConstructorDeclaratorRest(methodSymbol);
                    this.checkAndAddMethod(pos, position, classSymbol, methodSymbol, true);
                    if ((classSymbol.access & 0x800) != 0) {
                        methodSymbol.access = (short)(methodSymbol.access | 0x800);
                    }
                    if (isDeprecated) {
                        methodSymbol.deprecate();
                    }
                    methodSymbol.nextInClass = classSymbol.cd.methodList;
                    classSymbol.cd.methodList = methodSymbol;
                    break;
                }
                this.error(Message.errorReturnTypeRequired, pos, false);
                this.tryToRecoverFromSyntaxError((byte)1);
                break;
            }
            case 39: {
                this.parseClassDeclaration(pos, access, 39);
                break;
            }
            case 22: {
                this.parseClassDeclaration(pos, access, 22);
                break;
            }
            case 28: {
                this.parseClassDeclaration(pos, access, 28);
            }
        }
    }

    private void parseClassInitializer(MethodSymbol methodSymbol, int pos) {
        if ((this.currentClassSymbol.isNonStaticInnerClass() || this.currentClassSymbol.isLocalInnerClass()) && methodSymbol.isClassInitializer()) {
            this.error(Message.errorInnerCannotHaveStatics, pos, false);
        }
        MethodSymbol savedMethodSymbol = this.currentMethodSymbol;
        this.currentMethodSymbol = methodSymbol;
        StatementList savedStatementList = this.statementList;
        this.statementList = methodSymbol.cmd.statementList;
        MethodScope scope = new MethodScope(methodSymbol, this.currentScope, this);
        Scope outerScope = this.currentScope;
        this.currentScope = scope;
        try {
            this.scanner.scan();
            this.parseBlock();
            if (this.options.localVariables) {
                this.statementList.add(new EndOfScopeStatement(this.statementList, scope));
            }
        }
        catch (SyntaxError e) {
            throw e;
        }
        finally {
            if (!$assertionsDisabled && this.currentScope != scope) {
                throw new AssertionError();
            }
            this.currentScope = outerScope;
        }
        this.currentMethodSymbol = savedMethodSymbol;
        this.statementList = savedStatementList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RawClassSymbol parseEnumValueSpecificClassBody() {
        AnonymousClassSymbol classSymbol;
        RawClassSymbol outerClassSymbol = this.currentClassSymbol;
        ClassScope outerClassScope = this.currentClassScope;
        MethodSymbol savedCurrentMethod = this.currentMethodSymbol;
        this.currentMethodSymbol = null;
        FieldSymbol savedCurrentField = this.currentFieldSymbol;
        this.currentFieldSymbol = null;
        try {
            ClassScope classScope;
            classSymbol = new AnonymousClassSymbol(this.token.pos, 16408);
            this.currentClassSymbol = classSymbol;
            classSymbol.scope = this.currentScope;
            classSymbol.superClass = ParameterizedClassSymbol.getParameterizedClassSymbol(outerClassSymbol, null, null);
            classSymbol.cd.ccd.sourceFile = this.sourceFile;
            classSymbol.flags = (short)(classSymbol.flags | 0x20);
            this.currentClassScope = classScope = new ClassScope(classSymbol, this.currentScope, this);
            classSymbol.classScope = classScope;
            Scope outerScope = this.currentScope;
            this.currentScope = classScope;
            try {
                outerClassSymbol.addInnerClass(classSymbol);
                this.scanner.scan();
                this.parseClassBody(classSymbol);
                MethodSymbol methodSymbol = new MethodSymbol(classSymbol.pos, classSymbol, Identifier.initializerIdentifier, TypeSymbol.voidSymbol, 0, 0, null, true);
                methodSymbol.flags = (short)(methodSymbol.flags | 0x201);
                methodSymbol.localVarCount = 1;
                methodSymbol.actualArgCount = 1;
                methodSymbol.cmd.localVariables.add(null);
                methodSymbol.cmd.statementList = new StatementList();
                classSymbol.classScope.enterSymbol(methodSymbol);
                methodSymbol.nextInClass = classSymbol.cd.methodList;
                classSymbol.cd.methodList = methodSymbol;
                CastExpression expr = new CastExpression(0, new NullConstantExpression(0), classSymbol);
                ExpressionList exprList = new ExpressionList(expr);
                this.addImplicitSuperConstructorInvoke(classSymbol, classSymbol.pos, methodSymbol.cmd.statementList, exprList);
            }
            finally {
                if (!$assertionsDisabled && this.currentScope != classScope) {
                    throw new AssertionError();
                }
                this.currentScope = outerScope;
            }
        }
        catch (SyntaxError e) {
            throw e;
        }
        finally {
            this.currentMethodSymbol = savedCurrentMethod;
            this.currentFieldSymbol = savedCurrentField;
            this.currentClassSymbol = outerClassSymbol;
            this.currentClassScope = outerClassScope;
        }
        return classSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseEnumValues(RawClassSymbol classSymbol) {
        FieldSymbol field = new FieldSymbol(0, classSymbol, Identifier.enumValuesInternal, ArraySymbol.getArrayType(classSymbol, 1), 0, 4122, null);
        field.flags = (short)(field.flags | 0xFFFFA000);
        classSymbol.addField(field);
        if (this.token.kind == 62 && this.scanner.scanAhead() == 63) {
            this.scanner.scan();
        }
        int index = 0;
        while (this.token.kind != 63) {
            Symbol symbol;
            this.currentAnnotation = null;
            if (this.token.kind == 107) {
                this.parseAnnotation();
            }
            if (this.token.kind != 10) {
                this.syntaxError((byte)1, (byte)10);
            }
            if ((symbol = classSymbol.classScope.lookupSpecificSymbolInScope(this.token.id, 2, true)) != null) {
                this.error(Message.errorAlreadyDefined, this.token.pos, false, symbol.errorName());
            }
            int pos = this.token.pos;
            UnresolvedClassSymbol typeSymbol = new UnresolvedClassSymbol(classSymbol.toString(), null, (Scope)classSymbol.classScope);
            field = new FieldSymbol(pos, classSymbol, this.token.id, (TypeSymbol)typeSymbol, this.token.pos, 16409, this.currentAnnotation);
            field.flags = (short)(field.flags | Short.MIN_VALUE);
            classSymbol.classScope.enterSymbol(field);
            classSymbol.addField(field);
            ExpressionList exprList = new ExpressionList(new StringConstantExpression(pos, this.javaLangStringSymbol, field.identifier.name));
            exprList.next = new ExpressionList(new IntConstantExpression(pos, TypeSymbol.intSymbol, index));
            UnresolvedSymbol constructor = new UnresolvedSymbol(pos, this.currentScope, Identifier.initializerIdentifier);
            NewExpression newValue = new NewExpression(pos, classSymbol, null, null);
            FieldSymbol saveCurrentFieldSymbol = this.currentFieldSymbol;
            this.currentFieldSymbol = field;
            try {
                field.initializer = this.scanner.scan() == 101 ? this.parseActualParameterList(pos, constructor, null, newValue, exprList) : new InvokeExpression(pos, constructor, null, newValue, exprList);
            }
            finally {
                this.currentFieldSymbol = saveCurrentFieldSymbol;
            }
            if (this.token.kind == 80) {
                classSymbol.access = (short)(classSymbol.access & 0xFFFFFFEF);
                RawClassSymbol valueSpecificClass = this.parseEnumValueSpecificClassBody();
                MethodSymbol methodSymbol = new MethodSymbol(0, classSymbol, Identifier.initializerIdentifier, TypeSymbol.voidSymbol, 0, 0, null, true);
                methodSymbol.flags = (short)(methodSymbol.flags | 3);
                methodSymbol.localVarCount = 1;
                methodSymbol.actualArgCount = 1;
                methodSymbol.cmd.localVariables.add(null);
                methodSymbol.addArgument(valueSpecificClass);
                methodSymbol.nextInClass = classSymbol.cd.methodList;
                classSymbol.cd.methodList = methodSymbol;
                StatementList stmtList = methodSymbol.cmd.statementList = new StatementList();
                InvokeExpression invokeExpr = (InvokeExpression)field.initializer;
                invokeExpr.thisArgument = new ThisExpression(pos, classSymbol);
                invokeExpr.flags = (byte)(invokeExpr.flags | 1);
                stmtList.add(new ExpressionStatement(stmtList, pos, invokeExpr));
                constructor = new UnresolvedSymbol(pos, this.currentScope, Identifier.initializerIdentifier);
                newValue = new NewExpression(pos, valueSpecificClass, null, null);
                field.initializer = new InvokeExpression(pos, constructor, null, newValue, null);
            }
            if (this.token.kind == 81 || this.token.kind == 63) break;
            if (this.token.kind != 62) {
                this.syntaxError((byte)1, (byte)62);
            }
            if (this.scanner.scan() == 81) break;
            ++index;
        }
    }

    private void parseClassBody(RawClassSymbol classSymbol) {
        if (classSymbol.isEnum() && !classSymbol.isAnonymousInnerClass() && this.token.kind != 81) {
            this.parseEnumValues(classSymbol);
        }
        while (this.token.kind != 81) {
            while (this.token.kind == 63) {
                this.scanner.scan();
            }
            if (this.token.kind == 81) break;
            short access = 0;
            int pos = this.token.pos;
            if (this.token.kind == 48) {
                if (this.scanner.scan() == 80) {
                    if (classSymbol.isInterface()) {
                        this.error(Message.errorIllegalInitializer, this.token.pos, false, classSymbol.errorName());
                    }
                    this.parseClassInitializer(classSymbol.getClassInitializer(), pos);
                    continue;
                }
                access = (short)(access | 8);
            } else if (this.token.kind == 80) {
                if (classSymbol.isInterface()) {
                    this.error(Message.errorIllegalInitializer, this.token.pos, false, classSymbol.errorName());
                }
                this.parseClassInitializer(classSymbol.getDynamicInitializer(), 0);
                continue;
            }
            if (this.token.kind == 107 && this.scanner.scanAhead() == 39) {
                this.currentAnnotation = null;
                access = (short)(access | 0x2000);
                this.scanner.scan();
            } else {
                access = (short)(access | this.parseModifiers(access));
                if (this.token.kind == 107) {
                    if (this.scanner.scan() == 39) {
                        access = (short)(access | 0x2000);
                    } else {
                        this.error(Message.errorAnnotationExpected, this.token.pos, false);
                        this.syntaxError((byte)0);
                    }
                }
            }
            this.parseMemberDecl(classSymbol, pos, access);
        }
        this.scanner.scan();
    }

    private void parseFormalTypeParameterList() {
        if (!$assertionsDisabled && this.token.kind != 89) {
            throw new AssertionError();
        }
        TypeParameterList paramLast = null;
        this.typeParameterList = null;
        while (true) {
            if (this.scanner.scan() != 10) {
                this.syntaxError((byte)0, (byte)10);
            }
            TypeParameterSymbol typeParameterSymbol = new TypeParameterSymbol(this.token.pos, this.token.id);
            TypeParameterList tpl = new TypeParameterList(typeParameterSymbol);
            if (paramLast == null) {
                this.typeParameterList = paramLast = tpl;
            } else {
                paramLast.next = tpl;
                paramLast = tpl;
            }
            ClassSymbolPosList list = null;
            ClassSymbol bound = this.javaLangObjectPcs;
            int boundPos = 0;
            if (this.scanner.scan() == 29) {
                this.scanner.scan();
                boundPos = this.token.pos;
                TypeSymbol typeSymbol = this.parseType(false, false, false);
                if (typeSymbol.isClass()) {
                    bound = (ClassSymbol)typeSymbol;
                }
                if (this.token.kind == 84) {
                    do {
                        this.scanner.scan();
                        int pos = this.token.pos;
                        typeSymbol = this.parseType(false, false, false);
                        if (!typeSymbol.isClass()) continue;
                        ClassSymbolPosList tsl = new ClassSymbolPosList((ClassSymbol)typeSymbol, pos);
                        tsl.next = list;
                        list = tsl;
                    } while (this.token.kind == 84);
                }
            }
            typeParameterSymbol.bound = bound;
            typeParameterSymbol.boundPos = boundPos;
            typeParameterSymbol.interfaceBounds = list;
            if (this.token.kind == 90) break;
            if (this.token.kind == 62) continue;
            this.syntaxError((byte)0, (byte)90);
        }
        this.scanner.scan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RawClassSymbol parseClassDeclaration(int pos, short access, int tokenKind) {
        RawClassSymbol classSymbol;
        Symbol symbol;
        boolean isDeprecated = this.deprecatedFlag;
        this.deprecatedFlag = false;
        if (tokenKind == 39) {
            if (this.currentScope.kind == 2) {
                if (this.currentClassSymbol.isInnerClass() && (this.currentClassSymbol.access & 0x2208) == 0) {
                    this.error(Message.errorNoInterfaceAllowed, pos, false);
                } else {
                    if (this.options.strictfpmethods) {
                        access = (short)(access | 0x800);
                    }
                    this.checkAllowedAccessModifiers(pos, access, (short)11791);
                }
            } else if (this.currentScope.kind >= 3) {
                this.error(Message.errorNoInterfaceAllowed, pos, false);
            } else {
                if (this.options.strictfpmethods) {
                    access = (short)(access | 0x800);
                }
                this.checkAllowedAccessModifiers(pos, access, (short)11777);
            }
            access = (short)(access | 0x600);
        } else if (tokenKind == 28) {
            if (this.currentScope.kind == 2) {
                this.checkAllowedAccessModifiers(pos, access, (short)18447);
            } else if (this.currentScope.kind >= 3) {
                this.error(Message.errorNoEnumAllowed, pos, false);
            } else {
                this.checkAllowedAccessModifiers(pos, access, (short)18433);
            }
            access = (short)(access | 0x4010);
        } else {
            if (this.options.strictfpmethods) {
                access = (short)(access | 0x800);
            }
            if (this.currentScope.kind == 2) {
                if (this.currentClassSymbol != null && this.currentClassSymbol.isAnonymousInnerClass()) {
                    this.checkAllowedAccessModifiers(pos, access, (short)3088);
                } else {
                    this.checkAllowedAccessModifiers(pos, access, (short)3103);
                }
            } else if (this.currentScope.kind >= 3) {
                this.checkAllowedAccessModifiers(pos, access, (short)3088);
            } else {
                this.checkAllowedAccessModifiers(pos, access, (short)3089);
            }
        }
        this.checkExcludingAccessModifiers(pos, access, (short)7);
        this.checkConflictingAccessModifiers(pos, access, (short)1024, (short)16);
        this.scanner.scan();
        this.checkIdentifierNewerKeywordsConflict();
        if (this.token.kind != 10) {
            this.syntaxError((byte)0, (byte)10);
        }
        Identifier classIdentifier = this.token.id;
        int classPosition = this.token.pos;
        Scope scope = this.currentScope;
        block5 : switch (scope.kind) {
            default: {
                if (!$assertionsDisabled && scope.kind < 3) {
                    throw new AssertionError();
                }
                do {
                    if ((symbol = scope.lookupSpecificSymbolInScope(classIdentifier, 32, false)) != null) {
                        this.error(Message.errorDuplicateDefinition, this.token.pos, false, symbol.errorName() + " " + Message.inString + " " + this.currentMethodSymbol.errorName());
                        symbol = null;
                        break block5;
                    }
                    scope = ((LocalScope)scope).outerScope;
                } while (scope.kind >= 3);
                break;
            }
            case 1: 
            case 2: {
                symbol = scope.lookupSpecificSymbolInScope(classIdentifier, 32, false);
            }
        }
        this.scanner.scan();
        if (this.parsingAtLeastOneFive && this.token.kind == 89) {
            this.parseFormalTypeParameterList();
        }
        int superClassPosition = 0;
        ClassSymbol superClass = this.javaLangObjectPcs;
        if (symbol == this.javaLangObjectSymbol) {
            superClass = null;
        }
        ImplementationList implementationList = null;
        if (this.token.kind == 29) {
            if ((access & 0x6000) != 0) {
                this.error(Message.errorDifferentSymbolExpected, this.token.prevEndPos, false, Token.tokenToString((byte)80));
            } else if (symbol == this.javaLangObjectSymbol) {
                this.error(Message.errorNoSuperclass, pos, false);
            }
            this.scanner.scan();
            if ((access & 0x200) != 0) {
                implementationList = this.parseImpementationList();
            } else {
                superClassPosition = this.token.pos;
                TypeSymbol superSymbol = this.parseType(false, false, false);
                if (superSymbol == TypeSymbol.errorSymbol) {
                    superSymbol = null;
                }
                superClass = (ClassSymbol)superSymbol;
            }
        }
        if (this.token.kind == 36) {
            if (implementationList != null || (access & 0x2000) != 0) {
                this.error(Message.errorDifferentSymbolExpected, this.token.prevEndPos, false, Token.tokenToString((byte)80));
            }
            this.scanner.scan();
            if ((access & 0x2200) == 512 && implementationList == null) {
                this.error(Message.errorDifferentSymbolExpected, this.token.prevEndPos, false, Token.tokenToString((byte)80));
                this.skipTypeList();
            } else {
                implementationList = this.parseImpementationList();
            }
        }
        if ((access & 0x2000) != 0) {
            implementationList = new CompiledImplementationList(new UnresolvedClassSymbol("java.lang.annotation.Annotation", null, (Scope)this.globalScope));
        }
        if (this.token.kind != 80) {
            if (symbol != null) {
                classSymbol = (RawClassSymbol)symbol;
            } else {
                classSymbol = new RawClassSymbol(0, classIdentifier, 1, null, null, false, false);
                this.currentScope.enterSymbol(classSymbol);
            }
            classSymbol.flags = (short)(classSymbol.flags | 0x10);
            classSymbol.classScope = new ClassScope(classSymbol, null, null);
            this.syntaxError((byte)0, (byte)80);
        }
        this.scanner.scan();
        if (this.currentMethodSymbol != null && (this.currentMethodSymbol.access & 8) != 0) {
            access = (short)(access | 8);
        }
        RawClassSymbol outerClassSymbol = this.currentClassSymbol;
        ClassScope outerClassScope = this.currentClassScope;
        MethodSymbol savedCurrentMethod = this.currentMethodSymbol;
        this.currentMethodSymbol = null;
        FieldSymbol savedCurrentField = this.currentFieldSymbol;
        this.currentFieldSymbol = null;
        try {
            ClassScope classScope;
            if (symbol != null) {
                classSymbol = (RawClassSymbol)symbol;
                if (classSymbol.classScope != null) {
                    if (classSymbol.isCompiled()) {
                        this.error(Message.errorDuplicateDefinition, classPosition, false, symbol.errorName());
                        this.tryToRecoverFromSyntaxErrorInClassDeclaration();
                        RawClassSymbol rawClassSymbol = classSymbol;
                        return rawClassSymbol;
                    }
                    classSymbol.flags = (short)(classSymbol.flags & 0xFFFFFBFF);
                    classSymbol.setImplementationList(null);
                    classSymbol.cd = new RawClassSymbol.ClassData();
                    classSymbol.cd.ccd = new RawClassSymbol.CompiledClassData();
                } else if (symbol.scope != this.currentScope) {
                    this.error(Message.errorDuplicateDefinition, classPosition, false, symbol.errorName());
                    this.tryToRecoverFromSyntaxErrorInClassDeclaration();
                    RawClassSymbol rawClassSymbol = classSymbol;
                    return rawClassSymbol;
                }
                classSymbol.access = access;
                classSymbol.pos = classPosition;
                classSymbol.annotation = this.currentAnnotation;
                if ((access & 0x2000) != 0) {
                    classSymbol.cd = new RawClassSymbol.AnnotationClassData();
                } else if (this.typeParameterList != null) {
                    classSymbol.cd = new RawClassSymbol.GenericClassData(this.typeParameterList);
                    classSymbol.flags = (short)(classSymbol.flags | 0x4000);
                } else if (classSymbol.cd == null) {
                    classSymbol.cd = new RawClassSymbol.ClassData();
                }
                if (classSymbol.cd.ccd == null) {
                    classSymbol.cd.ccd = new RawClassSymbol.CompiledClassData();
                }
            } else {
                classSymbol = outerClassSymbol != null ? new InnerClassSymbol(classPosition, classIdentifier, access, this.typeParameterList, this.currentAnnotation, true) : new RawClassSymbol(classPosition, classIdentifier, access, this.typeParameterList, this.currentAnnotation, true, false);
                this.currentScope.enterSymbol(classSymbol);
            }
            this.currentClassSymbol = classSymbol;
            if ((access & 0x4000) != 0) {
                superClass = ParameterizedClassSymbol.getParameterizedClassSymbol(this.javaLangEnumSymbol, new TypeVariableList(new TypeVariableSymbol(0, 1, ParameterizedClassSymbol.getParameterizedClassSymbol(classSymbol, null, null))), null);
                classSymbol.flags = (short)(classSymbol.flags | this.javaLangEnumSymbol.flags & 0xC00);
                if (outerClassSymbol != null) {
                    classSymbol.access = (short)(classSymbol.access | 8);
                }
            }
            classSymbol.superClass = superClass;
            classSymbol.cd.ccd.tpos = superClassPosition;
            classSymbol.cd.ccd.sourceFile = this.sourceFile;
            classSymbol.flags = (short)(classSymbol.flags | 0x20);
            if (implementationList != null) {
                classSymbol.flags = (short)(classSymbol.flags | 0x400);
                classSymbol.setImplementationList(implementationList);
            }
            if (savedCurrentMethod != null || savedCurrentField != null || outerClassSymbol != null && outerClassSymbol.isLocalInnerClass()) {
                classSymbol.flags = (short)(classSymbol.flags | 0x80);
            }
            if (isDeprecated) {
                classSymbol.deprecate();
            }
            this.currentClassScope = classScope = new ClassScope(classSymbol, this.currentScope, this);
            classSymbol.classScope = classScope;
            Scope outerScope = this.currentScope;
            this.currentScope = classScope;
            try {
                MethodSymbol methodSymbol;
                InnerClassSymbol innerClassSymbol;
                if ((access & 0x2000) != 0) {
                    if (this.typeParameterList != null) {
                        this.error(Message.errorNoTypeParametersAllowed, this.typeParameterList.typeParameter.pos, false, Message.annotationString);
                    }
                } else {
                    TypeParameterList tpl = this.typeParameterList;
                    while (tpl != null) {
                        tpl.typeParameter.definingSymbol = classSymbol;
                        classScope.enterSymbol(tpl.typeParameter);
                        tpl = tpl.next;
                    }
                    tpl = this.typeParameterList;
                    while (tpl != null) {
                        tpl.typeParameter = (TypeParameterSymbol)tpl.typeParameter.replaceUnresolvedTypeParameters(this.typeParameterList);
                        tpl = tpl.next;
                    }
                    if (classSymbol.superClass != null) {
                        classSymbol.superClass = (ClassSymbol)classSymbol.superClass.replaceUnresolvedTypeParameters(this.typeParameterList);
                    }
                    while (implementationList != null) {
                        implementationList.interfaceSymbol = (ClassSymbol)implementationList.interfaceSymbol.replaceUnresolvedTypeParameters(this.typeParameterList);
                        implementationList = implementationList.next;
                    }
                }
                this.typeParameterList = null;
                if (outerClassSymbol == null || !outerClassSymbol.isAnonymousInnerClass()) {
                    this.classResolutionList.classSymbolList.add(classSymbol);
                }
                Identifier thisDollarIdentifier = null;
                if (outerClassSymbol == null) {
                    String sourceName = this.sourceFile.storage.getName();
                    int index = sourceName.indexOf(46);
                    boolean topLevelClass = false;
                    if (index >= 0) {
                        if (classSymbol.identifier == Identifier.getIdentifier(sourceName.substring(0, index))) {
                            topLevelClass = true;
                        }
                    } else if (classSymbol.identifier == Identifier.getIdentifier(sourceName)) {
                        topLevelClass = true;
                    }
                    if (topLevelClass) {
                        this.sourceFile.topLevelClass = classSymbol;
                    }
                    if ((access & 1) != 0 && (index < 0 || classSymbol.identifier != Identifier.getIdentifier(sourceName.substring(0, index)))) {
                        this.error(Error.errorPublicWrongFile, pos, false, classIdentifier.toString(), classIdentifier.toString());
                    }
                } else {
                    innerClassSymbol = (InnerClassSymbol)classSymbol;
                    outerClassSymbol.addInnerClass(innerClassSymbol);
                    if (outerClassSymbol.isInterface()) {
                        innerClassSymbol.access = (short)(innerClassSymbol.access | 9);
                        this.checkExcludingAccessModifiers(pos, innerClassSymbol.access, (short)7);
                    }
                    if (innerClassSymbol.isLocalInnerClass() && innerClassSymbol.isInterface()) {
                        this.error(Message.errorNoInterfaceAllowed, pos, false);
                    }
                    while (true) {
                        RawClassSymbol classSym = innerClassSymbol.getOuterClass();
                        if (classSym.identifier == classIdentifier) {
                            this.error(Message.errorInnerNameClash, classPosition, false, classSymbol.errorName());
                        }
                        if (!classSym.isInnerClass()) break;
                        innerClassSymbol = (InnerClassSymbol)classSym;
                    }
                }
                if ((access & 0x4000) != 0) {
                    methodSymbol = new MethodSymbol(0, classSymbol, Identifier.valueOfIdentifier, new UnresolvedClassSymbol(null, classSymbol.identifier, null, this.currentScope), 0, 9, null, true);
                    methodSymbol.flags = (short)(methodSymbol.flags | 0x20);
                    methodSymbol.addArgument(this.javaLangStringPcs);
                    methodSymbol.nextInClass = classSymbol.cd.methodList;
                    classSymbol.cd.methodList = methodSymbol;
                    classSymbol.classScope.enterSymbol(methodSymbol);
                    methodSymbol = new MethodSymbol(0, classSymbol, Identifier.valuesIdentifier, ArraySymbol.getArrayType(new UnresolvedClassSymbol(null, classSymbol.identifier, null, this.currentScope), 1), 0, 25, null, true);
                    methodSymbol.flags = (short)(methodSymbol.flags | 0x20);
                    methodSymbol.nextInClass = classSymbol.cd.methodList;
                    classSymbol.cd.methodList = methodSymbol;
                    classSymbol.classScope.enterSymbol(methodSymbol);
                    classSymbol.getClassInitializer();
                }
                this.parseClassBody(classSymbol);
                if (classSymbol.isInnerClass() && (classSymbol.access & 0x208) == 0) {
                    thisDollarIdentifier = this.getThisDollarIdentifier(classSymbol);
                    FieldSymbol fieldSymbol = this.addSyntheticField(classSymbol, thisDollarIdentifier, outerClassSymbol, (short)16);
                    fieldSymbol.flags = (short)(fieldSymbol.flags | 0x20);
                    innerClassSymbol = (InnerClassSymbol)classSymbol;
                    innerClassSymbol.addHiddenOuterThisArgument(outerClassSymbol, fieldSymbol);
                }
                if ((access & 0x200) == 0 && (symbol = classSymbol.classScope.lookupSpecificSymbolInScope(Identifier.initializerIdentifier, 8, true)) == null) {
                    short methAccess = (access & 0x4000) != 0 ? (short)2 : (short)((short)(classSymbol.access & 0x807));
                    methodSymbol = new MethodSymbol(classSymbol.pos, classSymbol, Identifier.initializerIdentifier, TypeSymbol.voidSymbol, 0, methAccess, null, true);
                    methodSymbol.flags = (short)(methodSymbol.flags | 0x200);
                    methodSymbol.localVarCount = 1;
                    methodSymbol.actualArgCount = 1;
                    methodSymbol.cmd.localVariables.add(null);
                    methodSymbol.cmd.statementList = new StatementList();
                    classSymbol.classScope.enterSymbol(methodSymbol);
                    methodSymbol.nextInClass = classSymbol.cd.methodList;
                    classSymbol.cd.methodList = methodSymbol;
                    if ((access & 0x4000) != 0) {
                        ExpressionList exprList = new ExpressionList(new MethodVariableExpression(0, methodSymbol.addArgument(this.javaLangStringSymbol)));
                        exprList.next = new ExpressionList(new MethodVariableExpression(0, methodSymbol.addArgument(TypeSymbol.intSymbol)));
                        this.addImplicitSuperConstructorInvoke(classSymbol, classSymbol.pos, methodSymbol.cmd.statementList, exprList);
                    } else if (classSymbol.superClass != null) {
                        this.addImplicitSuperConstructorInvoke(classSymbol, classSymbol.pos, methodSymbol.cmd.statementList, null);
                    }
                }
            }
            finally {
                if (!$assertionsDisabled && this.currentScope != classScope) {
                    throw new AssertionError();
                }
                this.currentScope = outerScope;
            }
        }
        catch (SyntaxError e) {
            throw e;
        }
        finally {
            this.currentMethodSymbol = savedCurrentMethod;
            this.currentFieldSymbol = savedCurrentField;
            this.currentClassSymbol = outerClassSymbol;
            this.currentClassScope = outerClassScope;
        }
        return classSymbol;
    }

    private void parseTypeDeclaration() {
        long ms = System.currentTimeMillis();
        block8: while (this.token.kind != 9) {
            while (this.token.kind == 63) {
                this.scanner.scan();
            }
            try {
                short access;
                int pos = this.token.pos;
                if (this.token.kind == 107 && this.scanner.scanAhead() == 39) {
                    this.currentAnnotation = null;
                    access = 8192;
                    this.scanner.scan();
                } else {
                    access = this.parseModifiers((short)0);
                    if (this.token.kind == 107) {
                        if (this.scanner.scan() == 39) {
                            access = (short)(access | 0x2000);
                        } else {
                            this.error(Message.errorAnnotationExpected, this.token.pos, false);
                            this.syntaxError((byte)0);
                        }
                    }
                }
                switch (this.token.kind) {
                    case 9: {
                        if (access == 0 && this.currentAnnotation == null) continue block8;
                    }
                    default: {
                        this.error(Message.errorClassOrInterfaceExpected, this.token.pos, false);
                        this.syntaxError((byte)0);
                        continue block8;
                    }
                    case 39: {
                        this.parseClassDeclaration(pos, access, 39);
                        continue block8;
                    }
                    case 22: {
                        this.parseClassDeclaration(pos, access, 22);
                        continue block8;
                    }
                    case 28: 
                }
                this.parseClassDeclaration(pos, access, 28);
            }
            catch (SyntaxError e) {
                if (!(e instanceof SyntaxErrorEndOfBlock)) continue;
                this.scanner.scan();
            }
        }
        if (this.options.verbose) {
            this.options.getLog().println("[" + Message.parsingString + " " + this.sourceFile.getPath() + " " + (System.currentTimeMillis() - ms) + "ms ]");
        }
    }

    private void parseImportDeclaration() {
        if (!$assertionsDisabled && this.token.kind != 37) {
            throw new AssertionError();
        }
        do {
            IdentifierList il;
            IdentifierList identifierPrev;
            IdentifierList identifierList;
            IdentifierList identifierLast;
            int position;
            boolean skip;
            byte flags;
            block15: {
                flags = 0;
                skip = false;
                if (this.scanner.scan() == 48) {
                    if (!this.parsingAtLeastOneFive) {
                        this.error(Message.errorDifferentSymbolExpected, this.token.pos, false, Token.tokenToString((byte)10));
                    }
                    flags = (byte)(flags | 2);
                    this.scanner.scan();
                }
                position = this.token.pos;
                identifierLast = null;
                identifierList = null;
                identifierPrev = null;
                do {
                    if (this.token.kind == 10) {
                        identifierPrev = identifierLast;
                        il = new IdentifierList(this.token.pos, this.token.id);
                        if (identifierList == null) {
                            identifierList = identifierLast = il;
                        } else {
                            identifierLast.next = il;
                            identifierLast = il;
                        }
                    } else if (this.token.kind == 98) {
                        if (identifierList == null) {
                            this.error(Message.errorDifferentSymbolExpected, this.token.pos, false, Token.tokenToString((byte)10));
                            skip = true;
                            break block15;
                        }
                        flags = (byte)(flags | 1);
                    } else {
                        this.error(Message.errorDifferentSymbolExpected, this.token.pos, false, Token.tokenToString((byte)10));
                        skip = true;
                        break block15;
                    }
                    if (this.scanner.scan() != 61) break block15;
                    this.scanner.scan();
                } while ((flags & 1) == 0);
                this.error(Message.errorDifferentSymbolExpected, this.token.pos, false, Token.tokenToString((byte)63));
                skip = true;
            }
            if (skip) continue;
            if (this.token.kind != 63) {
                this.error(Message.errorDifferentSymbolExpected, this.token.prevEndPos, false, Token.tokenToString((byte)63));
                continue;
            }
            this.scanner.scan();
            il = identifierPrev;
            if (il != null) {
                il.next = null;
            } else {
                identifierList = null;
            }
            UnresolvedSymbol symbol = new UnresolvedSymbol(identifierLast.pos, this.currentScope, identifierLast.identifier);
            symbol.qualifierList = identifierList;
            ImportDescriptor impDesc = new ImportDescriptor(position, symbol, flags);
            if (this.isDuplicateImportDescriptor(impDesc)) continue;
            impDesc.next = this.sourceFile.importList;
            this.sourceFile.importList = impDesc;
        } while (this.token.kind == 37);
    }

    private boolean isDuplicateImportDescriptor(ImportDescriptor impDesc) {
        String impDescName = impDesc.importSymbol.errorName();
        ImportDescriptor existingImpDesc = this.sourceFile.importList;
        while (existingImpDesc != null) {
            if (impDesc.importSymbol.identifier == existingImpDesc.importSymbol.identifier && impDesc.flags == existingImpDesc.flags && impDescName.equals(existingImpDesc.importSymbol.errorName())) {
                return true;
            }
            existingImpDesc = existingImpDesc.next;
        }
        return false;
    }

    private String stripNameAndReplace(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(this.options.fileSeparator);
        if (index >= 0) {
            path = path.substring(0, index);
        }
        return path.replace(this.options.fileSeparator.charAt(0), '.');
    }

    private void checkPackageNameAgainstFileName(PackageSymbol packageSymbol, int pos) {
        String packageName = packageSymbol.toString();
        String sourcePath = this.sourceFile.getPath();
        String strippedSourcePath = this.stripNameAndReplace(sourcePath);
        if (strippedSourcePath != null && !strippedSourcePath.endsWith(packageName) && (strippedSourcePath = this.stripNameAndReplace(this.sourceFile.getCanonicalPath())) != null && !strippedSourcePath.endsWith(packageName)) {
            this.warning(packageSymbol, Message.warningPackageDoesntMatchPath, pos, packageName, sourcePath);
        }
    }

    private void parseCompilationUnit() {
        StorageScope scope;
        boolean isPackageInfoFile = this.parsingAtLeastOneFive ? this.sourceFile.storage.getName().equals("package-info.java") : false;
        this.scanner.scan();
        Object scannerStateBeforePackage = null;
        if (isPackageInfoFile) {
            boolean hasAnnotations = false;
            scannerStateBeforePackage = this.scanner.saveScannerState();
            this.sourceFile.packageScope = new PackageScope(this, this.globalScope);
            this.currentPackageScope = this.sourceFile.packageScope;
            scope = this.sourceFile.packageScope;
            this.currentScope = this.sourceFile.packageScope;
            while (this.token.kind == 107) {
                hasAnnotations = true;
                if (this.parseAnnotation()) continue;
            }
            this.sourceFile.packageScope = null;
            this.currentPackageScope = null;
            scope = null;
            this.currentScope = null;
            if (hasAnnotations && this.token.kind != 43) {
                this.error(Message.errorDifferentSymbolExpected, this.token.pos, false, Token.tokenToString((byte)43));
            }
        }
        if (this.token.kind == 43) {
            block19: {
                PackageScope packageScope;
                PackageSymbol packageSymbol;
                scope = this.globalScope;
                int pos = this.token.pos;
                do {
                    if (this.scanner.scan() != 10) {
                        this.error(Message.errorDifferentSymbolExpected, this.token.pos, false, Token.tokenToString((byte)10));
                        this.scanner.scan();
                        scope = new PackageScope(this, this.globalScope);
                        break block19;
                    }
                    Symbol symbol = scope.lookupSpecificSymbolInScope(this.token.id, 16, false);
                    if (symbol != null) {
                        packageSymbol = (PackageSymbol)symbol;
                        packageScope = packageSymbol.packageScope;
                    } else {
                        symbol = scope.lookupSpecificSymbolInScope(this.token.id, 32, false);
                        if (symbol != null) {
                            this.error(Message.errorAlreadyDefined, this.token.pos, false, symbol.errorName());
                        }
                        packageScope = new PackageScope(this, scope);
                        packageSymbol = new PackageSymbol(this.token.pos, this.token.id, packageScope);
                        scope.enterSymbol(packageSymbol);
                        packageScope.packageSymbol = packageSymbol;
                    }
                    scope = packageScope;
                } while (this.scanner.scan() == 61);
                packageScope.readPackage();
                this.checkPackageNameAgainstFileName(packageSymbol, pos);
            }
            if (this.token.kind != 63) {
                this.error(Message.errorDifferentSymbolExpected, this.token.pos, false, Token.tokenToString((byte)63));
            } else {
                this.scanner.scan();
            }
        } else {
            if (this.token.kind == 9) {
                this.warning(null, Message.warningEmptySource, 0);
            }
            if (this.unnamedPackageScope == null) {
                this.unnamedPackageScope = scope = new PackageScope(this, this.globalScope);
            } else {
                scope = this.unnamedPackageScope;
            }
        }
        this.sourceFile.packageScope = (PackageScope)scope;
        this.currentPackageScope = scope;
        this.currentScope = this.currentPackageScope;
        this.currentAnnotation = null;
        if (isPackageInfoFile && !this.errorFound) {
            Object scannerStateAfterPackage = this.scanner.saveScannerState();
            this.scanner.restoreScannerState(scannerStateBeforePackage);
            while (this.token.kind == 107 && this.parseAnnotation()) {
            }
            this.scanner.restoreScannerState(scannerStateAfterPackage);
        }
        if (this.token.kind == 37) {
            this.parseImportDeclaration();
        }
        if (isPackageInfoFile) {
            short flags = 1536;
            RawClassSymbol interfaceSymbol = new RawClassSymbol(this.token.pos, Identifier.packageInfoIdentifier, flags, null, this.currentAnnotation, true, false);
            interfaceSymbol.cd = new RawClassSymbol.ClassData();
            interfaceSymbol.cd.methodTable = new MethodSymbol[0];
            interfaceSymbol.cd.ccd = new RawClassSymbol.CompiledClassData();
            interfaceSymbol.cd.ccd.sourceFile = this.sourceFile;
            interfaceSymbol.flags = (short)(interfaceSymbol.flags | 0x20);
            interfaceSymbol.classScope = new ClassScope(interfaceSymbol, this.currentScope, this);
            interfaceSymbol.superClass = this.javaLangObjectPcs;
            interfaceSymbol.cd.ccd.tpos = 0;
            this.currentScope.enterSymbol(interfaceSymbol);
            this.classResolutionList.classSymbolList.add(interfaceSymbol);
            this.currentAnnotation = null;
        }
        this.parseTypeDeclaration();
    }

    void parse(ArrayList sourceFiles) {
        this.sourceFileList = new ArrayList();
        int count = sourceFiles.size();
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            this.addSourceFile((Storage)sourceFiles.get(i));
        }
        while (true) {
            try {
                this.parseSourceFiles();
                this.resolveImports();
                this.resolveSuperClassesInterfaces(this.classResolutionList);
                if (this.parsingAtLeastOneFive) {
                    this.resolveClassAnnotationsAndBounds(this.classResolutionList);
                }
                this.resolveInnerClasses(this.classResolutionList);
                this.finishClassResolutions(this.classResolutionList);
                this.resolveFields(this.classResolutionList);
                this.resolveMethods(this.classResolutionList);
                this.buildMethodTables(this.classResolutionList);
                this.resolveFieldInitializers(this.classResolutionList);
                this.resolveMethodBodies(this.classResolutionList);
            }
            catch (NewSourceException e) {
                continue;
            }
            break;
        }
        this.errorStatements.clear();
        if (this.options.makeFile != null) {
            try {
                int totalBytesWritten = this.depInfo.writeFile(this.options.makeFile, this.options.encoding);
                if (this.options.verbose || this.options.elapsedTime) {
                    System.out.println("Wrote CDI File: " + totalBytesWritten + " bytes (" + totalBytesWritten / 1024 + "K)");
                }
            }
            catch (IOException e) {
                Error error = new Error(null, Error.errorWriteError, 0, this.options.makeFile.getPath());
                this.options.getLog().printError(error.message.getMessage());
                this.options.getLog().printError(e.getMessage());
                this.errorFound = true;
            }
        }
    }

    private void parseSourceFiles() {
        int first = this.nextParseSourceFileIndex;
        int last = this.sourceFileList.size();
        if (first < last) {
            for (int i = first; i < last; ++i) {
                this.sourceFile = (SourceFile)this.sourceFileList.get(i);
                Storage sourceStorage = this.sourceFile.storage;
                if (this.options.noquiet) {
                    this.options.getLog().println("[" + Message.compilingString + " " + this.sourceFile.getPath() + "]");
                }
                if (this.options.ideEnv != null && !this.options.ideEnv.authorizeParsing(sourceStorage, "")) {
                    throw new RuntimeException("user aborted");
                }
                int sourceFileSize = Compiler.loadFile(this, sourceStorage);
                String encoding = (String)sourceStorage.getProperty("encoding");
                if (encoding == null) {
                    encoding = this.options.encoding;
                }
                this.scanner = new Scanner(this, Compiler.loadBuffer, sourceFileSize, encoding, this.options.sourceJDKVersion);
                this.token = this.scanner.token;
                try {
                    this.parseCompilationUnit();
                    if (!$assertionsDisabled && this.token.kind != 9) {
                        throw new AssertionError();
                    }
                }
                catch (SyntaxErrorEndOfFile e) {
                    // empty catch block
                }
                this.scanner.scanBuffer = null;
                this.globalScope.removeDeclarations(this.sourceFile.importDeclarations);
                this.sourceLineCount += Scanner.positionToLine(this.token.pos);
            }
            this.nextParseSourceFileIndex = last;
            this.sourceFile = null;
            Compiler.loadBuffer = null;
        }
    }

    private void resolveImports() {
        int first = this.nextResolveImportsIndex;
        int last = this.sourceFileList.size();
        if (first < last) {
            for (int i = first; i < last; ++i) {
                this.sourceFile = (SourceFile)this.sourceFileList.get(i);
                ImportDescriptor.processImports(this, this.sourceFile);
                ++this.nextResolveImportsIndex;
            }
            this.sourceFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveSuperClassesInterfaces(ClassResolutionList resolutionList) {
        int classLast = resolutionList.classSymbolList.size();
        int fileLast = this.sourceFileList.size();
        int first = resolutionList.nextResolveSuperClassIndex;
        if (first == 0) {
            this.javaLangRuntimeExceptionSymbol.resolveType(this, 0, true, true, false);
            this.javaLangErrorSymbol.resolveType(this, 0, true, true, false);
            this.javaLangClassSymbol.resolveType(this, 0, true, true, false);
        }
        if (first < classLast) {
            this.prevResolutionFailures = Integer.MAX_VALUE;
            this.resolutionFailures = 0;
            this.resolutionRound = 0;
            while (true) {
                RawClassSymbol classSymbol;
                int i;
                if (this.parsingAtLeastOneFive && this.nextResolveStaticImportsIndex < fileLast) {
                    SourceFile savedSourceFile = this.sourceFile;
                    try {
                        for (i = this.nextResolveStaticImportsIndex; i < fileLast; ++i) {
                            this.sourceFile = (SourceFile)this.sourceFileList.get(i);
                            this.currentPackageScope = this.sourceFile.packageScope;
                            this.sourceFile.resolveStaticImports(this);
                            ++this.nextResolveStaticImportsIndex;
                        }
                    }
                    catch (UnresolvedSuperClassException e) {
                        ++this.resolutionFailures;
                    }
                    finally {
                        this.currentPackageScope = null;
                        this.sourceFile = savedSourceFile;
                    }
                }
                for (i = first; i < classLast; ++i) {
                    classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                    if (classSymbol.isAnonymousInnerClass()) continue;
                    Object rState = this.saveResolutionState(classSymbol);
                    try {
                        classSymbol.addNameDeclaration(this, classSymbol, classSymbol.pos);
                        this.resolutionFailures += classSymbol.resolveSuperClass(this, false);
                        this.resolutionFailures += classSymbol.resolveInterfaces(this);
                        this.resolutionFailures += classSymbol.resolveTypeParameters(this);
                        continue;
                    }
                    catch (RuntimeException e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    catch (AssertionError e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    catch (StackOverflowError e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    finally {
                        this.restoreResolutionState(rState);
                    }
                }
                if (this.resolutionFailures == 0) break;
                ++this.resolutionRound;
                if (this.prevResolutionFailures == this.resolutionFailures) {
                    for (i = first; i < classLast; ++i) {
                        classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                        if (!resolutionList.alsoHandleAnonymousClasses && classSymbol.isAnonymousInnerClass()) continue;
                        classSymbol.pruneUnresolvedClassSymbols(this);
                    }
                    break;
                }
                this.prevResolutionFailures = this.resolutionFailures;
                this.resolutionFailures = 0;
            }
            resolutionList.nextResolveSuperClassIndex = classLast;
        }
    }

    void resolveInnerClasses(ClassResolutionList resolutionList) {
        int first = resolutionList.nextResolveInnerClassesIndex;
        int classLast = resolutionList.classSymbolList.size();
        if (first < classLast) {
            this.prevResolutionFailures = Integer.MAX_VALUE;
            this.resolutionFailures = 0;
            this.resolutionRound = 0;
            while (true) {
                RawClassSymbol classSymbol;
                int i;
                for (i = first; i < classLast; ++i) {
                    classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                    if (!resolutionList.alsoHandleAnonymousClasses && classSymbol.isAnonymousInnerClass()) continue;
                    Object rState = this.saveResolutionState(classSymbol);
                    try {
                        this.resolutionFailures += classSymbol.resolveInnerClasses(this);
                        continue;
                    }
                    catch (RuntimeException e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    catch (AssertionError e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    catch (StackOverflowError e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    finally {
                        this.restoreResolutionState(rState);
                    }
                }
                if (this.resolutionFailures == 0) break;
                ++this.resolutionRound;
                if (this.prevResolutionFailures == this.resolutionFailures) {
                    for (i = first; i < classLast; ++i) {
                        classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                        if (!resolutionList.alsoHandleAnonymousClasses && classSymbol.isAnonymousInnerClass()) continue;
                        classSymbol.pruneUnresolvedClassSymbols(this);
                    }
                    break;
                }
                this.prevResolutionFailures = this.resolutionFailures;
                this.resolutionFailures = 0;
            }
            resolutionList.nextResolveInnerClassesIndex = classLast;
        }
    }

    void resolveClassAnnotationsAndBounds(ClassResolutionList resolutionList) {
        int first = resolutionList.nextResolveClassAnnotationsAndBoundsIndex;
        int classLast = resolutionList.classSymbolList.size();
        if (first < classLast) {
            for (int i = first; i < classLast; ++i) {
                RawClassSymbol classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                if (resolutionList.alsoHandleAnonymousClasses || !classSymbol.isAnonymousInnerClass()) {
                    Object rState = this.saveResolutionState(classSymbol);
                    try {
                        classSymbol.resolveClassAnnotationTypes(this);
                        classSymbol.checkBoundsOfSupers(this);
                    }
                    catch (RuntimeException e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    catch (AssertionError e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    catch (StackOverflowError e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    finally {
                        this.restoreResolutionState(rState);
                    }
                }
                ++resolutionList.nextResolveClassAnnotationsAndBoundsIndex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishClassResolutions(ClassResolutionList resolutionList) {
        RawClassSymbol classSymbol;
        int i;
        int classLast = resolutionList.classSymbolList.size();
        SourceFile savedSourceFile = this.sourceFile;
        try {
            for (i = resolutionList.nextBuildHierarchyIndex; i < classLast; ++i) {
                classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                if (!resolutionList.alsoHandleAnonymousClasses && classSymbol.isAnonymousInnerClass()) continue;
                this.sourceFile = classSymbol.cd.ccd.sourceFile;
                classSymbol.detectCyclicInheritance(this);
                if (classSymbol.isAnonymousInnerClass() || !classSymbol.isGenericThrowableDerived(this)) continue;
                this.error(Message.errorGenericExtendingThrowable, classSymbol.cd.ccd.tpos, false);
            }
        }
        finally {
            this.sourceFile = savedSourceFile;
        }
        resolutionList.nextBuildHierarchyIndex = classLast;
        int size = this.loadedClassesWithCompiledSuperclassesList.size();
        for (i = 0; i < size; ++i) {
            classSymbol = (RawClassSymbol)this.loadedClassesWithCompiledSuperclassesList.get(i);
            classSymbol.propagateFlagsFromSuperclasses();
        }
        this.loadedClassesWithCompiledSuperclassesList.clear();
    }

    void resolveFields(ClassResolutionList resolutionList) {
        int first = resolutionList.nextResolveFieldsIndex;
        int last = resolutionList.classSymbolList.size();
        if (first < last) {
            for (int i = first; i < last; ++i) {
                RawClassSymbol classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                if (resolutionList.alsoHandleAnonymousClasses || !classSymbol.isAnonymousInnerClass()) {
                    Object rState = this.saveResolutionState(classSymbol);
                    try {
                        classSymbol.resolveFields(this);
                    }
                    catch (RuntimeException e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    catch (AssertionError e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    catch (StackOverflowError e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    finally {
                        this.restoreResolutionState(rState);
                    }
                }
                ++resolutionList.nextResolveFieldsIndex;
            }
        }
    }

    void resolveMethods(ClassResolutionList resolutionList) {
        int first = resolutionList.nextResolveMethodsIndex;
        int last = resolutionList.classSymbolList.size();
        if (first < last) {
            for (int i = first; i < last; ++i) {
                RawClassSymbol classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                if (resolutionList.alsoHandleAnonymousClasses || !classSymbol.isAnonymousInnerClass()) {
                    Object state = this.saveResolutionState(classSymbol);
                    try {
                        classSymbol.resolveMethods(this);
                        if (this.parsingAtLeastOneFive) {
                            classSymbol.resolveMethodAndFieldAnnotationTypes(this);
                        }
                    }
                    catch (RuntimeException e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    catch (AssertionError e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    catch (StackOverflowError e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    finally {
                        this.restoreResolutionState(state);
                    }
                }
                ++resolutionList.nextResolveMethodsIndex;
            }
        }
    }

    void buildMethodTables(ClassResolutionList resolutionList) {
        int first = resolutionList.nextBuildMethodTablesIndex;
        int last = resolutionList.classSymbolList.size();
        if (first < last) {
            for (int i = first; i < last; ++i) {
                RawClassSymbol classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                if (!resolutionList.alsoHandleAnonymousClasses && classSymbol.isAnonymousInnerClass()) continue;
                Object state = this.saveResolutionState(classSymbol);
                try {
                    ImportSymbol importSymbol;
                    if (classSymbol.isAnnotation()) {
                        classSymbol.detectCyclicElementTypes(this);
                    }
                    classSymbol.buildMethodTable(this);
                    TypeParameterList tpl = classSymbol.cd.getTypeParameterList();
                    while (tpl != null) {
                        tpl.typeParameter.buildMethodTable(this);
                        tpl = tpl.next;
                    }
                    if ((classSymbol.access & 0x400) != 0) {
                        if (this.options.targetJDKVersion == 110) {
                            classSymbol.addInheritedInterfaceMethods(this);
                        }
                    } else if (classSymbol.superClass != null && ((classSymbol.superClass.access & 0x400) != 0 || classSymbol.getImplementationList() != null)) {
                        classSymbol.checkImplementationsOfAbstractMethods(this);
                    }
                    classSymbol.checkInterfaces(this, classSymbol.pos);
                    classSymbol.checkInnerClasses(this);
                    if (classSymbol.isInnerClass() || (importSymbol = this.currentPackageScope.lookupImportSymbol(classSymbol.identifier, (byte)32)) == null || (importSymbol.flags & 0xC) != 0) continue;
                    this.error(Message.errorClashWithImport, classSymbol.pos, false, classSymbol.identifier.toString(), importSymbol.errorName());
                    continue;
                }
                catch (RuntimeException e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                catch (AssertionError e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                catch (StackOverflowError e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                finally {
                    this.restoreResolutionState(state);
                }
            }
            resolutionList.nextBuildMethodTablesIndex = last;
        }
    }

    void resolveFieldInitializers(ClassResolutionList resolutionList) {
        int first = resolutionList.nextResolveFieldsInitIndex;
        int last = resolutionList.classSymbolList.size();
        if (first < last) {
            boolean newConstFound;
            Object rState;
            RawClassSymbol classSymbol;
            int i;
            for (i = first; i < last; ++i) {
                classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                if (!resolutionList.alsoHandleAnonymousClasses && classSymbol.isAnonymousInnerClass()) continue;
                rState = this.saveResolutionState(classSymbol);
                boolean saveThisInitialized = this.thisInitialized;
                try {
                    this.thisInitialized = resolutionList.thisInitialized;
                    classSymbol.resolveFieldInitializers(this);
                    continue;
                }
                catch (RuntimeException e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                catch (AssertionError e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                catch (StackOverflowError e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                finally {
                    this.restoreResolutionState(rState);
                    this.thisInitialized = saveThisInitialized;
                }
            }
            do {
                newConstFound = false;
                for (i = first; i < last; ++i) {
                    classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                    rState = this.saveResolutionState(classSymbol);
                    try {
                        newConstFound |= classSymbol.findConstantFields(this);
                        continue;
                    }
                    catch (RuntimeException e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    catch (AssertionError e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    catch (StackOverflowError e) {
                        this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                        throw e;
                    }
                    finally {
                        this.restoreResolutionState(rState);
                    }
                }
            } while (newConstFound);
            for (i = first; i < last; ++i) {
                classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                if (!resolutionList.alsoHandleAnonymousClasses && classSymbol.isAnonymousInnerClass()) continue;
                rState = this.saveResolutionState(classSymbol);
                try {
                    classSymbol.assignFieldInitializers(this);
                    continue;
                }
                catch (RuntimeException e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                catch (AssertionError e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                catch (StackOverflowError e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                finally {
                    this.restoreResolutionState(rState);
                }
            }
            resolutionList.nextResolveFieldsInitIndex = last;
        }
    }

    private void resolveMethodBodies(ClassResolutionList resolutionList) {
        int last;
        Object rState;
        RawClassSymbol classSymbol;
        int i;
        int first = resolutionList.nextResolveMethodBodiesIndex;
        if (first < resolutionList.classSymbolList.size()) {
            for (i = first; i < resolutionList.classSymbolList.size(); ++i) {
                classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                rState = this.saveResolutionState(classSymbol);
                try {
                    if (this.parsingAtLeastOneFive) {
                        classSymbol.resolveClassAnnotations(this);
                        classSymbol.resolveMethodAndFieldAnnotations(this);
                    }
                    classSymbol.resolveMethodBodies(this);
                    if (!classSymbol.isAnonymousInnerClass()) {
                        classSymbol.fixConstructors(this);
                    }
                }
                catch (UnresolvedSuperClassException e) {
                    this.error(Error.errorNotFound, classSymbol.pos, false, e.classSymbol.errorName(), "");
                }
                catch (RuntimeException e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                catch (AssertionError e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                catch (StackOverflowError e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                finally {
                    this.restoreResolutionState(rState);
                }
                ++resolutionList.nextResolveMethodBodiesIndex;
            }
            last = resolutionList.classSymbolList.size();
            for (i = first; i < last; ++i) {
                classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                rState = this.saveResolutionState(classSymbol);
                try {
                    if (!this.errorFound) {
                        classSymbol.checkPrivateFieldAndMethodUsage(this);
                    }
                    if (classSymbol.getTopLevelClass().scope.lookupSpecificSymbolInScope(Identifier.getIdentifier(classSymbol.getClassName()), 16, false) == null) continue;
                    this.error(Message.errorPackageClassConflict, classSymbol.pos, false, new String(classSymbol.getClassName()));
                    continue;
                }
                catch (RuntimeException e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                catch (AssertionError e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                catch (StackOverflowError e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                finally {
                    this.restoreResolutionState(rState);
                }
            }
        }
        while (this.ambiguityCheckList != null) {
            classSymbol = this.ambiguityCheckList.outerClass;
            rState = this.saveResolutionState(classSymbol);
            try {
                classSymbol.checkForTypeAmbiguity(this, this.ambiguityCheckList.innerClass);
                this.ambiguityCheckList = this.ambiguityCheckList.next;
            }
            catch (RuntimeException e) {
                this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                throw e;
            }
            catch (AssertionError e) {
                this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                throw e;
            }
            catch (StackOverflowError e) {
                this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                throw e;
            }
            finally {
                this.restoreResolutionState(rState);
            }
        }
        this.checkImportDeclarations();
        if (!(this.options.noCodeGeneration || this.errorFound && !this.options.generateClassesDespiteErrors || (first = resolutionList.nextGenerateCodeIndex) >= (last = resolutionList.classSymbolList.size()))) {
            for (i = first; i < last; ++i) {
                classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                if (classSymbol.isErroneous()) continue;
                rState = this.saveResolutionState(classSymbol);
                try {
                    classSymbol.generateCode(this);
                    continue;
                }
                catch (RuntimeException e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                catch (AssertionError e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                catch (StackOverflowError e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                finally {
                    this.restoreResolutionState(rState);
                }
            }
            last = resolutionList.classSymbolList.size();
            for (i = first; i < last; ++i) {
                classSymbol = (RawClassSymbol)resolutionList.classSymbolList.get(i);
                if (classSymbol.isErroneous()) continue;
                rState = this.saveResolutionState(classSymbol);
                try {
                    classSymbol.generateClass(this);
                    continue;
                }
                catch (RuntimeException e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                catch (AssertionError e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                catch (StackOverflowError e) {
                    this.stateAtInternalError = (ResolutionState)this.saveResolutionState();
                    throw e;
                }
                finally {
                    this.restoreResolutionState(rState);
                }
            }
            resolutionList.nextGenerateCodeIndex = last;
        }
    }

    boolean addSourceFile(Storage sourceStorage) {
        int i = this.sourceFileList.size();
        while (--i >= 0) {
            SourceFile sourceFile = (SourceFile)this.sourceFileList.get(i);
            if (sourceFile.storage != sourceStorage) continue;
            return i > this.nextParseSourceFileIndex;
        }
        this.sourceFileList.add(new SourceFile(sourceStorage));
        return true;
    }

    void addAmbiguityCheck(RawClassSymbol outerClass, RawClassSymbol innerClass) {
        if (outerClass.isCompiled() && innerClass.scope.kind < 3) {
            AmbiguityCheckRecord acr = new AmbiguityCheckRecord(outerClass, innerClass);
            acr.next = this.ambiguityCheckList;
            this.ambiguityCheckList = acr;
        }
    }

    void findSourceFileForIdentifier(Scope scope, Identifier identifier) {
        if (scope != null && scope != this.globalScope) {
            RawClassSymbol classSymbol = new RawClassSymbol(0, identifier, 0, null, null, true, false);
            classSymbol.scope = scope;
            Storage sourceFile = this.options.findStorageOfSource(classSymbol);
            if (sourceFile != null) {
                this.addSourceFile(sourceFile);
                throw new NewSourceException();
            }
        }
    }

    boolean sourceOrClassFileForIdentifierAvailable(Scope scope, Identifier identifier) {
        if (scope != null && scope != this.globalScope) {
            RawClassSymbol classSymbol = new RawClassSymbol(0, identifier, 0, null, null, true, false);
            classSymbol.scope = scope;
            if (this.options.findStorageOfClass(classSymbol) != null) {
                return true;
            }
            if (this.options.findStorageOfSource(classSymbol) != null) {
                return true;
            }
        }
        return false;
    }

    private void checkImportSymbol(ImportSymbol importSymbol, int pos) {
        if ((importSymbol.flags & 1) != 0) {
            short access;
            RawClassSymbol classSymbol;
            Symbol symbol = importSymbol.importedSymbol;
            switch (symbol.kind) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 32: {
                    classSymbol = (RawClassSymbol)symbol;
                    if (!classSymbol.isCompiled() && !classSymbol.isErroneous()) {
                        classSymbol.loadType(this, pos, false, true);
                    }
                    access = classSymbol.access;
                    break;
                }
                case 8: {
                    MethodSymbol methodSymbol = (MethodSymbol)symbol;
                    access = methodSymbol.access;
                    classSymbol = methodSymbol.definingClass;
                    break;
                }
                case 2: {
                    FieldSymbol fieldSymbol = (FieldSymbol)symbol;
                    access = fieldSymbol.access;
                    classSymbol = fieldSymbol.definingClass;
                }
            }
            if ((access & 1) == 0) {
                PackageScope packageScope = (PackageScope)classSymbol.getPackageScope();
                if (packageScope != this.currentPackageScope) {
                    this.error(Message.errorNotPublic, pos, false, symbol.errorName(), packageScope.packageSymbol.errorName());
                } else if ((access & 2) != 0) {
                    this.error(Message.errorAccessError, pos, false, symbol.errorName());
                }
            }
            if (symbol.isDeprecated()) {
                this.warning(classSymbol, Message.warningIsDeprecated, pos, symbol.errorName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkImportDeclarations() {
        int first;
        int last = this.sourceFileList.size();
        for (int i = first = this.nextImportSourceFileIndex; i < last; ++i) {
            this.sourceFile = (SourceFile)this.sourceFileList.get(i);
            this.currentPackageScope = this.sourceFile.packageScope;
            RawClassSymbol topLevelClass = this.sourceFile.topLevelClass;
            try {
                ImportDescriptor impDesc = this.sourceFile.importList;
                while (impDesc != null) {
                    ArrayList importSymbolList = impDesc.importSymbolList;
                    if (importSymbolList != null) {
                        ImportSymbol impSym;
                        int size = importSymbolList.size();
                        if (size == 0) {
                            if ((impDesc.flags & 5) == 5) {
                                this.error(Message.errorNotFound, impDesc.pos, false, impDesc.importSymbol.errorName(), "");
                            } else {
                                this.warning(null, Message.warningUnusedImport, impDesc.pos, impDesc.importSymbol.errorName());
                            }
                        } else if (size == 1) {
                            impSym = (ImportSymbol)importSymbolList.get(0);
                            if (!impSym.used) {
                                this.warning(null, Message.warningUnusedImport, impDesc.pos, impDesc.importSymbol.errorName());
                            }
                            if ((impDesc.flags & 1) == 0 || impSym.used) {
                                this.checkImportSymbol(impSym, impDesc.pos);
                            }
                            if (topLevelClass != null) {
                                topLevelClass.addNameReference(this, impSym.importedSymbol, impSym.pos);
                            }
                        } else if ((impDesc.flags & 1) != 0) {
                            int j;
                            int count = 0;
                            for (j = 0; j < size; ++j) {
                                impSym = (ImportSymbol)importSymbolList.get(j);
                                if (!impSym.used) continue;
                                ++count;
                                this.checkImportSymbol(impSym, impDesc.pos);
                            }
                            if (count != size) {
                                if (count == 0) {
                                    this.warning(null, Message.warningUnusedImport, impDesc.pos, impDesc.importSymbol.errorName());
                                } else {
                                    boolean isStaticImport = (impDesc.flags & 2) != 0;
                                    StringBuffer replacementBuf = new StringBuffer();
                                    for (j = 0; j < size; ++j) {
                                        impSym = (ImportSymbol)importSymbolList.get(j);
                                        if (!impSym.used) continue;
                                        replacementBuf.append('\n');
                                        replacementBuf.append("import ");
                                        if (isStaticImport) {
                                            replacementBuf.append("static ");
                                        }
                                        replacementBuf.append(impSym.toString());
                                        replacementBuf.append(';');
                                    }
                                    StringBuffer importBuf = new StringBuffer();
                                    if (isStaticImport) {
                                        importBuf.append("static ");
                                    }
                                    importBuf.append(impDesc.importSymbol.errorName());
                                    importBuf.append(".*");
                                    this.warning(null, Message.warningPartialUsedStarImport, impDesc.pos, importBuf.toString(), replacementBuf.toString());
                                }
                            }
                        }
                    }
                    impDesc = impDesc.next;
                }
            }
            finally {
                this.sourceFile = null;
                this.currentPackageScope = null;
            }
            ++this.nextImportSourceFileIndex;
        }
    }

    boolean isInStaticContext(TypeParameterSymbol tpSym) {
        Symbol symbol;
        if (this.suspendStaticContextChecking) {
            return false;
        }
        if (this.currentMethodSymbol != null) {
            symbol = this.currentMethodSymbol;
        } else if (this.currentFieldSymbol != null) {
            symbol = this.currentFieldSymbol;
        } else if (this.currentClassSymbol != null) {
            symbol = this.currentClassSymbol;
        } else {
            return false;
        }
        block5: while (true) {
            if (!$assertionsDisabled && symbol == null) {
                throw new AssertionError();
            }
            if (symbol == tpSym.definingSymbol) {
                return false;
            }
            switch (symbol.kind) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 2: {
                    FieldSymbol fieldSymbol = (FieldSymbol)symbol;
                    if ((fieldSymbol.access & 8) != 0) {
                        return true;
                    }
                    symbol = fieldSymbol.definingClass;
                    continue block5;
                }
                case 8: {
                    Symbol methodSymbol = symbol;
                    if ((methodSymbol.access & 8) != 0) {
                        return true;
                    }
                    symbol = methodSymbol.definingClass;
                    continue block5;
                }
                case 32: 
            }
            RawClassSymbol classSymbol = (RawClassSymbol)symbol;
            if ((classSymbol.access & 0x4208) != 0) {
                return true;
            }
            if (!classSymbol.isInnerClass()) {
                return false;
            }
            symbol = classSymbol.getOuterClass();
        }
    }

    static {
        $assertionsDisabled = !Parser.class.desiredAssertionStatus();
    }

    private static class AmbiguityCheckRecord {
        AmbiguityCheckRecord next;
        RawClassSymbol outerClass;
        RawClassSymbol innerClass;

        AmbiguityCheckRecord(RawClassSymbol outerClass, RawClassSymbol innerClass) {
            this.outerClass = outerClass;
            this.innerClass = innerClass;
        }
    }

    static class ResolutionState {
        SourceFile sourceFile;
        StorageScope currentPackageScope;
        Symbol[] currentImportDeclarations;
        RawClassSymbol currentClassSymbol;
        MethodSymbol currentMethodSymbol;
        FieldSymbol currentFieldSymbol;
        Statement currentStatement;
        SwitchLoopList innerSwitchLoop;
        int estimatedLineCount;
        boolean suspendDataFlowChecking;
        boolean sameSourceOnRestore;
        BitSet defSet;
        BitSet posSet;
        BitSet useSet;
        BitSet exitDefSet;

        ResolutionState() {
        }
    }
}

