/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.TypeVariableSymbol;

final class ParameterizedClassSymbol
extends ClassSymbol {
    static ParameterizedClassSymbol errorClass;
    private static ParameterizedClassSymbol[] discretePCSMap;
    private static int discretePCSMapCount;
    ParameterizedClassSymbol nextHashed;
    RawClassSymbol genericClassSymbol;
    TypeVariableList typeVariableList;
    ParameterizedClassSymbol outerClassSymbol;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ParameterizedClassSymbol(RawClassSymbol genericClassSymbol, TypeVariableList typeVariableList, ParameterizedClassSymbol outerClassSymbol) {
        super(0, genericClassSymbol.identifier, (byte)10, genericClassSymbol.access, null);
        this.genericClassSymbol = genericClassSymbol;
        this.typeVariableList = typeVariableList;
        this.outerClassSymbol = outerClassSymbol;
    }

    boolean isErroneous() {
        return (this.symbolFlags & 2) != 0 || this.genericClassSymbol.isErroneous();
    }

    String errorName() {
        if (this.isErroneous() || this.genericClassSymbol.isErroneous()) {
            return "";
        }
        return this.kindName() + " " + this.toString();
    }

    String kindName() {
        return this.genericClassSymbol.kindName();
    }

    protected void toString(StringBuffer sb) {
        if (this.outerClassSymbol != null) {
            this.outerClassSymbol.toString(sb);
            sb.append('.');
            sb.append(this.identifier.name);
        } else {
            this.genericClassSymbol.toString(sb);
        }
        if (this.typeVariableList != null) {
            this.typeVariableList.toString(sb);
        }
    }

    char[] getInternalName() {
        return this.genericClassSymbol.getInternalName();
    }

    char[] getSignature() {
        return this.genericClassSymbol.getSignature();
    }

    boolean equalTo(TypeSymbol typeSymbol, TypeSymbol recursionCheck) {
        if (this == typeSymbol) {
            return true;
        }
        if (typeSymbol.isParameterizedClass()) {
            ParameterizedClassSymbol pcs = (ParameterizedClassSymbol)typeSymbol;
            if (this.genericClassSymbol != pcs.genericClassSymbol) {
                return false;
            }
            if (this == recursionCheck || typeSymbol == recursionCheck) {
                return true;
            }
            if (this.typeVariableList == null || pcs.typeVariableList == null) {
                return true;
            }
            return this.typeVariableList.equals(pcs.typeVariableList, this);
        }
        if (typeSymbol.isRawClass()) {
            return this.genericClassSymbol == (RawClassSymbol)typeSymbol;
        }
        if (typeSymbol.isTypeParameter()) {
            TypeParameterSymbol tps = (TypeParameterSymbol)typeSymbol;
            if (doMethodTypeParameterConversion && (doClassTypeParameterConversion || tps.isMethodTypeParameter())) {
                if (this.equalTo(tps.bound, recursionCheck)) {
                    return true;
                }
                if (this.containsTypeParameter(tps)) {
                    return false;
                }
                if (tps.bound.isInterface()) {
                    return this.implementsInterface(tps.bound, recursionCheck);
                }
                return tps.bound.isSuperclass(this, recursionCheck);
            }
            return this == ReferenceTypeSymbol.nullTypeSymbol;
        }
        if (typeSymbol.isTypeVariable()) {
            TypeVariableSymbol tvs = (TypeVariableSymbol)typeSymbol;
            ClassSymbol classSymbol = (ClassSymbol)tvs.refSymbol;
            switch (tvs.typeVariableKind) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 0: {
                    return true;
                }
                case 1: {
                    return this.equalTo(classSymbol, recursionCheck);
                }
                case 2: {
                    return classSymbol == ReferenceTypeSymbol.nullTypeSymbol;
                }
                case 3: 
            }
            if (this.equalTo(classSymbol, recursionCheck)) {
                return true;
            }
            if (classSymbol.isInterface()) {
                return this.implementsInterface(classSymbol, recursionCheck);
            }
            return classSymbol.isSuperclass(this, recursionCheck);
        }
        if (typeSymbol.isIntersectionType()) {
            return typeSymbol.equalTo(this, recursionCheck);
        }
        return false;
    }

    TypeSymbol resolveType(Parser parser, int pos, boolean mustBePublic, boolean checkActualTypeParameters, boolean lazy) {
        this.genericClassSymbol = (RawClassSymbol)this.genericClassSymbol.resolveType(parser, pos, mustBePublic, checkActualTypeParameters, lazy);
        return this;
    }

    boolean isAccessible(ClassSymbol fromClass) {
        if (!this.genericClassSymbol.isAccessible(fromClass)) {
            return false;
        }
        if (this.typeVariableList != null) {
            return this.typeVariableList.isAccessible(fromClass);
        }
        return true;
    }

    boolean isAnnotation() {
        return this.genericClassSymbol.isAnnotation();
    }

    boolean isEnum() {
        return this.genericClassSymbol.isEnum();
    }

    boolean isInterface() {
        return this.genericClassSymbol.isInterface();
    }

    boolean isInnerClass() {
        return this.genericClassSymbol.isInnerClass();
    }

    boolean isStaticInnerClass() {
        return this.genericClassSymbol.isStaticInnerClass();
    }

    boolean isNonStaticInnerClass() {
        return this.genericClassSymbol.isNonStaticInnerClass();
    }

    boolean isParameterizedClass() {
        return true;
    }

    boolean isErasedType() {
        return this.typeVariableList == null && this.genericClassSymbol.cd.getTypeParameterList() != null;
    }

    boolean isReifiable() {
        TypeVariableList tvl = this.typeVariableList;
        while (tvl != null) {
            if (tvl.typeVariable.typeVariableKind != 0) {
                return false;
            }
            tvl = tvl.next;
        }
        if (this.isInnerClass() && !this.isAnonymousInnerClass() && !this.isStaticInnerClass()) {
            return (this.genericClassSymbol.symbolFlags & 8) == 0;
        }
        return true;
    }

    boolean isGenericType() {
        return this.genericClassSymbol.isGenericType();
    }

    boolean involvesGenerics() {
        return this.typeVariableList != null;
    }

    char[] getGenericSignature() {
        TypeVariableList tvl;
        StringBuffer sb;
        char[] signature;
        if (this.outerClassSymbol != null) {
            signature = this.outerClassSymbol.getGenericSignature();
            sb = new StringBuffer();
            if (this.outerClassSymbol.typeVariableList != null) {
                sb.append(signature, 0, signature.length - 1);
            } else {
                sb.append(signature);
            }
            sb.append('.');
            sb.append(this.identifier.name);
            tvl = this.typeVariableList;
            if (tvl == null) {
                return sb.toString().toCharArray();
            }
        } else {
            signature = this.genericClassSymbol.getGenericSignature();
            tvl = this.typeVariableList;
            if (tvl == null) {
                return signature;
            }
            sb = new StringBuffer();
            sb.append(signature, 0, signature.length - 1);
        }
        sb.append('<');
        do {
            if (tvl.typeVariable.involvesGenerics()) {
                sb.append(tvl.typeVariable.getGenericSignature());
                continue;
            }
            sb.append(tvl.typeVariable.getSignature());
        } while ((tvl = tvl.next) != null);
        sb.append(">;");
        return sb.toString().toCharArray();
    }

    boolean involvesTypeParameter() {
        TypeVariableList tvl = this.typeVariableList;
        while (tvl != null) {
            if (tvl.typeVariable.involvesTypeParameter()) {
                return true;
            }
            tvl = tvl.next;
        }
        return false;
    }

    boolean containsTypeParameterDefinedBy(Symbol definedBySymbol) {
        TypeVariableList tvl = this.typeVariableList;
        while (tvl != null) {
            if (tvl.typeVariable.containsTypeParameterDefinedBy(definedBySymbol)) {
                return true;
            }
            tvl = tvl.next;
        }
        return false;
    }

    boolean containsTypeParameter(TypeParameterSymbol tps) {
        TypeVariableList tvl = this.typeVariableList;
        while (tvl != null) {
            if (tvl.typeVariable.containsTypeParameter(tps)) {
                return true;
            }
            tvl = tvl.next;
        }
        return false;
    }

    void getTypeParameterSymbol(ArrayList al) {
        TypeVariableList tvl = this.typeVariableList;
        while (tvl != null) {
            tvl.typeVariable.getTypeParameterSymbol(al);
            tvl = tvl.next;
        }
    }

    void changeScope(Scope scope) {
        TypeVariableList tvl = this.typeVariableList;
        while (tvl != null) {
            tvl.typeVariable.changeScope(scope);
            tvl = tvl.next;
        }
    }

    TypeSymbol replaceUnresolvedTypeParameters(TypeParameterList tpl) {
        boolean change = false;
        TypeVariableList tvLast = null;
        TypeVariableList tvList = null;
        TypeVariableList thisTvl = this.typeVariableList;
        while (thisTvl != null) {
            TypeVariableSymbol tvs = (TypeVariableSymbol)thisTvl.typeVariable.replaceUnresolvedTypeParameters(tpl);
            TypeVariableList ntvl = new TypeVariableList(tvs);
            if (tvList == null) {
                tvList = tvLast = ntvl;
            } else {
                tvLast.next = ntvl;
                tvLast = ntvl;
            }
            change |= tvs != thisTvl.typeVariable;
            thisTvl = thisTvl.next;
        }
        if (change) {
            return ParameterizedClassSymbol.getParameterizedClassSymbol(this.genericClassSymbol, tvList, this.outerClassSymbol);
        }
        return this;
    }

    TypeSymbol replaceTypeParameters(TypeParameterList tpl) {
        boolean change = false;
        TypeVariableList tvLast = null;
        TypeVariableList tvList = null;
        TypeVariableList thisTvl = this.typeVariableList;
        while (thisTvl != null) {
            TypeVariableSymbol tvs = (TypeVariableSymbol)thisTvl.typeVariable.replaceTypeParameters(tpl);
            TypeVariableList ntvl = new TypeVariableList(tvs);
            if (tvList == null) {
                tvList = tvLast = ntvl;
            } else {
                tvLast.next = ntvl;
                tvLast = ntvl;
            }
            change |= tvs != thisTvl.typeVariable;
            thisTvl = thisTvl.next;
        }
        if (change) {
            return ParameterizedClassSymbol.getParameterizedClassSymbol(this.genericClassSymbol, tvList, this.outerClassSymbol);
        }
        return this;
    }

    TypeSymbol applyTypeVariables(TypeParameterList tpl, TypeVariableList tvl, boolean topLevel) {
        boolean change = false;
        TypeVariableList tvLast = null;
        TypeVariableList tvList = null;
        TypeVariableList thisTvl = this.typeVariableList;
        while (thisTvl != null) {
            TypeVariableSymbol tvs = (TypeVariableSymbol)thisTvl.typeVariable.applyTypeVariables(tpl, tvl, false);
            TypeVariableList ntvl = new TypeVariableList(tvs);
            if (tvList == null) {
                tvList = tvLast = ntvl;
            } else {
                tvLast.next = ntvl;
                tvLast = ntvl;
            }
            change |= tvs != thisTvl.typeVariable;
            thisTvl = thisTvl.next;
        }
        if (change) {
            return ParameterizedClassSymbol.getParameterizedClassSymbol(this.genericClassSymbol, tvList, this.outerClassSymbol);
        }
        return this;
    }

    TypeSymbol eraseType() {
        return ParameterizedClassSymbol.getParameterizedClassSymbol(this.genericClassSymbol, null, this.outerClassSymbol);
    }

    RawClassSymbol getClassSymbol() {
        return this.genericClassSymbol.getClassSymbol();
    }

    ClassSymbol getSuperClassSymbol() {
        ClassSymbol superClass = this.genericClassSymbol.getSuperClassSymbol();
        if (superClass == null || !superClass.containsTypeParameterDefinedBy(null)) {
            return superClass;
        }
        if (this.isErasedType()) {
            return (ClassSymbol)superClass.eraseType();
        }
        return (ClassSymbol)superClass.applyTypeVariables(this.genericClassSymbol.cd.getTypeParameterList(), this.typeVariableList);
    }

    ImplementationList getImplementationList() {
        ImplementationList orgList;
        ImplementationList implList = orgList = this.genericClassSymbol.getImplementationList();
        while (implList != null && !implList.interfaceSymbol.containsTypeParameterDefinedBy(null)) {
            implList = implList.next;
        }
        if (implList == null) {
            return orgList;
        }
        ImplementationList implLast = null;
        implList = null;
        do {
            ClassSymbol interfaceSymbol = this.isErasedType() ? (ClassSymbol)orgList.interfaceSymbol.eraseType() : (ClassSymbol)orgList.interfaceSymbol.applyTypeVariables(this.genericClassSymbol.cd.getTypeParameterList(), this.typeVariableList);
            ImplementationList il = new ImplementationList(interfaceSymbol);
            if (implList == null) {
                implList = implLast = il;
                continue;
            }
            implLast.next = il;
            implLast = il;
        } while ((orgList = orgList.next) != null);
        return implList;
    }

    void checkForOutOfPackageInnerClasses(ConstantPool constantPool, RawClassSymbol outerClass) {
        TypeVariableList tvl = this.typeVariableList;
        while (tvl != null) {
            TypeSymbol refSymbol = tvl.typeVariable.refSymbol;
            if (refSymbol != null && refSymbol.isReferenceType()) {
                ClassSymbol classSymbol;
                if (refSymbol.isArrayType()) {
                    ArraySymbol arraySymbol = (ArraySymbol)refSymbol;
                    if (!arraySymbol.baseType.isClass()) {
                        return;
                    }
                    classSymbol = (ClassSymbol)arraySymbol.baseType;
                } else {
                    classSymbol = (ClassSymbol)refSymbol;
                }
                if (classSymbol != null && !classSymbol.isTypeParameter()) {
                    constantPool.checkForOutOfPackageInnerClass(outerClass, classSymbol.getClassSymbol());
                    classSymbol.checkForOutOfPackageInnerClasses(constantPool, outerClass);
                }
            }
            tvl = tvl.next;
        }
    }

    static void initializeStatics() {
        discretePCSMap = new ParameterizedClassSymbol[1024];
        discretePCSMapCount = 0;
        errorClass = new ParameterizedClassSymbol(RawClassSymbol.getErrorClassSymbol(), null, null);
    }

    static void releaseStatics() {
        discretePCSMap = null;
        errorClass = null;
    }

    private static int rehashParameterizedClassSymbols() {
        int cnt = discretePCSMapCount;
        ParameterizedClassSymbol[] oldTable = discretePCSMap;
        int oldLength = oldTable.length;
        int newLength = oldLength << 1;
        ParameterizedClassSymbol[] newTable = new ParameterizedClassSymbol[newLength];
        for (int i = 0; i < oldLength; ++i) {
            ParameterizedClassSymbol npcs;
            ParameterizedClassSymbol pcs = oldTable[i];
            if (pcs == null) continue;
            do {
                --cnt;
                npcs = pcs.nextHashed;
                int hash = pcs.identifier.hash & newLength - 1;
                pcs.nextHashed = newTable[hash];
                newTable[hash] = pcs;
            } while ((pcs = npcs) != null);
            if (cnt == 0) break;
        }
        discretePCSMap = newTable;
        return newLength;
    }

    static ParameterizedClassSymbol getParameterizedClassSymbol(RawClassSymbol genericClassSymbol, TypeVariableList typeVariableList, ParameterizedClassSymbol outerClassSymbol) {
        int length = discretePCSMap.length;
        int count = discretePCSMapCount;
        if (length < 0x200000 && count > length - (length >> 2)) {
            length = ParameterizedClassSymbol.rehashParameterizedClassSymbols();
        }
        int hash = genericClassSymbol.identifier.hash;
        ParameterizedClassSymbol pcs = discretePCSMap[hash & length - 1];
        while (pcs != null) {
            if (pcs.genericClassSymbol == genericClassSymbol && pcs.outerClassSymbol == outerClassSymbol) {
                TypeVariableSymbol tvs2;
                TypeVariableSymbol tvs1;
                if (pcs.typeVariableList == typeVariableList) {
                    return pcs;
                }
                TypeVariableList tvl1 = pcs.typeVariableList;
                TypeVariableList tvl2 = typeVariableList;
                while (tvl1 != null && tvl2 != null) {
                    tvs1 = tvl1.typeVariable;
                    tvs2 = tvl2.typeVariable;
                    if (tvs1.typeVariableKind != tvs2.typeVariableKind || tvs1.refSymbol != tvs2.refSymbol) break;
                    tvl1 = tvl1.next;
                    tvl2 = tvl2.next;
                }
                if (tvl1 == tvl2) {
                    tvl1 = pcs.typeVariableList;
                    tvl2 = typeVariableList;
                    while (tvl1 != null && tvl2 != null) {
                        tvs1 = tvl1.typeVariable;
                        tvs2 = tvl2.typeVariable;
                        tvs1.pos = tvs2.pos;
                        tvl1 = tvl1.next;
                        tvl2 = tvl2.next;
                    }
                    return pcs;
                }
            }
            pcs = pcs.nextHashed;
        }
        pcs = new ParameterizedClassSymbol(genericClassSymbol, typeVariableList, outerClassSymbol);
        pcs.nextHashed = discretePCSMap[hash &= length - 1];
        ParameterizedClassSymbol.discretePCSMap[hash] = pcs;
        discretePCSMapCount = count + 1;
        return pcs;
    }

    static void updateAccessOfExistingParameterizedClasses(RawClassSymbol classSymbol) {
        int hash = classSymbol.identifier.hash;
        ParameterizedClassSymbol pcs = discretePCSMap[hash & discretePCSMap.length - 1];
        while (pcs != null) {
            if (pcs.genericClassSymbol == classSymbol) {
                pcs.access = classSymbol.access;
            }
            pcs = pcs.nextHashed;
        }
    }

    void checkBounds(Parser parser, int pos, TypeSymbol typeSymbol) {
        if (typeSymbol.isParameterizedClass() && !typeSymbol.isErroneous()) {
            ParameterizedClassSymbol pcs = (ParameterizedClassSymbol)typeSymbol;
            TypeVariableList tvl1 = this.typeVariableList;
            TypeVariableList tvl2 = pcs.typeVariableList;
            while (true) {
                if (tvl1 == null) {
                    return;
                }
                if (tvl2 == null) {
                    parser.error(Message.errorTypeParameterOutOfBounds, pos, false, pcs.errorName());
                    return;
                }
                TypeVariableSymbol tvs1 = tvl1.typeVariable;
                TypeVariableSymbol tvs2 = tvl2.typeVariable;
                switch (tvs1.typeVariableKind) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case 0: {
                        break;
                    }
                    case 3: {
                        if (tvs2.equalTo(tvs1)) break;
                        if (tvs1.refSymbol.isInterface()) {
                            if (((ClassSymbol)tvs2.refSymbol).implementsInterface((ClassSymbol)tvs1.refSymbol)) break;
                            parser.error(Message.errorTypeParameterOutOfBounds, pos, false, pcs.errorName());
                            break;
                        }
                        if (((ClassSymbol)tvs2.refSymbol).isSuperclass((ClassSymbol)tvs1.refSymbol)) break;
                        parser.error(Message.errorTypeParameterOutOfBounds, pos, false, pcs.errorName());
                        break;
                    }
                    case 2: {
                        if (tvs2.equalTo(tvs1)) break;
                        if (tvs1.refSymbol.isInterface()) {
                            if (((ClassSymbol)tvs1.refSymbol).implementsInterface((ClassSymbol)tvs2.refSymbol)) break;
                            parser.error(Message.errorTypeParameterOutOfBounds, pos, false, pcs.errorName());
                            break;
                        }
                        if (((ClassSymbol)tvs1.refSymbol).isSuperclass((ClassSymbol)tvs2.refSymbol)) break;
                        parser.error(Message.errorTypeParameterOutOfBounds, pos, false, pcs.errorName());
                    }
                }
                if (tvs1.isParameterizedClass()) {
                    ((ParameterizedClassSymbol)tvs1.refSymbol).checkBounds(parser, pos, tvs2.refSymbol);
                }
                tvl1 = tvl1.next;
                tvl2 = tvl2.next;
            }
        }
        parser.error(Message.errorTypeParameterOutOfBounds, pos, typeSymbol.isErroneous(), typeSymbol.errorName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkActualTypeParameters(Parser parser, int pos) {
        TypeVariableList tvl;
        if (!this.isErroneous() && (tvl = this.typeVariableList) != null) {
            do {
                TypeParameterSymbol tps;
                Object var7_6;
                TypeSymbol typeSymbol;
                if ((typeSymbol = tvl.typeVariable.refSymbol) == null) continue;
                try {
                    tvl.typeVariable.refSymbol = null;
                    typeSymbol = typeSymbol.resolveType(parser, pos, false, true, false);
                    var7_6 = null;
                    tvl.typeVariable.refSymbol = typeSymbol;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    tvl.typeVariable.refSymbol = typeSymbol;
                    throw throwable;
                }
                if (typeSymbol.isErroneous()) {
                    this.symbolFlags = (byte)(this.symbolFlags | 2);
                }
                if (!typeSymbol.isTypeParameter() || (tps = (TypeParameterSymbol)typeSymbol).isMethodTypeParameter() || tps.definingSymbol == this.getClassSymbol() || !parser.isInStaticContext(tps)) continue;
                parser.error(Message.errorUndefinedThis, pos, tps.isErroneous(), tps.errorName());
            } while ((tvl = tvl.next) != null);
            if (!parser.suspendTypeBoundsChecking) {
                this.checkBounds(parser);
            }
        }
    }

    void checkBounds(Parser parser) {
        TypeParameterList tpl;
        if (this.typeVariableList == null || this.isErroneous()) {
            return;
        }
        RawClassSymbol genericClass = this.getClassSymbol();
        TypeParameterList typeParameters = tpl = genericClass.cd.getTypeParameterList();
        TypeVariableList tvl = this.typeVariableList;
        do {
            if (tpl == null) {
                parser.error(Message.errorTooManyTypeParameters, this.pos, false, this.errorName());
                continue;
            }
            TypeSymbol typeSymbol = tvl.typeVariable.refSymbol;
            if (typeSymbol != null) {
                tpl.typeParameter.checkBounds(parser, tvl.typeVariable, typeParameters, this.typeVariableList);
            }
            tpl = tpl.next;
        } while ((tvl = tvl.next) != null);
        if (tpl != null) {
            parser.error(Message.errorMissingTypeParameters, this.pos, false, this.errorName());
        }
    }

    TypeSymbol getTypeVariable(TypeParameterSymbol tps) {
        TypeVariableList tvl = this.typeVariableList;
        if (tvl == null) {
            return null;
        }
        TypeParameterList tpl = this.getClassSymbol().cd.getTypeParameterList();
        while (tpl.typeParameter != tps) {
            tpl = tpl.next;
            tvl = tvl.next;
        }
        return tvl.typeVariable.refSymbol;
    }

    static boolean areDistinctParameterizedTypes(ClassSymbol one, ClassSymbol two) {
        if (!one.isParameterizedClass() || !two.isParameterizedClass()) {
            return false;
        }
        if (!one.eraseType().equalTo(two.eraseType())) {
            return true;
        }
        ParameterizedClassSymbol onePcs = (ParameterizedClassSymbol)one;
        ParameterizedClassSymbol twoPcs = (ParameterizedClassSymbol)two;
        TypeVariableList tvl1 = onePcs.typeVariableList;
        TypeVariableList tvl2 = twoPcs.typeVariableList;
        if (tvl1 == null || tvl2 == null) {
            return false;
        }
        while (tvl1 != null && tvl2 != null) {
            if (tvl1.typeVariable.typeVariableKind != 1 || tvl2.typeVariable.typeVariableKind != 1) {
                return false;
            }
            TypeSymbol ref1 = tvl1.typeVariable.refSymbol;
            TypeSymbol ref2 = tvl2.typeVariable.refSymbol;
            if (ref1 != null && ref2 != null) {
                if (ref1.isTypeParameter() || ref2.isTypeParameter()) {
                    return false;
                }
                if (ref1 instanceof ClassSymbol && ref2 instanceof ClassSymbol) {
                    if (ParameterizedClassSymbol.areDistinctParameterizedTypes((ClassSymbol)ref1, (ClassSymbol)ref2)) {
                        return true;
                    }
                } else if (ref1.isArrayType() && ref2.isArrayType()) {
                    ArraySymbol array1 = (ArraySymbol)ref1;
                    ArraySymbol array2 = (ArraySymbol)ref2;
                    if (array1.dimension != array2.dimension) {
                        return true;
                    }
                    if (array1.baseType instanceof ClassSymbol && array2.baseType instanceof ClassSymbol && ParameterizedClassSymbol.areDistinctParameterizedTypes((ClassSymbol)array1.baseType, (ClassSymbol)array2.baseType)) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            tvl1 = tvl1.next;
            tvl2 = tvl2.next;
        }
        return tvl1 != tvl2;
    }

    static {
        $assertionsDisabled = !ParameterizedClassSymbol.class.desiredAssertionStatus();
    }
}

