/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

abstract class NumericBinaryExpression
extends BinaryExpression {
    NumericBinaryExpression(byte kind, int pos, Expression leftOperand, Expression rightOperand) {
        super(kind, pos, leftOperand, rightOperand);
    }

    Expression resolveAndCheck(Parser parser) {
        Expression leftOp = this.leftOperand;
        leftOp = leftOp.resolveAndCheck(parser);
        Expression rightOp = this.rightOperand;
        rightOp = rightOp.resolveAndCheck(parser);
        TypeSymbol leftOpType = leftOp.getType();
        TypeSymbol rightOpType = rightOp.getType();
        TypeSymbol commonType = TypeSymbol.binaryNumericPromotion(parser, leftOpType, rightOpType);
        this.setType(commonType);
        if (commonType.isErroneous()) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, leftOpType.isErroneous() | rightOpType.isErroneous(), this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
            return new ErrorExpression(error);
        }
        this.leftOperand = leftOp.promoteType(parser, commonType);
        this.rightOperand = rightOp.promoteType(parser, commonType);
        return this.foldExpression();
    }
}

