/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.AnonymousClassSymbol;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionList;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ThisExpression;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.UnresolvedClassSymbol;

final class NewExpression
extends Expression {
    static final byte[] newArrayKind = new byte[12];
    ExpressionList dimExprList;
    Expression outerClassExpression;
    TypeSymbol newType;
    int dimension;

    NewExpression(int pos, TypeSymbol newType, Expression outerClassExpression, ExpressionList dimExprList) {
        super((byte)47, pos);
        this.newType = newType;
        this.outerClassExpression = outerClassExpression;
        this.dimExprList = dimExprList;
        this.setType(null);
    }

    Expression resolveAndCheck(Parser parser) {
        RawClassSymbol innerClass;
        TypeSymbol typeSymbol;
        ParameterizedClassSymbol pcs;
        TypeSymbol nwType;
        UnresolvedClassSymbol unresolvedClassSymbol;
        boolean typeHasBeenResolvedBefore;
        boolean bl = typeHasBeenResolvedBefore = this.getType() != null;
        if (this.outerClassExpression != null) {
            this.outerClassExpression = this.outerClassExpression.resolveAndCheck(parser);
            TypeSymbol outerClassType = this.outerClassExpression.getType();
            if (!outerClassType.isClass()) {
                Error error = parser.error(Message.errorObjectRequired, this.outerClassExpression.pos, outerClassType.isErroneous(), outerClassType.errorName());
                return new ErrorExpression(error);
            }
            if (this.newType instanceof UnresolvedClassSymbol) {
                unresolvedClassSymbol = (UnresolvedClassSymbol)this.newType;
                unresolvedClassSymbol.scope = ((ClassSymbol)outerClassType).getClassScope();
                if (unresolvedClassSymbol.qualifierList != null) {
                    parser.error(Message.errorIllegalQualifier, this.pos, false, "new");
                }
            }
        }
        if (this.newType.isAnonymousInnerClass()) {
            nwType = this.newType;
        } else {
            this.newType = nwType = this.newType.resolveType(parser, this.pos, false, true, false);
            if (parser.currentClassSymbol != null) {
                parser.currentClassSymbol.addNameReference(parser, nwType, this.pos);
            }
        }
        if (nwType.isPrimitiveType()) {
            Error error = parser.error(Message.errorDifferentKindRequired, this.pos, nwType.isErroneous(), Message.classString, nwType.errorName());
            return new ErrorExpression(error);
        }
        nwType.checkDeprecated(parser, this.pos);
        if (!nwType.isArrayType() && nwType.isParameterizedClass()) {
            pcs = (ParameterizedClassSymbol)nwType;
            TypeVariableList tvl = pcs.typeVariableList;
            while (tvl != null) {
                if (tvl.typeVariable.typeVariableKind != 1) {
                    Error error = parser.error(Message.errorNoWildCardsInNewTypeArgs, this.pos, nwType.isErroneous());
                    return new ErrorExpression(error);
                }
                tvl = tvl.next;
            }
        }
        if (nwType.isArrayType()) {
            ExpressionList el = this.dimExprList;
            el = this.dimExprList;
            int dim = 0;
            while (el != null) {
                Expression expr = el.expr;
                expr = expr.resolveAndCheck(parser);
                TypeSymbol exprType = expr.getType();
                if ((exprType.typeClass & 4) == 0) {
                    TypeSymbol primitiveType;
                    if (parser.parsingAtLeastOneFive && exprType.isReferenceType() && (primitiveType = BoxingExpression.getPrimitiveType(parser, exprType)) != null && (primitiveType.typeClass & 4) != 0) {
                        expr = new AutoUnboxingExpression(expr, primitiveType);
                        exprType = primitiveType;
                    } else {
                        Error error = parser.error(Message.errorIncompatibleTypes, expr.pos, exprType.isErroneous(), exprType.errorName(), "int");
                        return new ErrorExpression(error);
                    }
                }
                exprType = TypeSymbol.unaryNumericPromotion(parser, exprType);
                el.expr = expr.promoteType(parser, exprType);
                el = el.next;
                ++dim;
            }
            this.dimension = dim;
            ArraySymbol arraySymbol = (ArraySymbol)nwType;
            if (!typeHasBeenResolvedBefore && arraySymbol.baseType.isParameterizedClass()) {
                pcs = (ParameterizedClassSymbol)arraySymbol.baseType;
                if (!pcs.isReifiable()) {
                    Error error = pcs.typeVariableList == null ? parser.error(Error.errorArrayCreationOfGenericType, this.pos, false) : parser.error(Error.errorWildCardsInArrayCreation, this.pos, false);
                    return new ErrorExpression(error);
                }
                if (pcs.typeVariableList != null) {
                    TypeParameterList tpl = pcs.getClassSymbol().cd.getTypeParameterList();
                    TypeVariableList newTvl = TypeVariableList.newTypeVariableListExtendFromBounds(tpl);
                    pcs = ParameterizedClassSymbol.getParameterizedClassSymbol(pcs.getClassSymbol(), newTvl, null);
                    nwType = this.newType = ArraySymbol.getArrayType(pcs, arraySymbol.dimension);
                }
            }
        } else if (this.outerClassExpression != null) {
            ParameterizedClassSymbol outerClass;
            AnonymousClassSymbol anonClass = null;
            Identifier innerClassIdentifier = nwType.identifier;
            if (nwType.isAnonymousInnerClass()) {
                anonClass = (AnonymousClassSymbol)nwType;
                ClassSymbol superClass = anonClass.superClass;
                innerClassIdentifier = superClass.identifier;
                if (superClass instanceof UnresolvedClassSymbol) {
                    unresolvedClassSymbol = (UnresolvedClassSymbol)superClass;
                    if (unresolvedClassSymbol.qualifierList != null) {
                        Error error = parser.error(Message.errorIllegalQualifier, this.pos, false, "new");
                        if (anonClass != null) {
                            anonClass.flags = (short)(anonClass.flags | 0x10);
                        }
                        return new ErrorExpression(error);
                    }
                }
            }
            if ((typeSymbol = this.outerClassExpression.getType()).isRawClass()) {
                typeSymbol = ParameterizedClassSymbol.getParameterizedClassSymbol((RawClassSymbol)typeSymbol, null, null);
            }
            if ((innerClass = (outerClass = (ParameterizedClassSymbol)typeSymbol).getClassSymbol().lookupInnerClassByName(innerClassIdentifier)) == null || (innerClass.access & 8) != 0) {
                Error error = parser.error(Message.errorNotFound, this.pos, nwType.isErroneous(), nwType.errorName(), Message.inString + " " + outerClass.errorName());
                if (anonClass != null) {
                    anonClass.flags = (short)(anonClass.flags | 0x10);
                }
                return new ErrorExpression(error);
            }
            parser.addAmbiguityCheck(outerClass.getClassSymbol(), innerClass);
            if (!innerClass.isAccessible(parser.currentClassSymbol) || innerClass.getTopLevelClass() != parser.currentClassSymbol.getTopLevelClass() && (innerClass.access & 2) != 0) {
                Error error = parser.error(Message.errorAccessError, this.pos, innerClass.isErroneous(), innerClass.errorName());
                if (anonClass != null) {
                    anonClass.flags = (short)(anonClass.flags | 0x10);
                }
                return new ErrorExpression(error);
            }
            if ((innerClass.access & 0x400) != 0) {
                Error error = parser.error(Message.errorAbstractInstantiation, this.pos, innerClass.isErroneous(), innerClass.errorName());
                if (anonClass != null) {
                    anonClass.flags = (short)(anonClass.flags | 0x10);
                }
                return new ErrorExpression(error);
            }
            if (anonClass != null) {
                unresolvedClassSymbol = (UnresolvedClassSymbol)anonClass.superClass;
                unresolvedClassSymbol.resolveActualTypeParameters(parser, this.pos, false);
                pcs = ParameterizedClassSymbol.getParameterizedClassSymbol(innerClass, unresolvedClassSymbol.typeVariableList, outerClass);
                pcs.checkActualTypeParameters(parser, this.pos);
                anonClass.superClass = pcs;
                anonClass.completeAnonymousClass(parser);
            } else {
                pcs = (ParameterizedClassSymbol)nwType;
                this.newType = nwType = ParameterizedClassSymbol.getParameterizedClassSymbol(pcs.genericClassSymbol, pcs.typeVariableList, outerClass);
            }
        } else {
            ClassSymbol superClass;
            AnonymousClassSymbol anonClass;
            RawClassSymbol classSymbol = ((ClassSymbol)nwType).getClassSymbol();
            if (classSymbol.isAnonymousInnerClass()) {
                anonClass = (AnonymousClassSymbol)classSymbol;
                if ((anonClass.flags & 0x10) != 0) {
                    return ErrorExpression.errorExpression;
                }
                anonClass.completeAnonymousClass(parser);
                anonClass.superClass = superClass = (ClassSymbol)anonClass.superClass.resolveType(parser, this.pos, true, true, false);
                if (superClass.isNonStaticInnerClass() && (parser.currentMethodSymbol != null && (parser.currentMethodSymbol.access & 8) != 0 || parser.currentFieldSymbol != null && (parser.currentFieldSymbol.access & 8) != 0)) {
                    Error error = parser.error(Message.errorUndefinedThis, this.pos, superClass.isErroneous(), superClass.errorName());
                    anonClass.flags = (short)(anonClass.flags | 0x10);
                    return new ErrorExpression(error);
                }
            }
            if ((classSymbol.access & 0x400) != 0) {
                Error error = parser.error(Message.errorAbstractInstantiation, this.pos, classSymbol.isErroneous(), classSymbol.errorName());
                return new ErrorExpression(error);
            }
            if (classSymbol.isNonStaticInnerClass()) {
                if (classSymbol.isAnonymousInnerClass()) {
                    anonClass = (AnonymousClassSymbol)classSymbol;
                    superClass = anonClass.superClass;
                    if (superClass.isInnerClass() && !superClass.isLocalInnerClass()) {
                        parser.addAmbiguityCheck(superClass.getOuterClass(), superClass.getClassSymbol());
                    }
                } else if (!classSymbol.isLocalInnerClass()) {
                    boolean inStaticClass;
                    parser.addAmbiguityCheck(classSymbol.getOuterClass(), classSymbol);
                    boolean bl2 = inStaticClass = (parser.currentClassSymbol.access & 8) != 0;
                    if (!inStaticClass) {
                        boolean inStaticMethod;
                        boolean bl3 = inStaticMethod = parser.currentMethodSymbol != null && (parser.currentMethodSymbol.access & 8) != 0;
                        if (!inStaticMethod) {
                            boolean inStaticField;
                            boolean bl4 = inStaticField = parser.currentFieldSymbol != null && (parser.currentFieldSymbol.access & 8) != 0;
                            if (!inStaticField) {
                                RawClassSymbol outerClassOfInner = classSymbol.getOuterClass();
                                boolean outerIsCurrent = false;
                                boolean outerIsSuper = false;
                                for (RawClassSymbol currentClass = parser.currentClassSymbol; currentClass != null; currentClass = ((ClassSymbol)currentClass).getOuterClass()) {
                                    if (currentClass.equalTo(outerClassOfInner)) {
                                        outerIsCurrent = true;
                                        break;
                                    }
                                    if (outerClassOfInner.isSuperclass(currentClass)) {
                                        outerIsSuper = true;
                                        break;
                                    }
                                    if (!currentClass.isInnerClass()) break;
                                }
                                boolean innerIsCurrent = parser.currentClassSymbol.equalTo(classSymbol);
                                if (!(outerIsCurrent || outerIsSuper || innerIsCurrent)) {
                                    Error error = parser.error(Message.errorNeedEnclosingInstance, this.pos, classSymbol.isErroneous(), classSymbol.errorName());
                                    return new ErrorExpression(error);
                                }
                            }
                        }
                    }
                }
                if (!classSymbol.isAnonymousInnerClass()) {
                    if (!((parser.currentClassSymbol.access & 8) == 0 || classSymbol.getTopLevelClass() != parser.currentClassSymbol.getTopLevelClass() || classSymbol.isInnerClass(parser.currentClassSymbol) || parser.currentClassSymbol.equalTo(classSymbol) || parser.currentClassSymbol.isSuperclass(classSymbol) || classSymbol.getOuterClass().equalTo(parser.currentClassSymbol) || classSymbol.getOuterClass().isSuperclass(parser.currentClassSymbol))) {
                        Error error = parser.error(Message.errorUndefinedThis, this.pos, classSymbol.isErroneous(), classSymbol.errorName());
                        return new ErrorExpression(error);
                    }
                    if ((parser.currentMethodSymbol != null && (parser.currentMethodSymbol.access & 8) != 0 || parser.currentFieldSymbol != null && (parser.currentFieldSymbol.access & 8) != 0) && (!parser.currentClassSymbol.isInnerClass() || (parser.currentClassSymbol.access & 8) != 0 && !parser.currentClassSymbol.equalTo(classSymbol) && !parser.currentClassSymbol.isSuperclass(classSymbol))) {
                        Error error = parser.error(Message.errorUndefinedThis, this.pos, classSymbol.isErroneous(), classSymbol.errorName());
                        return new ErrorExpression(error);
                    }
                }
            }
        }
        if ((typeSymbol = nwType).isArrayType()) {
            typeSymbol = ((ArraySymbol)typeSymbol).baseType;
        }
        if (typeSymbol.isTypeParameter()) {
            Error error = parser.error(Message.errorIllegalTypeParameterOperator, this.pos, false, this.toString());
            return new ErrorExpression(error);
        }
        if (!parser.thisInitialized && typeSymbol.isInnerClass() && !typeSymbol.isStaticInnerClass()) {
            innerClass = ((ClassSymbol)typeSymbol).getClassSymbol();
            if (innerClass.isAnonymousInnerClass()) {
                innerClass = ((AnonymousClassSymbol)innerClass).getOverriddenClass().getClassSymbol();
            }
            if (parser.currentClassSymbol != null && innerClass.isInnerClass(parser.currentClassSymbol)) {
                Error error = parser.error(Message.errorReferenceBeforeSuper, this.pos, false);
                return new ErrorExpression(error);
            }
        }
        this.setType(nwType);
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        RawClassSymbol currentClassSymbol = byteCodeGenerator.parser.currentClassSymbol;
        TypeSymbol nwType = this.newType;
        if (nwType.isArrayType()) {
            TypeSymbol baseType;
            ExpressionList el = this.dimExprList;
            int dim = this.dimension;
            ArraySymbol arrayType = (ArraySymbol)nwType;
            if (dim == 1) {
                el.expr.generateByteCode(byteCodeGenerator);
                baseType = ArraySymbol.getArrayType(arrayType.baseType, arrayType.dimension - 1);
                if (baseType.isPrimitiveType()) {
                    byteCodeGenerator.generate_8_8((byte)-68, newArrayKind[baseType.typeKind]);
                } else {
                    short index = byteCodeGenerator.constantPool.enterConstantPoolClass(baseType.getInternalName());
                    byteCodeGenerator.generate_8_16((byte)-67, index);
                }
            } else {
                while (el != null) {
                    el.expr.generateByteCode(byteCodeGenerator);
                    el = el.next;
                }
                short index = byteCodeGenerator.constantPool.enterConstantPoolClass(arrayType.getInternalName());
                byteCodeGenerator.generate_8_16_8((byte)-59, index, (byte)dim);
                byteCodeGenerator.decOpStackHeight(dim - 1);
            }
            if (this.getType().typeKind == 1) {
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            if ((baseType = arrayType.baseType).isClass()) {
                RawClassSymbol elemClass = ((ClassSymbol)baseType).getClassSymbol();
                byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(currentClassSymbol, elemClass);
                currentClassSymbol.addNameReference(byteCodeGenerator.parser, baseType, this.pos);
            }
        } else {
            short index = byteCodeGenerator.constantPool.enterConstantPoolClass(nwType.getInternalName());
            byteCodeGenerator.generate_8_16_8((byte)-69, index, (byte)89);
            byteCodeGenerator.incOpStackHeight(2);
            if (nwType.isAnonymousInnerClass() && ((AnonymousClassSymbol)nwType).hasHiddenOuterThisArgument()) {
                byteCodeGenerator.generate_8((byte)42);
                byteCodeGenerator.incOpStackHeight(1);
            }
            if (this.outerClassExpression != null) {
                this.outerClassExpression.generateByteCode(byteCodeGenerator);
                if (!(this.outerClassExpression instanceof ThisExpression) || ((ThisExpression)this.outerClassExpression).outerClassSymbol != null) {
                    index = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(Identifier.javaLangObjectInternal.name, Identifier.getClassIdentifier.name, Identifier.javaLangClassMethodSignature.name);
                    byteCodeGenerator.generate_8((byte)89);
                    byteCodeGenerator.generate_8_16_8((byte)-74, index, (byte)87);
                    byteCodeGenerator.incOpStackHeight(1);
                    byteCodeGenerator.decOpStackHeight(1);
                }
            } else {
                RawClassSymbol classSymbol = ((ClassSymbol)nwType).getClassSymbol();
                if (classSymbol.isAnonymousInnerClass()) {
                    classSymbol = classSymbol.getSuperClassSymbol().getClassSymbol();
                }
                if (classSymbol.isNonStaticInnerClass()) {
                    classSymbol = classSymbol.getOuterClass();
                    if (currentClassSymbol.isInnerClass() && !classSymbol.equalTo(currentClassSymbol) && !classSymbol.isInnerClass(currentClassSymbol) && !classSymbol.isSuperclass(currentClassSymbol)) {
                        if (!byteCodeGenerator.parser.currentMethodSymbol.isConstructor()) {
                            byteCodeGenerator.loadLocalVariable(classSymbol, (short)0);
                        }
                        byteCodeGenerator.generateOuterClassFieldAccessor(classSymbol, currentClassSymbol, false);
                    } else {
                        byteCodeGenerator.loadLocalVariable(classSymbol, (short)0);
                    }
                }
            }
            RawClassSymbol elemClass = ((ClassSymbol)nwType).getClassSymbol();
            byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(currentClassSymbol, elemClass);
            currentClassSymbol.addNameReference(byteCodeGenerator.parser, nwType, this.pos);
        }
    }

    public String toString() {
        return "new";
    }

    static {
        NewExpression.newArrayKind[2] = 4;
        NewExpression.newArrayKind[4] = 5;
        NewExpression.newArrayKind[8] = 6;
        NewExpression.newArrayKind[9] = 7;
        NewExpression.newArrayKind[3] = 8;
        NewExpression.newArrayKind[5] = 9;
        NewExpression.newArrayKind[6] = 10;
        NewExpression.newArrayKind[7] = 11;
    }
}

