/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.NumericBinaryExpression;

final class ModuloExpression
extends NumericBinaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    ModuloExpression(int pos, Expression leftOperand, Expression rightOperand) {
        super((byte)37, pos, leftOperand, rightOperand);
    }

    strictfp Expression foldExpression() {
        Expression leftOp = this.leftOperand;
        Expression rightOp = this.rightOperand;
        if (leftOp.kind == 2 && rightOp.kind == 2) {
            switch (leftOp.getType().typeClass) {
                case 4: {
                    int ival = ((ConstantExpression)rightOp).getIntConstValue();
                    if (ival == 0) break;
                    return new IntConstantExpression(this.pos, this.getType(), ((ConstantExpression)leftOp).getIntConstValue() % ival);
                }
                case 8: {
                    long lval = ((LongConstantExpression)rightOp).lval;
                    if (lval == 0L) break;
                    return new LongConstantExpression(this.pos, ((LongConstantExpression)leftOp).lval % lval);
                }
                case 16: {
                    float fval = ((FloatConstantExpression)rightOp).fval;
                    if (fval == 0.0f) break;
                    return new FloatConstantExpression(this.pos, ((FloatConstantExpression)leftOp).fval % fval);
                }
                case 32: {
                    double dval = ((DoubleConstantExpression)rightOp).dval;
                    if (dval == 0.0) break;
                    return new DoubleConstantExpression(this.pos, ((DoubleConstantExpression)leftOp).dval % dval);
                }
            }
        }
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.leftOperand.generateByteCode(byteCodeGenerator);
        this.rightOperand.generateByteCode(byteCodeGenerator);
        switch (this.getType().typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 4: {
                byteCodeGenerator.generate_8((byte)112);
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8((byte)113);
                byteCodeGenerator.decOpStackHeight(2);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8((byte)114);
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8((byte)115);
                byteCodeGenerator.decOpStackHeight(2);
            }
        }
    }

    public String toString() {
        return "%";
    }

    static {
        $assertionsDisabled = !ModuloExpression.class.desiredAssertionStatus();
    }
}

