/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.NumericBinaryExpression;

final class MinusExpression
extends NumericBinaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    MinusExpression(int pos, Expression leftOperand, Expression rightOperand) {
        super((byte)34, pos, leftOperand, rightOperand);
    }

    strictfp Expression foldExpression() {
        Expression leftOp = this.leftOperand;
        Expression rightOp = this.rightOperand;
        if (leftOp.kind == 2 && rightOp.kind == 2) {
            switch (leftOp.getType().typeClass) {
                case 4: {
                    return new IntConstantExpression(this.pos, this.getType(), ((ConstantExpression)leftOp).getIntConstValue() - ((ConstantExpression)rightOp).getIntConstValue());
                }
                case 8: {
                    return new LongConstantExpression(this.pos, ((LongConstantExpression)leftOp).lval - ((LongConstantExpression)rightOp).lval);
                }
                case 16: {
                    return new FloatConstantExpression(this.pos, ((FloatConstantExpression)leftOp).fval - ((FloatConstantExpression)rightOp).fval);
                }
                case 32: {
                    return new DoubleConstantExpression(this.pos, ((DoubleConstantExpression)leftOp).dval - ((DoubleConstantExpression)rightOp).dval);
                }
            }
        }
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.leftOperand.generateByteCode(byteCodeGenerator);
        this.rightOperand.generateByteCode(byteCodeGenerator);
        switch (this.getType().typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 4: {
                byteCodeGenerator.generate_8((byte)100);
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8((byte)101);
                byteCodeGenerator.decOpStackHeight(2);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8((byte)102);
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8((byte)103);
                byteCodeGenerator.decOpStackHeight(2);
            }
        }
    }

    public String toString() {
        return "-";
    }

    static {
        $assertionsDisabled = !MinusExpression.class.desiredAssertionStatus();
    }
}

