/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnaryExpression;

final class LogicalNotExpression
extends UnaryExpression {
    BitSet trueDefSet;
    BitSet falseDefSet;
    static final /* synthetic */ boolean $assertionsDisabled;

    LogicalNotExpression(int pos, Expression operand) {
        super((byte)45, pos, operand);
    }

    Expression foldExpression() {
        Expression op = this.operand;
        if (op.kind == 2) {
            return new BooleanConstantExpression(op.pos, !((BooleanConstantExpression)op).bval);
        }
        return this;
    }

    Expression resolveAndCheck(Parser parser) {
        Expression op = this.operand.resolveAndCheck(parser);
        TypeSymbol opType = op.getType();
        byte typeKind = opType.typeKind;
        if (typeKind != 2) {
            if (parser.parsingAtLeastOneFive && opType.equalTo(parser.javaLangBooleanSymbol)) {
                op = op.promoteType(parser, TypeSymbol.booleanSymbol);
            } else {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, opType.isErroneous(), this.toString(), opType.errorName());
                return new ErrorExpression(error);
            }
        }
        if (op.kind == 2) {
            return new BooleanConstantExpression(op.pos, !((BooleanConstantExpression)op).bval);
        }
        this.setType(TypeSymbol.booleanSymbol);
        if (op.isLogicalExpression()) {
            this.trueDefSet = op.getLogicalExpressionFalseDefSet();
            this.falseDefSet = op.getLogicalExpressionTrueDefSet();
        } else {
            this.trueDefSet = (BitSet)parser.defSet.clone();
            this.falseDefSet = (BitSet)parser.defSet.clone();
        }
        this.operand = op;
        return this;
    }

    boolean isConstantBooleanExpression() {
        return this.operand.isConstantBooleanExpression();
    }

    boolean getConstantBooleanExpressionValue() {
        if (!$assertionsDisabled && !this.isConstantBooleanExpression()) {
            throw new AssertionError();
        }
        return !this.operand.getConstantBooleanExpressionValue();
    }

    boolean isLogicalExpression() {
        return true;
    }

    BitSet getLogicalExpressionTrueDefSet() {
        return this.trueDefSet;
    }

    BitSet getLogicalExpressionFalseDefSet() {
        return this.falseDefSet;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.operand.generateByteCode(byteCodeGenerator);
        byteCodeGenerator.generate_8_8((byte)4, (byte)-126);
        byteCodeGenerator.incOpStackHeight(1);
        byteCodeGenerator.decOpStackHeight(1);
    }

    void generateByteCodeBranch(ByteCodeGenerator byteCodeGenerator, Label label, boolean branchIfFalse) {
        this.operand.generateByteCodeBranch(byteCodeGenerator, label, !branchIfFalse);
    }

    public String toString() {
        return "!";
    }

    static {
        $assertionsDisabled = !LogicalNotExpression.class.desiredAssertionStatus();
    }
}

