/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.EnhancedForStatement;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SymbolList;

final class LabeledStatement
extends Statement {
    SymbolList labelList;
    StatementList labeledStatements;
    LabelSymbol breakLabelSymbol;
    BitSet resultDefSet;
    BitSet resultPosSet;
    BitSet resultUseSet;

    LabeledStatement(StatementList parent, int pos, SymbolList labelList, StatementList labeledStatements) {
        super(parent, pos, (byte)8);
        this.labelList = labelList;
        this.labeledStatements = labeledStatements;
        labeledStatements.parent = this;
        SymbolList sl = labelList;
        while (sl != null) {
            LabelSymbol labelSymbol = (LabelSymbol)sl.symbol;
            labelSymbol.label = new Label();
            sl = sl.next;
        }
    }

    void resolveAndCheck(Parser parser) {
        this.labeledStatements.resolveAndCheck(parser);
        if (this.resultDefSet != null) {
            parser.defSet.and(this.resultDefSet);
        }
        if (this.resultPosSet != null) {
            parser.posSet.or(this.resultPosSet);
        }
        if (this.resultUseSet != null) {
            parser.useSet.or(this.resultUseSet);
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
    }

    boolean canReachNextStatement(boolean strict) {
        if (this.breakLabelSymbol != null) {
            return true;
        }
        return this.labeledStatements.canReachNextStatement(strict);
    }

    private boolean foundLabel(LabelSymbol labelSymbol) {
        SymbolList sl = this.labelList;
        while (sl != null) {
            if (sl.symbol == labelSymbol) {
                return true;
            }
            sl = sl.next;
        }
        return false;
    }

    void updateDefUseSetsAfterBreak(Parser parser, LabelSymbol labelSymbol) {
        if (!this.foundLabel(labelSymbol)) {
            this.parent.updateDefUseSetsAfterBreak(parser, labelSymbol);
        }
        if (this.resultDefSet == null) {
            this.resultDefSet = (BitSet)parser.defSet.clone();
        } else {
            this.resultDefSet.and(parser.defSet);
        }
        if (this.resultPosSet == null) {
            this.resultPosSet = (BitSet)parser.posSet.clone();
        } else {
            this.resultPosSet.or(parser.posSet);
        }
        if (this.resultUseSet == null) {
            this.resultUseSet = (BitSet)parser.useSet.clone();
        } else {
            this.resultUseSet.or(parser.useSet);
        }
    }

    void updateDefUseSetsAfterContinue(Parser parser, LabelSymbol labelSymbol) {
        if (!this.foundLabel(labelSymbol)) {
            this.parent.updateDefUseSetsAfterContinue(parser, labelSymbol);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (this.labeledStatements.first instanceof EnhancedForStatement) {
            EnhancedForStatement stmt = (EnhancedForStatement)this.labeledStatements.first;
            stmt.generateByteCodePrologue(byteCodeGenerator);
        }
        SymbolList sl = this.labelList;
        while (sl != null) {
            LabelSymbol labelSymbol = (LabelSymbol)sl.symbol;
            byteCodeGenerator.setLabel(labelSymbol.label);
            sl = sl.next;
        }
        this.labeledStatements.generateByteCode(byteCodeGenerator);
        if (this.breakLabelSymbol != null) {
            byteCodeGenerator.setLabel(this.breakLabelSymbol.label);
        }
    }
}

