/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Keyword;

final class KeywordTable {
    static final int KEYWORD_HASHTABLE_SIZE = 4096;
    Keyword[] keywordHashMap = new Keyword[4096];

    KeywordTable() {
        this.initializeKeywords();
    }

    private void initializeKeywords() {
        this.enterKeyword("abstract", (byte)18);
        this.enterKeyword("assert", (byte)17);
        this.enterKeyword("boolean", (byte)0);
        this.enterKeyword("break", (byte)19);
        this.enterKeyword("byte", (byte)1);
        this.enterKeyword("case", (byte)20);
        this.enterKeyword("catch", (byte)21);
        this.enterKeyword("char", (byte)2);
        this.enterKeyword("class", (byte)22);
        this.enterKeyword("const", (byte)23);
        this.enterKeyword("continue", (byte)24);
        this.enterKeyword("default", (byte)25);
        this.enterKeyword("do", (byte)26);
        this.enterKeyword("double", (byte)3);
        this.enterKeyword("else", (byte)27);
        this.enterKeyword("enum", (byte)28);
        this.enterKeyword("extends", (byte)29);
        this.enterKeyword("false", (byte)30);
        this.enterKeyword("final", (byte)31);
        this.enterKeyword("finally", (byte)32);
        this.enterKeyword("float", (byte)4);
        this.enterKeyword("for", (byte)33);
        this.enterKeyword("goto", (byte)34);
        this.enterKeyword("if", (byte)35);
        this.enterKeyword("implements", (byte)36);
        this.enterKeyword("import", (byte)37);
        this.enterKeyword("instanceof", (byte)38);
        this.enterKeyword("int", (byte)5);
        this.enterKeyword("interface", (byte)39);
        this.enterKeyword("long", (byte)6);
        this.enterKeyword("native", (byte)40);
        this.enterKeyword("new", (byte)41);
        this.enterKeyword("null", (byte)42);
        this.enterKeyword("package", (byte)43);
        this.enterKeyword("private", (byte)44);
        this.enterKeyword("protected", (byte)45);
        this.enterKeyword("public", (byte)46);
        this.enterKeyword("return", (byte)47);
        this.enterKeyword("short", (byte)7);
        this.enterKeyword("static", (byte)48);
        this.enterKeyword("strictfp", (byte)49);
        this.enterKeyword("super", (byte)50);
        this.enterKeyword("switch", (byte)51);
        this.enterKeyword("synchronized", (byte)52);
        this.enterKeyword("this", (byte)53);
        this.enterKeyword("throw", (byte)54);
        this.enterKeyword("throws", (byte)55);
        this.enterKeyword("transient", (byte)56);
        this.enterKeyword("true", (byte)57);
        this.enterKeyword("try", (byte)58);
        this.enterKeyword("void", (byte)8);
        this.enterKeyword("volatile", (byte)59);
        this.enterKeyword("while", (byte)60);
    }

    void enterKeyword(String name, byte tokenKind) {
        Keyword keyword = new Keyword(name, tokenKind);
        int hash = keyword.identifier.hashCode() & 0xFFF;
        keyword.next = this.keywordHashMap[hash];
        this.keywordHashMap[hash] = keyword;
    }

    byte lookupKeyword(Identifier identifier) {
        int hash = identifier.hashCode() & 0xFFF;
        Keyword keyword = this.keywordHashMap[hash];
        while (keyword != null) {
            if (identifier == keyword.identifier) {
                return keyword.tokenKind;
            }
            keyword = keyword.next;
        }
        return 10;
    }
}

