/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.ojc.compiler.AnonymousClassSymbol;
import oracle.ojc.compiler.ArgumentVariableList;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.ArrayExpression;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CastExpression;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ClassSymbolList;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionList;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.MemberExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodScope;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.NewExpression;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.SuperExpression;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.ThisExpression;
import oracle.ojc.compiler.TryStatement;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.TypeVariableSymbol;
import oracle.ojc.compiler.UnresolvedSymbol;

final class InvokeExpression
extends MemberExpression {
    public static final byte IM_INTERFACE = 0;
    public static final byte IM_SUPER = 1;
    public static final byte IM_CONSTRUCTOR = 2;
    public static final byte IM_VIRTUAL = 3;
    public static final byte IM_STATIC = 4;
    public static final byte IEF_NONE = 0;
    public static final byte IEF_THIS_CONSTR_CALL = 1;
    public static final byte IEF_SUPER_CONSTR_CALL = 2;
    public static final byte IEF_CONSTR_CALL = 3;
    public static final byte IEF_VARARG = 4;
    Symbol method;
    TypeVariableList typeArguments;
    ExpressionList arguments;
    byte flags;
    boolean resolvedArguments;
    int methodPos;
    static final /* synthetic */ boolean $assertionsDisabled;

    InvokeExpression(int pos, Symbol method, TypeVariableList typeArguments, Expression thisArgument, ExpressionList arguments) {
        super((byte)4, pos, thisArgument);
        this.method = method;
        this.typeArguments = typeArguments;
        this.arguments = arguments;
        this.methodPos = method.pos;
    }

    boolean takeAssignmentContext() {
        return true;
    }

    private static boolean isWideningReferenceConversion(Parser parser, TypeSymbol fromType, TypeSymbol toType, byte phase) {
        if (fromType == ReferenceTypeSymbol.nullTypeSymbol) {
            return true;
        }
        if (toType == parser.javaLangObjectPcs) {
            return true;
        }
        byte toTypeKind = toType.typeKind;
        byte fromTypeKind = fromType.typeKind;
        if (fromTypeKind == 10 && toTypeKind == 10) {
            ClassSymbol fromClass = (ClassSymbol)fromType.resolveType(parser, 0, false, true, false);
            ClassSymbol toClass = (ClassSymbol)toType.resolveType(parser, 0, false, true, false);
            if (toType.isTypeParameter() && fromType.containsTypeParameter((TypeParameterSymbol)toType)) {
                return false;
            }
            if (toClass.isInterface()) {
                return fromClass.implementsInterface(toClass);
            }
            return toClass.isSuperclass(fromClass);
        }
        if (fromTypeKind == 11 && toTypeKind == 10) {
            ClassSymbol toClass = (ClassSymbol)toType;
            if (toClass.isInterface()) {
                return parser.javaLangCloneableSymbol != null && toClass.equalTo(parser.javaLangCloneableSymbol) || parser.javaIoSerializableSymbol != null && toClass.equalTo(parser.javaIoSerializableSymbol);
            }
            if (toClass.isTypeParameter()) {
                return ((TypeParameterSymbol)toClass).bound.getClassSymbol() == parser.javaLangObjectSymbol;
            }
            return toClass.equalTo(parser.javaLangObjectSymbol);
        }
        if (fromTypeKind == 11 && toTypeKind == 11) {
            ArraySymbol fromArray = (ArraySymbol)fromType;
            ArraySymbol toArray = (ArraySymbol)toType;
            TypeSymbol fromBaseType = ArraySymbol.getArrayType(fromArray.baseType, fromArray.dimension - 1);
            TypeSymbol toBaseType = ArraySymbol.getArrayType(toArray.baseType, toArray.dimension - 1);
            if (fromBaseType.isPrimitiveType() || toBaseType.isPrimitiveType()) {
                return toBaseType == fromBaseType;
            }
            return InvokeExpression.isWideningReferenceConversion(parser, fromBaseType, toBaseType, phase);
        }
        return false;
    }

    private static boolean canConvertArgument(Parser parser, MethodSymbol methodSymbol, TypeSymbol fromType, TypeSymbol toType, byte phase) {
        TypeParameterSymbol tps;
        if (fromType.equalTo(toType)) {
            return true;
        }
        byte toTypeKind = toType.typeKind;
        byte fromTypeKind = fromType.typeKind;
        if (toType.isErroneous() || fromType.isErroneous()) {
            return true;
        }
        if (toType.isTypeVariable()) {
            return fromType == ReferenceTypeSymbol.nullTypeSymbol;
        }
        if (toType.isTypeParameter() && !(tps = (TypeParameterSymbol)toType).containsTypeParameterDefinedBy(methodSymbol)) {
            if (fromType == ReferenceTypeSymbol.nullTypeSymbol) {
                return true;
            }
            if (fromType.isTypeParameter()) {
                ClassSymbol boundSymbol = ((TypeParameterSymbol)fromType).bound;
                while (boundSymbol.isTypeParameter()) {
                    if (boundSymbol == toType) {
                        return true;
                    }
                    boundSymbol = ((TypeParameterSymbol)boundSymbol).bound;
                }
            }
            return false;
        }
        if (phase > 1) {
            if (fromType.isReferenceType() && toType.isPrimitiveType()) {
                TypeSymbol primitiveType = BoxingExpression.getPrimitiveType(parser, fromType);
                if (primitiveType != null) {
                    return InvokeExpression.canConvertArgument(parser, methodSymbol, primitiveType, toType, (byte)1);
                }
            } else if (BoxingExpression.isBoxableType(fromType) && toType.isReferenceType()) {
                ParameterizedClassSymbol boxedType = BoxingExpression.getBoxedType(parser, fromType);
                return InvokeExpression.canConvertArgument(parser, methodSymbol, boxedType, toType, (byte)1);
            }
        }
        switch (fromTypeKind) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 10: 
            case 11: {
                if (!toType.isReferenceType()) {
                    return false;
                }
                return InvokeExpression.isWideningReferenceConversion(parser, fromType, toType, phase);
            }
            case 1: 
            case 2: 
            case 9: {
                return false;
            }
            case 4: 
            case 5: {
                if ((toType.typeClass & 0x38) != 0) {
                    return true;
                }
                return toTypeKind == 6;
            }
            case 3: {
                if ((toType.typeClass & 0x38) != 0) {
                    return true;
                }
                return toTypeKind == 5 || toTypeKind == 6;
            }
            case 6: {
                return (toType.typeClass & 0x38) != 0;
            }
            case 7: {
                return (toType.typeClass & 0x30) != 0;
            }
            case 8: 
        }
        return toTypeKind == 9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int compareArguments(Parser parser, MethodSymbol methodSymbol, TypeSymbol formalType, TypeSymbol actualType, byte phase, boolean doClassTypeParameterConversion, boolean doMethodTypeParameterConversion) {
        boolean saveDoMethodTypeParameterConversion;
        boolean saveDoClassTypeParameterConversion;
        block16: {
            block17: {
                block13: {
                    block14: {
                        ClassSymbol actualClass;
                        ClassSymbol formalClass;
                        block15: {
                            block11: {
                                block12: {
                                    block10: {
                                        saveDoClassTypeParameterConversion = ClassSymbol.doClassTypeParameterConversion;
                                        saveDoMethodTypeParameterConversion = ClassSymbol.doMethodTypeParameterConversion;
                                        try {
                                            ClassSymbol.doClassTypeParameterConversion = false;
                                            ClassSymbol.doMethodTypeParameterConversion = false;
                                            if (!actualType.equalTo(formalType)) break block10;
                                            int n = 1;
                                            Object var15_17 = null;
                                            ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
                                            ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                            return n;
                                        }
                                        catch (Throwable throwable) {
                                            Object var15_26 = null;
                                            ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
                                            ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                            throw throwable;
                                        }
                                    }
                                    ClassSymbol.doClassTypeParameterConversion = doClassTypeParameterConversion;
                                    ClassSymbol.doMethodTypeParameterConversion = doMethodTypeParameterConversion;
                                    if (!actualType.equalTo(formalType)) break block11;
                                    if (!formalType.isTypeParameter()) break block12;
                                    int n = -1;
                                    Object var15_18 = null;
                                    ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
                                    ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                    return n;
                                }
                                int n = 1;
                                Object var15_19 = null;
                                ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
                                ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                return n;
                            }
                            if (!actualType.isClass() || !formalType.isClass()) break block13;
                            formalClass = (ClassSymbol)formalType;
                            actualClass = (ClassSymbol)actualType;
                            if (!formalClass.isInterface() || !actualClass.implementsInterfaceDirectly(formalClass)) break block13;
                            actualClass = actualClass.getDirectInterfaceImplementation(formalClass);
                            if (!formalClass.isParameterizedClass() || !actualClass.isParameterizedClass()) break block14;
                            ParameterizedClassSymbol formalPcs = (ParameterizedClassSymbol)formalClass;
                            ParameterizedClassSymbol actualPcs = (ParameterizedClassSymbol)actualClass;
                            if (formalPcs.typeVariableList == null || actualPcs.typeVariableList == null || actualPcs.typeVariableList.equals(formalPcs.typeVariableList)) break block15;
                            int n = 0;
                            Object var15_20 = null;
                            ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
                            ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                            return n;
                        }
                        if (!actualClass.isErasedType() || formalClass.isErasedType()) break block14;
                        int n = -1;
                        Object var15_21 = null;
                        ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
                        ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                        return n;
                    }
                    int n = 1;
                    Object var15_22 = null;
                    ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
                    ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                    return n;
                }
                formalType.resolveType(parser, 0, false, true, false);
                actualType.resolveType(parser, 0, false, true, false);
                if (!InvokeExpression.canConvertArgument(parser, methodSymbol, actualType, formalType, phase)) break block16;
                if (actualType.isNumericType() && (phase <= 1 || (!actualType.isPrimitiveType() || !formalType.isReferenceType()) && (!actualType.isReferenceType() || !formalType.isPrimitiveType()))) break block17;
                int n = -1;
                Object var15_23 = null;
                ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
                ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                return n;
            }
            int n = 1;
            Object var15_24 = null;
            ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
            ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
            return n;
        }
        Object var15_25 = null;
        ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
        ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
        return 0;
    }

    private static TypeVariableSymbol computeLeastContainingTypeArgument(Parser parser, TypeVariableSymbol tvs1, TypeVariableSymbol tvs2) {
        int typeVariableKind;
        ReferenceTypeSymbol refSymbol;
        ClassSymbol refSymbol2;
        ClassSymbol refSymbol1 = (ClassSymbol)tvs1.refSymbol;
        if (refSymbol1 == null) {
            refSymbol1 = parser.javaLangObjectPcs;
        }
        if ((refSymbol2 = (ClassSymbol)tvs2.refSymbol) == null) {
            refSymbol2 = parser.javaLangObjectPcs;
        }
        switch (tvs1.typeVariableKind << 8 | tvs2.typeVariableKind) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 257: {
                if (refSymbol1 == refSymbol2) {
                    return tvs1;
                }
            }
            case 0: 
            case 1: 
            case 2: 
            case 256: 
            case 258: 
            case 512: 
            case 513: 
            case 514: {
                refSymbol = InvokeExpression.computeLeastUpperBound(parser, refSymbol1, refSymbol2);
                typeVariableKind = 2;
                break;
            }
            case 259: 
            case 769: 
            case 771: {
                TypeSymbol[] classArray = new ClassSymbol[]{refSymbol1, refSymbol2};
                refSymbol = InvokeExpression.computeInterSectionType(parser, classArray);
                typeVariableKind = 3;
                break;
            }
            case 3: 
            case 515: 
            case 768: 
            case 770: {
                if (refSymbol1 == refSymbol2) {
                    return tvs1;
                }
                refSymbol = parser.javaLangObjectPcs;
                typeVariableKind = 2;
            }
        }
        if (refSymbol == null) {
            return null;
        }
        return new TypeVariableSymbol(0, (byte)typeVariableKind, refSymbol);
    }

    private static ClassSymbol computeLeastContainingInvocation(Parser parser, ClassSymbol classSymbol1, ClassSymbol classSymbol2) {
        if (classSymbol1.isTypeParameter() || classSymbol2.isTypeParameter()) {
            return null;
        }
        ParameterizedClassSymbol pcs1 = (ParameterizedClassSymbol)classSymbol1;
        TypeVariableList tvl1 = pcs1.typeVariableList;
        if (tvl1 == null) {
            return pcs1;
        }
        ParameterizedClassSymbol pcs2 = (ParameterizedClassSymbol)classSymbol2;
        TypeVariableList tvl2 = pcs2.typeVariableList;
        if (tvl2 == null) {
            return pcs2;
        }
        TypeVariableList tvlLast = null;
        TypeVariableList tvlList = null;
        while (tvl1 != null) {
            TypeVariableSymbol tvs = InvokeExpression.computeLeastContainingTypeArgument(parser, tvl1.typeVariable, tvl2.typeVariable);
            if (tvs == null) {
                return null;
            }
            TypeVariableList tvl = new TypeVariableList(tvs);
            if (tvlList == null) {
                tvlList = tvlLast = tvl;
            } else {
                tvlLast.next = tvl;
                tvlLast = tvl;
            }
            tvl1 = tvl1.next;
            tvl2 = tvl2.next;
        }
        return ParameterizedClassSymbol.getParameterizedClassSymbol(pcs1.genericClassSymbol, tvlList, null);
    }

    private static ReferenceTypeSymbol computeLeastUpperBound(Parser parser, Set superTypeSet, Set erasedCandidateSet) {
        ClassSymbol classSymbol2;
        ClassSymbol classSymbol1;
        int i;
        int size;
        int count = size = erasedCandidateSet.size();
        if (size == 0) {
            return null;
        }
        ClassSymbol[] erasedCandidateArray = erasedCandidateSet.toArray(new ClassSymbol[size]);
        for (i = 0; i < size; ++i) {
            classSymbol1 = erasedCandidateArray[i];
            if (classSymbol1 == null) continue;
            for (int j = 0; j < size; ++j) {
                if (i == j || (classSymbol2 = erasedCandidateArray[j]) == null) continue;
                if (classSymbol2.isInterface()) {
                    if (!classSymbol1.implementsInterface(classSymbol2)) continue;
                    erasedCandidateArray[j] = null;
                    --count;
                    continue;
                }
                if (!classSymbol2.isSuperclass(classSymbol1)) continue;
                erasedCandidateArray[j] = null;
                --count;
            }
        }
        HashSet<ClassSymbol> minimalErasedCandidateSet = new HashSet<ClassSymbol>(count);
        for (i = 0; i < size; ++i) {
            classSymbol1 = erasedCandidateArray[i];
            if (classSymbol1 == null) continue;
            minimalErasedCandidateSet.add(classSymbol1);
        }
        ArrayList<ClassSymbol> candidateSet = new ArrayList<ClassSymbol>();
        Iterator mecIterator = minimalErasedCandidateSet.iterator();
        while (mecIterator.hasNext()) {
            RawClassSymbol rcs = (RawClassSymbol)mecIterator.next();
            Iterator stIterator = superTypeSet.iterator();
            ArrayList<ClassSymbol> invocationSet = new ArrayList<ClassSymbol>();
            while (stIterator.hasNext()) {
                classSymbol1 = (ClassSymbol)stIterator.next();
                if (classSymbol1.getClassSymbol() != rcs) continue;
                invocationSet.add(classSymbol1);
            }
            classSymbol1 = (ClassSymbol)invocationSet.get(0);
            size = invocationSet.size();
            for (i = 1; i < size; ++i) {
                classSymbol2 = (ClassSymbol)invocationSet.get(i);
                if ((classSymbol1 = InvokeExpression.computeLeastContainingInvocation(parser, classSymbol1, classSymbol2)) != null) continue;
                return null;
            }
            candidateSet.add(classSymbol1);
        }
        return InvokeExpression.computeInterSectionType(parser, candidateSet.toArray(new TypeSymbol[candidateSet.size()]));
    }

    private static Set intersect(Set set1, Set set2) {
        HashSet resultSet = new HashSet();
        Iterator iterator = set1.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (!set2.contains(element)) continue;
            resultSet.add(element);
        }
        return resultSet;
    }

    static ReferenceTypeSymbol computeLeastUpperBound(Parser parser, ClassSymbol classSymbol1, ClassSymbol classSymbol2) {
        HashSet<ClassSymbol> superTypeSet = new HashSet<ClassSymbol>();
        superTypeSet.add(classSymbol1);
        classSymbol1.getSuperTypes(superTypeSet);
        superTypeSet.add(classSymbol2);
        classSymbol2.getSuperTypes(superTypeSet);
        HashSet<RawClassSymbol> erasedSuperTypeSet1 = new HashSet<RawClassSymbol>();
        erasedSuperTypeSet1.add(classSymbol1.getClassSymbol());
        classSymbol1.getErasedSuperclasses(erasedSuperTypeSet1);
        HashSet<RawClassSymbol> erasedSuperTypeSet2 = new HashSet<RawClassSymbol>();
        erasedSuperTypeSet2.add(classSymbol2.getClassSymbol());
        classSymbol2.getErasedSuperclasses(erasedSuperTypeSet2);
        Set erasedCandidateSet = InvokeExpression.intersect(erasedSuperTypeSet1, erasedSuperTypeSet2);
        return InvokeExpression.computeLeastUpperBound(parser, superTypeSet, erasedCandidateSet);
    }

    private static ReferenceTypeSymbol computeInterSectionType(Parser parser, TypeSymbol[] typeArray) {
        ClassSymbol leastSuperClass;
        TypeSymbol leastSuperType = null;
        ImplementationList interfaces = null;
        ArrayList<TypeSymbol> typeParameterList = new ArrayList<TypeSymbol>();
        for (int i = 0; i < typeArray.length; ++i) {
            ImplementationList impl;
            TypeSymbol typeSymbol = typeArray[i];
            if (typeSymbol.isTypeParameter()) {
                typeParameterList.add(typeSymbol);
                ClassSymbolList csl = ((TypeParameterSymbol)typeSymbol).interfaceBounds;
                while (csl != null) {
                    impl = new ImplementationList(csl.classSymbol);
                    impl.next = interfaces;
                    interfaces = impl;
                    csl = csl.next;
                }
                continue;
            }
            if (typeSymbol.isInterface()) {
                impl = new ImplementationList((ClassSymbol)typeSymbol);
                impl.next = interfaces;
                interfaces = impl;
                continue;
            }
            if (typeSymbol == parser.javaLangObjectPcs) continue;
            if (leastSuperType == null) {
                leastSuperType = typeSymbol;
                continue;
            }
            if (leastSuperType == typeSymbol) continue;
            if (leastSuperType.isClass() && typeSymbol.isClass()) {
                leastSuperClass = (ClassSymbol)leastSuperType;
                ClassSymbol typeClass = (ClassSymbol)typeSymbol;
                if (leastSuperClass.isSuperclass(typeClass)) {
                    leastSuperType = typeSymbol;
                    continue;
                }
                if (typeClass.isSuperclass(leastSuperClass)) continue;
                leastSuperType = (ClassSymbol)InvokeExpression.findCommonSuperclass(parser, leastSuperType, typeSymbol);
                continue;
            }
            leastSuperType = parser.javaLangObjectPcs;
        }
        if (leastSuperType == null) {
            if (interfaces == null && typeParameterList.size() == 1) {
                return (ClassSymbol)typeParameterList.get(0);
            }
            if (interfaces != null && typeParameterList.size() == 0 && interfaces.next == null) {
                return interfaces.interfaceSymbol;
            }
            leastSuperType = parser.javaLangObjectPcs;
        } else {
            if (interfaces == null && typeParameterList.size() == 0) {
                if (leastSuperType.isReferenceType()) {
                    return (ReferenceTypeSymbol)leastSuperType;
                }
                return parser.javaLangObjectPcs;
            }
            if (!leastSuperType.isClass()) {
                return parser.javaLangObjectPcs;
            }
        }
        leastSuperClass = (ClassSymbol)leastSuperType;
        if (interfaces == null) {
            return leastSuperClass;
        }
        if (typeParameterList.size() == 0) {
            ClassSymbol interfaceSymbol = interfaces.interfaceSymbol;
            ImplementationList walkInterfaces = interfaces.next;
            while (walkInterfaces != null) {
                interfaceSymbol = (ClassSymbol)InvokeExpression.findCommonSuperInterface(parser, interfaceSymbol, walkInterfaces.interfaceSymbol);
                walkInterfaces = walkInterfaces.next;
            }
            if (parser.javaLangObjectPcs.equalTo(leastSuperClass)) {
                return interfaceSymbol;
            }
            if (leastSuperClass.equalTo(interfaceSymbol) || leastSuperClass.implementsInterface(interfaceSymbol)) {
                return leastSuperClass;
            }
        }
        return parser.javaLangObjectPcs;
    }

    private boolean inferTypeParametersFromInitialConstraints(Parser parser, MethodSymbol methodSymbol, TypeVariableList typeVariableList, InitialConstraint initialConstraintSet, boolean useSubTypes) {
        ReferenceTypeSymbol referenceTypeSymbol;
        EqualityConstraint equalityConstraintSet = new EqualityConstraintAnchor();
        InitialConstraint ic = initialConstraintSet;
        while (ic != null) {
            EqualityConstraint ec = ic.getImpliedEqualityConstraint(parser);
            if (ec != null) {
                EqualityConstraint ecn = ec;
                while (ecn.next != null) {
                    ecn = ecn.next;
                }
                ecn.next = equalityConstraintSet;
                equalityConstraintSet = ec;
            }
            ic = ic.next;
        }
        boolean done = true;
        TypeParameterList tpl = methodSymbol.typeParameterList;
        TypeVariableList tvl = typeVariableList;
        while (tpl != null) {
            TypeSymbol typeSymbol = equalityConstraintSet.findResolvedTypeParameter(tpl.typeParameter, null);
            if (typeSymbol == null) {
                if (tvl.typeVariable.refSymbol == null) {
                    done = false;
                }
            } else {
                tvl.typeVariable.refSymbol = typeSymbol;
                equalityConstraintSet.applyType(tpl.typeParameter, tvl.typeVariable);
            }
            tpl = tpl.next;
            tvl = tvl.next;
        }
        if (done) {
            return true;
        }
        done = true;
        tpl = methodSymbol.typeParameterList;
        tvl = typeVariableList;
        while (tpl != null) {
            if (tvl.typeVariable.refSymbol == null) {
                HashSet superTypeSet = new HashSet();
                equalityConstraintSet.computeSuperTypeSets(superTypeSet, tpl.typeParameter);
                HashSet erasedCandidateSet = new HashSet();
                equalityConstraintSet.computeErasedCanditiateSet(erasedCandidateSet, tpl.typeParameter);
                referenceTypeSymbol = InvokeExpression.computeLeastUpperBound(parser, superTypeSet, erasedCandidateSet);
                if (referenceTypeSymbol == null) {
                    done = false;
                } else {
                    tvl.typeVariable.refSymbol = referenceTypeSymbol;
                    tvl.typeVariable.typeVariableKind = 1;
                }
            }
            tpl = tpl.next;
            tvl = tvl.next;
        }
        if (done) {
            return true;
        }
        if (useSubTypes) {
            done = true;
            tpl = methodSymbol.typeParameterList;
            tvl = typeVariableList;
            while (tpl != null) {
                if (tvl.typeVariable.refSymbol == null) {
                    int size;
                    HashSet typeIntersectionSet = new HashSet();
                    equalityConstraintSet.getTypeIntersectionSet(typeIntersectionSet, tpl.typeParameter);
                    int count = size = typeIntersectionSet.size();
                    if (size == 0) {
                        done = false;
                    } else {
                        referenceTypeSymbol = InvokeExpression.computeInterSectionType(parser, typeIntersectionSet.toArray(new TypeSymbol[size]));
                        if (referenceTypeSymbol == null) {
                            done = false;
                        } else {
                            tvl.typeVariable.refSymbol = referenceTypeSymbol;
                            tvl.typeVariable.typeVariableKind = 1;
                        }
                    }
                }
                tpl = tpl.next;
                tvl = tvl.next;
            }
        }
        return done;
    }

    private TypeVariableList inferTypeParameters(Parser parser, MethodSymbol methodSymbol, ParameterizedClassSymbol definingClass, ExpressionList arguments, TypeSymbol assignmentContext, byte phase) {
        TypeVariableList tvl;
        InitialConstraint ic;
        InitialConstraint initialConstraintSet = null;
        TypeSymbol lastFormalArgType = null;
        ArgumentVariableList formalArgumentList = methodSymbol.argumentList;
        while (formalArgumentList != null) {
            TypeSymbol actualArgType;
            boolean skipArgument = false;
            ArgumentVariableSymbol argSymbol = formalArgumentList.argSymbol;
            TypeSymbol formalArgType = argSymbol.type;
            if (!formalArgType.isReferenceType()) {
                skipArgument = true;
            } else if (!(formalArgType = this.applyTypeParameters(formalArgType, definingClass, methodSymbol)).containsTypeParameterDefinedBy(methodSymbol)) {
                skipArgument = true;
            }
            if (phase == 3 && (methodSymbol.access & 0x80) != 0 && formalArgumentList.next == null) {
                if (arguments == null) break;
                if (lastFormalArgType != null) {
                    formalArgType = lastFormalArgType;
                } else {
                    ArraySymbol arraySymbol = (ArraySymbol)formalArgType;
                    lastFormalArgType = formalArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                }
            }
            if (!skipArgument && (actualArgType = arguments.expr.getType()) != ReferenceTypeSymbol.nullTypeSymbol) {
                block0 : switch (InvokeExpression.compareArguments(parser, methodSymbol, formalArgType, actualArgType, phase, true, true)) {
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    case -1: {
                        ic = new InitialConstraintActualConvertsIntoFormal(methodSymbol, formalArgType, actualArgType);
                        break;
                    }
                    case 1: {
                        ic = new InitialConstraintActualEqualsFormal(methodSymbol, formalArgType, actualArgType);
                        break;
                    }
                    case 0: {
                        switch (InvokeExpression.compareArguments(parser, methodSymbol, actualArgType, formalArgType, phase, true, true)) {
                            default: {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                            }
                            case 1: {
                                return null;
                            }
                            case -1: {
                                ic = new InitialConstraintFormalConvertsIntoActual(methodSymbol, formalArgType, actualArgType);
                                break block0;
                            }
                            case 0: 
                        }
                        return null;
                    }
                }
                ic.next = initialConstraintSet;
                initialConstraintSet = ic;
            }
            formalArgumentList = lastFormalArgType == null ? formalArgumentList.next : formalArgumentList;
            arguments = arguments.next;
        }
        TypeVariableList typeVariableLast = null;
        TypeVariableList typeVariableList = null;
        TypeParameterList tpl = methodSymbol.typeParameterList;
        while (tpl != null) {
            TypeVariableSymbol tvs = new TypeVariableSymbol(0, 1, null);
            tvl = new TypeVariableList(tvs);
            if (typeVariableList == null) {
                typeVariableList = typeVariableLast = tvl;
            } else {
                typeVariableLast.next = tvl;
                typeVariableLast = tvl;
            }
            tpl = tpl.next;
        }
        if (this.inferTypeParametersFromInitialConstraints(parser, methodSymbol, typeVariableList, initialConstraintSet, false)) {
            return typeVariableList;
        }
        initialConstraintSet = null;
        TypeSymbol typeSymbol = methodSymbol.resultType;
        if (typeSymbol.isReferenceType() && (typeSymbol = this.applyTypeParameters(typeSymbol, definingClass, methodSymbol)).containsTypeParameterDefinedBy(methodSymbol)) {
            tpl = methodSymbol.typeParameterList;
            tvl = typeVariableList;
            while (tpl != null) {
                if (tvl.typeVariable.refSymbol != null) {
                    typeSymbol = typeSymbol.applyTypeVariable(tpl.typeParameter, tvl.typeVariable);
                }
                tpl = tpl.next;
                tvl = tvl.next;
            }
            if (typeSymbol.containsTypeParameterDefinedBy(methodSymbol)) {
                if (assignmentContext == null) {
                    assignmentContext = parser.javaLangObjectPcs;
                }
                initialConstraintSet = new InitialConstraintFormalConvertsIntoActual(methodSymbol, typeSymbol, assignmentContext);
            }
        }
        tpl = methodSymbol.typeParameterList;
        tvl = typeVariableList;
        while (tpl != null) {
            if (tvl.typeVariable.refSymbol == null) {
                TypeSymbol bound = tpl.typeParameter.bound.applyTypeVariables(methodSymbol.typeParameterList, typeVariableList);
                ic = new InitialConstraintFormalConvertsIntoActual(methodSymbol, tpl.typeParameter, bound);
                if (initialConstraintSet != null) {
                    ic.next = initialConstraintSet;
                    initialConstraintSet = ic;
                } else {
                    initialConstraintSet = ic;
                }
            }
            if (tvl.typeVariable.refSymbol != null) {
                TypeParameterList tpl2 = methodSymbol.typeParameterList;
                TypeVariableList tvl2 = typeVariableList;
                while (tpl2 != null) {
                    if (tvl2.typeVariable.refSymbol == null) {
                        ClassSymbol tplBound = tpl.typeParameter.bound;
                        while (tplBound.isTypeParameter()) {
                            if (tplBound == tpl2.typeParameter) {
                                ic = new InitialConstraintActualConvertsIntoFormal(methodSymbol, tpl2.typeParameter, tvl.typeVariable.refSymbol);
                                if (initialConstraintSet != null) {
                                    ic.next = initialConstraintSet;
                                    initialConstraintSet = ic;
                                    break;
                                }
                                initialConstraintSet = ic;
                                break;
                            }
                            tplBound = ((TypeParameterSymbol)tplBound).bound;
                        }
                        ClassSymbol tpl2Bound = tpl2.typeParameter.bound;
                        while (tpl2Bound.isTypeParameter()) {
                            if (tpl2Bound == tpl.typeParameter) {
                                ic = new InitialConstraintFormalConvertsIntoActual(methodSymbol, tpl2.typeParameter, tvl.typeVariable.refSymbol);
                                if (initialConstraintSet != null) {
                                    ic.next = initialConstraintSet;
                                    initialConstraintSet = ic;
                                    break;
                                }
                                initialConstraintSet = ic;
                                break;
                            }
                            tpl2Bound = ((TypeParameterSymbol)tpl2Bound).bound;
                        }
                    }
                    tpl2 = tpl2.next;
                    tvl2 = tvl2.next;
                }
            }
            tpl = tpl.next;
            tvl = tvl.next;
        }
        if (this.inferTypeParametersFromInitialConstraints(parser, methodSymbol, typeVariableList, initialConstraintSet, true)) {
            return typeVariableList;
        }
        tvl = typeVariableList;
        while (tvl != null) {
            if (tvl.typeVariable.refSymbol == null) {
                tvl.typeVariable.refSymbol = parser.javaLangObjectPcs;
            }
            tvl = tvl.next;
        }
        return typeVariableList;
    }

    private static boolean compareTypeParameters(Parser parser, TypeParameterList tpl, TypeVariableList tvl) {
        while (tpl != null && tvl != null) {
            if (tvl.typeVariable.typeVariableKind == 0) {
                return false;
            }
            if (!(tvl.typeVariable.refSymbol.equalTo(tpl.typeParameter) || tpl.typeParameter.equalTo(parser.javaLangObjectPcs) && (tvl.typeVariable.refSymbol.isArrayType() || tvl.typeVariable.refSymbol.isTypeParameter()))) {
                return false;
            }
            tpl = tpl.next;
            tvl = tvl.next;
        }
        return tpl == null && tvl == null;
    }

    private TypeSymbol applyTypeParameters(TypeSymbol typeSymbol, ParameterizedClassSymbol definingClass, MethodSymbol methodSymbol) {
        if (typeSymbol.isArrayType()) {
            ArraySymbol typeArray = (ArraySymbol)typeSymbol;
            TypeSymbol newType = this.applyTypeParameters(typeArray.baseType, definingClass, methodSymbol);
            if (newType != typeArray.baseType) {
                return ArraySymbol.getArrayType(newType, typeArray.dimension);
            }
            return typeArray;
        }
        TypeSymbol orgTypeSymbol = typeSymbol;
        if (typeSymbol.containsTypeParameterDefinedBy(null)) {
            if (methodSymbol.typeParameterList != null) {
                typeSymbol = typeSymbol.applyTypeVariables(methodSymbol.typeParameterList, this.typeArguments);
            }
            if (definingClass != null && definingClass.typeVariableList != null) {
                typeSymbol = typeSymbol.applyTypeVariables(definingClass.genericClassSymbol.cd.getTypeParameterList(), definingClass.typeVariableList);
            }
        }
        if (typeSymbol == orgTypeSymbol && typeSymbol.isTypeParameter()) {
            TypeSymbol newBound;
            TypeParameterSymbol tps = (TypeParameterSymbol)typeSymbol;
            if (tps.bound != null && (newBound = this.applyTypeParameters(tps.bound, definingClass, methodSymbol)) != tps.bound) {
                TypeParameterSymbol newTps = new TypeParameterSymbol(tps.pos, tps.identifier, (ClassSymbol)newBound, tps.boundPos, tps.interfaceBounds);
                newTps.definingSymbol = tps.definingSymbol;
                typeSymbol = newTps;
            }
        }
        if (definingClass != null && definingClass.isErasedType()) {
            typeSymbol = typeSymbol.eraseType();
        }
        return typeSymbol;
    }

    private MethodMatchRecord findMatchingMethods(MethodMatchRecord methodMatchList, Parser parser, RawClassSymbol classSymbol, MethodSymbol[] methodTable, int actualArgCount, ExpressionList arguments, TypeSymbol assignmentContext, byte phase) {
        if (methodTable == null) {
            return methodMatchList;
        }
        boolean considerOuterClasses = true;
        Identifier identifier = this.method.identifier;
        for (int i = 0; i < methodTable.length; ++i) {
            boolean isVarArgMethod;
            MethodSymbol methodSymbol = methodTable[i];
            if (methodSymbol.identifier != identifier || methodSymbol.isBridgeMethod() || this.typeArguments != null && methodSymbol.typeParameterList == null) continue;
            considerOuterClasses = false;
            boolean usedErasedMethod = false;
            boolean bl = isVarArgMethod = (methodSymbol.access & 0x80) != 0;
            if (methodSymbol.argCount != actualArgCount && (phase != 3 || !isVarArgMethod || methodSymbol.argCount - 1 > actualArgCount)) continue;
            ParameterizedClassSymbol definingClass = null;
            if (methodSymbol.definingClass.cd.getTypeParameterList() != null) {
                ArrayList<TypeSymbol> definingClasses = new ArrayList<TypeSymbol>();
                if (this.thisArgument != null) {
                    TypeSymbol typeSymbol = this.thisArgument.getType();
                    if (typeSymbol.isParameterizedClass()) {
                        definingClasses.add(typeSymbol);
                    } else if (typeSymbol.isTypeParameter()) {
                        TypeParameterSymbol tps = (TypeParameterSymbol)typeSymbol;
                        definingClasses.add(tps.bound);
                        ClassSymbolList csl = tps.interfaceBounds;
                        while (csl != null) {
                            definingClasses.add(csl.classSymbol);
                            csl = csl.next;
                        }
                    } else {
                        definingClasses.add(ParameterizedClassSymbol.getParameterizedClassSymbol((RawClassSymbol)typeSymbol, null, null));
                    }
                } else {
                    definingClasses.add(ParameterizedClassSymbol.getParameterizedClassSymbol(classSymbol, TypeVariableList.newTypeVariableList(classSymbol.cd.getTypeParameterList()), null));
                }
                definingClass = InvokeExpression.getParameterizedSuperType(definingClasses, methodSymbol.definingClass);
            }
            TypeVariableList typeArgumentList = null;
            if (methodSymbol.typeParameterList != null) {
                if (definingClass != null && definingClass.genericClassSymbol.isGenericType() && definingClass.typeVariableList == null) {
                    usedErasedMethod = true;
                }
                if (!usedErasedMethod && this.erasedArgumentsForGenericParameters(methodSymbol, definingClass, arguments, isVarArgMethod, phase)) {
                    usedErasedMethod = true;
                }
                if (!usedErasedMethod && ((typeArgumentList = this.typeArguments) == null && (typeArgumentList = this.inferTypeParameters(parser, methodSymbol, definingClass, arguments, assignmentContext, phase)) == null || !InvokeExpression.compareTypeParameters(parser, methodSymbol.typeParameterList, typeArgumentList))) continue;
            }
            int conversions = 0;
            ExpressionList actualArgument = arguments;
            ArgumentVariableList formalArgumentList = methodSymbol.argumentList;
            block12: while (formalArgumentList != null) {
                TypeSymbol actualArgType;
                Expression argExpr;
                TypeSymbol formalArgType;
                ArgumentVariableSymbol argSymbol;
                if (phase == 3 && isVarArgMethod && formalArgumentList.next == null) {
                    argSymbol = formalArgumentList.argSymbol;
                    ArraySymbol arraySymbol = (ArraySymbol)argSymbol.type;
                    formalArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                    formalArgType = this.applyTypeParameters(formalArgType, definingClass, methodSymbol);
                    while (actualArgument != null) {
                        argExpr = actualArgument.expr;
                        actualArgType = argExpr.getType();
                        boolean doMethodTypeParameterConversion = formalArgType.containsTypeParameterDefinedBy(methodSymbol);
                        switch (InvokeExpression.compareArguments(parser, methodSymbol, formalArgType, actualArgType, phase, false, doMethodTypeParameterConversion)) {
                            default: {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                            }
                            case -1: {
                                ++conversions;
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 0: {
                                break block12;
                            }
                        }
                        actualArgument = actualArgument.next;
                    }
                } else {
                    argSymbol = formalArgumentList.argSymbol;
                    formalArgType = this.applyTypeParameters(argSymbol.type, definingClass, methodSymbol);
                    argExpr = actualArgument.expr;
                    actualArgType = argExpr.getType();
                    boolean doMethodTypeParameterConversion = formalArgType.containsTypeParameterDefinedBy(methodSymbol);
                    switch (InvokeExpression.compareArguments(parser, methodSymbol, formalArgType, actualArgType, phase, false, doMethodTypeParameterConversion)) {
                        default: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                        }
                        case -1: {
                            ++conversions;
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 0: {
                            break block12;
                        }
                    }
                    actualArgument = actualArgument.next;
                }
                formalArgumentList = formalArgumentList.next;
            }
            if (formalArgumentList != null) continue;
            MethodMatchRecord mmr = new MethodMatchRecord(definingClass, methodSymbol, typeArgumentList, conversions, usedErasedMethod);
            mmr.next = methodMatchList;
            methodMatchList = mmr;
        }
        if (considerOuterClasses && methodMatchList == null && classSymbol.isInnerClass() && identifier != Identifier.initializerIdentifier) {
            classSymbol = ((InnerClassSymbol)classSymbol).getOuterClass();
            methodTable = classSymbol.getMethodTable(parser);
            methodMatchList = this.findMatchingMethods(methodMatchList, parser, classSymbol, methodTable, actualArgCount, arguments, assignmentContext, phase);
        }
        return methodMatchList;
    }

    boolean erasedArgumentsForGenericParameters(MethodSymbol methodSymbol, ParameterizedClassSymbol definingClass, ExpressionList arguments, boolean isVarArgMethod, int phase) {
        ExpressionList actualArgument = arguments;
        ArgumentVariableList formalArgumentList = methodSymbol.argumentList;
        while (formalArgumentList != null) {
            TypeSymbol actualArgType;
            Expression argExpr;
            TypeSymbol formalArgType;
            ArgumentVariableSymbol argSymbol;
            if (phase == 3 && isVarArgMethod && formalArgumentList.next == null) {
                argSymbol = formalArgumentList.argSymbol;
                ArraySymbol arraySymbol = (ArraySymbol)argSymbol.type;
                formalArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                formalArgType = this.applyTypeParameters(formalArgType, definingClass, methodSymbol);
                while (actualArgument != null) {
                    argExpr = actualArgument.expr;
                    actualArgType = argExpr.getType();
                    if (argSymbol.type.containsTypeParameterDefinedBy(methodSymbol) && actualArgType.isParameterizedClass() && actualArgType.isErasedType() && formalArgType.isParameterizedClass() && !formalArgType.isErasedType()) {
                        return true;
                    }
                    actualArgument = actualArgument.next;
                }
            } else {
                argSymbol = formalArgumentList.argSymbol;
                formalArgType = this.applyTypeParameters(argSymbol.type, definingClass, methodSymbol);
                argExpr = actualArgument.expr;
                actualArgType = argExpr.getType();
                if (argSymbol.type.containsTypeParameterDefinedBy(methodSymbol) && actualArgType.isParameterizedClass() && actualArgType.isErasedType() && formalArgType.isParameterizedClass() && !formalArgType.isErasedType()) {
                    return true;
                }
                actualArgument = actualArgument.next;
            }
            formalArgumentList = formalArgumentList.next;
        }
        return false;
    }

    private static int compareTypes(Parser parser, TypeSymbol actual, TypeSymbol best, TypeSymbol challenger) {
        if (actual.isTypeParameter()) {
            actual = ((TypeParameterSymbol)actual).bound;
        }
        if (best.isTypeParameter()) {
            best = ((TypeParameterSymbol)best).bound;
        }
        if (challenger.isTypeParameter()) {
            challenger = ((TypeParameterSymbol)challenger).bound;
        }
        if (best.equalTo(challenger) || challenger.equalTo(best)) {
            return 0;
        }
        if (actual.equalTo(challenger)) {
            return 1;
        }
        if (parser.parsingAtLeastOneFive && BoxingExpression.isBoxableType(actual) && BoxingExpression.getBoxedType(parser, actual).equalTo(challenger)) {
            return 1;
        }
        if (actual.isNumericType() || challenger.isNumericType() && best.isNumericType()) {
            if (TypeSymbol.isWider(challenger.typeKind, best.typeKind)) {
                return -1;
            }
            if (TypeSymbol.isWider(best.typeKind, challenger.typeKind)) {
                return 1;
            }
            return 0;
        }
        if (challenger.isArrayType() || best.isArrayType()) {
            if (challenger.isArrayType() && best.isArrayType()) {
                ArraySymbol challengerArray = (ArraySymbol)challenger;
                ArraySymbol bestArray = (ArraySymbol)best;
                if (actual.isArrayType()) {
                    actual = ((ArraySymbol)actual).baseType;
                }
                return InvokeExpression.compareTypes(parser, actual, bestArray.baseType, challengerArray.baseType);
            }
            if (challenger.isArrayType()) {
                if (parser.javaLangCloneableSymbol != null && best.equalTo(parser.javaLangCloneableSymbol) || parser.javaIoSerializableSymbol != null && best.equalTo(parser.javaIoSerializableSymbol) || best.equalTo(parser.javaLangObjectSymbol)) {
                    return 1;
                }
                return 0;
            }
            if (parser.javaLangCloneableSymbol != null && challenger.equalTo(parser.javaLangCloneableSymbol) || parser.javaIoSerializableSymbol != null && challenger.equalTo(parser.javaIoSerializableSymbol) || challenger.equalTo(parser.javaLangObjectSymbol)) {
                return -1;
            }
            return 0;
        }
        if (best.isClass() && challenger.isClass()) {
            ClassSymbol bestClass = (ClassSymbol)best;
            ClassSymbol challengerClass = (ClassSymbol)challenger;
            if (bestClass.implementsInterface(challengerClass) || challengerClass.isSuperclass(bestClass)) {
                return -1;
            }
            if (challengerClass.implementsInterface(bestClass) || bestClass.isSuperclass(challengerClass)) {
                return 1;
            }
        }
        return 0;
    }

    private int compareMethods(Parser parser, ExpressionList actualArgList, MethodMatchRecord best, MethodMatchRecord challenger) {
        int result = 0;
        boolean bestVarArgsStarted = false;
        boolean challengerVarArgsStarted = false;
        ArgumentVariableList bestArgList = best.method.argumentList;
        ArgumentVariableList challengerArgList = challenger.method.argumentList;
        while (actualArgList != null && bestArgList != null && challengerArgList != null) {
            ArraySymbol arraySymbol;
            Expression actualArg = actualArgList.expr;
            TypeSymbol actualArgType = actualArg.getType();
            TypeSymbol bestArgType = bestArgList.argSymbol.type;
            if ((best.method.access & 0x80) != 0 && bestArgList.next == null) {
                if (bestVarArgsStarted || actualArgList.next != null || !actualArgType.isArrayType()) {
                    arraySymbol = (ArraySymbol)bestArgType;
                    bestArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                }
                bestVarArgsStarted = true;
            } else {
                bestArgList = bestArgList.next;
            }
            bestArgType = this.applyTypeParameters(bestArgType, best.definingClass, best.method);
            TypeSymbol challengerArgType = challengerArgList.argSymbol.type;
            if ((challenger.method.access & 0x80) != 0 && challengerArgList.next == null) {
                if (challengerVarArgsStarted || actualArgList.next != null || !actualArgType.isArrayType()) {
                    arraySymbol = (ArraySymbol)challengerArgType;
                    challengerArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                }
                challengerVarArgsStarted = true;
            } else {
                challengerArgList = challengerArgList.next;
            }
            challengerArgType = this.applyTypeParameters(challengerArgType, challenger.definingClass, challenger.method);
            result += InvokeExpression.compareTypes(parser, actualArgType, bestArgType, challengerArgType);
            actualArgList = actualArgList.next;
        }
        return result;
    }

    private boolean isAccessible(Parser parser, RawClassSymbol classSymbol, MethodSymbol methodSymbol, boolean printError) {
        block8: {
            RawClassSymbol currentClassSymbol = parser.currentClassSymbol;
            if (!(methodSymbol.isAccessible(currentClassSymbol, classSymbol) || this.thisArgument != null && this.thisArgument.getType().typeKind == 11)) {
                if (methodSymbol.definingClass.isInnerClass() || currentClassSymbol.isInnerClass()) {
                    boolean protectedAccess = ((methodSymbol.definingClass.access | methodSymbol.access) & 4) != 0;
                    RawClassSymbol currentOuterClass = currentClassSymbol;
                    RawClassSymbol definingOuterClass = methodSymbol.definingClass;
                    while (true) {
                        if (protectedAccess && !methodSymbol.isConstructor() && definingOuterClass.isSuperclass(currentOuterClass) && (this.thisArgument == null || this.thisArgument instanceof ThisExpression || this.thisArgument instanceof SuperExpression || this.thisArgument.getType().equalTo(currentOuterClass))) {
                            this.useAccessor = true;
                            break block8;
                        }
                        if (definingOuterClass == currentOuterClass) {
                            this.useAccessor = true;
                            break block8;
                        }
                        if (definingOuterClass.isInnerClass()) {
                            definingOuterClass = definingOuterClass.getOuterClass();
                            continue;
                        }
                        if (!currentOuterClass.isInnerClass()) break;
                        definingOuterClass = methodSymbol.definingClass;
                        currentOuterClass = currentOuterClass.getOuterClass();
                    }
                    if (printError) {
                        parser.error(Message.errorAccessError, this.pos, false, methodSymbol.errorName());
                    }
                    return false;
                }
                if (printError) {
                    parser.error(Message.errorAccessError, this.pos, false, methodSymbol.errorName());
                }
                return false;
            }
        }
        return true;
    }

    private Error errorNotFound(Parser parser, ClassSymbol classSymbol) {
        if (!classSymbol.isErroneous()) {
            StringBuffer str = new StringBuffer();
            if (this.method.identifier == Identifier.initializerIdentifier) {
                str.append(Message.constructorString);
                str.append(" ");
                if (this.typeArguments != null) {
                    this.typeArguments.toString(str);
                }
                str.append(classSymbol.identifier.toString());
            } else {
                str.append(Message.methodString);
                str.append(" ");
                if (this.typeArguments != null) {
                    this.typeArguments.toString(str);
                }
                str.append(this.method.identifier.toString());
            }
            str.append(ExpressionList.toFormalParamString(this.arguments));
            return parser.error(Message.errorNotFound, this.pos, false, str.toString(), Message.inString + " " + classSymbol.errorName());
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    Expression resolveAndCheck(Parser parser) {
        block123: {
            block132: {
                block131: {
                    block130: {
                        block125: {
                            block126: {
                                block129: {
                                    block127: {
                                        block128: {
                                            block124: {
                                                block122: {
                                                    assignmentContext = parser.assignmentContext;
                                                    parser.assignmentContext = null;
                                                    if (!(this.method instanceof UnresolvedSymbol)) {
                                                        if ((this.flags & 3) != 0) {
                                                            parser.thisInitialized = true;
                                                        }
                                                        return this;
                                                    }
                                                    unresolvedSymbol = (UnresolvedSymbol)this.method;
                                                    if (unresolvedSymbol.qualifierList == null) {
                                                        classSymbol = parser.currentClassSymbol;
                                                        methodTable = classSymbol.getMethodTable(parser);
                                                    } else {
                                                        if (!this.resolveQualifiedName(parser, unresolvedSymbol)) {
                                                            return ErrorExpression.errorExpression;
                                                        }
                                                        methodTable = null;
                                                        classSymbol = null;
                                                    }
                                                    errorInArgs = false;
                                                    thisArg = this.thisArgument;
                                                    if (thisArg != null) {
                                                        typeSymbol = (thisArg = thisArg.resolveAndCheck(parser)).getType();
                                                        if (typeSymbol.isArrayType()) {
                                                            classSymbol = parser.javaLangObjectSymbol;
                                                            methodTable = classSymbol.getMethodTable(parser);
                                                        } else if (typeSymbol.isTypeParameter()) {
                                                            classSymbol = ((ClassSymbol)typeSymbol).getClassSymbol();
                                                            methodTable = ((TypeParameterSymbol)typeSymbol).getMethodTable(parser);
                                                        } else if (typeSymbol.isClass()) {
                                                            classSymbol = ((ClassSymbol)typeSymbol).getClassSymbol();
                                                            methodTable = classSymbol.getMethodTable(parser);
                                                        } else {
                                                            if (!typeSymbol.isErroneous()) {
                                                                parser.error(Message.errorObjectRequired, thisArg.pos, false, Message.methodString + " " + unresolvedSymbol.errorName());
                                                            }
                                                            errorInArgs = true;
                                                        }
                                                        this.thisArgument = thisArg;
                                                    }
                                                    if (this.qualification != null) {
                                                        classSymbol = this.qualification.getClassSymbol();
                                                        methodTable = classSymbol.getMethodTable(parser);
                                                    }
                                                    tvl = this.typeArguments;
                                                    while (tvl != null) {
                                                        if (tvl.typeVariable.typeVariableKind != 1) {
                                                            parser.error(Message.errorNoWildCardsInMethodTypeArgs, this.pos, false);
                                                        }
                                                        tvl.typeVariable = (TypeVariableSymbol)tvl.typeVariable.resolveType(parser, this.pos, false, true, false);
                                                        tvl = tvl.next;
                                                    }
                                                    actualArgCount = 0;
                                                    actualArgument = this.arguments;
                                                    while (actualArgument != null) {
                                                        if (!this.resolvedArguments) {
                                                            actualArgument.expr = actualArgument.expr.resolveAndCheck(parser);
                                                        }
                                                        if (actualArgument.expr instanceof ThisExpression && !parser.thisInitialized) {
                                                            thisExpression = (ThisExpression)actualArgument.expr;
                                                            if (thisExpression.outerClassSymbol == null) {
                                                                parser.error(Message.errorReferenceBeforeSuper, actualArgument.expr.pos, false);
                                                                errorInArgs = true;
                                                            }
                                                        }
                                                        if ((argType = actualArgument.expr.getType()).isErroneous()) {
                                                            errorInArgs = true;
                                                        }
                                                        ++actualArgCount;
                                                        actualArgument = actualArgument.next;
                                                    }
                                                    if ((this.flags & 3) != 0) {
                                                        parser.thisInitialized = true;
                                                    }
                                                    if (errorInArgs || classSymbol.isErroneous()) {
                                                        return ErrorExpression.errorExpression;
                                                    }
                                                    classSymbol.resolveType(parser, this.pos, true, true, false);
                                                    if (unresolvedSymbol.identifier == Identifier.initializerIdentifier && this.typeArguments != null && classSymbol.cd.getTypeParameterList() != null && ((ParameterizedClassSymbol)thisArg.getType()).typeVariableList == null) {
                                                        str = Message.constructorString + " " + classSymbol.identifier.toString();
                                                        str = str + ExpressionList.toFormalParamString(this.arguments);
                                                        error = parser.error(Message.errorNotFound, this.pos, false, str, Message.inString + " " + classSymbol.errorName());
                                                        return new ErrorExpression(error);
                                                    }
                                                    currentClassSymbol = parser.currentClassSymbol;
                                                    matchedMethodRecord = null;
                                                    matchedMethodSymbol = null;
                                                    definingClass = null;
                                                    lastPhase = (byte)(parser.parsingAtLeastOneFive == false ? 1 : 3);
                                                    triedStaticImport = false;
                                                    importSymbol = null;
                                                    usedErasedMethod = false;
                                                    block6: for (phase = 1; phase <= lastPhase; phase = (byte)(phase + 1)) {
                                                        methodMatchList = this.findMatchingMethods(null, parser, classSymbol, methodTable, actualArgCount, this.arguments, assignmentContext, phase);
                                                        matchCount = 0;
                                                        mmr = methodMatchList;
                                                        while (mmr != null) {
                                                            ++matchCount;
                                                            mmr = mmr.next;
                                                        }
                                                        switch (matchCount) {
                                                            default: {
                                                                minConversions = actualArgCount;
                                                                pmmr = null;
                                                                mmr = methodMatchList;
                                                                while (mmr != null) {
                                                                    classSym = classSymbol;
                                                                    if (thisArg != null && thisArg instanceof SuperExpression) {
                                                                        classSym = ((SuperExpression)thisArg).classSymbol;
                                                                    }
                                                                    if (this.isAccessible(parser, classSym, mmr.method, false) && (!classSymbol.isInnerClass() || mmr.method.definingClass.equalTo(classSymbol) || mmr.method.definingClass.isSuperclass(classSymbol) || classSymbol.implementsInterface(mmr.method.definingClass) || thisArg == null && this.qualification == null)) ** GOTO lbl107
                                                                    --matchCount;
                                                                    if (pmmr == null) {
                                                                        methodMatchList = mmr.next;
                                                                    } else {
                                                                        pmmr.next = mmr.next;
                                                                    }
                                                                    ** GOTO lbl110
lbl107:
                                                                    // 1 sources

                                                                    if (mmr.conversions < minConversions) {
                                                                        minConversions = mmr.conversions;
                                                                    }
                                                                    pmmr = mmr;
lbl110:
                                                                    // 3 sources

                                                                    mmr = mmr.next;
                                                                }
                                                                matchedMethodRecord = null;
                                                                method2 = null;
                                                                method1 = null;
                                                                ambiguityError = false;
                                                                mmr = methodMatchList;
                                                                while (mmr != null) {
                                                                    if (mmr.conversions == minConversions) {
                                                                        if (matchedMethodRecord == null) {
                                                                            matchedMethodRecord = mmr;
                                                                        } else {
                                                                            result = this.compareMethods(parser, this.arguments, matchedMethodRecord, mmr);
                                                                            if (result == 0) {
                                                                                method1 = matchedMethodRecord.method;
                                                                                method2 = mmr.method;
                                                                                if (method1 != method2) {
                                                                                    ambiguityError = true;
                                                                                }
                                                                            } else if (result > 0) {
                                                                                matchedMethodRecord = mmr;
                                                                                ambiguityError = false;
                                                                            }
                                                                        }
                                                                    }
                                                                    mmr = mmr.next;
                                                                }
                                                                if (ambiguityError) {
                                                                    if (phase < lastPhase) continue block6;
                                                                    error = parser.error(Message.errorAmbiguousReference, this.pos, false, method1.errorName(), method1.errorName() + " " + Message.inString + " " + method1.definingClass.errorName(), method2.errorName() + " " + Message.inString + " " + method2.definingClass.errorName());
                                                                    return new ErrorExpression(error);
                                                                }
                                                                if (matchedMethodRecord != null) {
                                                                    if (triedStaticImport) {
                                                                        importSymbol.used = true;
                                                                    }
                                                                    usedErasedMethod = matchedMethodRecord.usedErasedMethod;
                                                                    definingClass = matchedMethodRecord.definingClass;
                                                                    matchedMethodSymbol = matchedMethodRecord.method;
                                                                    matchedMethodSymbol.flags = (short)(matchedMethodSymbol.flags | 16);
                                                                    break block6;
                                                                }
                                                            }
                                                            case 0: {
                                                                if (phase < lastPhase) continue block6;
                                                                if (parser.parsingAtLeastOneFive && !triedStaticImport && !this.hasMethodNamed(methodTable, unresolvedSymbol.identifier) && (importSymbol = parser.currentPackageScope.lookupImportSymbol(unresolvedSymbol.identifier, (byte)8)) != null) {
                                                                    triedStaticImport = true;
                                                                    phase = 1;
                                                                    classSymbol = importSymbol.getImportSymbolClass();
                                                                    methodTable = classSymbol.getMethodTable(parser);
                                                                    continue block6;
                                                                }
                                                                error = this.errorNotFound(parser, classSymbol);
                                                                return new ErrorExpression(error);
                                                            }
                                                            case 1: {
                                                                if (triedStaticImport) {
                                                                    importSymbol.used = true;
                                                                }
                                                                matchedMethodRecord = methodMatchList;
                                                                usedErasedMethod = matchedMethodRecord.usedErasedMethod;
                                                                definingClass = matchedMethodRecord.definingClass;
                                                                matchedMethodSymbol = matchedMethodRecord.method;
                                                                matchedMethodSymbol.flags = (short)(matchedMethodSymbol.flags | 16);
                                                                if (!(!classSymbol.isInnerClass() || matchedMethodSymbol.definingClass.equalTo(classSymbol) || matchedMethodSymbol.definingClass.isSuperclass(classSymbol) || classSymbol.implementsInterface(matchedMethodSymbol.definingClass) || thisArg == null && this.qualification == null)) {
                                                                    if (phase < lastPhase) continue block6;
                                                                    error = this.errorNotFound(parser, classSymbol);
                                                                    return new ErrorExpression(error);
                                                                }
                                                                if (thisArg != null && thisArg instanceof SuperExpression) {
                                                                    classSymbol = ((SuperExpression)thisArg).classSymbol;
                                                                }
                                                                if (this.isAccessible(parser, classSymbol, matchedMethodSymbol, true)) break block6;
                                                                return ErrorExpression.errorExpression;
                                                            }
                                                        }
                                                    }
                                                    if ((matchedMethodSymbol.access & 8) == 0) {
                                                        if (thisArg == null) {
                                                            if (this.qualification != null) {
                                                                error = parser.error(Message.errorStaticReference, this.pos, false, matchedMethodSymbol.errorName());
                                                                return new ErrorExpression(error);
                                                            }
                                                            if (!((parser.currentClassSymbol.access & 8) == 0 || matchedMethodSymbol.definingClass.equalTo(parser.currentClassSymbol) || (matchedMethodSymbol.access & 2) == 0 && matchedMethodSymbol.definingClass.isSuperclass(parser.currentClassSymbol) || parser.currentClassSymbol.implementsInterface(matchedMethodSymbol.definingClass))) {
                                                                error = parser.error(Message.errorDynamicRef, this.pos, false, matchedMethodSymbol.errorName());
                                                                return new ErrorExpression(error);
                                                            }
                                                            if (parser.currentMethodSymbol != null && (parser.currentMethodSymbol.access & 8) == 0 || parser.currentFieldSymbol != null && (parser.currentFieldSymbol.access & 8) == 0) {
                                                                thisArg = new ThisExpression(this.pos, parser.currentClassSymbol);
                                                                this.thisArgument = thisArg.resolveAndCheck(parser);
                                                            } else {
                                                                error = parser.error(Message.errorDynamicRef, this.pos, false, matchedMethodSymbol.errorName());
                                                                return new ErrorExpression(error);
                                                            }
                                                        }
                                                    } else if (thisArg != null) {
                                                        parser.warning(matchedMethodSymbol, Message.warningStaticAccessWithObject, this.pos, matchedMethodSymbol.errorName());
                                                    }
                                                    if (thisArg != null && (thisArg.getType().typeClass & -128) != 0 && matchedMethodSymbol.definingClass.equalTo(parser.javaLangObjectSymbol) && matchedMethodSymbol.identifier == Identifier.finalizeIdentifier) {
                                                        error = parser.error(Message.errorAccessError, this.pos, false, matchedMethodSymbol.errorName());
                                                        return new ErrorExpression(error);
                                                    }
                                                    actualArgument = this.arguments;
                                                    if (actualArgument != null) {
                                                        formalArgumentList = matchedMethodSymbol.argumentList;
                                                        do {
                                                            argSymbol = formalArgumentList.argSymbol;
                                                            if (phase == 3 && (matchedMethodSymbol.access & 128) != 0 && formalArgumentList.next == null) {
                                                                arraySymbol = (ArraySymbol)argSymbol.type;
                                                                formalArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                                                                this.flags = (byte)(this.flags | 4);
                                                            } else {
                                                                formalArgumentList = formalArgumentList.next;
                                                                formalArgType = argSymbol.type;
                                                            }
                                                            formalArgType = this.applyTypeParameters(formalArgType, definingClass, matchedMethodSymbol);
                                                            argExpr = actualArgument.expr;
                                                            actualArgType = argExpr.getType();
                                                            formalArgType.checkForUncheckedConversion(parser, argExpr.pos, actualArgType, false);
                                                            if (actualArgType.equalTo(formalArgType)) continue;
                                                            actualArgument.expr = argExpr.promoteType(parser, formalArgType);
                                                        } while ((actualArgument = actualArgument.next) != null);
                                                    }
                                                    if (thisArg != null && thisArg instanceof SuperExpression && (matchedMethodSymbol.access & 1024) != 0) {
                                                        error = parser.error(Message.errorAccessAbstract, this.pos, false, matchedMethodSymbol.errorName());
                                                        return new ErrorExpression(error);
                                                    }
                                                    if (matchedMethodSymbol.isDeprecated() && !matchedMethodSymbol.isGenerated()) {
                                                        if (!matchedMethodSymbol.definingClass.equalTo(parser.currentClassSymbol) || parser.options.selfDeprecation) {
                                                            parser.warning(matchedMethodSymbol, Message.warningIsDeprecated, this.pos, matchedMethodSymbol.errorName());
                                                        }
                                                    } else if (matchedMethodSymbol.definingClass.isDeprecated() && !matchedMethodSymbol.isGenerated() && (!matchedMethodSymbol.definingClass.equalTo(parser.currentClassSymbol) || parser.options.selfDeprecation)) {
                                                        parser.warning(matchedMethodSymbol.definingClass, Message.warningIsDeprecated, this.pos, matchedMethodSymbol.definingClass.errorName());
                                                    }
                                                    if (unresolvedSymbol.qualifierList == null && (matchedMethodSymbol.access & 8) != 0) {
                                                        matchedMethodSymbol.checkForAmbigousImport(parser, this.pos, parser.currentPackageScope, (short)8);
                                                    }
                                                    if (this.typeArguments != null && usedErasedMethod && definingClass != null && definingClass.genericClassSymbol.isGenericType() && definingClass.typeVariableList == null) {
                                                        error = parser.error(Message.errorNoTypeArgumentsForErasedMethod, this.pos, false, matchedMethodSymbol.erasedErrorName());
                                                        return new ErrorExpression(error);
                                                    }
                                                    if (!matchedMethodSymbol.isConstructor()) break block122;
                                                    if (matchedMethodSymbol == parser.currentMethodSymbol && (matchedMethodSymbol.flags & 2) != 0 && thisArg instanceof ThisExpression) {
                                                        parser.error(Message.errorCyclicConstructors, this.pos, false, matchedMethodSymbol.errorName());
                                                    }
                                                    typeSymbol = thisArg.getType();
                                                    if (matchedMethodSymbol.definingClass.isAnonymousInnerClass()) {
                                                        matchedMethodSymbol.definingClass.fixConstructors(parser);
                                                    }
                                                    break block123;
                                                }
                                                typeSymbol = matchedMethodSymbol.resultType;
                                                if (matchedMethodSymbol.identifier != Identifier.cloneIdentifier) break block124;
                                                if (thisArg != null && thisArg.getType().typeKind == 11) {
                                                    typeSymbol = thisArg.getType();
                                                }
                                                break block125;
                                            }
                                            if (matchedMethodSymbol.identifier != Identifier.getClassIdentifier || matchedMethodSymbol.definingClass != parser.javaLangObjectSymbol || !parser.parsingAtLeastOneFive || thisArg != null && !thisArg.getType().isReferenceType()) break block126;
                                            arrayType = null;
                                            classSymbol = null;
                                            if (thisArg == null) break block127;
                                            if (!thisArg.getType().isClass()) break block128;
                                            classSymbol = ((ClassSymbol)thisArg.getType()).getClassSymbol();
                                            break block129;
                                        }
                                        if (thisArg.getType().isArrayType()) {
                                            arrayType = (ArraySymbol)thisArg.getType();
                                            if (arrayType.baseType.isClass()) {
                                                classSymbol = ((ClassSymbol)arrayType.baseType).getClassSymbol();
                                            }
                                        }
                                        break block129;
                                    }
                                    classSymbol = currentClassSymbol;
                                }
                                if (classSymbol != null) {
                                    refTypeSym /* !! */  = ParameterizedClassSymbol.getParameterizedClassSymbol(classSymbol, null, null);
                                    if (arrayType != null) {
                                        refTypeSym /* !! */  = (ReferenceTypeSymbol)ArraySymbol.getArrayType(refTypeSym /* !! */ , arrayType.dimension);
                                    }
                                    tvs = new TypeVariableSymbol(0, 2, refTypeSym /* !! */ );
                                    typeSymbol = ParameterizedClassSymbol.getParameterizedClassSymbol(parser.javaLangClassSymbol, new TypeVariableList(tvs), null);
                                }
                                break block125;
                            }
                            if (usedErasedMethod) {
                                typeSymbol = typeSymbol.eraseType();
                            }
                        }
                        if ((typeSymbol = this.applyTypeParameters(typeSymbol, matchedMethodRecord.definingClass, matchedMethodSymbol)).containsTypeParameterDefinedBy(null)) {
                            typeSymbol = typeSymbol.replaceTypeParameters(parser.currentClassSymbol, matchedMethodSymbol.typeParameterList, matchedMethodRecord.typeArguments, thisArg);
                        }
                        if (!typeSymbol.isTypeParameter() || thisArg == null || !(thisType = thisArg.getType()).isParameterizedClass()) break block123;
                        pcs = (ParameterizedClassSymbol)thisType;
                        tps = (TypeParameterSymbol)typeSymbol;
                        if (pcs.typeVariableList != null) break block123;
                        if (!(tps.definingSymbol instanceof MethodSymbol)) break block130;
                        typeIsBound = true;
                        if (tps.definingSymbol != parser.currentMethodSymbol) break block131;
                        typeIsBound = false;
                        break block132;
                    }
                    if (tps.definingSymbol != pcs.genericClassSymbol && tps.definingSymbol != parser.currentClassSymbol && !parser.currentClassSymbol.isInnerClass((RawClassSymbol)tps.definingSymbol)) {
                        typeSymbol = tps.bound;
                    }
                    break block123;
                }
                for (currentScope = parser.currentMethodSymbol.scope; currentScope != null; currentScope = currentScope.getOuterScope()) {
                    if (currentScope.kind != 3 || ((MethodScope)currentScope).methodSymbol != tps.definingSymbol) continue;
                    typeIsBound = false;
                    break;
                }
            }
            if (typeIsBound) {
                typeSymbol = tps.bound;
            }
        }
        this.setType(typeSymbol.resolveType(parser, 0, false, true, false));
        if (thisArg == null || thisArg.getType().isReferenceType()) {
            throwsList = matchedMethodSymbol.throwsList;
            while (throwsList != null) {
                throwsList.throwsType = typeSymbol = throwsList.throwsType.resolveType(parser, this.pos, true, true, false);
                if (!typeSymbol.isErroneous()) {
                    if ((typeSymbol = this.applyTypeParameters(typeSymbol, matchedMethodRecord.definingClass, matchedMethodSymbol)).containsTypeParameterDefinedBy(null)) {
                        typeSymbol = typeSymbol.replaceTypeParameters(parser.currentClassSymbol, matchedMethodSymbol.typeParameterList, matchedMethodRecord.typeArguments, thisArg);
                    }
                    classSymbol = ((ClassSymbol)typeSymbol).getClassSymbol();
                    if (!(classSymbol.identifier == Identifier.cloneNotSupportedExceptionIdentifier && thisArg != null && thisArg.getType().isArrayType() || TryStatement.catchesType(parser, classSymbol) || !classSymbol.isCheckedException(parser) || thisArg != null && thisArg.getType().isArrayType())) {
                        if (parser.currentClassSymbol.isAnonymousInnerClass() && (parser.currentMethodSymbol == null || parser.currentMethodSymbol.isConstructor() || parser.currentMethodSymbol == parser.currentClassSymbol.cd.ccd.dynamicInitializer)) {
                            anonClassSymbol = (AnonymousClassSymbol)parser.currentClassSymbol;
                            if (!anonClassSymbol.constructorSymbol.checkThrowsList(classSymbol)) {
                                ctl = new MethodSymbol.CompiledThrowsList(classSymbol, 0);
                                ctl.next = anonClassSymbol.constructorSymbol.throwsList;
                                anonClassSymbol.constructorSymbol.throwsList = ctl;
                            }
                        } else if (parser.currentMethodSymbol == null || parser.currentMethodSymbol == parser.currentClassSymbol.cd.ccd.dynamicInitializer) {
                            parser.error(Message.errorUnreportedException, this.pos, false, classSymbol.errorName());
                        } else if (!parser.currentMethodSymbol.checkThrowsList(classSymbol)) {
                            parser.error(Message.errorUnreportedException, this.pos, false, typeSymbol.errorName());
                        }
                    }
                }
                throwsList = throwsList.next;
            }
        }
        if (this.thisArgument instanceof ThisExpression) {
            if (parser.currentClassSymbol.isAnonymousInnerClass()) {
                if (((parser.currentClassSymbol.flags & 4) != 0 || !parser.thisInitialized) && (classSymbol = ((ThisExpression)this.thisArgument).classSymbol).isInnerClass()) {
                    outerClass = matchedMethodSymbol.definingClass;
                    if (((ThisExpression)thisArg).outerClassSymbol != null) {
                        if ((parser.currentClassSymbol.flags & 4) != 0) {
                            error = parser.error(Message.errorReferenceBeforeSuper, this.pos, false);
                            return new ErrorExpression(error);
                        }
                        outerClass = (RawClassSymbol)((ThisExpression)thisArg).outerClassSymbol;
                    }
                    if (!(outerClass.equalTo(classSymbol) || outerClass.isSuperclass(classSymbol) && matchedMethodSymbol.isAccessible(parser.currentClassSymbol, classSymbol) || outerClass.isInterface() && classSymbol.implementsInterface(outerClass))) {
                        if ((parser.currentClassSymbol.flags & 4) != 0) {
                            error = parser.error(Message.errorReferenceBeforeSuper, this.pos, false);
                            return new ErrorExpression(error);
                        }
                        if (!parser.parsingAtLeastOneFive || !classSymbol.getClassSymbol().isInnerClass(outerClass)) {
                            error = parser.error(Message.errorReferenceBeforeSuper, this.pos, false);
                            return new ErrorExpression(error);
                        }
                    }
                }
            } else if (!parser.thisInitialized && ((ThisExpression)this.thisArgument).outerClassSymbol == null && (matchedMethodSymbol.definingClass.equalTo(this.thisArgument.getType()) || matchedMethodSymbol.definingClass.isSuperclass(((ClassSymbol)this.thisArgument.getType()).getClassSymbol()))) {
                error = parser.error(Message.errorReferenceBeforeSuper, this.pos, false);
                return new ErrorExpression(error);
            }
        }
        if ((this.flags & 3) != 0) {
            if (!(InvokeExpression.$assertionsDisabled || this.thisArgument instanceof ThisExpression || this.thisArgument instanceof SuperExpression)) {
                throw new AssertionError();
            }
            actualArgument = this.arguments;
            while (actualArgument != null) {
                argumentExpression = actualArgument.expr;
                while (argumentExpression instanceof CastExpression) {
                    argumentExpression = ((CastExpression)argumentExpression).operand;
                }
                isThisSuperError = false;
                if (argumentExpression instanceof SuperExpression) {
                    isThisSuperError = true;
                } else if (argumentExpression instanceof ThisExpression) {
                    if (parser.currentClassSymbol != null && parser.currentClassSymbol.equalTo(argumentExpression.getType())) {
                        isThisSuperError = true;
                    }
                } else if (argumentExpression.kind == 4 && ((InvokeExpression)argumentExpression).method.identifier == Identifier.initializerIdentifier && ((argType = argumentExpression.getType()).isParameterizedClass() || argType.isRawClass())) {
                    argClass = ((ClassSymbol)argType).getClassSymbol();
                    if (argClass.isAnonymousInnerClass()) {
                        argClass.flags = (short)(argClass.flags | 4);
                        argClass = argClass.getSuperClassSymbol().getClassSymbol();
                    }
                    if (argClass.isNonStaticInnerClass() && argClass.isInnerClass(currentClassSymbol)) {
                        isThisSuperError = true;
                    }
                }
                if (isThisSuperError) {
                    error = parser.error(Message.errorReferenceBeforeSuper, argumentExpression.pos, false);
                    return new ErrorExpression(error);
                }
                actualArgument = actualArgument.next;
            }
        }
        if ((this.flags & 2) != 0) {
            if (!InvokeExpression.$assertionsDisabled && !(this.thisArgument instanceof SuperExpression)) {
                throw new AssertionError();
            }
            argExpr = ((SuperExpression)this.thisArgument).outerClassExpr;
            if (argExpr != null) {
                if (!matchedMethodSymbol.definingClass.isNonStaticInnerClass()) {
                    error = parser.error(Message.errorIllegalQualifier, this.pos, false, "'super'");
                    return new ErrorExpression(error);
                }
                outerClass = matchedMethodSymbol.definingClass.getOuterClass();
                if (!outerClass.equalTo(classSymbol = ((ClassSymbol)argExpr.getType()).getClassSymbol()) && !outerClass.isSuperclass(classSymbol) || classSymbol.equalTo(parser.currentClassSymbol)) {
                    error = parser.error(Message.errorIllegalQualifier, this.pos, false, "'super'");
                    return new ErrorExpression(error);
                }
            }
        }
        this.method = matchedMethodSymbol;
        return this;
    }

    private static boolean isExcludeClass(Options options, RawClassSymbol classSymbol) {
        ArrayList excludeClasses = options.excludeClasses;
        if (excludeClasses != null) {
            String className = classSymbol.toString();
            int size = excludeClasses.size();
            for (int i = 0; i < size; ++i) {
                if (!className.equals((String)excludeClasses.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasMethodNamed(MethodSymbol[] methodTable, Identifier identifier) {
        for (int x = 0; x < methodTable.length; ++x) {
            if (methodTable[x].identifier != identifier) continue;
            return true;
        }
        return false;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        byte invocationMode;
        TypeSymbol exprType;
        short index;
        TypeSymbol baseType;
        ArraySymbol arrayType;
        InnerClassSymbol.HiddenArgumentList hal;
        InnerClassSymbol innerClassSymbol;
        Parser parser = byteCodeGenerator.parser;
        RawClassSymbol currentClassSymbol = parser.currentClassSymbol;
        MethodSymbol methodSymbol = (MethodSymbol)this.method;
        RawClassSymbol classSymbol = methodSymbol.definingClass;
        if (!(methodSymbol.isSynthetic() || methodSymbol.isGenerated() || methodSymbol.isDefaultConstructor())) {
            if (this.qualification != null) {
                currentClassSymbol.addNameReference(byteCodeGenerator.parser, this.qualification, this.pos);
            }
            currentClassSymbol.addNameReference(parser, methodSymbol, this.methodPos);
        }
        if (parser.options.excludeClasses != null && (methodSymbol.access & 8) != 0 && methodSymbol.resultType.typeKind == 1 && InvokeExpression.isExcludeClass(parser.options, classSymbol)) {
            return;
        }
        boolean savedDoingStringConcatonation = byteCodeGenerator.doingStringConcatonation;
        byteCodeGenerator.doingStringConcatonation = false;
        boolean isConstructor = methodSymbol.isConstructor();
        if (this.thisArgument != null) {
            if (!isConstructor) {
                TypeSymbol typeSymbol = this.thisArgument.getType();
                if (this.thisArgument instanceof SuperExpression) {
                    classSymbol = ((ClassSymbol)typeSymbol).getClassSymbol();
                } else {
                    if (!typeSymbol.isArrayType() && !typeSymbol.isTypeParameter()) {
                        classSymbol = ((ClassSymbol)typeSymbol).getClassSymbol();
                    }
                    if (classSymbol.isInterface() && !methodSymbol.definingClass.isInterface()) {
                        classSymbol = methodSymbol.definingClass;
                    }
                }
            }
            if (classSymbol.isNonStaticInnerClass() && this.thisArgument instanceof ThisExpression) {
                RawClassSymbol outerClass = methodSymbol.definingClass;
                if (((ThisExpression)this.thisArgument).outerClassSymbol != null) {
                    outerClass = (RawClassSymbol)((ThisExpression)this.thisArgument).outerClassSymbol;
                }
                if (!(outerClass.equalTo(classSymbol) || outerClass.isSuperclass(classSymbol) && methodSymbol.isAccessible(currentClassSymbol, currentClassSymbol) || outerClass.isInterface() && classSymbol.implementsInterface(outerClass))) {
                    if (!parser.currentMethodSymbol.isConstructor()) {
                        byteCodeGenerator.loadLocalVariable(classSymbol, (short)0);
                    }
                    classSymbol = byteCodeGenerator.generateOuterClassFieldAccessor(methodSymbol.definingClass, classSymbol, false);
                } else {
                    this.thisArgument.generateByteCode(byteCodeGenerator);
                }
            } else {
                this.thisArgument.generateByteCode(byteCodeGenerator);
            }
            if ((methodSymbol.access & 8) != 0) {
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
                this.thisArgument = null;
            }
        } else if (this.qualification != null) {
            classSymbol = this.qualification.getClassSymbol();
        } else if ((methodSymbol.access & 8) != 0 && classSymbol.isSuperclass(currentClassSymbol)) {
            classSymbol = currentClassSymbol;
        }
        if (isConstructor && methodSymbol.definingClass.isInnerClass()) {
            innerClassSymbol = (InnerClassSymbol)methodSymbol.definingClass;
            if (!(this.thisArgument instanceof NewExpression || this.thisArgument instanceof SuperExpression && ((SuperExpression)this.thisArgument).outerClassExpr != null)) {
                if ((this.flags & 1) != 0) {
                    hal = innerClassSymbol.hiddenArgumentList;
                    while (hal != null) {
                        if (hal.kind != 2) {
                            byteCodeGenerator.loadLocalVariable(hal.type, hal.stackVarIndex);
                        }
                        hal = hal.next;
                    }
                } else {
                    if (!$assertionsDisabled && (this.flags & 2) == 0) {
                        throw new AssertionError();
                    }
                    hal = innerClassSymbol.hiddenArgumentList;
                    while (hal != null) {
                        switch (hal.kind) {
                            default: {
                                if (!$assertionsDisabled) {
                                    throw new AssertionError();
                                }
                            }
                            case 2: {
                                break;
                            }
                            case 0: {
                                if (currentClassSymbol.isAnonymousInnerClass()) {
                                    byteCodeGenerator.loadLocalVariable(innerClassSymbol, (short)((currentClassSymbol.access & 8) == 0 ? 2 : 1));
                                    break;
                                }
                                if (currentClassSymbol.isInnerClass() && !innerClassSymbol.equalTo(currentClassSymbol) && !innerClassSymbol.isInnerClass(currentClassSymbol) && !innerClassSymbol.getOuterClass().isSuperclass(currentClassSymbol)) {
                                    byteCodeGenerator.generateOuterClassFieldAccessor(innerClassSymbol.getOuterClass(), currentClassSymbol, false);
                                    break;
                                }
                                byteCodeGenerator.loadLocalVariable(innerClassSymbol, (short)0);
                            }
                        }
                        hal = hal.next;
                    }
                }
            }
        }
        ArgumentVariableList formalArgumentList = methodSymbol.argumentList;
        ExpressionList actualArgument = this.arguments;
        while (actualArgument != null) {
            if ((this.flags & 4) != 0 && formalArgumentList.next == null) {
                byteCodeGenerator.generateIntConst(this.getArgCount(actualArgument));
                arrayType = (ArraySymbol)formalArgumentList.argSymbol.type;
                baseType = ArraySymbol.getArrayType(arrayType.baseType, arrayType.dimension - 1);
                if (baseType.containsTypeParameterDefinedBy(null)) {
                    baseType = baseType.replaceTypeParameters(byteCodeGenerator.parser.currentClassSymbol, ((MethodSymbol)this.method).typeParameterList, this.typeArguments, this.thisArgument);
                }
                if (baseType.isPrimitiveType()) {
                    byteCodeGenerator.generate_8_8((byte)-68, NewExpression.newArrayKind[baseType.typeKind]);
                } else {
                    index = byteCodeGenerator.constantPool.enterConstantPoolClass(baseType.getInternalName());
                    byteCodeGenerator.generate_8_16((byte)-67, index);
                }
                byteCodeGenerator.incOpStackHeight(1);
                int idx = 0;
                while (actualArgument != null) {
                    byteCodeGenerator.generate_8((byte)89);
                    byteCodeGenerator.generateIntConst(idx++);
                    byteCodeGenerator.incOpStackHeight(2);
                    Expression expr = actualArgument.expr;
                    expr.generateByteCode(byteCodeGenerator);
                    exprType = expr.getType();
                    byteCodeGenerator.generate_8(ArrayExpression.astore_opcode[exprType.typeKind]);
                    byteCodeGenerator.decOpStackHeight((exprType.typeClass & 0x28) != 0 ? 4 : 3);
                    actualArgument = actualArgument.next;
                }
                formalArgumentList = null;
                break;
            }
            actualArgument.expr.generateByteCode(byteCodeGenerator);
            formalArgumentList = formalArgumentList.next;
            actualArgument = actualArgument.next;
        }
        if (formalArgumentList != null) {
            if (!$assertionsDisabled && (methodSymbol.access & 0x80) == 0) {
                throw new AssertionError();
            }
            byteCodeGenerator.generateIntConst(0);
            arrayType = (ArraySymbol)formalArgumentList.argSymbol.type;
            baseType = ArraySymbol.getArrayType(arrayType.baseType, arrayType.dimension - 1);
            if (baseType.containsTypeParameterDefinedBy(null)) {
                baseType = baseType.replaceTypeParameters(byteCodeGenerator.parser.currentClassSymbol, ((MethodSymbol)this.method).typeParameterList, this.typeArguments, this.thisArgument);
            }
            if (baseType.isPrimitiveType()) {
                byteCodeGenerator.generate_8_8((byte)-68, NewExpression.newArrayKind[baseType.typeKind]);
            } else {
                index = byteCodeGenerator.constantPool.enterConstantPoolClass(baseType.getInternalName());
                byteCodeGenerator.generate_8_16((byte)-67, index);
            }
            byteCodeGenerator.incOpStackHeight(1);
        }
        if (isConstructor && methodSymbol.definingClass.isInnerClass()) {
            innerClassSymbol = (InnerClassSymbol)methodSymbol.definingClass;
            if (this.thisArgument instanceof NewExpression || this.thisArgument instanceof SuperExpression && ((SuperExpression)this.thisArgument).outerClassExpr != null) {
                hal = innerClassSymbol.hiddenArgumentList;
                while (hal != null) {
                    if (hal.kind == 2) {
                        byteCodeGenerator.loadLocalVariable(hal.type, hal.localVar.varStackIndex);
                    }
                    hal = hal.next;
                }
            } else if ((this.flags & 1) != 0) {
                hal = innerClassSymbol.hiddenArgumentList;
                while (hal != null) {
                    if (hal.kind == 2) {
                        byteCodeGenerator.loadLocalVariable(hal.type, (short)(parser.currentMethodSymbol.actualArgCount - hal.stackVarIndex));
                    }
                    hal = hal.next;
                }
            } else {
                if (!$assertionsDisabled && (this.flags & 2) == 0) {
                    throw new AssertionError();
                }
                hal = innerClassSymbol.hiddenArgumentList;
                while (hal != null) {
                    if (hal.kind == 2) {
                        if (!$assertionsDisabled && !currentClassSymbol.isAnonymousInnerClass()) {
                            throw new AssertionError();
                        }
                        InnerClassSymbol.HiddenArgumentList hhal = ((InnerClassSymbol)currentClassSymbol).hiddenArgumentList;
                        while (hhal != null) {
                            if (hal.localVar == hhal.localVar) {
                                byteCodeGenerator.loadLocalVariable(hal.type, (short)(parser.currentMethodSymbol.actualArgCount - hhal.stackVarIndex));
                                break;
                            }
                            hhal = hhal.next;
                        }
                    }
                    hal = hal.next;
                }
            }
        }
        if (this.thisArgument != null) {
            if (classSymbol.isInterface()) {
                invocationMode = 0;
            } else if (isConstructor) {
                invocationMode = 2;
            } else if (this.thisArgument instanceof SuperExpression) {
                invocationMode = 1;
                if (((SuperExpression)this.thisArgument).outerClassSymbol != null) {
                    if (!$assertionsDisabled && !currentClassSymbol.isInnerClass()) {
                        throw new AssertionError();
                    }
                    this.useAccessor = true;
                }
            } else {
                invocationMode = 3;
            }
        } else {
            invocationMode = 4;
        }
        if (this.useAccessor) {
            if (isConstructor) {
                MethodSymbol accMethSym = byteCodeGenerator.generateConstructorAccessor(methodSymbol, currentClassSymbol);
                index = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(accMethSym.definingClass.getInternalName(), accMethSym.identifier.name, accMethSym.getSignature());
                byteCodeGenerator.generate_8_8_16((byte)1, (byte)-73, index);
                byteCodeGenerator.incOpStackHeight(1);
                byteCodeGenerator.decOpStackHeight(1);
            } else {
                MethodSymbol accMethSym = byteCodeGenerator.generateMethodAccessor(methodSymbol, invocationMode);
                index = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(accMethSym.definingClass.getInternalName(), accMethSym.identifier.name, accMethSym.getSignature());
                byteCodeGenerator.generate_8_16((byte)-72, index);
            }
        } else {
            index = classSymbol.isInterface() ? byteCodeGenerator.constantPool.enterConstantPoolInterfaceMethodRef(classSymbol.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature()) : byteCodeGenerator.constantPool.enterConstantPoolMethodRef(classSymbol.getInternalName(), methodSymbol.identifier.name, methodSymbol.getSignature());
            switch (invocationMode) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 0: {
                    byteCodeGenerator.generate_8_16((byte)-71, index);
                    byteCodeGenerator.generate_8_8((byte)methodSymbol.actualArgCount, (byte)0);
                    break;
                }
                case 1: 
                case 2: {
                    byteCodeGenerator.generate_8_16((byte)-73, index);
                    break;
                }
                case 3: {
                    byteCodeGenerator.generate_8_16((byte)-74, index);
                    break;
                }
                case 4: {
                    byteCodeGenerator.generate_8_16((byte)-72, index);
                }
            }
        }
        byteCodeGenerator.decOpStackHeight(methodSymbol.actualArgCount);
        exprType = this.getType();
        switch (methodSymbol.resultType.typeKind) {
            case 10: 
            case 11: {
                TypeSymbol resultType;
                if (exprType.typeKind != 1 && !(resultType = methodSymbol.resultType.eraseType()).equalTo(exprType)) {
                    index = byteCodeGenerator.constantPool.enterConstantPoolClass(exprType.getInternalName());
                    byteCodeGenerator.generate_8_16((byte)-64, index);
                }
            }
            default: {
                byteCodeGenerator.incOpStackHeight(1);
                break;
            }
            case 7: 
            case 9: {
                byteCodeGenerator.incOpStackHeight(2);
            }
            case 1: 
        }
        if (exprType == TypeSymbol.voidSymbol) {
            switch (methodSymbol.resultType.typeKind) {
                default: {
                    byteCodeGenerator.generate_8((byte)87);
                    byteCodeGenerator.decOpStackHeight(1);
                    break;
                }
                case 7: 
                case 9: {
                    byteCodeGenerator.generate_8((byte)88);
                    byteCodeGenerator.decOpStackHeight(2);
                }
                case 1: 
            }
        }
        byteCodeGenerator.doingStringConcatonation = savedDoingStringConcatonation;
        byteCodeGenerator.constantPool.checkForOutOfPackageInnerClass(currentClassSymbol, classSymbol);
    }

    private int getArgCount(ExpressionList arguments) {
        int actualArgCount = 0;
        ExpressionList actualArgument = arguments;
        while (actualArgument != null) {
            ++actualArgCount;
            actualArgument = actualArgument.next;
        }
        return actualArgCount;
    }

    static {
        $assertionsDisabled = !InvokeExpression.class.desiredAssertionStatus();
    }

    private static class EqualityConstraintFormalIsT
    extends EqualityConstraint {
        EqualityConstraintFormalIsT(TypeParameterSymbol typeParameter, TypeSymbol actualArgType) {
            super(typeParameter, actualArgType);
        }

        TypeSymbol findResolvedTypeParameter(TypeParameterSymbol tps, TypeSymbol foundType) {
            if (this.typeParameter == tps || this.typeParameter.pos == tps.pos && this.typeParameter.definingSymbol == tps.definingSymbol && Identifier.compare(this.typeParameter.identifier.name, tps.identifier.name)) {
                return this.actualArgType;
            }
            return this.next.findResolvedTypeParameter(tps, foundType);
        }
    }

    private static class EqualityConstraintExacttype
    extends EqualityConstraint {
        EqualityConstraintExacttype(TypeParameterSymbol typeParameter, TypeSymbol actualArgType) {
            super(typeParameter, actualArgType);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        TypeSymbol findResolvedTypeParameter(TypeParameterSymbol tps, TypeSymbol foundType) {
            if (this.typeParameter != tps && (this.typeParameter.pos != tps.pos || this.typeParameter.definingSymbol != tps.definingSymbol || !Identifier.compare(this.typeParameter.identifier.name, tps.identifier.name))) return this.next.findResolvedTypeParameter(tps, foundType);
            if (foundType != null) {
                if (foundType.equalTo(this.actualArgType)) return this.next.findResolvedTypeParameter(tps, foundType);
                if (!foundType.isClass() || !this.actualArgType.isClass()) return TypeSymbol.errorSymbol;
                ClassSymbol foundClass = (ClassSymbol)foundType;
                ClassSymbol actualClass = (ClassSymbol)this.actualArgType;
                if (foundClass.isSuperclass(actualClass)) return this.next.findResolvedTypeParameter(tps, foundType);
                if (actualClass.isSuperclass(foundClass)) {
                    foundType = this.actualArgType;
                    return this.next.findResolvedTypeParameter(tps, foundType);
                } else {
                    if (actualClass.implementsInterface(foundClass)) return this.next.findResolvedTypeParameter(tps, foundType);
                    if (!foundClass.implementsInterface(actualClass)) return TypeSymbol.errorSymbol;
                    foundType = this.actualArgType;
                }
                return this.next.findResolvedTypeParameter(tps, foundType);
            } else {
                foundType = this.actualArgType;
            }
            return this.next.findResolvedTypeParameter(tps, foundType);
        }
    }

    private static class EqualityConstraintSupertype
    extends EqualityConstraint {
        EqualityConstraintSupertype(TypeParameterSymbol typeParameter, TypeSymbol actualArgType) {
            super(typeParameter, actualArgType);
        }

        void computeSuperTypeSets(Set superTypeSet, TypeParameterSymbol tps) {
            if (this.typeParameter == tps || this.typeParameter.pos == tps.pos && this.typeParameter.definingSymbol == tps.definingSymbol && Identifier.compare(this.typeParameter.identifier.name, tps.identifier.name)) {
                ClassSymbol classSymbol = (ClassSymbol)this.actualArgType;
                superTypeSet.add(classSymbol);
                classSymbol.getSuperTypes(superTypeSet);
            }
            this.next.computeSuperTypeSets(superTypeSet, tps);
        }

        void computeErasedCanditiateSet(Set erasedCandidateSet, TypeParameterSymbol tps) {
            if (this.typeParameter == tps || this.typeParameter.pos == tps.pos && this.typeParameter.definingSymbol == tps.definingSymbol && Identifier.compare(this.typeParameter.identifier.name, tps.identifier.name)) {
                ClassSymbol classSymbol = (ClassSymbol)this.actualArgType;
                HashSet<RawClassSymbol> erasedSuperTypeSet = new HashSet<RawClassSymbol>();
                erasedSuperTypeSet.add(classSymbol.getClassSymbol());
                classSymbol.getErasedSuperclasses(erasedSuperTypeSet);
                if (erasedCandidateSet.isEmpty()) {
                    erasedCandidateSet.addAll(erasedSuperTypeSet);
                } else {
                    Object element;
                    ArrayList toBeRemoved = new ArrayList();
                    Iterator iterator = erasedCandidateSet.iterator();
                    while (iterator.hasNext()) {
                        element = iterator.next();
                        if (erasedSuperTypeSet.contains(element)) continue;
                        toBeRemoved.add(element);
                    }
                    iterator = toBeRemoved.iterator();
                    while (iterator.hasNext()) {
                        element = iterator.next();
                        erasedCandidateSet.remove(element);
                    }
                    toBeRemoved.clear();
                }
            }
            this.next.computeErasedCanditiateSet(erasedCandidateSet, tps);
        }

        TypeSymbol findResolvedTypeParameter(TypeParameterSymbol tps, TypeSymbol foundType) {
            if (this.typeParameter == tps || this.typeParameter.pos == tps.pos && this.typeParameter.definingSymbol == tps.definingSymbol && Identifier.compare(this.typeParameter.identifier.name, tps.identifier.name)) {
                TypeSymbol finalType = this.next.findResolvedTypeParameter(tps, foundType);
                if (finalType != null && !finalType.equalTo(this.actualArgType) && !this.actualArgType.equalTo(finalType)) {
                    if (finalType.isClass() && this.actualArgType.isClass()) {
                        ClassSymbol actualClass = (ClassSymbol)this.actualArgType;
                        ClassSymbol finalClass = (ClassSymbol)finalType;
                        if (actualClass.isSuperclass(finalClass) || finalClass.implementsInterface(actualClass)) {
                            return TypeSymbol.errorSymbol;
                        }
                    } else {
                        return TypeSymbol.errorSymbol;
                    }
                }
                return finalType;
            }
            return this.next.findResolvedTypeParameter(tps, foundType);
        }
    }

    private static class EqualityConstraintSubtype
    extends EqualityConstraint {
        EqualityConstraintSubtype(TypeParameterSymbol typeParameter, TypeSymbol actualArgType) {
            super(typeParameter, actualArgType);
        }

        void getTypeIntersectionSet(Set typeIntersectionSet, TypeParameterSymbol tps) {
            if (this.typeParameter == tps || this.typeParameter.pos == tps.pos && this.typeParameter.definingSymbol == tps.definingSymbol && Identifier.compare(this.typeParameter.identifier.name, tps.identifier.name)) {
                typeIntersectionSet.add(this.actualArgType);
            }
            this.next.getTypeIntersectionSet(typeIntersectionSet, tps);
        }

        TypeSymbol findResolvedTypeParameter(TypeParameterSymbol tps, TypeSymbol foundType) {
            if (this.typeParameter == tps || this.typeParameter.pos == tps.pos && this.typeParameter.definingSymbol == tps.definingSymbol && Identifier.compare(this.typeParameter.identifier.name, tps.identifier.name)) {
                TypeSymbol finalType = this.next.findResolvedTypeParameter(tps, foundType);
                if (finalType != null && !finalType.equalTo(this.actualArgType) && !this.actualArgType.equalTo(finalType)) {
                    if (finalType.isClass() && this.actualArgType.isClass()) {
                        ClassSymbol actualClass = (ClassSymbol)this.actualArgType;
                        ClassSymbol finalClass = (ClassSymbol)finalType;
                        if (!actualClass.isSuperclass(finalClass) && !finalClass.implementsInterface(actualClass)) {
                            return TypeSymbol.errorSymbol;
                        }
                    } else {
                        return TypeSymbol.errorSymbol;
                    }
                }
                return finalType;
            }
            return this.next.findResolvedTypeParameter(tps, foundType);
        }
    }

    private static class EqualityConstraintAnchor
    extends EqualityConstraint {
        EqualityConstraintAnchor() {
            super(null, null);
        }

        TypeSymbol findResolvedTypeParameter(TypeParameterSymbol tps, TypeSymbol foundType) {
            return foundType;
        }

        void applyType(TypeParameterSymbol tps, TypeVariableSymbol tvs) {
        }

        void computeSuperTypeSets(Set superTypeSet, TypeParameterSymbol tps) {
        }

        void getTypeIntersectionSet(Set typeIntersectionSet, TypeParameterSymbol tps) {
        }

        void computeErasedCanditiateSet(Set erasedCandidateSet, TypeParameterSymbol tps) {
        }
    }

    private static abstract class EqualityConstraint {
        EqualityConstraint next;
        TypeParameterSymbol typeParameter;
        TypeSymbol actualArgType;

        EqualityConstraint(TypeParameterSymbol typeParameter, TypeSymbol actualArgType) {
            this.typeParameter = typeParameter;
            this.actualArgType = actualArgType;
        }

        TypeSymbol findResolvedTypeParameter(TypeParameterSymbol tps, TypeSymbol foundType) {
            return this.next.findResolvedTypeParameter(tps, foundType);
        }

        void computeSuperTypeSets(Set superTypeSet, TypeParameterSymbol tps) {
            this.next.computeSuperTypeSets(superTypeSet, tps);
        }

        void getTypeIntersectionSet(Set typeIntersectionSet, TypeParameterSymbol tps) {
            this.next.getTypeIntersectionSet(typeIntersectionSet, tps);
        }

        void applyType(TypeParameterSymbol tps, TypeVariableSymbol tvs) {
            this.actualArgType = this.actualArgType.applyTypeVariable(tps, tvs);
            this.next.applyType(tps, tvs);
        }

        void computeErasedCanditiateSet(Set erasedCandidateSet, TypeParameterSymbol tps) {
            this.next.computeErasedCanditiateSet(erasedCandidateSet, tps);
        }
    }

    private static class InitialConstraintActualEqualsFormal
    extends InitialConstraint {
        InitialConstraintActualEqualsFormal(MethodSymbol methodSymbol, TypeSymbol formalArgType, TypeSymbol actualArgType) {
            super(methodSymbol, formalArgType, actualArgType);
        }

        EqualityConstraint getImpliedEqualityConstraint(Parser parser) {
            while (true) {
                ArraySymbol arraySymbol;
                if (this.formalArgType.isTypeParameter()) {
                    TypeParameterSymbol typeParameter = (TypeParameterSymbol)this.formalArgType;
                    if (typeParameter.definingSymbol == this.methodSymbol) {
                        if (this.actualArgType.isArrayType() && typeParameter.bound.getClassSymbol() == parser.javaLangObjectSymbol) {
                            return new EqualityConstraintFormalIsT(typeParameter, this.actualArgType);
                        }
                        return new EqualityConstraintExacttype(typeParameter, this.actualArgType);
                    }
                }
                if (!this.formalArgType.isArrayType()) break;
                if (this.actualArgType.isArrayType()) {
                    arraySymbol = (ArraySymbol)this.formalArgType;
                    this.formalArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                    arraySymbol = (ArraySymbol)this.actualArgType;
                    this.actualArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                    continue;
                }
                if (!this.actualArgType.isTypeVariable()) break;
                TypeVariableSymbol typeVariable = (TypeVariableSymbol)this.actualArgType;
                if (typeVariable.kind != 2 || !typeVariable.refSymbol.isArrayType()) break;
                arraySymbol = (ArraySymbol)this.formalArgType;
                this.formalArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                arraySymbol = (ArraySymbol)typeVariable.refSymbol;
                this.actualArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
            }
            if (this.formalArgType.isParameterizedClass() && this.actualArgType.isClass()) {
                if (this.actualArgType.isTypeParameter()) {
                    return null;
                }
                EqualityConstraint ecList = null;
                ParameterizedClassSymbol fpcs = (ParameterizedClassSymbol)this.formalArgType;
                ParameterizedClassSymbol apcs = MemberExpression.getParameterizedSuperType((ClassSymbol)this.actualArgType, fpcs.genericClassSymbol);
                TypeVariableList ftvl = fpcs.typeVariableList;
                TypeVariableList atvl = apcs.typeVariableList;
                block6: while (true) {
                    if (ftvl == null || atvl == null) {
                        return ecList;
                    }
                    if (!ftvl.typeVariable.containsTypeParameterDefinedBy(this.methodSymbol)) {
                        ftvl = ftvl.next;
                        atvl = atvl.next;
                        continue;
                    }
                    TypeVariableSymbol ftv = ftvl.typeVariable;
                    TypeVariableSymbol atv = atvl.typeVariable;
                    ftvl = ftvl.next;
                    atvl = atvl.next;
                    switch (ftv.typeVariableKind << 8 | atv.typeVariableKind) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 257: 
                        case 514: 
                        case 515: 
                        case 770: 
                        case 771: {
                            EqualityConstraint ec = new InitialConstraintActualEqualsFormal(this.methodSymbol, ftv.refSymbol, atv.refSymbol).getImpliedEqualityConstraint(parser);
                            if (ec == null) continue block6;
                            ec.next = ecList;
                            ecList = ec;
                            continue block6;
                        }
                        case 258: 
                        case 259: 
                        case 513: {
                            EqualityConstraint ec = new InitialConstraintActualConvertsIntoFormal(this.methodSymbol, ftv.refSymbol, atv.refSymbol).getImpliedEqualityConstraint(parser);
                            if (ec == null) continue block6;
                            ec.next = ecList;
                            ecList = ec;
                            continue block6;
                        }
                        case 769: {
                            EqualityConstraint ec = new InitialConstraintFormalConvertsIntoActual(this.methodSymbol, ftv.refSymbol, atv.refSymbol).getImpliedEqualityConstraint(parser);
                            if (ec == null) continue block6;
                            ec.next = ecList;
                            ecList = ec;
                            continue block6;
                        }
                    }
                }
            }
            return null;
        }
    }

    private static class InitialConstraintFormalConvertsIntoActual
    extends InitialConstraint {
        InitialConstraintFormalConvertsIntoActual(MethodSymbol methodSymbol, TypeSymbol formalArgType, TypeSymbol actualArgType) {
            super(methodSymbol, formalArgType, actualArgType);
        }

        EqualityConstraint getImpliedEqualityConstraint(Parser parser) {
            while (true) {
                ArraySymbol arraySymbol;
                if (this.formalArgType.isTypeParameter()) {
                    TypeParameterSymbol typeParameter = (TypeParameterSymbol)this.formalArgType;
                    if (typeParameter.definingSymbol == this.methodSymbol) {
                        return new EqualityConstraintSubtype(typeParameter, this.actualArgType);
                    }
                }
                if (!this.formalArgType.isArrayType()) break;
                if (this.actualArgType.isArrayType()) {
                    arraySymbol = (ArraySymbol)this.formalArgType;
                    this.formalArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                    arraySymbol = (ArraySymbol)this.actualArgType;
                    this.actualArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                    continue;
                }
                if (!this.actualArgType.isTypeVariable()) break;
                TypeVariableSymbol typeVariable = (TypeVariableSymbol)this.actualArgType;
                if (typeVariable.kind != 2 || !typeVariable.refSymbol.isArrayType()) break;
                arraySymbol = (ArraySymbol)this.formalArgType;
                this.formalArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                arraySymbol = (ArraySymbol)typeVariable.refSymbol;
                this.actualArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
            }
            if (this.formalArgType.isParameterizedClass() && this.actualArgType.isParameterizedClass()) {
                ParameterizedClassSymbol apcs = (ParameterizedClassSymbol)this.actualArgType;
                ParameterizedClassSymbol fpcs = MemberExpression.getParameterizedSuperType((ClassSymbol)this.formalArgType, apcs.genericClassSymbol);
                if (fpcs == null) {
                    return null;
                }
                TypeVariableList ftvl = fpcs.typeVariableList;
                TypeVariableList atvl = apcs.typeVariableList;
                EqualityConstraint ecList = null;
                block11: while (true) {
                    EqualityConstraint ec;
                    if (ftvl == null || atvl == null) {
                        return ecList;
                    }
                    if (!ftvl.typeVariable.containsTypeParameterDefinedBy(this.methodSymbol)) {
                        ftvl = ftvl.next;
                        atvl = atvl.next;
                        continue;
                    }
                    TypeVariableSymbol ftv = ftvl.typeVariable;
                    TypeVariableSymbol atv = atvl.typeVariable;
                    ftvl = ftvl.next;
                    atvl = atvl.next;
                    switch (ftv.typeVariableKind) {
                        default: {
                            continue block11;
                        }
                        case 1: {
                            switch (atv.typeVariableKind) {
                                default: {
                                    continue block11;
                                }
                                case 1: {
                                    ec = new InitialConstraintActualEqualsFormal(this.methodSymbol, ftv.refSymbol, atv.refSymbol).getImpliedEqualityConstraint(parser);
                                    if (ec == null) continue block11;
                                    ec.next = ecList;
                                    ecList = ec;
                                    continue block11;
                                }
                                case 2: {
                                    ec = new InitialConstraintActualConvertsIntoFormal(this.methodSymbol, ftv.refSymbol, atv.refSymbol).getImpliedEqualityConstraint(parser);
                                    if (ec == null) continue block11;
                                    ec.next = ecList;
                                    ecList = ec;
                                    continue block11;
                                }
                                case 3: 
                            }
                            ec = new InitialConstraintFormalConvertsIntoActual(this.methodSymbol, ftv.refSymbol, atv.refSymbol).getImpliedEqualityConstraint(parser);
                            if (ec == null) continue block11;
                            ec.next = ecList;
                            ecList = ec;
                            continue block11;
                        }
                        case 2: {
                            if (atv.typeVariableKind != 2 || (ec = new InitialConstraintFormalConvertsIntoActual(this.methodSymbol, ftv.refSymbol, atv.refSymbol).getImpliedEqualityConstraint(parser)) == null) continue block11;
                            ec.next = ecList;
                            ecList = ec;
                            continue block11;
                        }
                        case 3: 
                    }
                    if (atv.typeVariableKind != 3 || (ec = new InitialConstraintActualConvertsIntoFormal(this.methodSymbol, ftv.refSymbol, atv.refSymbol).getImpliedEqualityConstraint(parser)) == null) continue;
                    ec.next = ecList;
                    ecList = ec;
                }
            }
            return null;
        }
    }

    private static class InitialConstraintActualConvertsIntoFormal
    extends InitialConstraint {
        InitialConstraintActualConvertsIntoFormal(MethodSymbol methodSymbol, TypeSymbol formalArgType, TypeSymbol actualArgType) {
            super(methodSymbol, formalArgType, actualArgType);
        }

        EqualityConstraint getImpliedEqualityConstraint(Parser parser) {
            while (true) {
                ArraySymbol arraySymbol;
                if (BoxingExpression.isBoxableType(this.actualArgType)) {
                    this.actualArgType = BoxingExpression.getBoxedType(parser, this.actualArgType);
                }
                if (this.formalArgType.isTypeParameter()) {
                    TypeParameterSymbol typeParameter = (TypeParameterSymbol)this.formalArgType;
                    if (typeParameter.definingSymbol == this.methodSymbol) {
                        TypeParameterSymbol actualTps;
                        if (this.actualArgType.isArrayType() && typeParameter.bound.getClassSymbol() == parser.javaLangObjectSymbol) {
                            return new EqualityConstraintFormalIsT(typeParameter, this.actualArgType);
                        }
                        if (this.actualArgType.isTypeParameter() && (actualTps = (TypeParameterSymbol)this.actualArgType).equalTo(typeParameter)) {
                            return new EqualityConstraintExacttype(typeParameter, this.actualArgType);
                        }
                        return new EqualityConstraintSupertype(typeParameter, this.actualArgType);
                    }
                }
                if (!this.formalArgType.isArrayType()) break;
                if (this.actualArgType.isArrayType()) {
                    arraySymbol = (ArraySymbol)this.formalArgType;
                    this.formalArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                    arraySymbol = (ArraySymbol)this.actualArgType;
                    this.actualArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                    continue;
                }
                if (!this.actualArgType.isTypeVariable()) break;
                TypeVariableSymbol typeVariable = (TypeVariableSymbol)this.actualArgType;
                if (typeVariable.kind != 2 || !typeVariable.refSymbol.isArrayType()) break;
                arraySymbol = (ArraySymbol)this.formalArgType;
                this.formalArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                arraySymbol = (ArraySymbol)typeVariable.refSymbol;
                this.actualArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
            }
            if (this.formalArgType.isParameterizedClass() && this.actualArgType.isClass()) {
                if (this.actualArgType.isTypeParameter()) {
                    return null;
                }
                ParameterizedClassSymbol fpcs = (ParameterizedClassSymbol)this.formalArgType;
                ParameterizedClassSymbol apcs = MemberExpression.getParameterizedSuperType((ClassSymbol)this.actualArgType, fpcs.genericClassSymbol);
                TypeVariableList ftvl = fpcs.typeVariableList;
                TypeVariableList atvl = apcs.typeVariableList;
                EqualityConstraint ecList = null;
                block6: while (true) {
                    EqualityConstraint ec;
                    if (ftvl == null || atvl == null) {
                        return ecList;
                    }
                    if (!ftvl.typeVariable.containsTypeParameterDefinedBy(this.methodSymbol)) {
                        ftvl = ftvl.next;
                        atvl = atvl.next;
                        continue;
                    }
                    TypeVariableSymbol ftv = ftvl.typeVariable;
                    TypeVariableSymbol atv = atvl.typeVariable;
                    ftvl = ftvl.next;
                    atvl = atvl.next;
                    switch (ftv.typeVariableKind) {
                        default: {
                            continue block6;
                        }
                        case 1: {
                            if (atv.typeVariableKind != 1 || (ec = new InitialConstraintActualEqualsFormal(this.methodSymbol, ftv.refSymbol, atv.refSymbol).getImpliedEqualityConstraint(parser)) == null) continue block6;
                            ec.next = ecList;
                            ecList = ec;
                            continue block6;
                        }
                        case 2: {
                            if (atv.typeVariableKind != 1 && atv.typeVariableKind != 2 || (ec = new InitialConstraintActualConvertsIntoFormal(this.methodSymbol, ftv.refSymbol, atv.refSymbol).getImpliedEqualityConstraint(parser)) == null) continue block6;
                            ec.next = ecList;
                            ecList = ec;
                            continue block6;
                        }
                        case 3: 
                    }
                    if (atv.typeVariableKind != 1 && atv.typeVariableKind != 3 || (ec = new InitialConstraintFormalConvertsIntoActual(this.methodSymbol, ftv.refSymbol, atv.refSymbol).getImpliedEqualityConstraint(parser)) == null) continue;
                    ec.next = ecList;
                    ecList = ec;
                }
            }
            return null;
        }
    }

    private static abstract class InitialConstraint {
        InitialConstraint next;
        MethodSymbol methodSymbol;
        TypeSymbol formalArgType;
        TypeSymbol actualArgType;

        InitialConstraint(MethodSymbol methodSymbol, TypeSymbol formalArgType, TypeSymbol actualArgType) {
            this.methodSymbol = methodSymbol;
            this.formalArgType = formalArgType;
            this.actualArgType = actualArgType;
        }

        abstract EqualityConstraint getImpliedEqualityConstraint(Parser var1);
    }

    private static class MethodMatchRecord {
        MethodMatchRecord next;
        ParameterizedClassSymbol definingClass;
        MethodSymbol method;
        TypeVariableList typeArguments;
        int conversions;
        boolean usedErasedMethod;

        MethodMatchRecord(ParameterizedClassSymbol definingClass, MethodSymbol method, TypeVariableList typeArguments, int conversions, boolean usedErasedMethod) {
            this.definingClass = definingClass;
            this.method = method;
            this.typeArguments = typeArguments;
            this.conversions = conversions;
            this.usedErasedMethod = usedErasedMethod;
        }
    }
}

