/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.TypeSymbol;

final class IntConstantExpression
extends ConstantExpression {
    int ival;

    IntConstantExpression(int pos, TypeSymbol type, int ival) {
        super(pos, type);
        this.ival = ival;
    }

    void setType(TypeSymbol type) {
        this.setTypeExempt(type);
    }

    Expression copyConstantExpression(int newPos) {
        return new IntConstantExpression(newPos, this.getType(), this.ival);
    }

    static void generateByteCodeIntConstant(ByteCodeGenerator byteCodeGenerator, int ival) {
        byteCodeGenerator.generateIntConst(ival);
        byteCodeGenerator.incOpStackHeight(1);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        IntConstantExpression.generateByteCodeIntConstant(byteCodeGenerator, this.ival);
    }

    int getIntConstValue() {
        return this.ival;
    }
}

