/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.IdentifierList;
import oracle.ojc.compiler.ImportSymbol;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.PackageSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.SourceFile;
import oracle.ojc.compiler.StorageScope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeSymbolList;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedStaticImportList;
import oracle.ojc.compiler.UnresolvedSymbol;

final class ImportDescriptor {
    static final byte ID_STAR = 1;
    static final byte ID_STATIC = 2;
    static final byte ID_PACKAGENOTFOUND = 4;
    static final byte ID_PROCESSED = 8;
    ImportDescriptor next;
    UnresolvedSymbol importSymbol;
    ArrayList importSymbolList;
    int pos;
    byte flags;

    ImportDescriptor(int pos, UnresolvedSymbol importSymbol, byte flags) {
        this.pos = pos;
        this.importSymbol = importSymbol;
        this.flags = flags;
        this.importSymbolList = new ArrayList();
    }

    void importInnerClasses(Parser parser, RawClassSymbol classSymbol, int pos) {
        if (classSymbol.classScope == null) {
            classSymbol.loadType(parser, pos, true, true);
        }
        this.flags = (byte)(this.flags & 0xFFFFFFFB);
        TypeSymbolList tsl = classSymbol.cd.innerClassList;
        if (tsl != null) {
            boolean samePackage;
            StorageScope globalScope = parser.globalScope;
            StorageScope packageScope = parser.currentPackageScope;
            boolean bl = samePackage = parser.currentPackageScope == classSymbol.getPackageScope();
            do {
                TypeSymbol typeSymbol;
                if ((typeSymbol = tsl.typeSymbol).isLocalInnerClass() || !samePackage && (typeSymbol.access & 1) == 0) continue;
                InnerClassSymbol innerClassSymbol = (InnerClassSymbol)typeSymbol;
                if (packageScope == null || packageScope.lookupImportSymbol(innerClassSymbol.identifier, (byte)32) != null || globalScope.lookupImportSymbol(innerClassSymbol.identifier, (byte)32) != null) continue;
                ImportSymbol importSymbol = new ImportSymbol(pos, innerClassSymbol, this);
                importSymbol.flags = (byte)(importSymbol.flags | 0xC);
                this.importSymbolList.add(importSymbol);
                packageScope.enterSymbol(importSymbol);
                this.importInnerClasses(parser, innerClassSymbol, pos);
            } while ((tsl = tsl.next) != null);
        }
    }

    private void processImport(Parser parser, SourceFile sourceFile) {
        IdentifierList il = this.importSymbol.qualifierList;
        if ((this.flags & 2) != 0) {
            Identifier identifier;
            UnresolvedClassSymbol ucs;
            if ((this.flags & 8) != 0) {
                return;
            }
            if ((this.flags & 1) != 0) {
                ucs = new UnresolvedClassSymbol(il, this.importSymbol.identifier, null, parser.globalScope);
                identifier = null;
            } else {
                identifier = this.importSymbol.identifier;
                IdentifierList pil = null;
                while (il != null) {
                    if (il.next == null) {
                        identifier = il.identifier;
                        if (pil == null) {
                            il = null;
                            break;
                        }
                        pil.next = null;
                        il = this.importSymbol.qualifierList;
                        break;
                    }
                    pil = il;
                    il = il.next;
                }
                ucs = new UnresolvedClassSymbol(il, identifier, null, parser.globalScope);
                identifier = this.importSymbol.identifier;
            }
            UnresolvedStaticImportList usil = new UnresolvedStaticImportList(this, ucs, identifier);
            usil.next = sourceFile.usil;
            sourceFile.usil = usil;
            this.flags = (byte)(this.flags | 8);
            return;
        }
        Scope scope = parser.globalScope;
        if (il != null) {
            RawClassSymbol classSymbol;
            PackageSymbol packageSymbol;
            PackageScope packageScope;
            Symbol symbol = scope.lookupSpecificSymbolInScope(il.identifier, 32, false);
            if (symbol == null) {
                do {
                    if ((symbol = scope.lookupSpecificSymbolInScope(il.identifier, 16, false)) == null) {
                        symbol = scope.lookupSpecificSymbolInScope(il.identifier, 32, false);
                        if (symbol != null) break;
                        parser.findSourceFileForIdentifier(scope, il.identifier);
                        packageScope = new PackageScope(parser, (StorageScope)scope);
                        packageSymbol = new PackageSymbol(this.pos, il.identifier, packageScope);
                        symbol = packageSymbol;
                        scope.enterSymbol(packageSymbol);
                        packageScope.packageSymbol = packageSymbol;
                        this.flags = (byte)(this.flags | 4);
                    } else {
                        packageSymbol = (PackageSymbol)symbol;
                    }
                    packageSymbol.packageScope.readPackage();
                    scope = packageSymbol.packageScope;
                } while ((il = il.next) != null);
            }
            while (il != null) {
                symbol = scope.lookupSpecificSymbolInScope(il.identifier, 32, false);
                if (symbol == null) {
                    parser.error(Message.errorNotFound, il.pos, false, Message.classString + " " + il.identifier.toString(), "");
                    return;
                }
                classSymbol = (RawClassSymbol)symbol;
                classSymbol.resolveType(parser, il.pos, true, true, false);
                scope = classSymbol.classScope;
                il = il.next;
            }
            if ((this.flags & 1) != 0) {
                if ((symbol.kind & 0x20) != 0) {
                    this.importInnerClasses(parser, (RawClassSymbol)symbol, this.pos);
                    return;
                }
                packageSymbol = (PackageSymbol)symbol;
                scope = packageSymbol.packageScope;
                symbol = scope.lookupSpecificSymbolInScope(this.importSymbol.identifier, 48, false);
                if (symbol != null) {
                    if ((symbol.kind & 0x20) != 0) {
                        packageScope = (PackageScope)parser.currentPackageScope;
                        classSymbol = (RawClassSymbol)symbol;
                        if ((classSymbol.access & 1) == 0 && packageScope != classSymbol.getPackageScope()) {
                            parser.error(Message.errorNotPublic, this.pos, false, classSymbol.errorName(), packageSymbol.errorName());
                        } else {
                            this.importInnerClasses(parser, classSymbol, this.pos);
                        }
                        return;
                    }
                    packageSymbol = (PackageSymbol)symbol;
                    packageScope = packageSymbol.packageScope;
                } else {
                    packageScope = new PackageScope(parser, (StorageScope)scope);
                    packageSymbol = new PackageSymbol(this.pos, this.importSymbol.identifier, packageScope);
                    scope.enterSymbol(packageSymbol);
                    packageScope.packageSymbol = packageSymbol;
                    packageScope.readPackage();
                }
                packageScope.importPackage(this, this.pos, true);
            } else {
                symbol = scope.lookupSpecificSymbolInScope(this.importSymbol.identifier, 32, false);
                if (symbol != null) {
                    classSymbol = (RawClassSymbol)symbol;
                } else {
                    classSymbol = scope.kind == 2 ? new InnerClassSymbol(this.pos, this.importSymbol.identifier, 0, null, null, false) : new RawClassSymbol(this.pos, this.importSymbol.identifier, 0, null, null, false, false);
                    scope.enterSymbol(classSymbol);
                }
                classSymbol.loadType(parser, this.pos, null, true, true);
                packageScope = (PackageScope)parser.currentPackageScope;
                if ((classSymbol.access & 7) == 0 && packageScope != classSymbol.getPackageScope()) {
                    packageScope = (PackageScope)classSymbol.getPackageScope();
                    parser.error(Message.errorNotPublic, this.pos, false, classSymbol.errorName(), packageScope.packageSymbol.errorName());
                    scope.removeSymbol(classSymbol);
                    return;
                }
                ImportSymbol importSym = packageScope.lookupImportSymbol(classSymbol.identifier, (byte)32);
                if (importSym != null) {
                    if (importSym.importedSymbol == classSymbol) {
                        parser.warning(null, Message.warningDuplicateImport, this.pos, classSymbol.errorName());
                        importSym.flags = (byte)(importSym.flags & 0xFFFFFFF3);
                    } else if ((importSym.flags & 4) == 0) {
                        parser.error(Message.errorDoubleImport, this.importSymbol.pos, false, classSymbol.errorName());
                    } else {
                        importSym = new ImportSymbol(this.pos, classSymbol, this);
                        importSym.flags = (byte)(importSym.flags | 1);
                        this.importSymbolList.add(importSym);
                        parser.currentPackageScope.enterSymbol(importSym);
                    }
                } else {
                    importSym = new ImportSymbol(this.pos, classSymbol, this);
                    importSym.flags = (byte)(importSym.flags | 1);
                    this.importSymbolList.add(importSym);
                    parser.currentPackageScope.enterSymbol(importSym);
                }
            }
        } else if ((this.flags & 1) != 0) {
            PackageScope packageScope;
            Symbol symbol = scope.lookupSpecificSymbolInScope(this.importSymbol.identifier, 16, false);
            if (symbol != null) {
                PackageSymbol packageSymbol = (PackageSymbol)symbol;
                packageScope = packageSymbol.packageScope;
            } else {
                packageScope = new PackageScope(parser, (StorageScope)scope);
                PackageSymbol packageSymbol = new PackageSymbol(this.pos, this.importSymbol.identifier, packageScope);
                scope.enterSymbol(packageSymbol);
                packageScope.packageSymbol = packageSymbol;
                packageScope.readPackage();
                this.flags = (byte)(this.flags | 4);
            }
            packageScope.importPackage(this, this.pos, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processImports(Parser parser, SourceFile sourceFile) {
        ArrayList fileImportList = new ArrayList();
        parser.currentPackageScope = sourceFile.packageScope;
        if (parser.currentPackageScope != null) {
            parser.currentPackageScope.recordDeclarations(fileImportList);
            try {
                ImportDescriptor importList = sourceFile.importList;
                while (importList != null) {
                    importList.processImport(parser, sourceFile);
                    importList = importList.next;
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                parser.currentPackageScope.recordDeclarations(null);
                int size = fileImportList.size();
                if (size > 0) {
                    sourceFile.importDeclarations = fileImportList.toArray(new Symbol[size]);
                    parser.currentPackageScope.removeDeclarations(sourceFile.importDeclarations);
                }
                throw throwable;
            }
            parser.currentPackageScope.recordDeclarations(null);
            int size = fileImportList.size();
            if (size > 0) {
                sourceFile.importDeclarations = fileImportList.toArray(new Symbol[size]);
                parser.currentPackageScope.removeDeclarations(sourceFile.importDeclarations);
            }
        }
    }
}

