/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;

final class IfStatement
extends Statement {
    Expression condition;
    StatementList thenStatements;

    IfStatement(StatementList parent, int pos, Expression condition, StatementList thenStatements) {
        super(parent, pos, (byte)2);
        this.condition = condition;
        this.thenStatements = thenStatements;
        thenStatements.parent = this;
    }

    void resolveAndCheck(Parser parser) {
        Expression expr = this.condition.resolveAndCheck(parser);
        this.condition = expr = this.checkForBooleanExpression(parser, expr, this.condition.pos);
        BitSet defSet = (BitSet)parser.defSet.clone();
        BitSet posSet = (BitSet)parser.posSet.clone();
        if (expr.isLogicalExpression()) {
            parser.defSet = expr.getLogicalExpressionTrueDefSet();
        }
        boolean savedSuspendDataFlowChecking = parser.suspendDataFlowChecking;
        if (expr.isConstantBooleanExpression() && !expr.getConstantBooleanExpressionValue()) {
            parser.suspendDataFlowChecking = true;
        }
        this.thenStatements.resolveAndCheck(parser);
        parser.suspendDataFlowChecking = savedSuspendDataFlowChecking;
        if (expr.isConstantBooleanExpression()) {
            if (!expr.getConstantBooleanExpressionValue()) {
                parser.defSet = defSet;
            }
        } else if (!this.thenStatements.canReachNextStatement(false)) {
            parser.defSet = defSet;
            if (expr.isLogicalExpression()) {
                parser.defSet.or(expr.getLogicalExpressionFalseDefSet());
            }
            parser.posSet = posSet;
        } else if (expr.isLogicalExpression()) {
            parser.defSet.and(expr.getLogicalExpressionFalseDefSet());
        } else {
            parser.defSet = defSet;
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Expression expr = this.condition;
        if (expr.isConstantBooleanExpression()) {
            if (expr.kind != 2) {
                expr.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            if (expr.getConstantBooleanExpressionValue()) {
                this.thenStatements.generateByteCode(byteCodeGenerator);
            }
        } else {
            Label falseLabel = new Label();
            expr.generateByteCodeBranch(byteCodeGenerator, falseLabel, true);
            this.thenStatements.generateByteCode(byteCodeGenerator);
            byteCodeGenerator.setLabel(falseLabel);
        }
    }

    boolean canReachNextStatement(boolean strict) {
        if (strict && this.condition.isConstantBooleanExpression() && this.condition.getConstantBooleanExpressionValue()) {
            return this.thenStatements.canReachNextStatement(strict);
        }
        return true;
    }
}

