/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;

final class IfElseStatement
extends Statement {
    Expression condition;
    StatementList thenStatements;
    StatementList elseStatements;

    IfElseStatement(StatementList parent, int pos, Expression condition, StatementList thenStatements, StatementList elseStatements) {
        super(parent, pos, (byte)3);
        this.condition = condition;
        this.thenStatements = thenStatements;
        this.elseStatements = elseStatements;
        thenStatements.parent = elseStatements.parent = this;
    }

    void resolveAndCheck(Parser parser) {
        Expression expr = this.condition.resolveAndCheck(parser);
        this.condition = expr = this.checkForBooleanExpression(parser, expr, this.condition.pos);
        BitSet defSet = (BitSet)parser.defSet.clone();
        BitSet posSet = (BitSet)parser.posSet.clone();
        BitSet useSet = (BitSet)parser.useSet.clone();
        if (expr.isLogicalExpression()) {
            parser.defSet = expr.getLogicalExpressionTrueDefSet();
        }
        boolean savedSuspendDataFlowChecking = parser.suspendDataFlowChecking;
        if (expr.isConstantBooleanExpression() && !expr.getConstantBooleanExpressionValue()) {
            parser.suspendDataFlowChecking = true;
        }
        this.thenStatements.resolveAndCheck(parser);
        parser.suspendDataFlowChecking = savedSuspendDataFlowChecking;
        BitSet thenDefSet = parser.defSet;
        BitSet thenPosSet = parser.posSet;
        BitSet thenUseSet = parser.useSet;
        parser.defSet = defSet;
        parser.posSet = posSet;
        parser.useSet = useSet;
        if (expr.isLogicalExpression()) {
            parser.defSet = expr.getLogicalExpressionFalseDefSet();
        }
        if (expr.isConstantBooleanExpression() && expr.getConstantBooleanExpressionValue()) {
            parser.suspendDataFlowChecking = true;
        }
        this.elseStatements.resolveAndCheck(parser);
        parser.suspendDataFlowChecking = savedSuspendDataFlowChecking;
        boolean thenCanReach = this.thenStatements.canReachNextStatement(false);
        boolean elseCanReach = this.elseStatements.canReachNextStatement(false);
        if (expr.isConstantBooleanExpression()) {
            if (expr.getConstantBooleanExpressionValue() && thenCanReach) {
                parser.defSet = thenDefSet;
                parser.useSet = thenUseSet;
            }
        } else {
            if (!elseCanReach) {
                parser.defSet = thenDefSet;
                parser.posSet = thenPosSet;
            } else if (thenCanReach) {
                parser.defSet.and(thenDefSet);
            }
            parser.posSet.or(thenPosSet);
            parser.useSet.or(thenUseSet);
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
        if (this.next != null && !(thenCanReach | elseCanReach) && this.next.isCodeStatement()) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Expression expr = this.condition;
        if (expr.isConstantBooleanExpression()) {
            if (expr.kind != 2) {
                expr.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            if (expr.getConstantBooleanExpressionValue()) {
                this.thenStatements.generateByteCode(byteCodeGenerator);
            } else {
                this.elseStatements.generateByteCode(byteCodeGenerator);
            }
        } else {
            Label falseLabel = new Label();
            expr.generateByteCodeBranch(byteCodeGenerator, falseLabel, true);
            this.thenStatements.generateByteCode(byteCodeGenerator);
            Label doneLabel = new Label();
            if (this.thenStatements.canReachNextStatement(false)) {
                byteCodeGenerator.generateBranch_goto(doneLabel);
            }
            byteCodeGenerator.setLabel(falseLabel);
            this.elseStatements.generateByteCode(byteCodeGenerator);
            byteCodeGenerator.setLabel(doneLabel);
        }
    }

    boolean isLoopExitStatement() {
        return this.thenStatements.isLoopExitStatement() & this.elseStatements.isLoopExitStatement();
    }

    boolean canReachNextStatement(boolean strict) {
        return this.thenStatements.canReachNextStatement(strict) | this.elseStatements.canReachNextStatement(strict);
    }
}

