/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.Log2;
import oracle.ojc.interfaces.Storage;

public class IdeLog
implements Log2 {
    private int nwarnings;
    private int nerrors;

    IdeLog() {
    }

    public void redirect(String fileName) {
    }

    protected void finalize() {
        System.err.flush();
    }

    public void print(String word) {
        System.err.print(word);
        System.err.flush();
    }

    public void println(String line) {
        System.err.println(line);
        System.err.flush();
    }

    static String formatMessage(Storage source, int pos, ErrorInfo info, boolean warning) {
        if (pos == 0) {
            return (warning ? Message.warningString : Message.errorString) + " #" + info.getNumber() + ": " + info.getMessage();
        }
        int line = Scanner.positionToLine(pos);
        return source.toString() + ":" + line + ": " + (warning ? Message.warningString : Message.errorString) + " #" + info.getNumber() + ": " + info.getMessage();
    }

    private void printMessage(Storage source, int pos, ErrorInfo info, boolean warning) {
        this.println(IdeLog.formatMessage(source, pos, info, warning));
    }

    public void printError(Storage source, int pos, ErrorInfo info) {
        ++this.nerrors;
        this.printMessage(source, pos, info, false);
    }

    public void printError(String errorMessage) {
        ++this.nerrors;
        this.println(Message.errorColonString + errorMessage);
    }

    public void printWarning(Storage source, int pos, ErrorInfo info) {
        ++this.nwarnings;
        this.printMessage(source, pos, info, true);
    }

    public void printWarning(String warningMessage) {
        ++this.nwarnings;
        this.println(Message.warningColonString + warningMessage);
    }

    public int nerrors() {
        return this.nerrors;
    }

    public int nwarnings() {
        return this.nwarnings;
    }
}

