/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.TypeSymbol;

final class FloatConstantExpression
extends ConstantExpression {
    float fval;

    FloatConstantExpression(int pos, float fval) {
        super(pos, TypeSymbol.floatSymbol);
        this.fval = fval;
    }

    Expression copyConstantExpression(int newPos) {
        return new FloatConstantExpression(newPos, this.fval);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        int bits = Float.floatToIntBits(this.fval);
        if (bits == 0) {
            byteCodeGenerator.generate_8((byte)11);
        } else if (bits == 1065353216) {
            byteCodeGenerator.generate_8((byte)12);
        } else if (bits == 0x40000000) {
            byteCodeGenerator.generate_8((byte)13);
        } else {
            short index = byteCodeGenerator.constantPool.enterConstantPoolFloat(this.fval);
            if (index > 255) {
                byteCodeGenerator.generate_8_16((byte)19, index);
            } else {
                byteCodeGenerator.generate_8_8((byte)18, (byte)index);
            }
        }
        byteCodeGenerator.incOpStackHeight(1);
    }
}

